/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution.inviteGift;

import cc.lechun.active.entity.active.ActiveCustomerEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveCustomerInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.framework.common.enums.common.StatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.ActiveGiftPropertyInfoVo;
import cc.lechun.mall.entity.distribution.ActiveGiftRechangeResultVo;
import cc.lechun.mall.entity.distribution.GiftRechangeStatusEnum;
import cc.lechun.mall.entity.distribution.ShopSalePersionEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.iservice.distribution.BaseInviteGiftInterface;
import cc.lechun.mall.iservice.distribution.ShopSalePersionInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseInviteGift
implements BaseInviteGiftInterface {
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private ActivePropertyInterface activePropertyInterface;
    @Autowired
    ActiveCustomerInterface activeCustomerInterface;
    @Autowired
    private ShopSalePersionInterface shopSalePersionInterface;
    @Autowired
    private RedisService redisService;
    @Autowired
    private ActiveCashticketInterface cashticketInterface;
    @Autowired
    protected ActiveQrcodeInterface activeQrcodeService;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    @ReadThroughSingleCache(namespace="BaseInviteGift.getActiveGiftPropertyInfoVo", expiration=240)
    public ActiveGiftPropertyInfoVo getActiveGiftPropertyInfoVo(@ParameterValueKeyProvider String bindCode) {
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = new ActiveGiftPropertyInfoVo();
        List<ActivePropertyEntity> propertyList = this.activePropertyInterface.getActivePropertyList(bindCode);
        if (CollectionUtils.isEmpty(propertyList)) {
            this.logger.error("\u6d3b\u52a8bindCode={}\u5c5e\u6027\u672a\u914d\u7f6e:\u8bf7\u68c0\u67e5", (Object)bindCode);
            return activeGiftPropertyInfoVo;
        }
        this.setTakedPageDesc(activeGiftPropertyInfoVo, propertyList);
        this.setArticleUrl(activeGiftPropertyInfoVo, propertyList);
        this.setJoinActiveAllowNum(activeGiftPropertyInfoVo, propertyList);
        this.setProductName(activeGiftPropertyInfoVo, propertyList);
        this.setShareSuccessDesc(activeGiftPropertyInfoVo, propertyList);
        this.setNotHasGiftDesc(activeGiftPropertyInfoVo, propertyList);
        this.setNotHasInviteQualification(activeGiftPropertyInfoVo, propertyList);
        this.setNotAllowSelfTakedDesc(activeGiftPropertyInfoVo, propertyList);
        this.setNotAllowOldUserTakedDesc(activeGiftPropertyInfoVo, propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "ipLimitCount", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "addressLimitCount", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "miniBuyMilkLimitCount", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "allBuyMilkLimitCount", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "closeOrderBuy", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "salesPersonMoblie", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "baseInviteNum", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "activeJoinLimit", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "activeUrl", propertyList);
        this.logger.info("\u6d3b\u52a8\u5c5e\u6027:{}", (Object)activeGiftPropertyInfoVo.toString());
        return activeGiftPropertyInfoVo;
    }

    @Override
    public BaseJsonVo setRechange(String rechangeCode, String mobile, String customerId) {
        this.logger.info("\u6838\u9500\u5458:{},\u5151\u6362\u7801:{},\u6838\u9500\u5458\u624b\u673a\u53f7{}", new Object[]{customerId, rechangeCode, mobile});
        BaseJsonVo<ActiveCustomerEntity> rechangStatusJsonVo = this.activeCustomerInterface.getGiftRechangeStatus(rechangeCode, "");
        if (!rechangStatusJsonVo.isSuccess()) {
            return rechangStatusJsonVo;
        }
        if (((ActiveCustomerEntity)rechangStatusJsonVo.getValue()).getStatus().intValue() == GiftRechangeStatusEnum.Rechanged.getValue()) {
            return BaseJsonVo.error((String)"\u6838\u9500\u5931\u8d25\uff0c\u5151\u6362\u7801\u5df2\u5151\u6362");
        }
        ShopSalePersionEntity shopSalePersionEntity = new ShopSalePersionEntity();
        shopSalePersionEntity.setStatus(StatusEnum.STATUS_OK.getValue());
        List shopSalePersionEntityList = this.shopSalePersionInterface.getList(shopSalePersionEntity);
        if (!shopSalePersionEntityList.stream().anyMatch(sale -> mobile.trim().equals(sale.getSalePersonMobile().trim()))) {
            return BaseJsonVo.error((String)"\u4fc3\u9500\u5458\u624b\u673a\u53f7\u6709\u8bef");
        }
        ActiveGiftRechangeResultVo activeGiftRechangeResultVo = new ActiveGiftRechangeResultVo();
        ActiveCustomerEntity update = (ActiveCustomerEntity)rechangStatusJsonVo.getValue();
        update.setRechangeTime(DateUtils.now());
        update.setRechangeUser(customerId);
        update.setStatus(2);
        this.activeCustomerInterface.updateActiveCustomerRecord(update);
        activeGiftRechangeResultVo.setMessage(GiftRechangeStatusEnum.Rechange_succ.getName());
        activeGiftRechangeResultVo.setRechangeStatus(GiftRechangeStatusEnum.Rechange_succ.getValue());
        List<ActiveQrcodeEntity> qrcodeList = this.activeQrcodeService.getQrcodeListByActiveNo(update.getActiveNo());
        ActiveQrcodeEntity activeQrcodeEntity = qrcodeList.get(0);
        List<Integer> ticketIdList = this.cashticketInterface.getCashticketTicketId(activeQrcodeEntity.getBindCode(), customerId);
        if (CollectionUtils.isNotEmpty(ticketIdList)) {
            for (Integer item : ticketIdList) {
                this.cashticketInterface.updateCashticketStatus(item, update.getCustomerId(), CashStatusEnum.jinyong);
            }
        }
        return BaseJsonVo.success((Object)activeGiftRechangeResultVo);
    }

    private void setTakedPageDesc(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("takedPageDesc", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setTakedPageDesc(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setArticleUrl(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("articleUrl", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setArticleUrl(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setJoinActiveAllowNum(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("joinActiveAllowNum", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setJoinActiveAllowNum(Integer.valueOf(propertyEntityOptional.get().getPropertyValue()));
        }
    }

    private void setProductName(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        MallProductEntity productEntity;
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("productId", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent() && StringUtils.isNotEmpty((String)propertyEntityOptional.get().getPropertyValue()) && (productEntity = this.productInterface.getProduct(propertyEntityOptional.get().getPropertyValue())) != null) {
            activeGiftPropertyInfoVo.setProductName(productEntity.getProName());
            activeGiftPropertyInfoVo.setPrice(new BigDecimal(productEntity.getProPrice()));
            activeGiftPropertyInfoVo.setProductId(productEntity.getProId());
            activeGiftPropertyInfoVo.setProductCategoryId(productEntity.getProductCategoryId());
            activeGiftPropertyInfoVo.setTransportType(productEntity.getTransportType());
        }
    }

    private void setShareSuccessDesc(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("shareSuccessDesc", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setShareSuccessDesc(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setNotHasGiftDesc(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("notHasGiftDesc", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setNotHasGiftDesc(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setNotHasInviteQualification(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("notHasInviteQualification", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setNotHasInviteQualification(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setNotAllowSelfTakedDesc(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("notAllowSelfTakedDesc", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setNotAllowSelfTakedDesc(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setNotAllowOldUserTakedDesc(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("notAllowOldUserTakedDesc", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setNotAllowOldUserTakedDesc(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setFilds(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, String propertyName, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals(propertyName, activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            try {
                Class<Object> type = activeGiftPropertyInfoVo.getClass().getDeclaredField(propertyName).getType();
                Method setMethod = activeGiftPropertyInfoVo.getClass().getMethod("set" + this.captureName(propertyName), type);
                if (type.isAssignableFrom(String.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, propertyEntityOptional.get().getPropertyValue());
                }
                if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, Integer.parseInt(propertyEntityOptional.get().getPropertyValue()));
                }
                if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, Double.parseDouble(propertyEntityOptional.get().getPropertyValue()));
                }
                if (type.isAssignableFrom(Float.TYPE) || type.isAssignableFrom(Float.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, Float.valueOf(Float.parseFloat(propertyEntityOptional.get().getPropertyValue())));
                }
                if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, Boolean.parseBoolean(propertyEntityOptional.get().getPropertyValue()));
                }
                if (type.isAssignableFrom(BigDecimal.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, new BigDecimal(propertyEntityOptional.get().getPropertyValue()));
                }
                if (type.isAssignableFrom(Date.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, DateUtils.StrToDate((String)propertyEntityOptional.get().getPropertyValue(), (String)"yyyy-MM-dd"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String captureName(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }
}

