/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.evaluate;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.CollectionUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.evaluate.EvaluateOrderMapper;
import cc.lechun.mall.dao.evaluate.EvaluateOrderProductMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.evaluate.EvaluateLabelParamVo;
import cc.lechun.mall.entity.evaluate.EvaluateOrderEntity;
import cc.lechun.mall.entity.evaluate.EvaluateOrderProductEntity;
import cc.lechun.mall.entity.evaluate.EvaluateParamVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.form.evaluate.EvaluateForm;
import cc.lechun.mall.form.evaluate.EvaluateProductForm;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.evaluate.EvaluateOrderInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.service.accountBalance.AccountBalanceService;
import cc.lechun.mall.service.trade.MallOrderService;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EvaluateOrderService
implements EvaluateOrderInterface {
    private static final Logger log = LoggerFactory.getLogger(EvaluateOrderService.class);
    @Autowired
    private EvaluateOrderMapper evaluateOrderMapper;
    @Autowired
    private EvaluateOrderProductMapper evaluateOrderProductMapper;
    @Autowired
    private MallOrderService mallOrderService;
    @Autowired
    private AccountBalanceService accountBalanceService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MallVipInterface vipService;

    @Override
    @Transactional
    public BaseJsonVo saveEvaluate(EvaluateForm evaluateForm, CustomerDetailVo customerDetailVo) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("balanceResultDesc", "");
        if (evaluateForm == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u8ba2\u5355");
        }
        if (StringUtil.isEmpty((String)evaluateForm.getOrderNo())) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u8ba2\u5355");
        }
        MallOrderEntity mallOrderEntity = this.mallOrderService.getmallOrder(evaluateForm.getOrderNo());
        if (mallOrderEntity == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u8ba2\u5355");
        }
        int count = this.getEvaluateCount(evaluateForm.getOrderNo());
        if (count > 0) {
            this.saveEvaluateOrderProduct(evaluateForm, count);
            if (!StringUtil.isEmpty((String)evaluateForm.getEvaluate())) {
                EvaluateOrderEntity evaluateOrderEntity = this.getEvaluateOrder(evaluateForm.getOrderNo());
                EvaluateOrderEntity evaluateOrderEntity1 = new EvaluateOrderEntity();
                evaluateOrderEntity1.setTid(evaluateOrderEntity.getTid());
                evaluateOrderEntity1.setEvaluate(evaluateOrderEntity.getEvaluate() + ";" + evaluateForm.getEvaluate());
                this.evaluateOrderMapper.updateByPrimaryKeySelective(evaluateOrderEntity1);
            }
        } else {
            int balance;
            this.saveEvaluateOrder(evaluateForm, mallOrderEntity, customerDetailVo.getCustomerId());
            this.saveEvaluateOrderProduct(evaluateForm, count);
            this.mallOrderService.updateOrderEvaluate(evaluateForm.getOrderNo());
            if (!StringUtil.isEmpty((String)evaluateForm.getEvaluate()) && evaluateForm.getEvaluate().length() >= 10 && (balance = this.getSendBalance(customerDetailVo.getPlatformGroupId())) > 0) {
                this.accountBalanceService.rechargeByEvaluate(customerDetailVo.getCustomerId(), mallOrderEntity.getOrderMainNo(), balance * 100);
                map.put("balanceResultDesc", balance + "\u5143\u5956\u52b1\u91d1\u5df2\u5b58\u5165\u60a8\u7684\u8d26\u6237");
            }
        }
        map.put("qrcodeUrl", this.getQrcodeUrl(customerDetailVo.getPlatformGroupId()));
        this.vipService.finishEvaluate(customerDetailVo.getCustomerId());
        return BaseJsonVo.success(map);
    }

    private BaseJsonVo saveEvaluateOrder(EvaluateForm evaluateForm, MallOrderEntity mallOrderEntity, String customerId) {
        EvaluateOrderEntity evaluateOrderEntity = new EvaluateOrderEntity();
        evaluateOrderEntity.setUserId(customerId);
        evaluateOrderEntity.setOrderNo(evaluateForm.getOrderNo());
        evaluateOrderEntity.setFlag(evaluateForm.getFlag());
        evaluateOrderEntity.setEvaluate(evaluateForm.getEvaluate());
        evaluateOrderEntity.setGoodTags(evaluateForm.getGoodTags() == null ? "" : String.join((CharSequence)";", evaluateForm.getGoodTags()));
        evaluateOrderEntity.setCreateTime(DateUtils.now());
        evaluateOrderEntity.setOrderMainNo(mallOrderEntity.getOrderMainNo());
        evaluateOrderEntity.setProvince(mallOrderEntity.getConsigneeProvincename());
        evaluateOrderEntity.setCity(mallOrderEntity.getConsigneeCityname());
        evaluateOrderEntity.setArea(mallOrderEntity.getConsigneeAreaname());
        this.evaluateOrderMapper.insertSelective(evaluateOrderEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    private BaseJsonVo saveEvaluateOrderProduct(EvaluateForm evaluateForm, int count) {
        if (evaluateForm.getProducts() != null && evaluateForm.getProducts().size() > 0) {
            EvaluateOrderProductEntity evaluateOrderProductEntity = null;
            for (EvaluateProductForm evaluateProductForm : evaluateForm.getProducts()) {
                evaluateOrderProductEntity = new EvaluateOrderProductEntity();
                evaluateOrderProductEntity.setOrderNo(evaluateForm.getOrderNo());
                evaluateOrderProductEntity.setProductId(evaluateProductForm.getProductId());
                evaluateOrderProductEntity.setProdcutName(evaluateProductForm.getProdcutName());
                evaluateOrderProductEntity.setProdcutFlag(evaluateProductForm.getProdcutFlag());
                evaluateOrderProductEntity.setProductComment(evaluateProductForm.getProductComment());
                evaluateOrderProductEntity.setSource(evaluateForm.getSource());
                evaluateOrderProductEntity.setCreateTime(DateUtils.now());
                evaluateOrderProductEntity.setAddEvaluateTimes(count);
                this.evaluateOrderProductMapper.insertSelective(evaluateOrderProductEntity);
            }
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    private int getSendBalance(int platformGroupId) {
        return this.dictionaryInterface.getDictionaryToInt(platformGroupId, 100, "balance");
    }

    private String getPic(int platformGroupId) {
        return this.dictionaryInterface.getDictionaryToString(platformGroupId, 100, "evaluatPic");
    }

    private String getBalanceDesc(int platformGroupId) {
        return this.dictionaryInterface.getDictionaryToString(platformGroupId, 100, "balanceDesc");
    }

    private String getBables(int platformGroupId) {
        return this.dictionaryInterface.getDictionaryToString(platformGroupId, 100, "labels");
    }

    private String getQrcodeUrl(int platformGroupId) {
        return this.dictionaryInterface.getDictionaryToString(platformGroupId, 100, "qrcode");
    }

    @Override
    public int getEvaluateCount(String orderNo) {
        EvaluateOrderProductEntity evaluateOrderProductEntity = new EvaluateOrderProductEntity();
        evaluateOrderProductEntity.setOrderNo(orderNo);
        List list = this.evaluateOrderProductMapper.getList(evaluateOrderProductEntity);
        HashSet<Integer> addSet = new HashSet<Integer>();
        for (EvaluateOrderProductEntity entity : list) {
            if (addSet.contains(entity.getAddEvaluateTimes())) continue;
            addSet.add(entity.getAddEvaluateTimes());
        }
        return addSet.size();
    }

    private EvaluateOrderEntity getEvaluateOrder(String orderNo) {
        EvaluateOrderEntity evaluateOrderEntity = new EvaluateOrderEntity();
        evaluateOrderEntity.setOrderNo(orderNo);
        List ls = this.evaluateOrderMapper.getList(evaluateOrderEntity);
        return (EvaluateOrderEntity)CollectionUtils.listToEntiy((List)ls);
    }

    @Override
    public EvaluateParamVo getEvaluateParamVo(String orderNo, int platformGroupId) {
        EvaluateParamVo evaluateParamVo = new EvaluateParamVo();
        evaluateParamVo.setEvaluateCount(this.getEvaluateCount(orderNo));
        evaluateParamVo.setEvaluatPic(this.getPic(platformGroupId));
        int balance = this.getSendBalance(platformGroupId);
        String balanceDesc = this.getBalanceDesc(platformGroupId);
        if (!StringUtil.isEmpty((String)balanceDesc)) {
            balanceDesc.replace("#\u91d1\u989d#", balance + "");
        }
        evaluateParamVo.setBalanceDesc(balanceDesc);
        String lableJsons = this.getBables(platformGroupId);
        if (!StringUtil.isEmpty((String)lableJsons)) {
            List evaluateLabelParamVos = JSON.parseArray((String)lableJsons, EvaluateLabelParamVo.class);
            evaluateParamVo.setLabels(evaluateLabelParamVos);
        }
        return evaluateParamVo;
    }

    public static void main(String[] args) {
        ArrayList<EvaluateLabelParamVo> evaluateLabelParamVos = new ArrayList<EvaluateLabelParamVo>();
        List<String> l1 = Arrays.asList("\u51c6\u65f6\u670d\u52a1\u597d", "\u8d27\u54c1\u5b8c\u597d", "\u51b0\u888b\u672a\u878d\u5316", "\u9001\u8d27\u4e0a\u95e8", "\u98ce\u96e8\u65e0\u963b");
        List<String> l2 = Arrays.asList("\u5ef6\u8fdf\u914d\u9001", "\u51b0\u888b\u878d\u5316", "\u8d27\u54c1\u635f\u574f", "\u672a\u53ca\u65f6\u901a\u77e5", "\u9001\u9519\u53e3\u5473", "\u4ea7\u54c1\u7f3a\u5931", "\u4e0d\u9001\u4e0a\u95e8", "\u670d\u52a1\u6001\u5ea6\u4e0d\u597d");
        for (int i = 1; i < 6; ++i) {
            EvaluateLabelParamVo v = new EvaluateLabelParamVo();
            v.setFlag(i);
            switch (i) {
                case 1: {
                    v.setDesc("\u975e\u5e38\u4e0d\u6ee1\u610f\uff0c\u5404\u65b9\u9762\u90fd\u5f88\u5dee");
                    v.setLabel(l1);
                    break;
                }
                case 2: {
                    v.setDesc("\u4e0d\u6ee1\u610f\uff0c\u6bd4\u8f83\u5dee");
                    v.setLabel(l1);
                    break;
                }
                case 3: {
                    v.setDesc("\u4e00\u822c\uff0c\u8fd8\u9700\u6539\u5584");
                    v.setLabel(l1);
                    break;
                }
                case 4: {
                    v.setDesc("\u6bd4\u8f83\u6ee1\u610f\uff0c\u4ecd\u53ef\u6539\u5584");
                    v.setLabel(l1);
                    break;
                }
                case 5: {
                    v.setDesc("\u975e\u5e38\u6ee1\u610f\uff0c\u65e0\u53ef\u6311\u5254");
                    v.setLabel(l2);
                }
            }
            evaluateLabelParamVos.add(v);
        }
        log.info(JSON.toJSONString(evaluateLabelParamVos));
        EvaluateForm evaluateForm = new EvaluateForm();
        evaluateForm.setOrderNo("123");
        evaluateForm.setFlag(1);
        evaluateForm.setEvaluate("dwadwa");
        evaluateForm.setSource("1");
        evaluateForm.setBadTags(Arrays.asList("\u51c6\u65f6\u670d\u52a1\u597d", "\u8d27\u54c1\u5b8c\u597d", "\u51b0\u888b\u672a\u878d\u5316", "\u9001\u8d27\u4e0a\u95e8", "\u98ce\u96e8\u65e0\u963b"));
        evaluateForm.setGoodTags(Arrays.asList("\u51c6\u65f6\u670d\u52a1\u597d", "\u8d27\u54c1\u5b8c\u597d", "\u51b0\u888b\u672a\u878d\u5316", "\u9001\u8d27\u4e0a\u95e8", "\u98ce\u96e8\u65e0\u963b"));
        ArrayList<EvaluateProductForm> products = new ArrayList<EvaluateProductForm>();
        EvaluateProductForm evaluateProductForm = new EvaluateProductForm();
        evaluateProductForm.setProdcutFlag(1);
        evaluateProductForm.setProdcutName("dwadwa");
        evaluateProductForm.setProductId("1");
        evaluateProductForm.setProductComment("ccom");
        products.add(evaluateProductForm);
        evaluateForm.setProducts(products);
        log.info(JSON.toJSONString((Object)evaluateForm));
    }

    @Override
    public List<EvaluateOrderEntity> getEvaluateOrderList(EvaluateOrderEntity evaluateOrderEntity) throws ParseException {
        String beginDateStr = null;
        String endDateStr = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (evaluateOrderEntity.getBeginCreateTime() != null) {
            beginDateStr = DateUtils.formatDate((Date)evaluateOrderEntity.getBeginCreateTime(), (String)"yyyy-MM-dd") + " 00:00:00";
            evaluateOrderEntity.setBeginCreateTime(sdf.parse(beginDateStr));
        } else {
            evaluateOrderEntity.setBeginCreateTime(sdf.parse("2013-01-01 00:00:00"));
        }
        if (evaluateOrderEntity.getEndCreateTime() != null) {
            endDateStr = DateUtils.formatDate((Date)evaluateOrderEntity.getEndCreateTime(), (String)"yyyy-MM-dd") + " 23:59:59";
            evaluateOrderEntity.setEndCreateTime(sdf.parse(endDateStr));
        } else {
            String dateStr = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd") + " 23:59:59";
            evaluateOrderEntity.setEndCreateTime(sdf.parse(dateStr));
        }
        List<EvaluateOrderEntity> evaluateOrderEntityList = this.evaluateOrderMapper.getEvaluateOrderList(evaluateOrderEntity);
        return evaluateOrderEntityList;
    }

    @Override
    public PageInfo getEvaluateOrderListByPage(int currentPage, int pageSize, EvaluateOrderEntity evaluateOrderEntity) throws ParseException {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        this.getEvaluateOrderList(evaluateOrderEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public EvaluateOrderEntity getEvaluateOrderDetail(EvaluateOrderEntity evaluateOrderEntity) {
        EvaluateOrderEntity evaluateOrderDetail = this.evaluateOrderMapper.getEvaluateOrderDetail(evaluateOrderEntity);
        return evaluateOrderDetail;
    }

    @Override
    public List<EvaluateOrderProductEntity> getEvaluateOrderProductList(EvaluateOrderProductEntity evaluateOrderProductEntity) {
        List<EvaluateOrderProductEntity> evaluateOrderProductList = this.evaluateOrderProductMapper.getEvaluateOrderProductList(evaluateOrderProductEntity);
        return evaluateOrderProductList;
    }

    @Override
    public PageInfo getEvaluateOrderProductListByPage(int currentPage, int pageSize, EvaluateOrderProductEntity evaluateOrderProductEntity) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        this.getEvaluateOrderProductList(evaluateOrderProductEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }
}

