/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.item;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.item.IndexNavVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.iservice.item.MallBuildPageInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.item.MallPageConfigInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.utils.ScpUtils;
import java.io.IOException;
import java.util.Map;
import org.codehaus.plexus.util.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallPageConfigService
extends BaseService
implements MallPageConfigInterface {
    @Autowired
    private MallBuildPageInterface buildPageInterface;
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private MallIndexItemInterface indexItemInterface;

    @Override
    public BaseJsonVo savePageFile(int platformId, String content, String fileName, int isFirstPage) {
        PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(platformId);
        if (platFormEntity == null) {
            return BaseJsonVo.error((String)("\u5e73\u53f0[" + platformId + "]\u4e0d\u5b58\u5728"));
        }
        String[] htmlPaths = platFormEntity.getWebPath().split(";");
        String remotePath = "";
        try {
            for (String indexPath : htmlPaths) {
                if (indexPath.isEmpty()) continue;
                if (isFirstPage == 1) {
                    remotePath = indexPath;
                    indexPath = indexPath + fileName;
                } else {
                    remotePath = indexPath + "/template/pagebuild/";
                    indexPath = indexPath + "/template/pagebuild/" + fileName;
                }
                String contentOld = "";
                if (FileUtils.fileExists((String)indexPath)) {
                    contentOld = FileUtils.fileRead((String)indexPath, (String)"UTF-8");
                }
                if (content.equals(contentOld)) continue;
                FileUtils.fileWrite((String)indexPath, (String)"UTF-8", (String)content);
                ScpUtils.putFile(indexPath, remotePath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            return BaseJsonVo.error((String)("\u6587\u4ef6" + fileName + "\u4fdd\u5b58\u5931\u8d25"));
        }
        return BaseJsonVo.success((Object)"");
    }

    private String getReplaceContent(IndexNavVo navVo, Map<String, String> map, String content) {
        for (String key : map.keySet()) {
            String val = map.get(key);
            if (key.equals("productTagName") || key.equals("groupTagsName")) {
                String otherName = "";
                for (String s : val.split(";")) {
                    otherName = otherName + "<span class=\"tag\">" + s + "</span>";
                }
                content = content.replace("${" + key + "}", otherName);
                continue;
            }
            if (key.equals("items")) continue;
            if (key.equals("picMap")) {
                Map picMap = JsonUtils.stringToMap((String)val.replace("{", "{\"").replace("}", "\"}").replace("=", "\":\"").replace("], ", "]\",\""));
                for (String k : picMap.keySet()) {
                    String v = (String)picMap.get(k);
                    if (v == null) continue;
                    v = v.replace("[", "").replace("]", "").replace("\"", "");
                    k = k.replace("Product", "").replace("Promotion", "").replace("Group", "").replace("Active", "").replace("Vip", "");
                    String[] arr = v.split(",");
                    int i = 0;
                    for (String a : arr) {
                        content = content.replace("${" + k + i + "}", a);
                        content = content.replace("${" + k + "}", a);
                        ++i;
                    }
                }
                continue;
            }
            content = content.replace("${" + key + "}", val);
        }
        content = content.replace("${isvipday}", navVo.getIsvipday());
        content = content.replace("${terminal}", String.valueOf(navVo.getPlatformId()));
        return content;
    }
}

