/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.redpackage.RedpackageInterface;
import cc.lechun.active.service.sales.ActiveSaleContext;
import cc.lechun.common.enums.sync.DataSyncTypeEnum;
import cc.lechun.framework.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.messagePush.PaySuccessMessageInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.service.youshu.OrderDataService;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="confirmGoods")
public class ConfirmGoodsListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallDataSyncInterface syncInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderInterface orderService;
    @Autowired
    private RedpackageInterface redpackageService;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    @Lazy
    private ActiveInterface activeInterface;
    @Autowired
    private ActiveSaleContext activeContext;
    @Autowired
    private PrepayCardPlanDetailInterface planDetailInterface;
    @Autowired
    MallOrderSyncInfoInterface orderSyncInfoInterface;
    @Autowired
    private PaySuccessMessageInterface paySuccessMessageInterface;
    @Autowired
    private OrderDataService orderDataService;

    public boolean receive(Message message, ConsumeContext context) {
        try {
            Map param = (Map)ObjectConvert.toObject((byte[])message.getBody());
            String orderMainNo = param.get("orderMainNo").toString();
            String orderNo = param.get("orderNo").toString();
            String customerId = param.get("userId").toString();
            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            try {
                this.redpackageService.confirmOrder(orderMainEntity);
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-\u7ea2\u5305\u786e\u8ba4\u6536\u8d27\u51fa\u9519", (Throwable)e);
            }
            try {
                ActiveEntity activeEntity;
                if (StringUtils.isNotEmpty((String)orderMainEntity.getBindCode()) && (activeEntity = this.activeInterface.getActiveEntityByQrcode(orderMainEntity.getBindCode())) != null) {
                    this.activeContext.confirmOrder(activeEntity.getActiveType(), orderMainEntity);
                }
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-\u8bb0\u5f55\u9080\u8bf7\u51fa\u9519", (Throwable)e);
            }
            new Thread(() -> {
                try {
                    Thread.sleep(5000L);
                    BaseJsonVo baseJsonVo = this.vipService.customerLevelUp(orderMainEntity.getCustomerId(), orderMainEntity.getOrderMainNo());
                    if (!baseJsonVo.isSuccess()) {
                        this.log.error("\u786e\u8ba4\u6536\u8d27-\u4f1a\u5458\u5347\u7ea7\u5931\u8d25{}", (Object)baseJsonVo.getError_msg());
                    }
                }
                catch (Exception e) {
                    this.log.error("\u786e\u8ba4\u6536\u8d27-\u4f1a\u5458\u5347\u7ea7\u51fa\u9519", (Throwable)e);
                }
            }).start();
            try {
                this.vipService.finishAllTasksByFinishOrder(orderMainNo, orderMainEntity.getCustomerId());
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-\u4f1a\u5458\u8ba2\u5355\u7c7b\u4efb\u52a1\u51fa\u9519", (Throwable)e);
            }
            try {
                this.syncInterface.producerData(orderMainNo, DataSyncTypeEnum.BI_MAIN_ORDER, "confirmGoods");
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-BI\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            this.planDetailInterface.orderConfirmGoodsUpdateCardPlanStatus(orderMainNo);
            try {
                this.paySuccessMessageInterface.confirmGoodsNotify(orderMainEntity);
            }
            catch (Exception e) {
                this.log.error("\u786e\u8ba4\u6536\u8d27-\u7b7e\u6536\u901a\u77e5\u51fa\u9519", (Throwable)e);
            }
            BaseJsonVo syncResult = this.orderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, OrderStatusEnum.COMPLETION);
            if (!syncResult.isSuccess()) {
                this.log.error("\u8ba2\u5355{}\u652f\u4ed8\u6210\u529f\u72b6\u6001\u540c\u6b65\u5230OMS\u5931\u8d25\uff1a{}", (Object)orderMainNo, (Object)syncResult.getError_msg());
            }
            try {
                this.orderDataService.updateOrder(orderMainEntity);
            }
            catch (Exception e) {
                e.getStackTrace();
                this.log.error("\u6709\u6570\u8ba2\u5355\u7b7e\u6536\u4e0a\u62a5-\u7b7e\u6536\u901a\u77e5\u51fa\u9519", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.log.error("\u6d88\u8d39\u6d88\u606fconfirmGoods\u5f02\u5e38\uff0c" + e.getMessage());
        }
        return true;
    }
}

