/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.service.sales.ActiveSaleContext;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.InteractionTypeEnum;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.iservice.accessLog.OrderAccessLogInterface;
import cc.lechun.mall.iservice.customer.CustomerFreeInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.InteractionInterface;
import cc.lechun.mall.iservice.distribution.DistributionOrderInterface;
import cc.lechun.mall.iservice.distribution.DistributorGrowthActiveInterface;
import cc.lechun.mall.iservice.messagePush.PaySuccessMessageInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardRecommendInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderMessageInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.iservice.trade.MiniShopOrderInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanDomainInterface;
import cc.lechun.mall.service.youshu.OrderDataService;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="orderPay")
public class OrderPayListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private ActiveCommonInterface activeCommonService;
    @Autowired
    private ActiveSaleContext activeContext;
    @Autowired
    private MallDataSyncInterface syncInterface;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MallOrderMessageInterface orderMessageInterface;
    @Autowired
    DistributionOrderInterface distributionOrderInterface;
    @Lazy
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    private InteractionInterface interactionInterface;
    @Autowired
    MallOrderSyncInfoInterface orderSyncInfoInterface;
    @Autowired
    private OrderDataService orderDataService;
    @Autowired
    private PaySuccessMessageInterface paySuccessMessageInterface;
    @Autowired
    private MiniShopOrderInterface miniShopOrderInterface;
    @Autowired
    MallOrderPlanDomainInterface mallOrderPlanDomainInterface;
    @Autowired
    DistributorGrowthActiveInterface distributorGrowthActiveInterface;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private OrderAccessLogInterface orderAccessLogInterface;
    @Autowired
    CustomerFreeInterface customerFreeService;
    @Autowired
    PrepayCardRecommendInterface prepayCardRecommendInterface;

    public boolean receive(Message message, ConsumeContext context) {
        try {
            Map param = (Map)ObjectConvert.toObject((byte[])message.getBody());
            String orderMainNo = param.get("orderMainNo").toString();
            this.log.info("\u63a5\u6536\u8ba2\u5355\u6d88\u606f....{}", (Object)orderMainNo);
            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            if (orderMainEntity == null) {
                this.log.error("\u8ba2\u5355:{}\u4e0d\u5b58\u5728", (Object)orderMainNo);
                return false;
            }
            this.log.info("\u63a5\u6536\u8ba2\u5355\u6d88\u606f....{}", (Object)JsonUtils.toJson((Object)orderMainEntity, (boolean)false));
            if (Objects.equals(orderMainEntity.getOrderClass(), OrderClassEnum.BUY_CARD_CUT_ORDER.getValue())) {
                try {
                    BaseJsonVo baseJsonVo = this.tradeInterface.spliteSourceOrder(orderMainEntity);
                    return baseJsonVo.isSuccess();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return true;
                }
            }
            new Thread(() -> {
                try {
                    Thread.sleep(10000L);
                    BaseJsonVo syncResult = this.orderSyncInfoInterface.toDetailOrderStatus(orderMainNo, null, OrderStatusEnum.PAYCONFIRM);
                    if (!syncResult.isSuccess()) {
                        this.log.error("order-toDetailOrderStatus-error:{},why:{}", (Object)orderMainNo, (Object)syncResult.getError_msg());
                    } else {
                        this.log.info("order-toDetailOrderStatus-success:{}", (Object)orderMainNo);
                    }
                }
                catch (Exception e) {
                    this.log.error("order-toDetailOrderStatus-exception", (Throwable)e);
                }
            }).start();
            if (param.get("activeType") != null) {
                this.log.info("\u6d3b\u52a8\u8ba2\u5355:{},\u6d3b\u52a8\u7c7b\u578b:{}", (Object)orderMainNo, param.get("activeType"));
                Integer activeType = Integer.valueOf(param.get("activeType").toString());
                if (activeType != null && activeType >= 1) {
                    this.activeContext.afterPay(activeType, orderMainEntity).isSuccess();
                }
                this.activeCommonService.pushActiveMessage(orderMainEntity);
            }
            try {
                List<MallOrderPayEntity> payEntityList;
                List cashPayList;
                this.log.info("\u8ba2\u5355:{}\u817e\u8baf\u6709\u6570\u6570\u636e\u4e0a\u62a5\u5f00\u59cb", (Object)orderMainNo);
                boolean statusFlag = false;
                if (orderMainEntity.getStatus().intValue() == OrderStatusEnum.COMPLETION.getValue()) {
                    orderMainEntity.setStatus(OrderStatusEnum.PAYCONFIRM.getValue());
                    statusFlag = true;
                }
                this.orderDataService.updateOrder(orderMainEntity);
                if (statusFlag) {
                    orderMainEntity.setStatus(OrderStatusEnum.COMPLETION.getValue());
                }
                if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                    this.log.info("\u5f00\u59cb\u5904\u7406\u5976\u5361\u8ba2\u5355:{}", (Object)orderMainNo);
                    this.mallOrderPlanDomainInterface.saveOrderPlan(orderMainEntity);
                    this.customerFreeService.useFreeProdcutFromPool(orderMainEntity);
                    this.log.info("\u5904\u7406\u5976\u5361\u8ba2\u5355:{}\u7ed3\u675f", (Object)orderMainNo);
                }
                if (CollectionUtils.isNotEmpty(cashPayList = (payEntityList = this.orderPayInterface.getList(orderMainNo)).stream().filter(p -> p.getPaytypeId().intValue() == PayTypeEnum.COUPON_PAY.getValue()).collect(Collectors.toList()))) {
                    for (MallOrderPayEntity payEntity : cashPayList) {
                        if (payEntity.getPaytypeId() != 3) continue;
                        this.distributorGrowthActiveInterface.sendCash(orderMainEntity.getCustomerId(), payEntity.getCashticketId(), orderMainEntity.getPlatformId());
                        if (this.redisService.get(payEntity.getCashticketId().toString()) == null) continue;
                        this.distributorGrowthActiveInterface.setRechange(this.redisService.get(payEntity.getCashticketId().toString()).toString(), orderMainEntity.getCustomerId());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (orderMainEntity.getOrderClass().intValue() == OrderClassEnum.MALL_ORDER.getValue() || orderMainEntity.getOrderClass().intValue() == OrderClassEnum.SPLITE_DELIVERY_ORDER.getValue()) {
                this.log.info("\u5f00\u59cb\u66f4\u65b0\u7528\u6237:{}\u5b9e\u7269\u8ba2\u5355\u6570,\u8ba2\u5355:{}", (Object)orderMainEntity.getCustomerId(), (Object)orderMainNo);
                CustomerEntity customerEntity = new CustomerEntity();
                Integer num = this.orderInterface.getUserOrderCountPaid(param.get("userId").toString());
                this.log.info("\u6d88\u606f\u540e\u66f4\u65b0\u7528\u6237\u5f53\u524d\u8ba2\u5355\u6570[" + param.get("userId") + "]" + num);
                customerEntity.setIsNew(num == null || num < 1 ? 1 : 0);
                customerEntity.setCurrentOrderCount(num);
                if (customerEntity.getFirstOrderTime() == null) {
                    customerEntity.setFirstOrderTime(orderMainEntity.getCreateTime());
                }
                customerEntity.setCustomerId(param.get("userId").toString());
                this.customerInterface.updateCustomerEntitySelective(customerEntity);
            }
            this.distributionOrderInterface.makeOrder(orderMainEntity);
            this.miniShopOrderInterface.payOrderResult(orderMainEntity);
            new Thread(() -> {
                try {
                    if (orderMainEntity.getOrderSource() == 0) {
                        BaseJsonVo result = this.prepayCardRecommendInterface.recommendCards(orderMainNo);
                        if (!result.isSuccess()) {
                            this.log.error("[{}]\u5b9e\u7269\u5355\u4e0b\u5355\u540e\u63a8\u8350\u5976\u5361\u5931\u8d25\uff1a{}", (Object)orderMainNo, (Object)result.getMessage());
                        } else {
                            this.log.info("[{}]\u5b9e\u7269\u5355\u4e0b\u5355\u540e\u63a8\u8350\u5976\u5361\u6210\u529f\uff01", (Object)orderMainNo);
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error("[{}]\u5b9e\u7269\u5355\u4e0b\u5355\u540e\uff0c\u8d2d\u4e70\u63a8\u8350\u5976\u5361\uff0c\u539f\u5b9e\u7269\u5355\u5168\u989d\u9000\u6b3e\u53d1\u751f\u5f02\u5e38!", (Object)orderMainNo, (Object)e);
                }
            }).start();
            new Thread(() -> {
                try {
                    if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY.getValue() && StringUtils.isNotEmpty((CharSequence)orderMainEntity.getSourceOrderNo())) {
                        boolean result = this.prepayCardRecommendInterface.updateRecommendSuccessByOrderMainNo(orderMainEntity.getSourceOrderNo());
                        if (result) {
                            this.log.error("[{}]\u5b9e\u7269\u5355\u4e0b\u5355\u540e\uff0c\u8d2d\u4e70\u63a8\u8350\u5976\u5361\u5931\u8d25", (Object)orderMainNo);
                        } else {
                            this.log.info("[{}]\u5b9e\u7269\u5355\u4e0b\u5355\u540e\uff0c\u8d2d\u4e70\u63a8\u8350\u5976\u5361\u6210\u529f\uff01", (Object)orderMainNo);
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error("[{}]\u5b9e\u7269\u5355\u4e0b\u5355\u540e\uff0c\u8d2d\u4e70\u63a8\u8350\u5976\u5361\uff0c\u539f\u5b9e\u7269\u5355\u5168\u989d\u9000\u6b3e\u53d1\u751f\u5f02\u5e38!", (Object)orderMainNo, (Object)e);
                }
            }).start();
            try {
                BaseJsonVo result = this.orderSyncInfoInterface.syncToOMS(orderMainNo);
                this.log.info("syncOMSresult{}....{}", (Object)orderMainNo, (Object)JsonUtils.toJson((Object)result, (boolean)false));
                if (!result.isSuccess()) {
                    this.log.error("\u62c6\u5206\u8ba2\u5355\u660e\u7ec6\u51fa\u73b0\u9519\u8bef\uff0c" + result.getError_msg());
                }
            }
            catch (Exception e) {
                this.log.error("\u62c6\u5206\u8ba2\u5355\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38\uff0c" + e.getMessage());
            }
            this.orderAccessLogInterface.writeAccessLog(orderMainEntity, "payOrder", "\u652f\u4ed8\u8ba2\u5355");
            if (!this.orderPayInterface.checkMilkCardOrder(orderMainNo)) {
                this.orderMessageInterface.sendOrderPaySuccessTextMessage(orderMainEntity);
            }
            this.paySuccessMessageInterface.sendRechangeNotify(orderMainEntity);
            this.paySuccessMessageInterface.sendSuccessNotify(orderMainEntity);
            this.interactionInterface.saveCustomerInteractionAsync(orderMainEntity.getCustomerId(), 1, InteractionTypeEnum.PAY.getValue(), orderMainNo, orderMainEntity.getPlatformId());
            this.log.info("\u6d88\u8d39\u5b8c\u8ba2\u5355\u6d88\u606f....\u8ba2\u5355\u53f7:{}", (Object)orderMainEntity.getOrderMainNo());
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u6d88\u606f\u5904\u7406\u5931\u8d25" + message.getMsgID(), (Throwable)e);
        }
        return true;
    }
}

