/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.apiinvoke.cms.CorpTagInvoke;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.vo.weixin.ScanMessageVo;
import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.mall.entity.customer.InteractionTypeEnum;
import cc.lechun.mall.iservice.customer.InteractionInterface;
import cc.lechun.mall.iservice.weixin.WeiXinScanInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scanCode")
public class ScanQrcodeListener
implements MessageQueueInterface {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeiXinScanInterface scanReceiveMessageService;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    private InteractionInterface interactionInterface;
    @Autowired
    CorpTagInvoke corpTagInvoke;
    @Autowired
    private ActiveInterface activeInterface;

    public boolean receive(Message message, ConsumeContext consumeContext) {
        this.log.info("\u63a5\u53d7\u626b\u7801\u6d88\u606f...");
        try {
            Map messageBody = (Map)ObjectConvert.toObject((byte[])message.getBody());
            ScanMessageVo scanMessageVo = new ScanMessageVo();
            scanMessageVo.setPlatformId(Integer.parseInt(messageBody.get("platformId").toString()));
            scanMessageVo.setUserId(messageBody.get("userId").toString());
            scanMessageVo.setDtFrom(messageBody.get("dtFrom").toString());
            scanMessageVo.setBindCode(messageBody.get("bindCode").toString());
            scanMessageVo.setOpenId(messageBody.get("openId").toString());
            try {
                ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(messageBody.get("bindCode").toString());
                if (activeEntity != null && Objects.equals(activeEntity.getActiveType(), 40)) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("\u5305\u88f9\u5361\u8ba2\u5355\u300c\u6296\u97f3\u300d", 155);
                    map.put("\u5305\u88f9\u5361\u8ba2\u5355\u300c\u4eac\u4e1c\u300d", 156);
                    map.put("\u5305\u88f9\u5361\u8ba2\u5355\u300c\u5929\u732b\u300d", 154);
                    map.put("\u5305\u88f9\u5361\u8ba2\u5355\u626b\u7801\u300c\u5fae\u4fe1\u5927\u7ea2\u8272\u300d", 153);
                    if (map.get(activeEntity.getActiveName()) != null) {
                        this.corpTagInvoke.markTag(messageBody.get("userId").toString(), (Integer)map.get(activeEntity.getActiveName()), DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mallRedisLock.lock("SCAN:" + messageBody.get("bindCode").toString(), messageBody.get("userId").toString(), 60L, TimeUnit.SECONDS)) {
                this.scanReceiveMessageService.scanCode(scanMessageVo).isSuccess();
                this.interactionInterface.saveCustomerInteractionAsync(messageBody.get("userId").toString(), 1, InteractionTypeEnum.SCAN.getValue(), messageBody.get("bindCode").toString(), Integer.parseInt(messageBody.get("platformId").toString()));
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("\u626b\u7801\u6d88\u606f{}\u5904\u7406\u5931\u8d25{}", (Object)message.getMsgID(), (Object)e);
            return false;
        }
    }
}

