/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.messagePush;

import cc.lechun.common.constants.message.MessageActionConstants;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallOrderProductMapper;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.messagePush.PaySuccessMessageInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaySuccessMessageService
extends BaseService
implements PaySuccessMessageInterface {
    @Autowired
    private MessageInterface messageInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private MallOrderProductMapper mallOrderProductMapper;
    @Autowired
    private MallProductInterface mallProductInterface;

    @Override
    public BaseJsonVo confirmGoodsNotify(MallOrderMainEntity orderMainEntity) {
        if (DateUtils.getAddDateByDay((Date)orderMainEntity.getCreateTime(), (int)7).before(new Date())) {
            return BaseJsonVo.error((String)"7\u5929\u540e\u786e\u8ba4\u6536\u8d27\u7684\u4e0d\u518d\u53d1\u9001\u6d88\u606f");
        }
        if (orderMainEntity.getPlatformId() == 4) {
            List<MallOrderEntity> list = this.mallOrderInterface.getOrderList(orderMainEntity.getOrderMainNo());
            MallOrderEntity orderEntity = list.get(0);
            List<MallOrderProductEntity> mallOrderProductEntityList = this.mallOrderProductMapper.getOrderProductInfoByOrderNo(orderEntity.getOrderNo());
            StringBuffer sb = new StringBuffer();
            if (mallOrderProductEntityList != null && mallOrderProductEntityList.size() > 0) {
                for (MallOrderProductEntity mallOrderProductEntity : mallOrderProductEntityList) {
                    if (mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                        MallProductEntity mallProductEntity = this.mallProductInterface.getProduct(mallOrderProductEntity.getProductId());
                        sb.append(mallProductEntity.getProNameSx() == null ? mallOrderProductEntity.getProductName() : mallProductEntity.getProNameSx()).append(",");
                        continue;
                    }
                    sb.append(mallOrderProductEntity.getProductName()).append(",");
                }
            }
            String productName = sb.toString();
            productName = productName.substring(0, productName.length() - 1);
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (orderMainEntity.getPlatformId() == 4 && productName.length() > 20) {
                productName = productName.indexOf(",") > 0 ? ((productName = productName.substring(0, productName.lastIndexOf(","))).length() > 16 ? productName.substring(0, 16) + "..." : productName + "...") : productName.substring(0, 16) + "...";
            }
            paramsMap.put("proName", productName);
            paramsMap.put("deliverName", orderEntity.getDeliverName());
            paramsMap.put("waybillNo", orderEntity.getWaybillNo());
            return this.messageInterface.sendWechatMessage(MessageActionConstants.confirmGoods, orderMainEntity.getCustomerId(), paramsMap);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo sendCrowdPaySuccessNotify(MallOrderMainEntity orderMainEntity, String openId) {
        return this.messageInterface.sendWechatMessage(MessageActionConstants.orderpaysuccessCrowd, orderMainEntity.getCustomerId(), null);
    }

    @Override
    public BaseJsonVo sendSuccessNotify(MallOrderMainEntity orderMainEntity) {
        try {
            if (orderMainEntity.getPlatformId() == 4 && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARDPLAN.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_TMALL.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_JD_POP.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_CHANNEL.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_JD_SELF_RUN.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_CHANNEL.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_STRATEGY.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_SHOP.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.RECHANGE_CARD.getValue()) {
                List<MallOrderEntity> list = this.mallOrderInterface.getOrderList(orderMainEntity.getOrderMainNo());
                MallOrderEntity orderEntity = list.get(0);
                List<MallOrderProductEntity> mallOrderProductEntityList = this.mallOrderProductMapper.getOrderProductInfoByOrderNo(orderEntity.getOrderNo());
                StringBuffer sb = new StringBuffer();
                int num = 0;
                if (mallOrderProductEntityList != null && mallOrderProductEntityList.size() > 0) {
                    for (MallOrderProductEntity mallOrderProductEntity : mallOrderProductEntityList) {
                        if (mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                            MallProductEntity mallProductEntity = this.mallProductInterface.getProduct(mallOrderProductEntity.getProductId());
                            sb.append(mallProductEntity.getProNameSx() == null ? mallOrderProductEntity.getProductName() : mallProductEntity.getProNameSx()).append(",");
                        } else {
                            sb.append(mallOrderProductEntity.getProductName()).append(",");
                        }
                        num += mallOrderProductEntity.getQuantity().intValue();
                    }
                }
                String itemName = sb.toString();
                itemName = itemName.substring(0, itemName.length() - 1);
                if (orderMainEntity.getPlatformId() == 4 && itemName.length() > 20) {
                    itemName = itemName.indexOf(",") > 0 ? ((itemName = itemName.substring(0, itemName.lastIndexOf(","))).length() > 16 ? itemName.substring(0, 16) + "..." : itemName + "...") : itemName.substring(0, 16) + "...";
                }
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                String orderAmount = String.valueOf(orderMainEntity.getOrderAmount());
                if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                    orderAmount = String.valueOf(orderMainEntity.getPoints());
                }
                paramsMap.put("payAmount", orderAmount);
                paramsMap.put("createTime", DateUtils.now((String)""));
                paramsMap.put("number", String.valueOf(num));
                paramsMap.put("proName", itemName);
                return this.messageInterface.sendWechatMessage(MessageActionConstants.paySuceessNotice, orderMainEntity.getCustomerId(), paramsMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo sendRechangeNotify(MallOrderMainEntity orderMainEntity) {
        try {
            List<MallOrderPayEntity> list;
            if (orderMainEntity.getPlatformId() == 4 && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARDPLAN.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_TMALL.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_JD_POP.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_CHANNEL.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_JD_SELF_RUN.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_CHANNEL.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_STRATEGY.getValue() && orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_SHOP.getValue() && (list = this.orderPayInterface.getOrderPayInfoByOrderMainNoPayList(PayTypeEnum.BALANCE_PAY.getValue(), orderMainEntity.getOrderMainNo())) != null && list.size() > 0) {
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("change", String.valueOf(list.stream().mapToDouble(c -> c.getPayamount().doubleValue()).sum()));
                paramsMap.put("rechange", String.valueOf(this.accountBalanceInterface.getGiftBalanceById(orderMainEntity.getCustomerId())));
                paramsMap.put("notice", "\u4f59\u989d\u53d8\u52a8\u63d0\u9192");
                this.messageInterface.sendWechatMessage(MessageActionConstants.rechange, orderMainEntity.getCustomerId(), paramsMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void sendRechangeNotify(BigDecimal rechange, String customerId, Integer platformId, String remark) {
        if (platformId == 4) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("change", String.valueOf(rechange));
            paramsMap.put("rechange", String.valueOf(this.accountBalanceInterface.getGiftBalanceById(customerId)));
            paramsMap.put("notice", remark);
            this.messageInterface.sendWechatMessage(MessageActionConstants.rechange, customerId, paramsMap);
        }
    }
}

