/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.platform;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.mall.dao.platform.PlatFormGroupMapper;
import cc.lechun.mall.entity.platform.PlatFormGroupEntity;
import cc.lechun.mall.iservice.platform.PlatFormGroupInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlatFormGroupService
implements PlatFormGroupInterface {
    private static final Logger log = LoggerFactory.getLogger(PlatFormGroupService.class);
    @Autowired
    private PlatFormGroupMapper platFormGroupMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="PlatFormGroup", expiration=7200)
    @ReadDataSource
    public PlatFormGroupEntity getPlatFormGroup(@ParameterValueKeyProvider int platformGroupId) {
        return (PlatFormGroupEntity)this.platFormGroupMapper.selectByPrimaryKey(Integer.valueOf(platformGroupId));
    }

    @Override
    @ReadThroughAssignCache(assignedKey="list", namespace="ValidPlatFormGroupList", expiration=7200)
    @ReadDataSource
    public List<PlatFormGroupEntity> getValidPlatFormGroupList() {
        PlatFormGroupEntity platFormGroupEntity = new PlatFormGroupEntity();
        platFormGroupEntity.setStatus(1);
        return this.platFormGroupMapper.getList(platFormGroupEntity);
    }

    @Override
    @ReadThroughAssignCache(assignedKey="list", namespace="PlatFormGroupList", expiration=7200)
    @ReadDataSource
    public List<PlatFormGroupEntity> getPlatFormGroupList() {
        return this.platFormGroupMapper.getList(new PlatFormGroupEntity());
    }
}

