/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardBatchMapper;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardItemEntity;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallRecommendCardVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardBatchService
extends BaseService<PrepayCardBatchEntity, Integer>
implements PrepayCardBatchInterface {
    @Resource
    PrepayCardBatchMapper prepayCardBatchMapper;
    @Autowired
    PrepayCardItemInterface prepayCardItemInterface;
    @Autowired
    MallProductInterface productService;
    @Autowired
    MallPromotionInterface promotionInterface;

    @Override
    public void cacPoint(MallMainOrderVo mainOrderVo) {
        for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
            int cardType;
            int n = cardType = orderVo.getTransportType() == 1 ? 3 : 0;
            if (StringUtils.isNotEmpty((String)mainOrderVo.getOrderCacheVo().getBindCode()) && (Objects.equals(mainOrderVo.getOrderCacheVo().getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue())) || Objects.equals(mainOrderVo.getOrderCacheVo().getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue())))) {
                cardType = Integer.valueOf(mainOrderVo.getOrderCacheVo().getBindCode());
            }
            if (cardType <= 0) continue;
            List<PrepayCardItemEntity> pointProductList = this.prepayCardItemInterface.getCardItemEntityList(cardType);
            BigDecimal usedCardPointAmount = BigDecimal.ZERO;
            BigDecimal canUsedCardAmount = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(orderVo.getProducts())) {
                for (MallProductVO mallProductVO : orderVo.getProducts()) {
                    this.productService.setProductPoint(mallProductVO, pointProductList);
                    if (mallProductVO.getCardFactPrice().compareTo(BigDecimal.ZERO) <= 0) continue;
                    usedCardPointAmount = PriceUtils.add((BigDecimal)usedCardPointAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)mallProductVO.getCardFactPrice(), (Integer)mallProductVO.getCount()));
                    canUsedCardAmount = PriceUtils.add((BigDecimal)canUsedCardAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)mallProductVO.getFactPrice(), (Integer)mallProductVO.getCount()));
                    this.logger.info("\u5546\u54c1:{},\u70b9\u5361\u7ed3\u7b97\u91d1\u989d:{},\u73b0\u91d1\u7ed3\u7b97\u91d1\u989d:{},\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d:{}", new Object[]{mallProductVO.getProName(), mallProductVO.getCardFactPrice(), mallProductVO.getFactPrice(), canUsedCardAmount});
                }
            }
            if (CollectionUtils.isNotEmpty(orderVo.getPromotions())) {
                for (MallPromotionVO mallPromotionVO : orderVo.getPromotions()) {
                    this.promotionInterface.setProductPoint(mallPromotionVO, pointProductList);
                    if (mallPromotionVO.getCardFactPrice().compareTo(BigDecimal.ZERO) <= 0) continue;
                    usedCardPointAmount = PriceUtils.add((BigDecimal)usedCardPointAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)mallPromotionVO.getCardFactPrice(), (Integer)mallPromotionVO.getCount()));
                    canUsedCardAmount = PriceUtils.add((BigDecimal)canUsedCardAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)mallPromotionVO.getFactPrice(), (Integer)mallPromotionVO.getCount()));
                    this.logger.info("\u5546\u54c1:{},\u70b9\u5361\u7ed3\u7b97\u91d1\u989d:{},\u73b0\u91d1\u7ed3\u7b97\u91d1\u989d:{},\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d:{}", new Object[]{mallPromotionVO.getPromotionName(), mallPromotionVO.getCardFactPrice(), mallPromotionVO.getFactPrice(), canUsedCardAmount});
                }
            }
            orderVo.setCanUseCardPrice(canUsedCardAmount);
            orderVo.setUseCardPointPrice(usedCardPointAmount);
        }
        BigDecimal[] useCardPointPrice = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] canUseCardPrice = new BigDecimal[]{new BigDecimal(0)};
        mainOrderVo.getMallOrderVos().forEach(c -> {
            if (c.getCanUseCardPrice().compareTo(BigDecimal.ZERO) > 0) {
                useCardPointPrice[0] = PriceUtils.addNoUp((BigDecimal)useCardPointPrice[0], (BigDecimal)c.getUseCardPointPrice());
                canUseCardPrice[0] = PriceUtils.addNoUp((BigDecimal)canUseCardPrice[0], (BigDecimal)c.getCanUseCardPrice());
                this.logger.info("\u4f7f\u7528\u5361\u652f\u4ed8\u7d2f\u8ba1\u70b9\u6570\u91d1\u989d\u548c:{},\u5b9e\u9645\u91d1\u989d:{},\u5b50\u5355\u5b9e\u9645\u91d1\u989d:{}", new Object[]{useCardPointPrice[0], canUseCardPrice[0], c.getOrderAmount()});
            }
        });
        mainOrderVo.setUseCardPointPrice(useCardPointPrice[0]);
        mainOrderVo.setCanUseCardPrice(canUseCardPrice[0]);
        this.logger.info("\u80fd\u7528\u5361\u5546\u54c1\u91d1\u989d:{}", (Object)canUseCardPrice[0]);
    }

    @Override
    public List<PrepayCardBatchEntity> getPrepayCardBatchEntityList(BigDecimal cardPointAmount, int batchType) {
        List<Object> resultList = new ArrayList();
        resultList = batchType == 3 ? this.prepayCardBatchMapper.getEnableBatchListForNewCard(batchType, 26) : this.prepayCardBatchMapper.getEnableBatchList(batchType, 26);
        if (CollectionUtils.isNotEmpty(resultList = resultList.stream().filter(c -> c.getCardPrice().intValue() >= 500).collect(Collectors.toList()))) {
            if (Integer.valueOf(3).equals(batchType)) {
                return resultList.stream().filter(card -> card.getCardPrice().compareTo(cardPointAmount) >= 0).sorted(Comparator.comparing(PrepayCardBatchEntity::getCardPrice)).collect(Collectors.toList());
            }
            return resultList.stream().filter(card -> card.getSaleValue().compareTo(cardPointAmount) >= 0).sorted(Comparator.comparing(PrepayCardBatchEntity::getSaleValue)).collect(Collectors.toList());
        }
        return new ArrayList<PrepayCardBatchEntity>();
    }

    @Override
    public BaseJsonVo<List<MallRecommendCardVO>> buildMallRecommendCardVO(MallOrderVo orderVo, PrepayCardBatchEntity prepayCardBatchEntity, MallPromotionVO promotionVO, BigDecimal canUseCardPrice, BigDecimal cardPointAmount) {
        ArrayList<MallRecommendCardVO> resultList = new ArrayList<MallRecommendCardVO>();
        MallRecommendCardVO recommendCardVO = new MallRecommendCardVO();
        recommendCardVO.setAddMaxCount(1);
        recommendCardVO.setBatchId(prepayCardBatchEntity.getBatchId());
        recommendCardVO.setCardCutAmount(orderVo.getUseCardCutAmount());
        recommendCardVO.setFactPrice(promotionVO.getFactPrice());
        recommendCardVO.setOriginPrice(promotionVO.getOriginPrice());
        recommendCardVO.setHasFreight(0);
        recommendCardVO.setProductPic(promotionVO.getPromotionPic());
        recommendCardVO.setProName(promotionVO.getPromotionName());
        recommendCardVO.setProductType(SalesTypeEnum.SALES_PROMOTION.getValue());
        recommendCardVO.setProId(promotionVO.getPromotionId());
        recommendCardVO.setFactPrice(promotionVO.getFactPrice() != null ? promotionVO.getFactPrice() : promotionVO.getPromotionPrice());
        recommendCardVO.setCouponAmount(BigDecimal.ZERO);
        recommendCardVO.setCount(promotionVO.getCount());
        recommendCardVO.setDeductionAmount(PriceUtils.subtract((BigDecimal)canUseCardPrice, (BigDecimal)orderVo.getUseCardCutAmount()));
        recommendCardVO.setSurplus(PriceUtils.subtract((BigDecimal)prepayCardBatchEntity.getCardPrice(), (BigDecimal)cardPointAmount));
        resultList.add(recommendCardVO);
        orderVo.setRecommendCardVOList(resultList);
        return BaseJsonVo.success(resultList);
    }

    @Override
    @ReadThroughSingleCache(namespace="PrepayCardBatchService.getPrepayCardBatch", expiration=300)
    public Integer getPrepayCardType(@ParameterValueKeyProvider String shoppingType) {
        if (shoppingType.length() > 2) {
            PrepayCardBatchEntity prepayCardBatchEntity = this.prepayCardBatchMapper.getPrepayCardBatch(shoppingType);
            return prepayCardBatchEntity == null ? null : prepayCardBatchEntity.getCardType();
        }
        return Integer.valueOf(shoppingType);
    }
}

