/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardFreeMapper;
import cc.lechun.mall.entity.customer.CustomerFreeEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeProductEntity;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.iservice.customer.CustomerFreeInterface;
import cc.lechun.mall.iservice.customer.CustomerFreeRecordInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardFreeInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallFreeProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardFreeService
extends BaseService<PrepayCardFreeEntity, Integer>
implements PrepayCardFreeInterface {
    @Resource
    private PrepayCardFreeMapper prepayCardFreeMapper;
    @Autowired
    private MallFreeInterface mallFreeInterface;
    @Autowired
    private MallFreeProductInterface freeProductInterface;
    @Autowired
    private PrepayCardInterface prepayCardInterface;
    @Autowired
    private CustomerFreeRecordInterface freeRecordInterface;
    @Autowired
    @Lazy
    private CustomerFreeInterface customerFreeInterface;
    @Autowired
    MallProductPicInterface picService;

    @Override
    public List<Map<String, Object>> getCardFreeProduct(String customerId, String card) {
        if (StringUtils.isNotEmpty((String)card)) {
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)card));
            if (prepayCardEntity == null) {
                return new ArrayList<Map<String, Object>>();
            }
            if (!customerId.equals(prepayCardEntity.getBelongCustomerId())) {
                return new ArrayList<Map<String, Object>>();
            }
            return this.getCardFreeProduct(prepayCardEntity.getBatchId(), customerId, card);
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public boolean checkCustomerIsChooseFree(String customerId, Integer batchId, Integer addOrShow) {
        if (StringUtil.isEmpty((String)customerId)) {
            return false;
        }
        return this.freeRecordInterface.existsFreeRecord(customerId, batchId, addOrShow);
    }

    @Override
    public List<Map<String, Object>> getCardFreeProduct(Integer batchId, String customerId, String cardId) {
        if (batchId == null || StringUtils.isEmpty((String)cardId)) {
            return new ArrayList<Map<String, Object>>();
        }
        PrepayCardFreeEntity prepayCardFreeEntity = new PrepayCardFreeEntity();
        prepayCardFreeEntity.setBatchId(batchId);
        prepayCardFreeEntity.setStatus(1);
        List lst = this.getList(prepayCardFreeEntity, 0L);
        if (!this.checkCustomerIsChooseFree(customerId, batchId, 0)) {
            lst = lst.stream().filter(c -> Integer.valueOf(1).equals(c.getFreeType())).collect(Collectors.toList());
        }
        lst = lst.stream().filter(c -> Integer.valueOf(2).equals(c.getCright()) || Integer.valueOf(3).equals(c.getCright())).collect(Collectors.toList());
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        HashMap<String, Integer> existsMap = new HashMap<String, Integer>();
        for (PrepayCardFreeEntity freeEntity : lst) {
            CustomerFreeEntity search = new CustomerFreeEntity();
            search.setCustomerId(customerId);
            search.setCardBatchId(batchId);
            search.setFreeId(freeEntity.getFreeId());
            search.setCardId(cardId);
            List freeEntities = this.customerFreeInterface.getList(search, 0L);
            int count = freeEntities.stream().filter(c -> !Integer.valueOf(0).equals(c.getStatus())).mapToInt(c -> c.getQuantity()).sum();
            if (existsMap.get(freeEntity.getBatchId() + "_" + freeEntity.getFreeId()) != null) {
                count = (Integer)existsMap.get(freeEntity.getBatchId() + "_" + freeEntity.getFreeId());
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("id", freeEntity.getId());
            map.put("batchId", batchId);
            map.put("quantity", freeEntity.getFreeQuantity() - count < 0 ? 0 : freeEntity.getFreeQuantity() - count);
            if (count - freeEntity.getFreeQuantity() > 0) {
                existsMap.put(freeEntity.getBatchId() + "_" + freeEntity.getFreeId(), count - freeEntity.getFreeQuantity());
                count = freeEntity.getFreeQuantity();
            } else {
                existsMap.put(freeEntity.getBatchId() + "_" + freeEntity.getFreeId(), 0);
            }
            map.put("usedQuantity", count);
            map.put("freeType", freeEntity.getFreeType());
            map.put("freeMethod", freeEntity.getFreeMethod());
            map.put("freeId", freeEntity.getFreeId());
            MallFreeEntity mallFreeEntity = this.mallFreeInterface.selectByPrimaryKey(freeEntity.getFreeId());
            if (mallFreeEntity != null) {
                map.put("freeName", mallFreeEntity.getFreeName());
            }
            ArrayList freeProducts = new ArrayList();
            if (StringUtil.isNotEmpty((String)freeEntity.getFreeId())) {
                List<MallFreeProductEntity> frees = this.mallFreeInterface.getMallFreeProduct(freeEntity.getFreeId());
                for (MallFreeProductEntity freeProductEntity : frees) {
                    LinkedHashMap<String, Object> productMap = new LinkedHashMap<String, Object>();
                    productMap.put("productId", freeProductEntity.getProductId());
                    productMap.put("productName", freeProductEntity.getProductName());
                    productMap.put("productType", freeProductEntity.getProductType());
                    productMap.put("quantity", freeProductEntity.getProductCount());
                    List<MallProductPicEntity> picList1 = this.picService.getProductPics(freeProductEntity.getProductId(), ProductPicTypeEnum.PRO_SAMLL.getValue());
                    productMap.put("image", picList1 != null && picList1.size() > 0 ? picList1.get(0).getFullRelativeUrl() : "");
                    freeProducts.add(productMap);
                }
            }
            map.put("freeProducts", freeProducts);
            results.add(map);
        }
        return results;
    }
}

