/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardItemMapper;
import cc.lechun.mall.dao.prepay.PrepayCardMapper;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardItemEntity;
import cc.lechun.mall.entity.prepay.PrepayCardRecommendDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardStatusEnum;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.sales.MallIndexPromotionVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardItemService
extends BaseService<PrepayCardItemEntity, Integer>
implements PrepayCardItemInterface {
    @Resource
    private PrepayCardItemMapper prepayCardItemMapper;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private PrepayCardMapper prepayCardMapper;
    @Autowired
    BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    private MallPromotionProductInterface promotionProductInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private ActiveInterface activeInterface;

    @Override
    public BaseJsonVo<List<MallIndexProductVo>> getPrepayCardItem(String customerId, String bindCode, Integer cardType) {
        PrepayCardItemEntity search = new PrepayCardItemEntity();
        if (Objects.equals(cardType, PrepayCardTypeEnum.new_card_Cold.getValue()) || Objects.equals(cardType, PrepayCardTypeEnum.new_card_Nomal.getValue())) {
            BaseJsonVo<List<Map<String, Object>>> baseJsonVo = this.balanceAccountInvoke.getUsableSpecialList(customerId, cardType);
            if (!baseJsonVo.isSuccess()) {
                this.logger.error("\u7528\u6237:{}\u6ca1\u6709\u53ef\u7528\u5976\u5361", (Object)customerId);
                return BaseJsonVo.error((String)baseJsonVo.getMessage());
            }
            PrepayCardEntity cardQuery = new PrepayCardEntity();
            cardQuery.setRelateCardNo(((Map)((List)baseJsonVo.getValue()).get(0)).get("cardNo").toString());
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardMapper.getSingle(cardQuery);
            search.setCardBatchId(prepayCardEntity.getBatchId());
        } else {
            cardType = this.getCardTypeByBindCode(bindCode);
            if (cardType == null) {
                cardType = PrepayCardTypeEnum.yogurt_card.getValue();
            }
        }
        search.setCardType(cardType);
        search.setStatus(1);
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u5217\u8868:{}", (Object)search.toString());
        List lst = this.getList(search);
        ArrayList<Object> productVoList = new ArrayList<Object>();
        List<MallShoppingcartEntity> cardList = this.shoppingcartInterface.getShoppingCart(customerId, StringUtils.isNotEmpty((String)bindCode) ? bindCode : cardType.toString());
        for (PrepayCardItemEntity p : lst) {
            MallShoppingcartEntity entity;
            Optional<MallShoppingcartEntity> entityOptional;
            BaseJsonVo<MallIndexProductVo> baseJsonVo;
            if (p.getSaleValue() == null || p.getSaleValue().compareTo(BigDecimal.ZERO) <= 0) {
                this.logger.error("\u5546\u54c1:{},\u7c7b\u578b:{} \u6ca1\u6709\u9500\u552e\u4ef7\u6216\u8005\u5df2\u4e0b\u67b6", (Object)p.getItemId(), (Object)p.getItemType());
                continue;
            }
            if (!Integer.valueOf(4).equals(p.getItemType()) || !(baseJsonVo = this.productInterface.buildIndexProductVo(p.getItemId())).isSuccess()) continue;
            ((MallIndexProductVo)baseJsonVo.getValue()).setQuantity(0);
            if (CollectionUtils.isNotEmpty(cardList) && (entityOptional = cardList.stream().filter(card -> Objects.equals(card.getSalesId(), p.getItemId())).findFirst()).isPresent() && (entity = entityOptional.get()) != null) {
                ((MallIndexProductVo)baseJsonVo.getValue()).setQuantity(entity.getQuantity());
            }
            ((MallIndexProductVo)baseJsonVo.getValue()).setSaleValue(p.getSaleValue());
            ((MallIndexProductVo)baseJsonVo.getValue()).setCardOriginPrice(p.getOriginPrice());
            productVoList.add(baseJsonVo.getValue());
        }
        return BaseJsonVo.success(productVoList);
    }

    @Override
    public BaseJsonVo<Map<String, Object>> getPrepayCardProductItem(String customerId, String bindCode, Integer cardType) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        if (cardType == null || Objects.equals(cardType, PrepayCardTypeEnum.yogurt_card.getValue())) {
            cardType = PrepayCardTypeEnum.yogurt_card.getValue();
            map.put("limitMinCount", Integer.valueOf(990));
            PrepayCardBatchEntity entity = new PrepayCardBatchEntity();
            entity.setBindCode(bindCode);
            entity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.getSingle(entity);
            if (entity != null) {
                map.put("limitMinCount", Integer.valueOf(entity.getPerPrice().intValue()));
                cardType = entity.getCardType();
            }
        }
        Map<String, BigDecimal> specialAccount = this.balanceAccountInvoke.getSpecialAccount(customerId, cardType);
        map.put("saleValue", specialAccount.get("usableAccount"));
        PrepayCardItemEntity search = new PrepayCardItemEntity();
        if (Objects.equals(cardType, PrepayCardTypeEnum.new_card_Cold.getValue()) || Objects.equals(cardType, PrepayCardTypeEnum.new_card_Nomal.getValue())) {
            BaseJsonVo<List<Map<String, Object>>> baseJsonVo = this.balanceAccountInvoke.getUsableSpecialList(customerId, cardType);
            if (!baseJsonVo.isSuccess()) {
                return BaseJsonVo.error((String)baseJsonVo.getMessage());
            }
            PrepayCardEntity cardQuery = new PrepayCardEntity();
            cardQuery.setRelateCardNo(((Map)((List)baseJsonVo.getValue()).get(0)).get("cardNo").toString());
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardMapper.getSingle(cardQuery);
            search.setCardBatchId(prepayCardEntity.getBatchId());
            PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(prepayCardEntity.getBatchId());
            this.logger.info("\u7528\u6237:{}\u4f7f\u7528\u5361:{}\u7684\u4ef7\u683c\u9009\u8d2d\u5546\u54c1", (Object)customerId, (Object)prepayCardBatchEntity.getBatchName());
            map.put("limitMinCount", prepayCardBatchEntity.getPerPrice());
        }
        search.setCardType(cardType);
        search.setStatus(1);
        this.logger.info("\u67e5\u8be2\u5546\u54c1\u5217\u8868:{}", (Object)search.toString());
        List lst = this.getList(search, 0L);
        ArrayList<Object> productVoList = new ArrayList<Object>();
        ArrayList<Object> promotionVoList = new ArrayList<Object>();
        List<MallShoppingcartEntity> cardList = this.shoppingcartInterface.getShoppingCart(customerId, StringUtils.isNotEmpty((String)bindCode) ? bindCode : cardType.toString());
        for (PrepayCardItemEntity p : lst) {
            MallShoppingcartEntity entity;
            Optional<MallShoppingcartEntity> entityOptional;
            Object baseJsonVo;
            if (p.getSaleValue() == null || p.getSaleValue().compareTo(BigDecimal.ZERO) <= 0) {
                this.logger.error("\u5546\u54c1:{},\u7c7b\u578b:{} \u6ca1\u6709\u9500\u552e\u4ef7\u6216\u8005\u5df2\u4e0b\u67b6", (Object)p.getItemId(), (Object)p.getItemType());
                continue;
            }
            if (Objects.equals(SalesTypeEnum.SALES_PRODUCT.getValue(), p.getItemType())) {
                baseJsonVo = this.productInterface.buildIndexProductVo(p.getItemId());
                if (!baseJsonVo.isSuccess()) continue;
                ((MallIndexProductVo)baseJsonVo.getValue()).setQuantity(0);
                if (CollectionUtils.isNotEmpty(cardList) && (entityOptional = cardList.stream().filter(card -> Objects.equals(card.getSalesId(), p.getItemId())).findFirst()).isPresent() && (entity = entityOptional.get()) != null) {
                    ((MallIndexProductVo)baseJsonVo.getValue()).setQuantity(entity.getQuantity());
                }
                ((MallIndexProductVo)baseJsonVo.getValue()).setSaleValue(p.getSaleValue());
                ((MallIndexProductVo)baseJsonVo.getValue()).setCardOriginPrice(p.getOriginPrice());
                productVoList.add(baseJsonVo.getValue());
                continue;
            }
            if (!Objects.equals(SalesTypeEnum.SALES_PROMOTION.getValue(), p.getItemType()) || !(baseJsonVo = this.promotionInterface.buildIndexPromotionVo(p.getItemId())).isSuccess()) continue;
            ((MallIndexPromotionVo)baseJsonVo.getValue()).setQuantity(0);
            if (CollectionUtils.isNotEmpty(cardList) && (entityOptional = cardList.stream().filter(card -> Objects.equals(card.getSalesId(), p.getItemId())).findFirst()).isPresent() && (entity = entityOptional.get()) != null) {
                ((MallIndexPromotionVo)baseJsonVo.getValue()).setQuantity(entity.getQuantity());
            }
            ((MallIndexPromotionVo)baseJsonVo.getValue()).setCardFactPrice(p.getSaleValue());
            ((MallIndexPromotionVo)baseJsonVo.getValue()).setCardOriginPrice(p.getOriginPrice());
            promotionVoList.add(baseJsonVo.getValue());
        }
        map.put("item", productVoList);
        map.put("promotionItem", promotionVoList);
        return BaseJsonVo.success(map);
    }

    private BigDecimal getRate(String customerId, Integer cardType) {
        PrepayCardEntity query = new PrepayCardEntity();
        query.setBelongCustomerId(customerId);
        query.setCardType(cardType);
        List cardEntityList = this.prepayCardMapper.getList(query);
        if (CollectionUtils.isEmpty((Collection)cardEntityList)) {
            this.logger.info("\u7528\u6237:{}\u5e10\u6237\u4e2d\u65e0{} \u7c7b\u578b\u5976\u5361", (Object)customerId, (Object)cardType);
            return BigDecimal.ONE;
        }
        BigDecimal rate = BigDecimal.ONE;
        if (CollectionUtils.isNotEmpty(cardEntityList = cardEntityList.stream().filter(c -> c.getMilkCardRate() != null && (Objects.equals(c.getStatus(), PrepayCardStatusEnum.ACTIVE.getValue()) || Objects.equals(c.getStatus(), PrepayCardStatusEnum.TAKED.getValue()))).sorted((c1, c2) -> c1.getMilkCardRate().compareTo(c2.getMilkCardRate())).collect(Collectors.toList()))) {
            rate = ((PrepayCardEntity)cardEntityList.get(0)).getMilkCardRate();
            this.logger.info("\u7528\u6237:{},\u4ef7\u683c\u6d6e\u52a8:{},\u5361:{}", new Object[]{customerId, rate, ((PrepayCardEntity)cardEntityList.get(0)).getCardId()});
        }
        return rate == null ? BigDecimal.ONE : rate;
    }

    @Override
    public Integer getCardTypeByBindCode(String bindCode) {
        PrepayCardBatchEntity search = new PrepayCardBatchEntity();
        search.setBindCode(bindCode);
        search = (PrepayCardBatchEntity)this.prepayCardBatchInterface.getSingle(search);
        if (search != null) {
            return search.getCardType();
        }
        return null;
    }

    @Override
    public PrepayCardItemEntity getCardItemEntityByBindCode(String customerId, String bindCode, Integer itemType, String itemId) {
        Integer cardType = PrepayCardTypeEnum.yogurt_card.getValue();
        BigDecimal rate = BigDecimal.ONE;
        PrepayCardItemEntity query = new PrepayCardItemEntity();
        if (Objects.equals(bindCode, String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue())) || Objects.equals(bindCode, String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue()))) {
            cardType = Integer.valueOf(bindCode);
            BaseJsonVo<List<Map<String, Object>>> baseJsonVo = this.balanceAccountInvoke.getUsableSpecialList(customerId, cardType);
            if (!baseJsonVo.isSuccess()) {
                this.logger.error("\u7528\u6237:{}\u4f59\u989d\u7cfb\u7edf\u8fd4\u56de\u51fa\u9519:{}", (Object)customerId, (Object)baseJsonVo.getMessage());
                throw new RuntimeException(baseJsonVo.getMessage());
            }
            PrepayCardEntity cardQuery = new PrepayCardEntity();
            cardQuery.setRelateCardNo(((Map)((List)baseJsonVo.getValue()).get(0)).get("cardNo").toString());
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardMapper.getSingle(cardQuery);
            query.setCardBatchId(prepayCardEntity.getBatchId());
        }
        query.setCardType(cardType);
        query.setItemId(itemId);
        query.setItemType(itemType);
        query.setStatus(1);
        this.logger.info("\u67e5\u8be2:{}", (Object)query.toString());
        PrepayCardItemEntity prepayCardItemEntity = (PrepayCardItemEntity)this.getSingle(query);
        if (prepayCardItemEntity != null) {
            prepayCardItemEntity.setSaleValue(PriceUtils.multiply((BigDecimal)prepayCardItemEntity.getSaleValue(), (BigDecimal)rate));
        }
        return prepayCardItemEntity;
    }

    @Override
    public List<PrepayCardItemEntity> getCardItemEntityListByBindCode(String customerId, String bindCode, Integer itemType) {
        this.logger.info("\u6279\u91cf\u67e5\u8be2\u63a5\u6536\u53c2\u6570customerId:{},bindCode:{},itemType:{}", new Object[]{customerId, bindCode, itemType});
        Integer cardType = PrepayCardTypeEnum.yogurt_card.getValue();
        BigDecimal rate = BigDecimal.ONE;
        PrepayCardItemEntity query = new PrepayCardItemEntity();
        if (Objects.equals(bindCode, String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue())) || Objects.equals(bindCode, String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue()))) {
            cardType = Integer.valueOf(bindCode);
            BaseJsonVo<List<Map<String, Object>>> baseJsonVo = this.balanceAccountInvoke.getUsableSpecialList(customerId, cardType);
            if (!baseJsonVo.isSuccess()) {
                this.logger.error("\u7528\u6237:{}\u4f59\u989d\u7cfb\u7edf\u8fd4\u56de\u51fa\u9519:{}", (Object)customerId, (Object)baseJsonVo.getMessage());
                throw new RuntimeException(baseJsonVo.getMessage());
            }
            PrepayCardEntity cardQuery = new PrepayCardEntity();
            cardQuery.setRelateCardNo(((Map)((List)baseJsonVo.getValue()).get(0)).get("cardNo").toString());
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardMapper.getSingle(cardQuery);
            query.setCardBatchId(prepayCardEntity.getBatchId());
        }
        query.setCardType(cardType);
        query.setItemType(itemType);
        query.setStatus(1);
        this.logger.info("\u6279\u91cf\u67e5\u8be2:{}", (Object)query.toString());
        List list = this.getList(query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.stream().forEach(item -> item.setSaleValue(PriceUtils.multiply((BigDecimal)item.getSaleValue(), (BigDecimal)rate)));
        }
        return list;
    }

    @ReadThroughSingleCache(namespace="PrepayCardItemService.getCardItemEntityList", expiration=300)
    public List<PrepayCardItemEntity> getCardItemEntityList(@ParameterValueKeyProvider(order=0) Integer cardType, @ParameterValueKeyProvider(order=1) Integer itemType) {
        PrepayCardItemEntity query = new PrepayCardItemEntity();
        query.setCardType(cardType);
        query.setItemType(itemType);
        query.setStatus(1);
        return this.getList(query, 0L);
    }

    @Override
    @ReadThroughSingleCache(namespace="PrepayCardItemService.getCardItemEntityList", expiration=300)
    public List<PrepayCardItemEntity> getCardItemEntityList(@ParameterValueKeyProvider(order=0) Integer cardType) {
        PrepayCardItemEntity query = new PrepayCardItemEntity();
        query.setCardType(cardType);
        query.setStatus(1);
        return this.getList(query, 0L);
    }

    @Override
    public List<PrepayCardItemEntity> getCardItemEntityList(String customerId, String shoppingType) {
        return this.getCardItemEntityList(customerId, shoppingType, null);
    }

    @Override
    public List<PrepayCardItemEntity> getCardItemEntityList(String customerId, String shoppingType, Integer itemType) {
        Integer cardType = PrepayCardTypeEnum.yogurt_card.getValue();
        BigDecimal rate = BigDecimal.ONE;
        PrepayCardItemEntity query = new PrepayCardItemEntity();
        if (Objects.equals(shoppingType, String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue())) || Objects.equals(shoppingType, String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue()))) {
            cardType = Integer.valueOf(shoppingType);
            BaseJsonVo<List<Map<String, Object>>> baseJsonVo = this.balanceAccountInvoke.getUsableSpecialList(customerId, cardType);
            if (!baseJsonVo.isSuccess()) {
                this.logger.error("\u7528\u6237:{}\u4f59\u989d\u7cfb\u7edf\u8fd4\u56de\u51fa\u9519:{}", (Object)customerId, (Object)baseJsonVo.getMessage());
                throw new RuntimeException(baseJsonVo.getMessage());
            }
            PrepayCardEntity cardQuery = new PrepayCardEntity();
            cardQuery.setRelateCardNo(((Map)((List)baseJsonVo.getValue()).get(0)).get("cardNo").toString());
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardMapper.getSingle(cardQuery);
            query.setCardBatchId(prepayCardEntity.getBatchId());
        }
        BigDecimal newRate = rate;
        query.setStatus(1);
        query.setCardType(cardType);
        if (itemType != null) {
            query.setItemType(itemType);
        }
        this.logger.info("\u7528\u6237:{},\u5976\u5361\u4ef7\u683c\u4e0a\u6d6e\u6bd4\u4f8b:{},\u5976\u5361\u7c7b\u578b:{}", new Object[]{customerId, rate, cardType});
        try {
            List list = this.getList(query, 0L);
            if (rate.compareTo(BigDecimal.ONE) > 0) {
                return list.stream().map(e -> {
                    PrepayCardItemEntity emp = new PrepayCardItemEntity();
                    BeanUtils.copyProperties((Object)e, (Object)emp);
                    emp.setSaleValue(PriceUtils.multiply((BigDecimal)e.getSaleValue(), (BigDecimal)newRate));
                    return emp;
                }).collect(Collectors.toList());
            }
            return list;
        }
        catch (NumberFormatException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public BaseJsonVo<List<PrepayCardRecommendDetailEntity>> getConvertPrepayCards(BigDecimal orerAmount, List<Map<String, Object>> productList, List<PrepayCardBatchEntity> batchEntities) {
        ArrayList<PrepayCardRecommendDetailEntity> results = new ArrayList<PrepayCardRecommendDetailEntity>();
        for (PrepayCardBatchEntity batchEntity : batchEntities) {
            String bindCode;
            this.logger.info("\u5faa\u73af\u5361\u6279\u6b21:" + batchEntity.getBatchName());
            PrepayCardItemEntity search = new PrepayCardItemEntity();
            search.setCardBatchId(batchEntity.getBatchId());
            search.setStatus(1);
            List list = this.prepayCardItemMapper.getList(search);
            boolean isAll = true;
            BigDecimal factAmount = BigDecimal.ZERO;
            for (Map<String, Object> p : productList) {
                Optional<PrepayCardItemEntity> itemEntity = list.stream().filter(c -> {
                    MallProductEntity product = this.productInterface.getProduct(c.getItemId());
                    return p.get("barCode").toString().equals(product == null ? null : product.getBarCode());
                }).findFirst();
                if (itemEntity.isPresent()) {
                    Integer quantity = Integer.valueOf(p.get("quantity").toString());
                    factAmount = factAmount.add(itemEntity.get().getSaleValue().multiply(BigDecimal.valueOf(quantity.intValue())));
                    continue;
                }
                this.logger.info("\u5361\u6279\u6b21{},\u5224\u5b9a\u4e0d\u7b26\u5408\u7684\u5546\u54c1{}", (Object)batchEntity.getBatchName(), (Object)p.get("barCode").toString());
                isAll = false;
                break;
            }
            if (!isAll) {
                factAmount = orerAmount;
            }
            if (factAmount.floatValue() > orerAmount.floatValue()) {
                factAmount = orerAmount;
            }
            if (StringUtils.isEmpty((String)(bindCode = batchEntity.getBindCode()))) {
                this.logger.info("\u5361\u6279\u6b21{},bindCode\u7a7a", (Object)batchEntity.getBatchName());
                continue;
            }
            ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
            MallPromotionEntity promotionEntity = null;
            if (activeEntity != null) {
                promotionEntity = this.promotionInterface.getMallPromotionEntityByActiveNo(activeEntity.getActiveNo());
            }
            if (promotionEntity == null) {
                this.logger.info("\u5361\u6279\u6b21{},\u4fc3\u9500\u4e0d\u5b58\u5728\uff0cbindCode\uff1a{}", (Object)batchEntity.getBatchName(), (Object)bindCode);
                continue;
            }
            MallPromotionProductEntity promotionProductEntity = this.promotionProductInterface.getPromotionProductEntity(promotionEntity.getPromotionId());
            if (promotionProductEntity != null && StringUtils.isNotEmpty((String)bindCode)) {
                PrepayCardRecommendDetailEntity recommendDetailEntity = new PrepayCardRecommendDetailEntity();
                recommendDetailEntity.setCardBatchId(batchEntity.getBatchId());
                recommendDetailEntity.setCardAmount(batchEntity.getCardPrice());
                recommendDetailEntity.setCardPromotionId(promotionEntity.getPromotionId());
                recommendDetailEntity.setBindCode(bindCode);
                recommendDetailEntity.setCardSaleAmount(promotionProductEntity.getPromotionPrice());
                recommendDetailEntity.setOrderAmount(orerAmount);
                recommendDetailEntity.setFactAmount(factAmount);
                recommendDetailEntity.setPayAmount(recommendDetailEntity.getCardSaleAmount().subtract(recommendDetailEntity.getOrderAmount()));
                recommendDetailEntity.setBalanceAmount(recommendDetailEntity.getCardAmount().subtract(recommendDetailEntity.getFactAmount()));
                this.logger.info("\u652f\u4ed8\u91d1\u989d:" + recommendDetailEntity.getPayAmount() + ",\u751f\u6210\u4f59\u989d\uff1a" + recommendDetailEntity.getBalanceAmount() + ",\u8ba2\u5355\u91d1\u989d\uff1a" + recommendDetailEntity.getOrderAmount() + ",\u5b9e\u9645\u8ba2\u5355\u91d1\u989d\uff1a" + recommendDetailEntity.getFactAmount());
                if (!(recommendDetailEntity.getPayAmount().floatValue() > 0.0f) || !(recommendDetailEntity.getBalanceAmount().floatValue() > 0.0f) || !(recommendDetailEntity.getOrderAmount().subtract(recommendDetailEntity.getFactAmount()).floatValue() >= 0.0f)) continue;
                results.add(recommendDetailEntity);
                continue;
            }
            this.logger.info("\u4fc3\u9500\u5546\u54c1\u4e3a\u7a7a\uff0c\u6216\u8005bindCode\u4e3a\u7a7a");
        }
        return results.size() > 0 ? BaseJsonVo.success(results) : BaseJsonVo.error((String)"\u6ca1\u6709\u5339\u914d\u7684\u5976\u5361");
    }
}

