/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.dao.prepay.PrepayCardDetailMapper;
import cc.lechun.mall.dao.sales.ChannelMapper;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.mall.entity.prepay.ShopChannelEnum;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanLogInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mallapi.dto.prepay.DouDianPrepayPlanDTO;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class PrepayCardPlanDetailService
extends BaseService<PrepayCardDetailEntity, Integer>
implements PrepayCardPlanDetailInterface {
    @Resource
    PrepayCardDetailMapper prepayCardDetailMapper;
    @Autowired
    private PrepayCardPlanLogInterface planLogInterface;
    @Autowired
    private PrepayCardInterface prepayCardInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    @Lazy
    private PrepayCardPlanDetailInterface prepayCardPlanDetailInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private ChannelMapper channelMapper;

    @Override
    public List<PrepayCardDetailEntity> getPointPrepayCardDetailEntityList(String customerId) {
        PrepayCardDetailEntity query = new PrepayCardDetailEntity();
        query.setCustomerId(customerId);
        query.setCardId("");
        query.setOrderMainNo("");
        query.setStatus(PrepayCardPlanStatusEnum.ACTIVE.getValue());
        List list = this.getList(query, 0L);
        return list.stream().filter(prepayCardDetailEntity -> prepayCardDetailEntity.getPickTime() != null && prepayCardDetailEntity.getPickTime().after(DateUtils.now()) && StringUtils.isEmpty((String)prepayCardDetailEntity.getOrderMainNo()) && prepayCardDetailEntity.getPricePoint().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
    }

    @Override
    public List<PrepayCardDetailEntity> getUnExecPrepayCardDetailEntityList(String customerId) {
        PrepayCardDetailEntity query = new PrepayCardDetailEntity();
        query.setCustomerId(customerId);
        query.setStatus(PrepayCardPlanStatusEnum.ACTIVE.getValue());
        List list = this.getList(query, 0L);
        return list.stream().filter(prepayCardDetailEntity -> prepayCardDetailEntity.getPickTime().getTime() + 1L > DateUtils.currentDate().getTime() && prepayCardDetailEntity.getPricePoint() != null && StringUtils.isEmpty((String)prepayCardDetailEntity.getOrderMainNo()) && prepayCardDetailEntity.getPricePoint().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
    }

    @Override
    public List<PrepayCardDetailEntity> getPrepayCardDetailEntityList(String customerId, Integer status, Integer hour) {
        return this.prepayCardDetailMapper.getPrepayCardDetailEntityList(customerId, status, hour);
    }

    @Override
    public List<PrepayCardDetailEntity> getPlanDetailList(String cardId) {
        PrepayCardDetailEntity query = new PrepayCardDetailEntity();
        query.setCardId(cardId);
        return this.prepayCardDetailMapper.getList(query);
    }

    @Override
    public List<PrepayCardDetailEntity> getPlanDetailListByOrderMainNo(String orderMainno) {
        PrepayCardDetailEntity query = new PrepayCardDetailEntity();
        query.setOrderMainNo(orderMainno);
        return this.prepayCardDetailMapper.getList(query);
    }

    @Override
    @Transactional
    public BaseJsonVo suspendPrepayCardPlan(String carId) {
        PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
        prepayCardDetailEntity.setCardId(carId);
        List list = this.prepayCardDetailMapper.getList(prepayCardDetailEntity);
        ArrayList result = new ArrayList();
        if (list.size() > 0) {
            list.forEach(d -> {
                if ((d.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue() || d.getStatus().intValue() == PrepayCardPlanStatusEnum.DELIVERY.getValue()) && d.getPickTime().after(DateUtils.currentDate())) {
                    PrepayCardDetailEntity update = new PrepayCardDetailEntity();
                    update.setDetailedId(d.getDetailedId());
                    update.setStatus(PrepayCardPlanStatusEnum.SUSPEND.getValue());
                    result.add(update);
                }
            });
        }
        return this.batchUpdate(result) > 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    private List<PrepayCardDetailEntity> getTodayValidPlan(Date today) {
        PrepayCardDetailEntity searchDetail = new PrepayCardDetailEntity();
        searchDetail.setStatus(2);
        return this.getList(searchDetail, 0L);
    }

    @Override
    public List<PrepayCardDetailEntity> getTodayValidPointPlan(Date today) {
        return this.prepayCardDetailMapper.getDetailPlanList(OrderSourceEnum.RECHANGE_CARD.getValue(), "", PrepayCardPlanStatusEnum.ACTIVE.getValue(), today);
    }

    BaseJsonVo ValidatePlan(PrepayCardDetailEntity detailEntity) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)detailEntity.getCardId()));
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u5bf9\u5e94\u7684\u5361\u4e0d\u5b58\u5728");
        }
        if (prepayCardEntity.getStatus() == null || prepayCardEntity.getStatus() != 2) {
            return BaseJsonVo.error((String)"\u5bf9\u5e94\u7684\u5361\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        if (detailEntity.getOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue() && detailEntity.getPickTime() == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u6ca1\u6709\u9009\u62e9\u53d1\u8d27\u65e5\u671f");
        }
        if (detailEntity.getAddrId() == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u6ca1\u6709\u9009\u62e9\u6536\u8d27\u5730\u5740");
        }
        return BaseJsonVo.success((Object)"");
    }

    BaseJsonVo ValidateCustomePlan(PrepayCardDetailEntity detailEntity) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)(detailEntity = (PrepayCardDetailEntity)this.selectByPrimaryKey(detailEntity.getDetailedId(), 0L)).getCardId()));
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u5bf9\u5e94\u7684\u5361\u4e0d\u5b58\u5728");
        }
        if (prepayCardEntity.getStatus() == null || prepayCardEntity.getStatus() != 2) {
            return BaseJsonVo.error((String)"\u5bf9\u5e94\u7684\u5361\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        if (detailEntity.getAddrId() == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u6ca1\u6709\u9009\u62e9\u6536\u8d27\u5730\u5740");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createPlanOrder(PrepayCardDetailEntity detailEntity, MallOrderCacheVo orderCacheVo, int platFormId) throws InvalidKeySpecException, NoSuchAlgorithmException {
        BaseJsonVo baseJsonVo = this.ValidatePlan(detailEntity);
        if (!baseJsonVo.isSuccess()) {
            this.logger.error("\u8ba1\u5212:{}\u521b\u5efa\u8ba2\u5355\u5931\u8d25:{}", (Object)detailEntity.toString(), (Object)baseJsonVo.getMessage());
            return baseJsonVo;
        }
        String o = null;
        if (StringUtil.isEmpty((String)detailEntity.getOrderMainNo())) {
            orderCacheVo.setCacheType(2);
            orderCacheVo.setAddressId(detailEntity.getAddrId());
            orderCacheVo.setDeliverDate(detailEntity.getPickTime());
            orderCacheVo.setDeliverDate2(detailEntity.getPickTime());
            orderCacheVo.setSourceOrderNo(detailEntity.getCardOrderMainNo());
            orderCacheVo.setMildCardPay(1);
            baseJsonVo = this.tradeInterface.createOrder(platFormId, detailEntity.getCustomerId(), orderCacheVo);
            this.logger.info("createResult : {}", (Object)JsonUtils.toJson((Object)baseJsonVo, (boolean)true));
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            Map result = (Map)baseJsonVo.getValue();
            o = result.get("mainOrderNo");
            this.updateOrderMainNo(detailEntity.getDetailedId(), o.toString());
        } else {
            o = detailEntity.getOrderMainNo();
        }
        String ip = "127.0.0.1";
        PayOutputEntity payOutputEntity = this.payOrderInterface.topay(detailEntity.getCustomerId(), o.toString(), ip);
        this.logger.info("payResult : " + JsonUtils.toJson((Object)payOutputEntity, (boolean)true));
        if (payOutputEntity.getStatus() != 6) {
            this.planLogInterface.saveCardPlanLog(detailEntity.getDetailedId(), payOutputEntity.getMessage());
            return BaseJsonVo.error((String)payOutputEntity.getMessage());
        }
        this.prepayCardPlanDetailInterface.orderPaySuccessUpdateCardPlanStatus(o.toString());
        this.planLogInterface.updateLogStatus(detailEntity.getDetailedId(), 1);
        return BaseJsonVo.success((Object)payOutputEntity);
    }

    @Override
    public BaseJsonVo createPlanOrder(MallOrderCacheVo orderCacheVo, String customerId, int platFormId) throws InvalidKeySpecException, NoSuchAlgorithmException {
        Object o = null;
        orderCacheVo.setCacheType(2);
        orderCacheVo.setAddressId(orderCacheVo.getAddressId());
        orderCacheVo.setDeliverDate(orderCacheVo.getDeliverDate());
        orderCacheVo.setDeliverDate2(orderCacheVo.getDeliverDate2());
        orderCacheVo.setMildCardPay(1);
        BaseJsonVo baseJsonVo = this.tradeInterface.createOrder(platFormId, customerId, orderCacheVo);
        this.logger.info("createResult : {}", (Object)JsonUtils.toJson((Object)baseJsonVo, (boolean)true));
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        Map result = (Map)baseJsonVo.getValue();
        o = result.get("mainOrderNo");
        String ip = "127.0.0.1";
        PayOutputEntity payOutputEntity = this.payOrderInterface.topay(customerId, o.toString(), ip);
        this.logger.info("payResult : " + JsonUtils.toJson((Object)payOutputEntity, (boolean)true));
        if (payOutputEntity.getStatus() != 6) {
            this.logger.error("\u8ba2\u5355:{}\u652f\u4ed8\u5931\u8d25", result.get("mainOrderNo"));
            return BaseJsonVo.error((String)payOutputEntity.getMessage());
        }
        return BaseJsonVo.success((Object)payOutputEntity);
    }

    @Override
    public BaseJsonVo createPlanOrder(Date today) {
        List<PrepayCardDetailEntity> detailEntities = this.getTodayValidPlan(today);
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            Integer platFormId = null;
            if (CollectionUtils.isNotEmpty(detailEntities = detailEntities.stream().filter(d -> d.getCreateTime().after(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-3))).collect(Collectors.toList()))) {
                for (PrepayCardDetailEntity detailEntity : detailEntities) {
                    if (!StringUtils.isNotEmpty((String)detailEntity.getCardId())) continue;
                    if (platFormId == null) {
                        List<PrepayCardDetailEntity> list = this.getPlanDetailList(detailEntity.getCardId());
                        List temp = list.stream().filter(detail -> StringUtils.isNotEmpty((String)detail.getOrderMainNo())).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(temp)) {
                            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(((PrepayCardDetailEntity)temp.get(0)).getOrderMainNo());
                            platFormId = orderMainEntity.getPlatformId();
                        } else {
                            platFormId = PlatFormEnum.LECHUN_MINI.getValue();
                        }
                    }
                    BaseJsonVo baseJsonVo = this.createPlanOrder(detailEntity, (int)platFormId);
                }
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Async
    public BaseJsonVo createPlanOrder(String cardId, int platFormId) {
        PrepayCardDetailEntity search = new PrepayCardDetailEntity();
        search.setCardId(cardId);
        search.setStatus(2);
        List detailEntities = this.getList(search, 0L);
        if (CollectionUtils.isNotEmpty((Collection)detailEntities)) {
            detailEntities = detailEntities.stream().sorted((d1, d2) -> d2.getDetailedId() - d1.getDetailedId()).collect(Collectors.toList());
            for (PrepayCardDetailEntity detailEntity : detailEntities) {
                BaseJsonVo baseJsonVo = this.createPlanOrder(detailEntity, platFormId);
                this.logger.info("\u521b\u5efa\u8ba2\u5355:{},\u53c2\u6570:{}", (Object)baseJsonVo.isSuccess(), (Object)detailEntity);
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createPlanOrder(PrepayCardDetailEntity detailEntity, int platFormId) {
        if (this.mallRedisLock.lock(detailEntity.getDetailedId() + ":createOrder", "1", 20L, TimeUnit.SECONDS)) {
            BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
            try {
                baseJsonVo = this.setOrderCache(detailEntity, platFormId);
                this.logger.info("\u8ba1\u5212:{},\u8bbe\u7f6e\u7f13\u5b58:{},{}", new Object[]{detailEntity.getDetailedId(), baseJsonVo.isSuccess(), baseJsonVo.getMessage()});
                if (!baseJsonVo.isSuccess()) {
                    this.planLogInterface.saveCardPlanLog(detailEntity.getDetailedId(), baseJsonVo.getMessage());
                    return baseJsonVo;
                }
                baseJsonVo = this.createPlanOrder(detailEntity, (MallOrderCacheVo)baseJsonVo.getValue(), platFormId);
                this.logger.info("\u8ba1\u5212:{},\u521b\u5efa\u8ba2\u5355:{},{}", new Object[]{detailEntity.toString(), baseJsonVo.isSuccess(), baseJsonVo.getMessage()});
                return baseJsonVo;
            }
            catch (Exception e) {
                this.planLogInterface.saveCardPlanLog(detailEntity.getDetailedId(), baseJsonVo.getMessage());
                e.printStackTrace();
                this.planLogInterface.saveCardPlanLog(detailEntity.getDetailedId(), baseJsonVo.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
        return BaseJsonVo.error((String)"\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
    }

    @Override
    @Transactional
    public BaseJsonVo createCustomPlanOrder(PrepayCardDetailEntity prepayCardDetailEntity, DouDianPrepayPlanDTO plan) {
        if (this.mallRedisLock.lock(prepayCardDetailEntity.getDetailedId() + ":createOrder", "1", 20L, TimeUnit.SECONDS)) {
            BaseJsonVo baseJsonVo = this.ValidateCustomePlan(prepayCardDetailEntity);
            if (!baseJsonVo.isSuccess()) {
                this.planLogInterface.saveCardPlanLog(prepayCardDetailEntity.getDetailedId(), baseJsonVo.getMessage());
                return baseJsonVo;
            }
            baseJsonVo = this.setCustomOrderCache(prepayCardDetailEntity, PlatFormEnum.LECHUN_MINI.getValue(), plan);
            if (!baseJsonVo.isSuccess()) {
                this.planLogInterface.saveCardPlanLog(prepayCardDetailEntity.getDetailedId(), baseJsonVo.getMessage());
                return baseJsonVo;
            }
            try {
                baseJsonVo = ((PrepayCardPlanDetailService)SpringContextUtil.getBean(this.getClass())).createPlanOrder(prepayCardDetailEntity, (MallOrderCacheVo)baseJsonVo.getValue(), PlatFormEnum.LECHUN_MINI.getValue());
            }
            catch (InvalidKeySpecException e) {
                this.logger.error("\u521b\u5efa\u6296\u5e97\u5976\u5361\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
                return BaseJsonVo.error((String)("\u521b\u5efa\u6296\u5e97\u5976\u5361\u8ba2\u5355\u5f02\u5e38" + plan.getOrderNo()));
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error("\u521b\u5efa\u6296\u5e97\u5976\u5361\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
                return BaseJsonVo.error((String)("\u521b\u5efa\u6296\u5e97\u5976\u5361\u8ba2\u5355\u5f02\u5e38" + plan.getOrderNo()));
            }
            if (!baseJsonVo.isSuccess()) {
                this.planLogInterface.saveCardPlanLog(prepayCardDetailEntity.getDetailedId(), baseJsonVo.getMessage());
                return baseJsonVo;
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo<MallOrderCacheVo> setOrderCache(PrepayCardDetailEntity detailEntity, int platFormId) {
        MallOrderCacheInVo inVo = new MallOrderCacheInVo();
        inVo.setDeliverCount(1);
        inVo.setDeliverPeriod(1);
        inVo.setDeliverType(1);
        inVo.setOrderSource(detailEntity.getOrderSource());
        inVo.setBindCode("");
        inVo.setDefineField("");
        ArrayList<MallOrderCacheInItemVo> itemVoList = new ArrayList<MallOrderCacheInItemVo>();
        MallOrderCacheInItemVo itemVo = new MallOrderCacheInItemVo();
        itemVo.setItemId(detailEntity.getPromotionId());
        itemVo.setItemType(1);
        itemVo.setQuantity(detailEntity.getQuantity());
        itemVoList.add(itemVo);
        inVo.setMallOrderCacheInItemVoList(itemVoList);
        inVo.setChannel(this.getChannleId(detailEntity));
        return this.tradeInterface.setOrderCache(platFormId, detailEntity.getCustomerId(), inVo);
    }

    private Integer getChannleId(Integer detailId) {
        PrepayCardDetailEntity prepayCardDetailEntity = (PrepayCardDetailEntity)this.prepayCardPlanDetailInterface.selectByPrimaryKey(detailId);
        return this.getChannleId(prepayCardDetailEntity);
    }

    private Integer getChannleId(PrepayCardDetailEntity detailEntity) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)detailEntity.getCardId()));
        if (prepayCardEntity != null && StringUtils.isNotEmpty((String)prepayCardEntity.getShopId())) {
            return ShopChannelEnum.getChannelId(prepayCardEntity.getShopId());
        }
        return null;
    }

    private BaseJsonVo setCustomOrderCache(PrepayCardDetailEntity detailEntity, int platFormId, DouDianPrepayPlanDTO plan) {
        MallOrderCacheInVo inVo = new MallOrderCacheInVo();
        Integer channelId = ShopChannelEnum.getChannelId(plan.getShopId());
        inVo.setChannel(channelId);
        inVo.setDeliverCount(1);
        inVo.setDeliverPeriod(1);
        inVo.setDeliverType(1);
        inVo.setOrderSource(detailEntity.getOrderSource());
        inVo.setBindCode("");
        inVo.setDefineField("");
        ArrayList<MallOrderCacheInItemVo> itemVoList = new ArrayList<MallOrderCacheInItemVo>();
        StringBuilder sb = new StringBuilder();
        plan.getProducts().forEach(product -> {
            MallOrderCacheInItemVo itemVo = new MallOrderCacheInItemVo();
            MallProductEntity productByBarcode = this.productInterface.getProductByBarcodeActive(product.getCbarcode());
            if (productByBarcode == null) {
                sb.append("\u5546\u54c1[" + product.getCbarcode() + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728");
                return;
            }
            itemVo.setItemId(productByBarcode.getProId());
            itemVo.setItemType(4);
            itemVo.setQuantity(product.getProductNum());
            itemVo.setPrice(product.getUnitPrice());
            itemVoList.add(itemVo);
        });
        if (sb.length() > 0) {
            return BaseJsonVo.error((String)sb.toString());
        }
        inVo.setMallOrderCacheInItemVoList(itemVoList);
        BaseJsonVo<MallOrderCacheVo> mallOrderCacheVoBaseJsonVo = this.tradeInterface.setOrderCache(platFormId, detailEntity.getCustomerId(), inVo);
        if (mallOrderCacheVoBaseJsonVo.isSuccess()) {
            ((MallOrderCacheVo)mallOrderCacheVoBaseJsonVo.getValue()).setFreight(plan.getFreight());
        }
        return mallOrderCacheVoBaseJsonVo;
    }

    @Override
    @Transactional
    public BaseJsonVo orderPaySuccessUpdateCardPlanStatus(String orderMainNo) {
        PrepayCardDetailEntity entity = new PrepayCardDetailEntity();
        entity.setOrderMainNo(orderMainNo);
        entity = (PrepayCardDetailEntity)this.getSingle(entity, 0L);
        if (entity != null) {
            if (entity.getStatus() != 2) {
                return BaseJsonVo.error((String)"\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u66f4\u65b0");
            }
            entity.setStatus(4);
            if (this.updateByPrimaryKeySelective(entity) > 0) {
                return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
            }
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public BaseJsonVo orderConfirmGoodsUpdateCardPlanStatus(String orderMainNo) {
        block5: {
            try {
                PrepayCardDetailEntity entity = new PrepayCardDetailEntity();
                entity.setOrderMainNo(orderMainNo);
                List list = this.getList(entity, 0L);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    Iterator iterator = list.iterator();
                    if (iterator.hasNext()) {
                        PrepayCardDetailEntity detailEntity = (PrepayCardDetailEntity)iterator.next();
                        if (detailEntity.getStatus() != 4) {
                            return BaseJsonVo.error((String)"\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u66f4\u65b0");
                        }
                        detailEntity.setStatus(6);
                        this.updateByPrimaryKeySelective(detailEntity);
                        return BaseJsonVo.success((Object)"");
                    }
                    break block5;
                }
                return BaseJsonVo.success((Object)"");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public BaseJsonVo orderRefundUpdateCardPlanStatus(String orderMainNo) {
        PrepayCardDetailEntity entity = new PrepayCardDetailEntity();
        entity.setOrderMainNo(orderMainNo);
        entity = (PrepayCardDetailEntity)this.getSingle(entity);
        if (entity != null) {
            if (entity.getStatus() == 5) {
                return BaseJsonVo.success((Object)"");
            }
            entity.setStatus(5);
            this.updateByPrimaryKeySelective(entity);
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateOrderMainNo(Integer detailId, String orderMainNo) {
        PrepayCardDetailEntity detailEntity = new PrepayCardDetailEntity();
        detailEntity.setOrderMainNo(orderMainNo);
        PrepayCardDetailEntity search = new PrepayCardDetailEntity();
        search.setDetailedId(detailId);
        search.setStatus(2);
        if (this.updateByEntity(detailEntity, search) > 0) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5f02\u5e38");
    }

    @Override
    public BaseJsonVo editPlanOrder(PrepayCardDetailEntity cardDetailEntity) {
        BaseJsonVo baseJsonVo;
        List<Object> orderEntities = new ArrayList();
        if (cardDetailEntity.getStatus() != 4 && cardDetailEntity.getStatus() != 3) {
            return BaseJsonVo.success((Object)"\u8be5\u72b6\u6001\u65e0\u9700\u4fee\u6539\u8ba2\u5355");
        }
        if (StringUtil.isEmpty((String)cardDetailEntity.getOrderMainNo())) {
            return BaseJsonVo.success((Object)"\u8ba2\u5355\u53f7\u4e3a\u7a7a\uff0c\u65e0\u9700\u4fee\u6539\u8ba2\u5355");
        }
        orderEntities = this.orderInterface.getOrderList(cardDetailEntity.getOrderMainNo());
        if (orderEntities == null || orderEntities.size() == 0) {
            return BaseJsonVo.error((String)"\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539\u8be5\u8ba2\u5355");
        }
        if (((MallOrderEntity)orderEntities.get(0)).getPickupTime() == null) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u5df2\u6d41\u8f6c\uff0c\u65e0\u6cd5\u4fee\u6539");
        }
        if (cardDetailEntity.getStatus() == 4 && !(baseJsonVo = this.orderInterface.editOrderAddress(cardDetailEntity.getCustomerId(), ((MallOrderEntity)orderEntities.get(0)).getOrderNo(), cardDetailEntity.getAddrId())).isSuccess()) {
            return BaseJsonVo.error((String)("\u8ba2\u5355\u6536\u8d27\u5730\u5740\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + baseJsonVo.getMessage() + "\uff1b"));
        }
        if (cardDetailEntity.getPickTime() != null) {
            Date pickTime = DateUtils.StrToDate((String)DateUtils.formatDate((Date)cardDetailEntity.getPickTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss");
            if (cardDetailEntity.getStatus() == 3) {
                pickTime = DateUtils.StrToDate((String)"2038-01-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
            }
            if (!(baseJsonVo = this.orderInterface.editOrderDeliverDate(cardDetailEntity.getCustomerId(), ((MallOrderEntity)orderEntities.get(0)).getOrderNo(), pickTime, null, false)).isSuccess()) {
                return BaseJsonVo.error((String)("\u8ba2\u5355\u914d\u9001\u65e5\u671f\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + baseJsonVo.getMessage() + "\uff1b"));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deletePlanOrder(PrepayCardDetailEntity cardDetailEntity) {
        this.planLogInterface.saveCardPlanLog(cardDetailEntity.getDetailedId(), "cardId:" + cardDetailEntity.getCardId() + "\u8ba1\u5212:" + cardDetailEntity.getDetailedId() + ",\u8ba2\u5355:" + cardDetailEntity.getOrderMainNo() + ",\u5c06\u88ab\u5220\u9664");
        PrepayCardEntity cardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)cardDetailEntity.getCardId()));
        if (cardDetailEntity.getStatus() != 4 && cardDetailEntity.getStatus() != 3) {
            return BaseJsonVo.success((Object)"\u8ba1\u5212\u8be5\u72b6\u6001\u4e0d\u80fd\u5220\u9664\u8ba2\u5355");
        }
        try {
            if (StringUtils.isNotEmpty((String)cardDetailEntity.getOrderMainNo())) {
                MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(cardDetailEntity.getOrderMainNo());
                if (orderMainEntity == null) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return BaseJsonVo.error((String)("\u8ba2\u5355\u4e0d\u5b58\u5728,\u8ba2\u5355\u53f7\uff1a" + cardDetailEntity.getOrderMainNo()));
                }
                BaseJsonVo<BalanceChangeDTO> baseJsonVo = this.tradeInterface.deletePrepayCardOrder(cardDetailEntity.getOrderMainNo());
                if (!baseJsonVo.isSuccess()) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return baseJsonVo;
                }
                BigDecimal orderAmount = orderMainEntity.getOrderAmount();
                if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                    orderAmount = orderMainEntity.getPoints();
                }
                this.logger.info("\u8c03\u7528\u4f59\u989d\u7cfb\u7edf\u8fd8\u652f\u4ed8\u91d1\u7684\u63a5\u53e3:cancelSpecialCardOrder,\u53c2\u6570cardNo:{},ordrMainNo:{},price:{},operater:{}", new Object[]{cardEntity.getRelateCardNo(), cardDetailEntity.getOrderMainNo(), orderAmount, cardDetailEntity.getCustomerId()});
                baseJsonVo = this.balanceAccountInvoke.cancelSpecialCardOrder(orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue() ? "" : cardEntity.getRelateCardNo(), cardDetailEntity.getOrderMainNo(), orderAmount, cardDetailEntity.getCustomerId());
                this.logger.info("\u8c03\u7528\u4f59\u989d\u7cfb\u7edf\u8fd8\u652f\u4ed8\u91d1\u7684\u63a5\u53e3:cancelSpecialCardOrder,\u8fd4\u56de\uff1asuccess:{},message:{}", (Object)baseJsonVo.isSuccess(), (Object)baseJsonVo.getMessage());
                if (!baseJsonVo.isSuccess()) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return baseJsonVo;
                }
                if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                    PrepayCardDetailEntity query = new PrepayCardDetailEntity();
                    query.setOrderMainNo(orderMainEntity.getOrderMainNo());
                    List detailEntityList = this.getList(query, 0L);
                    for (PrepayCardDetailEntity item : detailEntityList) {
                        int count = this.deleteByPrimaryKey(item.getDetailedId());
                        this.logger.info("\u5220\u9664\u8ba1\u5212:{},{}", (Object)item.getDetailedId(), (Object)(count > 1 ? "\u6210\u529f" : "\u5931\u8d25"));
                    }
                } else {
                    PrepayCardEntity valueCard = new PrepayCardEntity();
                    valueCard.setRemainCount(cardDetailEntity.getQuantity());
                    valueCard.setUpdateTimeStamp(UUID.randomUUID().toString());
                    PrepayCardEntity filterCard = new PrepayCardEntity();
                    filterCard.setCardId(cardEntity.getCardId());
                    filterCard.setUpdateTimeStamp(cardEntity.getUpdateTimeStamp());
                    int count = this.prepayCardInterface.updatePlusByEntity(valueCard, filterCard);
                    if (count == 0) {
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        this.logger.error("\u5976\u5361\uff1a{} \u5f52\u8fd8\u6b21\u6570\u5931\u8d25\uff1a\u8ba1\u5212\u660e\u7ec6:{}\uff0c\u5931\u8d25", (Object)cardEntity.getCardId(), (Object)cardDetailEntity.getDetailedId());
                        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                    }
                    count = this.deleteByPrimaryKey(cardDetailEntity.getDetailedId());
                    if (count == 0) {
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        this.logger.error("\u5976\u5361\uff1a{} \u5220\u9664\u8ba1\u5212\u660e\u7ec6\uff1a{}\uff0c\u5931\u8d25", (Object)cardEntity.getCardId(), (Object)cardDetailEntity.getDetailedId());
                        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                    }
                }
                return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("\u5976\u5361\uff1a{}\u660e\u7ec6\uff1a{}\uff0c\u5220\u9664\u5f02\u5e38\uff1a{}", new Object[]{cardEntity.getCardId(), cardDetailEntity.getDetailedId(), e.getMessage()});
            return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }
}

