/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.apiinvoke.cms.CorpTagInvoke;
import cc.lechun.apiinvoke.oms.WxOrderClient;
import cc.lechun.apiinvoke.refund.CsmsRefundInvoke;
import cc.lechun.apiinvoke.tmall.TmallInvoke;
import cc.lechun.balance.dto.SpecialCardDTO;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.csmsapi.dto.refund.PlatformDTO;
import cc.lechun.framework.common.utils.cache.RedisLock;
import cc.lechun.framework.common.utils.cache.RedisLockParameter;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.dao.customer.CustomerAddressMapper;
import cc.lechun.mall.dao.prepay.PrepayCardMapper;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.mall.entity.prepay.PrepayCardRecommendDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardStatusEnum;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardLogInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardRecommendInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderProductVO;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderVO;
import cc.lechun.omsv2.entity.order.third.weixin.WxOrderEntityVO;
import cc.lechun.tmall.model.BaseShop;
import com.qimen.api.response.ReceiverinfoQueryResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrepayCardService
extends BaseService<PrepayCardEntity, String>
implements PrepayCardInterface {
    private static final String EXCHANGE_PWD_PREFIX = "EXCHANGE_PWD_";
    @Resource
    PrepayCardMapper prepayCardMapper;
    @Autowired
    PrepayCardLogInterface cardLogInterface;
    @Autowired
    MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    MallOrderProductInterface mallOrderProductInterface;
    @Autowired
    PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    AccountBalanceInterface balanceInterface;
    @Autowired
    private MessageInterface messageService;
    @Autowired
    @Lazy
    private PrepayCardPlanDetailInterface prepayCardPlanDetailService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private MallPromotionProductInterface promotionProductInterface;
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    CorpTagInvoke corpTagInvoke;
    @Autowired
    CustomerAddressInterface customerAddressInterface;
    @Autowired
    CustomerAddressMapper customerAddressMapper;
    @Autowired
    private WxOrderClient wxOrderClient;
    @Autowired
    private CsmsRefundInvoke csmsRefundInvoke;
    @Autowired
    private TmallInvoke tmallInvoke;
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    private MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    PrepayCardRecommendInterface prepayCardRecommendInterface;
    @Autowired
    @Lazy
    private PrepayCardOrderPlanInterface prepayCardOrderPlanInterface;

    @Override
    public BaseJsonVo<BigDecimal> getSpecialTotal(String customerId, Integer cardType) {
        return this.balanceAccountInvoke.getSpecialTotal(customerId, cardType);
    }

    @Override
    public BaseJsonVo refundOrderPlanNum(String cardId, Integer remainCount, Integer num) {
        return this.prepayCardMapper.addCardCount(cardId, remainCount, num) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u9000\u6b21\u6570\u5931\u8d25");
    }

    @Override
    public BaseJsonVo pushFinshMessage() {
        PrepayCardEntity query = new PrepayCardEntity();
        query.setStatus(PrepayCardStatusEnum.FINISH.getValue());
        List list = this.prepayCardMapper.getList(query);
        if (list != null && list.size() > 0) {
            list.forEach(prepayCardEntity -> {
                if (prepayCardEntity.getRemainCount() == 0) {
                    PrepayCardDetailEntity maxDetail;
                    PrepayCardDetailEntity detailEntity = new PrepayCardDetailEntity();
                    detailEntity.setCardId(prepayCardEntity.getCardId());
                    List detailList = this.prepayCardPlanDetailService.getList(detailEntity, 0L);
                    if ((detailList != null || detailList.size() > 0) && (maxDetail = (PrepayCardDetailEntity)detailList.stream().max(Comparator.comparing(PrepayCardDetailEntity::getPickTime)).orElse(null)) != null) {
                        boolean flag;
                        boolean bl = flag = maxDetail.getPickTime().before(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-30)) && maxDetail.getPickTime().after(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-31));
                        if (flag) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("orderNo", StringUtils.isEmpty((String)prepayCardEntity.getOrderMainNo()) ? "" : prepayCardEntity.getOrderMainNo());
                            map.put("cardType", PrepayCardTypeEnum.getName(prepayCardEntity.getCardType()));
                            map.put("beginTime", DateUtils.formatDate((Date)prepayCardEntity.getFirstDate(), (String)""));
                            map.put("endTime", DateUtils.formatDate((Date)prepayCardEntity.getEndTime(), (String)""));
                            this.messageService.sendWechatMessage(MessageTypeEnum.TEMPLATE_MESSAGE, (Integer)74, prepayCardEntity.getBelongCustomerId(), map);
                        }
                    }
                }
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo pushExpiredMessage() {
        PrepayCardEntity query = new PrepayCardEntity();
        query.setStatus(PrepayCardStatusEnum.ACTIVE.getValue());
        List list = this.prepayCardMapper.getList(query);
        if (list != null && list.size() > 0) {
            list.forEach(prepayCardEntity -> {
                if (prepayCardEntity.getRemainCount() > 0) {
                    boolean flag;
                    boolean bl = flag = prepayCardEntity.getEndTime().before(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-30)) && prepayCardEntity.getEndTime().after(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-31));
                    if (flag) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("cardType", PrepayCardTypeEnum.getName(prepayCardEntity.getCardType()));
                        map.put("cardNo", prepayCardEntity.getRelateCardNo());
                        map.put("number", prepayCardEntity.getRemainCount().toString());
                        map.put("unit", StringUtils.isEmpty((String)prepayCardEntity.getUnit()) ? "\u7bb1" : "\u5305");
                        map.put("endTime", DateUtils.formatDate((Date)prepayCardEntity.getEndTime(), (String)""));
                        map.put("product", PrepayCardTypeEnum.getName(prepayCardEntity.getCardType()).replace("\u5361", ""));
                        map.put("cardId", prepayCardEntity.getCardId());
                        this.messageService.sendWechatMessage(MessageTypeEnum.TEMPLATE_MESSAGE, (Integer)75, prepayCardEntity.getBelongCustomerId(), map);
                    }
                }
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo pushActivedMessage() {
        PrepayCardEntity query = new PrepayCardEntity();
        query.setStatus(PrepayCardStatusEnum.TAKED.getValue());
        List list = this.prepayCardMapper.getList(query);
        if (list != null && list.size() > 0) {
            list.forEach(prepayCardEntity -> this.pushActivedMessage((PrepayCardEntity)prepayCardEntity));
        }
        return BaseJsonVo.success((Object)"\u53617\u5929\u672a\u6fc0\u6d3b\u6d88\u606f\u63a8\u9001\u5b8c\u6210");
    }

    @Override
    public BaseJsonVo pushProcessMessage() {
        PrepayCardEntity query = new PrepayCardEntity();
        query.setStatus(PrepayCardStatusEnum.ACTIVE.getValue());
        List list = this.prepayCardMapper.getList(query);
        if (list != null && list.size() > 0) {
            list.forEach(prepayCardEntity -> {
                if (prepayCardEntity.getRemainCount() > 0) {
                    PrepayCardDetailEntity maxDetail;
                    PrepayCardDetailEntity detailEntity = new PrepayCardDetailEntity();
                    detailEntity.setCardId(prepayCardEntity.getCardId());
                    List detailList = this.prepayCardPlanDetailService.getList(detailEntity, 0L);
                    if ((detailList != null || detailList.size() >= 0) && (maxDetail = (PrepayCardDetailEntity)detailList.stream().max(Comparator.comparing(PrepayCardDetailEntity::getCreateTime)).orElse(null)) != null) {
                        boolean flag;
                        boolean bl = flag = prepayCardEntity.getCreateTime().before(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-30)) && prepayCardEntity.getCreateTime().after(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-31));
                        if (flag) {
                            prepayCardEntity.setCreateTime(maxDetail.getCreateTime());
                            this.pushProcessMessage((PrepayCardEntity)prepayCardEntity);
                        }
                    }
                }
            });
        }
        return BaseJsonVo.success((Object)"\u53617\u5929\u672a\u6fc0\u6d3b\u6d88\u606f\u63a8\u9001\u5b8c\u6210");
    }

    private void pushProcessMessage(PrepayCardEntity prepayCardEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unit", StringUtils.isEmpty((String)prepayCardEntity.getUnit()) ? "\u7bb1" : "\u5305");
        map.put("number", prepayCardEntity.getRemainCount().toString());
        map.put("dateTime", DateUtils.formatDate((Date)prepayCardEntity.getCreateTime(), (String)""));
        map.put("cardType", PrepayCardTypeEnum.getName(prepayCardEntity.getCardType()).replace("\u5361", ""));
        map.put("cardId", prepayCardEntity.getCardId());
        this.messageService.sendWechatMessage(MessageTypeEnum.TEMPLATE_MESSAGE, (Integer)73, prepayCardEntity.getBelongCustomerId(), map);
    }

    @Override
    public BaseJsonVo pushActivedMessage(PrepayCardEntity prepayCardEntity) {
        if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.TAKED.getValue()) {
            boolean flag;
            boolean bl = flag = prepayCardEntity.getCreateTime().before(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-7)) && prepayCardEntity.getCreateTime().after(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-8));
            if (flag) {
                HashMap<String, String> map = new HashMap<String, String>();
                CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(prepayCardEntity.getBelongCustomerId(), 1);
                if (customerDetailVo != null) {
                    map.put("nickName", StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34");
                    map.put("mobile", String.valueOf(customerDetailVo.getMobile()));
                    map.put("dateTime", DateUtils.formatDate((Date)prepayCardEntity.getCreateTime(), (String)""));
                    map.put("cardId", prepayCardEntity.getCardId());
                    this.messageService.sendWechatMessage(MessageTypeEnum.TEMPLATE_MESSAGE, (Integer)72, customerDetailVo.getCustomerId(), map);
                    return BaseJsonVo.success((Object)"\u63a8\u9001\u6210\u529f");
                }
            }
        }
        return BaseJsonVo.error((String)"\u4e0d\u7b26\u5408\u63a8\u8350\u6761\u4ef6");
    }

    @Override
    public void setCardStatus(String cardId) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.selectByPrimaryKey((Serializable)((Object)cardId), 0L);
        if ((Objects.equals(prepayCardEntity.getCardType(), PrepayCardTypeEnum.coffee_card.getValue()) || Objects.equals(prepayCardEntity.getCardType(), PrepayCardTypeEnum.milk_card.getValue())) && (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.TAKED.getValue() || prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue())) {
            boolean isFinnish;
            PrepayCardEntity update = new PrepayCardEntity();
            update.setCardId(cardId);
            update.setStatus(PrepayCardStatusEnum.NOEFFECT.getValue());
            PrepayCardDetailEntity query = new PrepayCardDetailEntity();
            query.setCardId(cardId);
            List list = this.prepayCardPlanDetailService.getList(query, 0L);
            if (CollectionUtils.isNotEmpty((Collection)list) && !list.stream().anyMatch(p -> p.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue() || p.getStatus().intValue() == PrepayCardPlanStatusEnum.SUSPEND.getValue() || p.getStatus().intValue() == PrepayCardPlanStatusEnum.DELIVERY.getValue()) && prepayCardEntity.getRemainCount() == 0 && (isFinnish = list.stream().anyMatch(p -> p.getStatus().intValue() == PrepayCardPlanStatusEnum.FINISH.getValue())) && prepayCardEntity.getRemainCount() == 0) {
                update.setStatus(PrepayCardStatusEnum.FINISH.getValue());
                this.updateByPrimaryKeySelective(update);
                this.cardLogInterface.saveCardPlanLog(cardId, prepayCardEntity.getStatus(), update.getStatus(), "\u6240\u6709\u8ba2\u5355\u786e\u8ba4\u6536\u8d27\u65f6\u5b8c\u6210");
            }
        }
    }

    public BaseJsonVo orderConfirmGoodsUpdateCardStatus(String cardId) {
        PrepayCardEntity entity = (PrepayCardEntity)this.selectByPrimaryKey((Serializable)((Object)cardId));
        if (entity != null && entity.getStatus() == 2 && Objects.equals(entity.getCardType(), PrepayCardTypeEnum.milk_card.getValue())) {
            Integer _old = entity.getStatus();
            Integer _new = 6;
            entity.setStatus(_new);
            this.updateByPrimaryKeySelective(entity);
            this.cardLogInterface.saveCardPlanLog(cardId, _old, _new, "\u786e\u8ba4\u6536\u8d27\u66f4\u65b0\u72b6\u6001");
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public BaseJsonVo orderRefundUpdateCardPlanStatus(String cardId) {
        Integer _old;
        PrepayCardEntity entity = (PrepayCardEntity)this.selectByPrimaryKey((Serializable)((Object)cardId));
        if (entity != null && (_old = entity.getStatus()) != 5) {
            Integer _new = 5;
            entity.setStatus(_new);
            this.updateByPrimaryKeySelective(entity);
            this.cardLogInterface.saveCardPlanLog(cardId, _old, _new, "\u9000\u6b3e\u66f4\u65b0\u72b6\u6001");
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public BaseJsonVo orderAllRefundUpdateCardPlanStatus(String cardOrderMainNo) {
        PrepayCardEntity entity = new PrepayCardEntity();
        entity.setOrderMainNo(cardOrderMainNo);
        entity = (PrepayCardEntity)this.getSingle(entity);
        if (entity != null) {
            Integer _old = entity.getStatus();
            Integer _new = 5;
            entity.setStatus(_new);
            this.updateByPrimaryKeySelective(entity);
            this.cardLogInterface.saveCardPlanLog(entity.getCardId(), _old, _new, "\u9000\u6b3e\u66f4\u65b0\u72b6\u6001");
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    public BaseJsonVo orderPaySuccessUpdateCardPlanCount(String cardId, String updateTimeStamp) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.selectByPrimaryKey((Serializable)((Object)cardId));
        if (prepayCardEntity != null && this.prepayCardMapper.reduceCardCount(cardId, updateTimeStamp) > 0) {
            this.remoteCache((Serializable)((Object)cardId));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u6263\u51cf\u5931\u8d25");
    }

    @Override
    public int updateCardCount(PrepayCardEntity prepayCardEntity) {
        this.remoteCache((Serializable)((Object)prepayCardEntity.getCardId()));
        return this.prepayCardMapper.updateCardCount(prepayCardEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo orderPaySuccessCreateCard(String orderMainNo) {
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        if (mallOrderMainEntity.getStatus() >= 3 && mallOrderMainEntity.getStatus() <= 16) {
            return this.orderPaySuccessCreateCard(mallOrderMainEntity);
        }
        return BaseJsonVo.error((String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u7b26");
    }

    @Override
    public BaseJsonVo orderPaySuccessCreateCard(MallOrderMainEntity mallOrderMainEntity) {
        PrepayCardRecommendDetailEntity recommendDetail;
        PrepayCardEntity query = new PrepayCardEntity();
        query.setOrderMainNo(mallOrderMainEntity.getOrderMainNo());
        PrepayCardEntity temp = (PrepayCardEntity)this.prepayCardMapper.getSingle(query);
        if (temp != null && StringUtils.isNotEmpty((String)temp.getCardId())) {
            return BaseJsonVo.success((Object)"\u5df2\u5145\u503c\u6210\u529f");
        }
        List<MallOrderProductEntity> products = this.mallOrderProductInterface.getOrderProductInfoByOrderMianNo(mallOrderMainEntity.getOrderMainNo());
        if (products == null || products.size() == 0) {
            return BaseJsonVo.error((String)"\u751f\u6210\u8ba2\u5355\u5546\u54c1\u9519\u8bef");
        }
        PrepayCardBatchEntity param = new PrepayCardBatchEntity();
        this.logger.info("<><><><>1" + JsonUtils.toJson(products, (boolean)true));
        this.logger.info("<><><><>2" + JsonUtils.toJson((Object)mallOrderMainEntity, (boolean)true));
        param.setCardPromotionId(products.get(0).getPromotionId());
        List batches = this.prepayCardBatchInterface.getList(param);
        if (batches == null || batches.size() == 0) {
            param = new PrepayCardBatchEntity();
            if (StringUtils.isNotEmpty((String)mallOrderMainEntity.getBindCode())) {
                param.setBindCode(mallOrderMainEntity.getBindCode());
                batches = this.prepayCardBatchInterface.getList(param);
            }
        }
        if (batches == null || batches.size() == 0) {
            return BaseJsonVo.error((String)("[\u751f\u6210prepay\u5361][" + mallOrderMainEntity.getOrderMainNo() + "]\u67e5\u8be2\u5361\u6279\u6b21\u9519\u8bef"));
        }
        BigDecimal deductAmount = BigDecimal.ZERO;
        if (mallOrderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY.getValue() && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)mallOrderMainEntity.getSourceOrderNo()) && (recommendDetail = this.prepayCardRecommendInterface.getRecommendDetail(mallOrderMainEntity.getSourceOrderNo())) != null && (deductAmount = recommendDetail.getFactAmount()) == null) {
            deductAmount = BigDecimal.ZERO;
        }
        PrepayCardBatchEntity batch = (PrepayCardBatchEntity)batches.get(0);
        PrepayCardEntity entity = new PrepayCardEntity();
        entity.setCardId(IDGenerate.getUniqueIdStr());
        entity.setCardPassword(entity.getCardId());
        entity.setBuyerCustomerId(mallOrderMainEntity.getCustomerId());
        entity.setBelongCustomerId(entity.getBuyerCustomerId());
        entity.setBatchId(batch.getBatchId());
        entity.setOrderMainNo(mallOrderMainEntity.getOrderMainNo());
        entity.setTotalCount(batch.getDeliverCount());
        entity.setRemainCount(entity.getTotalCount());
        entity.setStatus(PrepayCardStatusEnum.ACTIVE.getValue());
        entity.setOrderSource(batch.getOrderSource());
        entity.setCardType(batch.getCardType());
        entity.setCardPrice(batch.getCardPrice());
        entity.setUnit(StringUtils.isNotEmpty((String)batch.getProductPromotionId()) ? this.promotionService.getPromotionUnit(batch.getProductPromotionId()) : "");
        entity.setBatchType(batch.getBatchType());
        if (Integer.valueOf(4).equals(entity.getCardType()) || Integer.valueOf(5).equals(entity.getCardType())) {
            List<MallOrderPayEntity> payEntityList = this.mallOrderPayInterface.getOrderPayInfoByOrderMainNoPayList(3, mallOrderMainEntity.getOrderMainNo());
            BigDecimal ticketAmount = BigDecimal.ZERO;
            if (payEntityList != null && payEntityList.size() > 0) {
                ticketAmount = payEntityList.get(0).getPayamount();
            }
            entity.setSaleValue(entity.getCardPrice());
            batch.setSaleValue(entity.getCardPrice());
        } else {
            entity.setSaleValue(batch.getSaleValue());
        }
        entity.setShopId("1325743461067264001");
        entity.setMilkCardRate(batch.getMilkCardRate());
        entity.setCardPrice(batch.getCardPrice());
        entity.setRate(batch.getRate());
        entity.setCreateTime(DateUtils.now());
        this.logger.info(">>>>>>>>>>>entity:{}", (Object)JsonUtils.toJson((Object)entity, (boolean)false));
        BaseJsonVo<SpecialCardDTO> vo = this.balanceInterface.charge(entity.getCardId(), entity.getBuyerCustomerId(), mallOrderMainEntity.getOrderMainNo(), batch, deductAmount);
        if (!vo.isSuccess()) {
            return vo;
        }
        entity.setRelateCardNo(((SpecialCardDTO)vo.getValue()).getCardNo());
        entity.setBindCode(mallOrderMainEntity.getBindCode());
        this.insertSelective(entity);
        if (deductAmount.floatValue() > 0.0f && Integer.valueOf(4).equals(entity.getCardType()) || Integer.valueOf(5).equals(entity.getCardType())) {
            this.prepayCardOrderPlanInterface.createPlanDetail(entity, mallOrderMainEntity.getSourceOrderNo(), deductAmount);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo<PrepayCardEntity> activateCustomCard(Integer batchId, String orderNo, BigDecimal totalAmount, Integer totalCount, String shopId) {
        PrepayCardEntity query = new PrepayCardEntity();
        query.setOrderMainNo(orderNo);
        PrepayCardEntity temp = (PrepayCardEntity)this.prepayCardMapper.getSingle(query);
        if (temp != null && StringUtils.isNotEmpty((String)temp.getCardId())) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u5df2\u7ecf\u751f\u6210\u8ba1\u5212");
        }
        PrepayCardBatchEntity batch = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(batchId);
        if (batch == null) {
            return BaseJsonVo.error((String)"\u5361\u6279\u6b21\u914d\u7f6e\u9519\u8bef");
        }
        PrepayCardEntity entity = new PrepayCardEntity();
        entity.setCardId(IDGenerate.getUniqueIdStr());
        entity.setCardPassword(entity.getCardId());
        entity.setBuyerCustomerId(orderNo);
        entity.setBelongCustomerId(orderNo);
        entity.setBatchId(batch.getBatchId());
        entity.setOrderMainNo(orderNo);
        entity.setTotalCount(totalCount);
        entity.setRemainCount(0);
        entity.setStatus(PrepayCardStatusEnum.ACTIVE.getValue());
        entity.setOrderSource(batch.getOrderSource());
        entity.setCardType(batch.getCardType());
        entity.setCardPrice(totalAmount);
        entity.setUnit("\u4ef6");
        entity.setBatchType(batch.getBatchType());
        entity.setSaleValue(batch.getSaleValue());
        entity.setRate(batch.getRate());
        entity.setCreateTime(DateUtils.now());
        entity.setShopId(shopId);
        batch.setCardPrice(totalAmount);
        BaseJsonVo<SpecialCardDTO> vo = this.balanceInterface.charge(entity.getCardId(), entity.getBuyerCustomerId(), orderNo, batch, BigDecimal.ZERO);
        if (!vo.isSuccess()) {
            return BaseJsonVo.error((String)vo.getMessage());
        }
        entity.setRelateCardNo(((SpecialCardDTO)vo.getValue()).getCardNo());
        this.insertSelective(entity);
        return BaseJsonVo.success((Object)entity);
    }

    @Override
    @WriteDataSource
    public PrepayCardEntity findByPwd(String card) {
        if (StringUtils.isEmpty((String)card)) {
            return null;
        }
        return this.prepayCardMapper.findByPwd(card);
    }

    @Override
    @RedisLock(key="PREPAY_EXCHANGE", expire=7L, waitTime=60L)
    @Transactional
    public BaseJsonVo exchange(@RedisLockParameter String customerId, String card, String orderNo, String phone) {
        CustomerEntity search;
        Integer errTimes = null;
        if (this.redisCacheUtil.exists(EXCHANGE_PWD_PREFIX + customerId) && (errTimes = (Integer)this.redisCacheUtil.get(EXCHANGE_PWD_PREFIX + customerId)) >= 3) {
            this.logger.error("\u5976\u5361\u5151\u6362\u8d85\u51fa\u9650\u5236\u6b21\u6570\uff1a" + errTimes + ",customerId:" + customerId + ",\u5361\u5bc6\uff1a" + card);
            return BaseJsonVo.error((String)"\u60a8\u4eca\u65e5\u5df2\u8f93\u95193\u6b21\uff0c\u8bf7\u660e\u5929\u518d\u8bd5");
        }
        PrepayCardEntity cardEntity = this.prepayCardMapper.findByPwd(card);
        if (cardEntity == null || StringUtils.isEmpty((String)cardEntity.getCardId())) {
            errTimes = this.redisCacheUtil.increment(EXCHANGE_PWD_PREFIX + customerId, 1);
            if (errTimes <= 1) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.set(10, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                long dateDiffSecond = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)calendar.getTime());
                this.redisCacheUtil.set(EXCHANGE_PWD_PREFIX + customerId, (Object)errTimes, Long.valueOf(dateDiffSecond));
            }
            if (errTimes >= 3) {
                return BaseJsonVo.error((String)"\u5361\u5bc6\u9519\u8bef\uff0c\u60a8\u4eca\u65e5\u5df2\u8f93\u95193\u6b21\uff0c\u8bf7\u660e\u5929\u518d\u8bd5");
            }
            return BaseJsonVo.error((String)"\u5361\u5bc6\u9519\u8bef");
        }
        if (cardEntity.getStatus() != 0) {
            return BaseJsonVo.error((String)"\u8be5\u5361\u5bc6\u5df2\u88ab\u6fc0\u6d3b");
        }
        String shopId = "";
        PrepayCardBatchEntity batch = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(cardEntity.getBatchId());
        if (Integer.valueOf(4).equals(cardEntity.getCardType()) || Integer.valueOf(5).equals(cardEntity.getCardType())) {
            BaseJsonVo jsonVo = this.checkPrePayCardWithNewCard(batch, cardEntity, orderNo, phone);
            if (!jsonVo.isSuccess()) {
                return jsonVo;
            }
            shopId = jsonVo.getValue().toString();
        }
        this.redisCacheUtil.remove(EXCHANGE_PWD_PREFIX + customerId);
        BaseJsonVo<SpecialCardDTO> vo = this.balanceInterface.charge(cardEntity.getCardId(), customerId, "", batch, BigDecimal.ZERO);
        if (!vo.isSuccess()) {
            return vo;
        }
        cardEntity.setBelongCustomerId(customerId);
        cardEntity.setBuyerCustomerId(customerId);
        cardEntity.setRelateCardNo(((SpecialCardDTO)vo.getValue()).getCardNo());
        cardEntity.setStatus(PrepayCardStatusEnum.ACTIVE.getValue());
        cardEntity.setCardType(batch.getCardType());
        cardEntity.setCreateTime(DateUtils.now());
        if (StringUtils.isNotEmpty((String)batch.getProductPromotionId())) {
            cardEntity.setUnit(this.promotionService.getPromotionUnit(batch.getProductPromotionId()));
        }
        cardEntity.setBindCode(batch.getBindCode());
        cardEntity.setBatchType(batch.getBatchType());
        cardEntity.setSaleValue(batch.getSaleValue());
        cardEntity.setCardPrice(batch.getCardPrice());
        cardEntity.setRate(batch.getRate());
        if (StringUtils.isNotEmpty((String)orderNo)) {
            cardEntity.setOrderMainNo(orderNo);
        }
        cardEntity.setPhone(phone);
        cardEntity.setShopId(shopId);
        int i = this.updateByPrimaryKeySelective(cardEntity);
        if (StringUtils.isNotEmpty((String)phone) && (search = this.customerService.getCustomer(customerId)) != null && StringUtils.isEmpty((String)search.getMobile())) {
            search = new CustomerEntity();
            search.setCustomerId(customerId);
            search.setMobile(phone);
            this.customerService.updateCustomerEntitySelective(search);
        }
        if (StringUtils.isNotEmpty((String)orderNo)) {
            this.biOrderDetailInvoke.orderBindCustomer(customerId, phone, orderNo, 1);
        }
        return BaseJsonVo.success((Object)cardEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo bindOrder(String customerId, String orderNo, String mobile) {
        List<PrepayCardEntity> prepayCardEntities = this.checkOrderSynced(orderNo);
        if (prepayCardEntities != null && prepayCardEntities.size() > 0) {
            return ((PrepayCardService)SpringContextUtil.getBean(this.getClass())).bindOrder(customerId, orderNo, prepayCardEntities);
        }
        if (StringUtils.isNotEmpty((String)mobile)) {
            BaseJsonVo updateMobileResult = this.updateOriginConsigneeMobile(orderNo, mobile);
            if (!updateMobileResult.isSuccess()) {
                return updateMobileResult;
            }
        } else {
            BaseJsonVo<OriginOrderVO> originOrderResult = this.mallOrderMainInterface.getOriginOrder(orderNo);
            if (!originOrderResult.isSuccess()) {
                return originOrderResult;
            }
            OriginOrderVO originOrderVO = (OriginOrderVO)originOrderResult.getValue();
            this.logger.info("originOrderVO:{}", (Object)JsonUtils.toJson((Object)originOrderVO, (boolean)false));
            if (originOrderVO.getConsigneeMobile().contains("*")) {
                BaseJsonVo<ReceiverinfoQueryResponse.ReceiverInfo> decodeResult = this.decodeConsignee(orderNo, originOrderVO.getOaid());
                this.logger.info("decodeResult:{}", (Object)JsonUtils.toJson(decodeResult, (boolean)false));
                if (!decodeResult.isSuccess()) {
                    return decodeResult;
                }
                BaseJsonVo updateMobileResult = this.updateOriginConsignee(orderNo, (ReceiverinfoQueryResponse.ReceiverInfo)decodeResult.getValue());
                this.logger.info("updateMobileResult:{}", (Object)JsonUtils.toJson((Object)updateMobileResult, (boolean)false));
                if (!updateMobileResult.isSuccess()) {
                    return updateMobileResult;
                }
                originOrderVO.setConsigneeMobile(((ReceiverinfoQueryResponse.ReceiverInfo)decodeResult.getValue()).getMobile());
            }
            if (originOrderVO.getConsigneeMobile().length() == 16 && originOrderVO.getConsigneeMobile().contains("-") || StringUtils.isEmpty((String)originOrderVO.getConsigneeMobile())) {
                HashMap<String, Object> rtnMap = new HashMap<String, Object>();
                rtnMap.put("cardType", 1);
                rtnMap.put("needMobile", 1);
                rtnMap.put("cardId", null);
                rtnMap.put("msg", "\u8bf7\u8f93\u5165\u6536\u8d27\u4eba\u624b\u673a\u53f7");
                return BaseJsonVo.success(rtnMap);
            }
        }
        BaseJsonVo syncOrderResult = this.syncOrder(orderNo);
        this.logger.info("syncOrderResult:{}", (Object)JsonUtils.toJson((Object)syncOrderResult, (boolean)false));
        if (!syncOrderResult.isSuccess()) {
            return syncOrderResult;
        }
        prepayCardEntities = this.checkOrderSynced(orderNo);
        if (prepayCardEntities == null || prepayCardEntities.size() == 0) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u5bc4\u5b58\u8ba2\u5355");
        }
        return ((PrepayCardService)SpringContextUtil.getBean(this.getClass())).bindOrder(customerId, orderNo, prepayCardEntities);
    }

    private List<PrepayCardEntity> checkOrderSynced(String orderNo) {
        List<PrepayCardEntity> rst = this.prepayCardMapper.checkOrderSynced(orderNo);
        return rst;
    }

    private BaseJsonVo<ReceiverinfoQueryResponse.ReceiverInfo> decodeConsignee(String orderNo, String oaid) {
        BaseShop baseShop = this.buildBaseShop();
        this.logger.info("\u5bc4\u5b58\u8ba2\u5355\u624b\u673a\u53f7\u89e3\u5bc6\u53c2\u6570\uff0corderNo={},oaid={},baseShop={}", new Object[]{orderNo, oaid, JsonUtils.toJson((Object)baseShop, (boolean)false)});
        BaseJsonVo<ReceiverinfoQueryResponse> oaidResult = this.tmallInvoke.receiverinfoQuery(baseShop, orderNo, oaid);
        if (!oaidResult.isSuccess()) {
            this.logger.error("\u5bc4\u5b58\u8ba2\u5355\u624b\u673a\u53f7\u89e3\u5bc6\u5931\u8d25\uff0corderNo={},oaid={},baseShop={},\u8fd4\u56de\u503c\uff1a{}", new Object[]{orderNo, oaid, JsonUtils.toJson((Object)baseShop, (boolean)false), JsonUtils.toJson(oaidResult, (boolean)false)});
            return BaseJsonVo.error((String)oaidResult.getMessage());
        }
        this.logger.info("\u5bc4\u5b58\u8ba2\u5355\u624b\u673a\u53f7\u89e3\u5bc6\u6210\u529f\uff0corderNo={},oaid={},baseShop={},\u8fd4\u56de\u503c\uff1a{}", new Object[]{orderNo, oaid, JsonUtils.toJson((Object)baseShop, (boolean)false), JsonUtils.toJson(oaidResult, (boolean)false)});
        return BaseJsonVo.success((Object)((ReceiverinfoQueryResponse)oaidResult.getValue()).getReceiverInfo());
    }

    private BaseJsonVo syncOrder(String orderNo) {
        BaseJsonVo baseJsonVo = this.wxOrderClient.splitCycleOrderByExternalOrderNo(orderNo);
        return baseJsonVo;
    }

    private BaseJsonVo updateOriginConsigneeMobile(String orderNo, String mobile) {
        WxOrderEntityVO wxOrderEntityVO = new WxOrderEntityVO();
        wxOrderEntityVO.setExternalOrderNo(orderNo);
        wxOrderEntityVO.setConsigneeMobile(mobile);
        BaseJsonVo<WxOrderEntityVO> updateMobileResult = this.wxOrderClient.updateMainOrderByOrderMainNo(wxOrderEntityVO);
        return updateMobileResult;
    }

    private BaseJsonVo updateOriginConsignee(String orderNo, ReceiverinfoQueryResponse.ReceiverInfo receiverInfo) {
        WxOrderEntityVO wxOrderEntityVO = new WxOrderEntityVO();
        wxOrderEntityVO.setExternalOrderNo(orderNo);
        wxOrderEntityVO.setConsigneeMobile(receiverInfo.getMobile());
        wxOrderEntityVO.setConsigneeAddress(receiverInfo.getDetailAddress());
        wxOrderEntityVO.setConsigneeName(receiverInfo.getName());
        BaseJsonVo<WxOrderEntityVO> updateMobileResult = this.wxOrderClient.updateMainOrderByOrderMainNo(wxOrderEntityVO);
        return updateMobileResult;
    }

    @Override
    @Transactional
    public BaseJsonVo bindOrder(String customerId, String orderNo, List<PrepayCardEntity> cardList) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        rtnMap.put("cardType", 1);
        rtnMap.put("needMobile", 0);
        if (customerId.equals(cardList.get(0).getBelongCustomerId())) {
            rtnMap.put("cardId", cardList.get(0).getCardId());
            rtnMap.put("msg", "\u60a8\u5df2\u7ed1\u5b9a\u4e86\u8fd9\u4e2a\u8ba2\u5355\uff0c\u5feb\u5230\u6211\u7684\u5361\u5305\u67e5\u770b\u5427~");
            return BaseJsonVo.success(rtnMap);
        }
        if (!orderNo.equals(cardList.get(0).getBelongCustomerId())) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u5df2\u88ab\u5176\u4ed6\u8d26\u53f7\u7ed1\u5b9a");
        }
        List<CustomerAddressEntity> validCustomerAddressList = this.customerAddressInterface.getValidCustomerAddressList(orderNo);
        if (validCustomerAddressList == null || validCustomerAddressList.size() == 0) {
            this.logger.error("\u60b2\u50ac\uff0c\u5bc4\u5b58\u5361\u66f4\u65b0\u5730\u5740\u7684\u7528\u6237ID\u5565\u90fd\u6ca1\u67e5\u5230\uff0ccustomerId={},orderNo={},cardList={}", new Object[]{customerId, orderNo, JsonUtils.toJson(cardList, (boolean)false)});
        }
        validCustomerAddressList.forEach(addr -> {
            addr.setCustomerId(customerId);
            int i = this.customerAddressMapper.updateByPrimaryKeySelective(addr);
            if (i == 0) {
                this.logger.error("\u60b2\u50ac\uff0c\u5bc4\u5b58\u5361\u66f4\u65b0\u5730\u5740\u7684\u7528\u6237ID\u6ca1\u66f4\u65b0\u4e86\uff0ccustomerId={},orderNo={},addr={}", new Object[]{customerId, orderNo, JsonUtils.toJson((Object)addr, (boolean)false)});
            }
        });
        cardList.forEach(card -> {
            card.setBuyerCustomerId(customerId);
            card.setBelongCustomerId(customerId);
            this.prepayCardMapper.updateByPrimaryKeySelective(card);
        });
        List<PrepayCardDetailEntity> detailList = this.prepayCardPlanDetailService.getPlanDetailList(cardList.get(0).getCardId());
        if (detailList == null || detailList.size() == 0) {
            this.logger.error("\u60b2\u50ac\uff0c\u5bc4\u5b58\u5361\u66f4\u65b0\u8ba1\u5212Detail\u5565\u90fd\u6ca1\u67e5\u5230\uff0ccustomerId={},orderNo={},cardList.get(0).getCardId()={}", new Object[]{customerId, orderNo, cardList.get(0).getCardId()});
        }
        detailList.forEach(detail -> {
            detail.setCustomerId(customerId);
            int i = this.prepayCardPlanDetailService.updateByPrimaryKeySelective(detail);
            if (i == 0) {
                this.logger.error("\u60b2\u50ac\uff0c\u5bc4\u5b58\u5361\u66f4\u65b0detail\u6ca1\u66f4\u65b0\u4e86\uff0ccustomerId={},orderNo={},detail={}", new Object[]{customerId, orderNo, JsonUtils.toJson((Object)detail, (boolean)false)});
            }
            MallOrderMainEntity mainOrder = new MallOrderMainEntity();
            mainOrder.setOrderMainNo(detail.getOrderMainNo());
            mainOrder.setCustomerId(customerId);
            Boolean j = this.mallOrderMainInterface.updateOrderMain(mainOrder);
            if (!j.booleanValue()) {
                this.logger.error("\u60b2\u50ac\uff0c\u5bc4\u5b58\u5361\u66f4\u65b0\u4e3b\u8ba2\u5355\u7684\u7528\u6237ID\u6ca1\u66f4\u65b0\u4e86\uff0ccustomerId={},orderNo={},mainOrder={}", new Object[]{customerId, orderNo, JsonUtils.toJson((Object)mainOrder, (boolean)false)});
            }
        });
        BaseJsonVo b = this.balanceAccountInvoke.changeSpecialCardOwner(cardList.get(0).getRelateCardNo(), orderNo, customerId);
        if (!b.isSuccess()) {
            this.logger.error("\u60b2\u50ac\uff0c\u5bc4\u5b58\u5361\u5237\u65b0\u4f59\u989d\u7cfb\u7edf\u7684specialCard\u6ca1\u66f4\u65b0\u4e86\uff0ccustomerId={},orderNo={},cardList.get(0).getRelateCardNo()={},b={}", new Object[]{customerId, orderNo, cardList.get(0).getRelateCardNo(), JsonUtils.toJson((Object)b, (boolean)false)});
        }
        rtnMap.put("cardId", cardList.get(0).getCardId());
        rtnMap.put("msg", "\u7ed1\u5b9a\u6210\u529f\uff0c\u5feb\u53bb\u6211\u7684\u5361\u5305\u770b\u770b\u5427~");
        return BaseJsonVo.success(rtnMap);
    }

    private BaseShop buildBaseShop() {
        BaseShop baseShop = new BaseShop();
        PlatformDTO platformDTO = new PlatformDTO();
        platformDTO.setPlatformName("\u6dd8\u5b9d");
        BaseJsonVo<List<PlatformDTO>> listBaseJsonVo = this.csmsRefundInvoke.listPlatformInfo(platformDTO);
        PlatformDTO platformDTOParam = null;
        if (!listBaseJsonVo.isSuccess() || listBaseJsonVo.getValue() == null || ((List)listBaseJsonVo.getValue()).size() <= 0) {
            return null;
        }
        platformDTOParam = (PlatformDTO)((List)listBaseJsonVo.getValue()).get(0);
        baseShop.setAppSecret(platformDTOParam.getShopSecret());
        baseShop.setSessionKey(platformDTOParam.getShopToken());
        baseShop.setAppKey(platformDTOParam.getShopKey());
        baseShop.setShopId(platformDTOParam.getShopId());
        baseShop.setLastUpdateTime(platformDTOParam.getLastUpdateTime());
        baseShop.setPlatform(platformDTOParam.getPlatformName());
        return baseShop;
    }

    public static void main(String[] args) {
        String a = "1@#KUGaHdQD6RL6QOscC0JEWia7dyfYzbWsJKnbAnyOdJ4kMIQhpe4TVMownEiQ5oBJ+g==";
        System.out.println(a.hashCode());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    public BaseJsonVo checkPrePayCardWithNewCard(PrepayCardBatchEntity batchEntity, PrepayCardEntity cardEntity, String orderNo, String phone) {
        String cardBarCode = batchEntity.getMilkCardBarcode();
        Integer batchId = batchEntity.getBatchId();
        if (StringUtils.isEmpty((String)cardBarCode)) {
            return BaseJsonVo.error((String)"\u5361\u6279\u6b21\u6ca1\u6709\u914d\u7f6e\u536169\u7801");
        }
        if (StringUtils.isEmpty((String)orderNo)) {
            return BaseJsonVo.error((String)"\u8bf7\u586b\u5199\u8ba2\u5355\u53f7");
        }
        PrepayCardEntity search = new PrepayCardEntity();
        search.setOrderMainNo(orderNo);
        search.setBatchId(batchId);
        int alreadyCount = this.prepayCardMapper.existsByEntity(search);
        String shopId = "";
        BaseJsonVo<OriginOrderVO> originJson = this.mallOrderMainInterface.getOriginOrder(orderNo);
        if (!originJson.isSuccess()) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u67e5\u6b631");
        }
        shopId = ((OriginOrderVO)originJson.getValue()).getShopId();
        BaseJsonVo<List<OriginOrderProductVO>> jsonVo = this.mallOrderMainInterface.getOriginOrderProduct(orderNo);
        if (!jsonVo.isSuccess()) return BaseJsonVo.error((String)"\u65e0\u6cd5\u67e5\u627e\u8ba2\u5355\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        if (CollectionUtils.isEmpty((Collection)((Collection)jsonVo.getValue()))) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u67e5\u6b63");
        }
        List lst = ((List)jsonVo.getValue()).stream().filter(c -> cardBarCode.equals(c.getProductCbarcode())).collect(Collectors.toList());
        if (lst.size() <= 0) return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0e\u5361\u4e0d\u5bf9\u5e94\uff0c\u8bf7\u67e5\u6b63");
        int quantity = lst.stream().mapToInt(c -> c.getProductNum().intValue()).sum();
        if (alreadyCount + 1 <= quantity) return BaseJsonVo.success((Object)shopId);
        return BaseJsonVo.error((String)("\u8be5\u8ba2\u5355\u53f7\u5df2\u6210\u529f\u6fc0\u6d3b" + alreadyCount + "\u5f20\u5361\uff0c\u4e0d\u80fd\u518d\u6b21\u6fc0\u6d3b\u5361\u7247"));
    }
}

