/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.qrcode;

import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.qrcode.MiniQrcodeMapper;
import cc.lechun.mall.entity.qrcode.MiniQrcodeEntity;
import cc.lechun.mall.iservice.qrcode.MiniQrcodeInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import weixin.popular.api.QrcodeAPI;
import weixin.popular.bean.qrcode.MiniQrcode;

@Service
public class MiniQrcodeService
extends BaseService<MiniQrcodeEntity, Integer>
implements MiniQrcodeInterface {
    @Resource
    private MiniQrcodeMapper miniQrcodeMapper;
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private OssService ossService;
    @Value(value="${lechun.environment}")
    private String environment;

    @Override
    public String getQrcodePath(Integer platformId, String customerId, String bindCode, String page, String toPage, String queryPara, Integer width) {
        MiniQrcodeEntity miniQrcodeEntity = new MiniQrcodeEntity();
        miniQrcodeEntity.setBindCode(bindCode);
        miniQrcodeEntity.setCustomerId(customerId);
        miniQrcodeEntity.setPage(page);
        MiniQrcodeEntity single = (MiniQrcodeEntity)this.miniQrcodeMapper.getSingle(miniQrcodeEntity);
        if (single == null) {
            miniQrcodeEntity.setQueryPara(queryPara);
            miniQrcodeEntity.setCreateTime(DateUtils.now());
            miniQrcodeEntity.setToPage(toPage);
            this.miniQrcodeMapper.insert(miniQrcodeEntity);
            String accessToken = this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platformId);
            MiniQrcode miniQrcode = new MiniQrcode();
            miniQrcode.setPage(page);
            miniQrcode.setWidth(width);
            miniQrcode.setScene(miniQrcodeEntity.getSenceId().toString());
            try {
                BufferedImage bufferedImage = QrcodeAPI.getUnlimited((String)accessToken, (MiniQrcode)miniQrcode);
                if (bufferedImage != null) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "png", os);
                    ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                    String fileName = UUID.randomUUID().toString().replace("-", "") + ".png";
                    String qrcodeImageUrl = AliyunOSSDir.QRCODE_IMG_STORAGE.getPath().replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd")) + fileName;
                    this.ossService.uploadFile(qrcodeImageUrl, is);
                    MiniQrcodeEntity update = new MiniQrcodeEntity();
                    update.setSenceId(miniQrcodeEntity.getSenceId());
                    update.setQrcodePath(qrcodeImageUrl);
                    miniQrcodeEntity.setQrcodePath(qrcodeImageUrl);
                    int result = this.miniQrcodeMapper.updateByPrimaryKey(miniQrcodeEntity);
                    this.logger.info("\u66f4\u65b0:{}", (Object)result);
                    return StringUtils.isNotEmpty((String)qrcodeImageUrl) ? this.ossService.getImageResoure(qrcodeImageUrl) : "";
                }
                throw new RuntimeException("\u5c0f\u7a0b\u5e8f\u7801\u751f\u6210\u5931\u8d25");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return StringUtils.isNotEmpty((String)single.getQrcodePath()) ? this.ossService.getImageResoure(single.getQrcodePath()) : "";
    }

    @Override
    public String getQrcodePath(Integer platformId, String customerId, String bindCode, Integer width) {
        String page = "active1/pages/recover_index/index";
        String toPage = "active1/pages/recover_index/index";
        String queryPara = "bindCode=" + bindCode + "&inviteId=" + customerId;
        return this.getQrcodePath(platformId, customerId, bindCode, page, toPage, queryPara, width);
    }

    @Override
    public String getQrcodePath(Integer platformId, String customerId, String bindCode) {
        return this.getQrcodePath(platformId, customerId, bindCode, 280);
    }
}

