/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.active.entity.active.ActiveInviteLogEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveInviteLogInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.reunion.ReunionOrderProductRecoveryMapper;
import cc.lechun.mall.entity.reunion.ReunionOrderEntity;
import cc.lechun.mall.entity.reunion.ReunionOrderProductRecoveryEntity;
import cc.lechun.mall.entity.reunion.ReunionProductEntity;
import cc.lechun.mall.entity.reunion.ReunionProductVO;
import cc.lechun.mall.iservice.reunion.ReunionInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderProductRecoveryInterface;
import cc.lechun.mall.iservice.reunion.ReunionProductInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReunionOrderProductRecoveryService
extends BaseService<ReunionOrderProductRecoveryEntity, Integer>
implements ReunionOrderProductRecoveryInterface {
    @Resource
    private ReunionOrderProductRecoveryMapper reunionOrderProductRecoveryMapper;
    @Autowired
    private ReunionProductInterface reunionProductInterface;
    @Autowired
    private ReunionOrderInterface reunionOrderInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private ReunionInterface reunionInterface;
    @Autowired
    private ActiveInviteLogInterface activeInviteLogInterface;
    @Autowired
    private MessageInterface messageInterface;

    @Override
    public List<ReunionOrderProductRecoveryEntity> getRecoveryProducts(String customerId, String bindCode) {
        return this.reunionOrderProductRecoveryMapper.getRecoveryProducts(customerId, bindCode);
    }

    @Override
    @Transactional
    public BaseJsonVo saveRecoveryList(String customerId, String bindCode, List<ReunionProductVO> products) {
        ReunionOrderEntity reunionOrder = this.reunionOrderInterface.getReunionOrder(bindCode, customerId);
        if (reunionOrder == null) {
            return BaseJsonVo.error((String)"\u8bf7\u5148\u9009\u62e9\u5151\u6362\u5730\u70b9");
        }
        if (reunionOrder.getOrderStatus() == 3) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u8ba1\u5212\u5df2\u5173\u95ed\uff0c\u8bf7\u5230[\u4e2a\u4eba\u4e2d\u5fc3-\u5168\u90e8\u8ba1\u5212]\u9875\u9762\u91cd\u65b0\u5f00\u542f\uff01");
        }
        this.logger.info("\u8bb0\u5f55\u4fdd\u5b58\u56de\u6536\u54c1\u65e5\u5fd7...");
        ActiveInviteLogEntity activeInviteLogEntity = new ActiveInviteLogEntity();
        activeInviteLogEntity.setBindCode(bindCode);
        activeInviteLogEntity.setInviteId("");
        activeInviteLogEntity.setCustomerId(customerId);
        activeInviteLogEntity.setCreateTime(DateUtils.now());
        activeInviteLogEntity.setFromStatus(reunionOrder.getOrderStatus());
        activeInviteLogEntity.setOrderMainNo(reunionOrder.getOrderId().toString());
        this.logger.info(products.toString());
        activeInviteLogEntity.setMessage("\u4fdd\u5b58\u56de\u6536\u54c1,\u7ad9\u70b9\u5730\u5740\uff1a" + reunionOrder.getReunionSiteId());
        this.activeInviteLogInterface.saveInviteLog(activeInviteLogEntity);
        int i = this.reunionOrderProductRecoveryMapper.deleteOrderRecoveryProduct(reunionOrder.getOrderId());
        this.logger.info("HAHA\u4fdd\u5b58\u56de\u6536\u54c11\uff0ci={}", (Object)i);
        BigDecimal[] recoverAmount = new BigDecimal[]{BigDecimal.ZERO};
        this.logger.info("HAHA\u4fdd\u5b58\u56de\u6536\u54c12\uff0cproducts={}", (Object)JsonUtils.toJson(products, (boolean)false));
        products.forEach(product -> {
            if (product.getProductId() != null && product.getOrderCount() > 0) {
                ReunionOrderProductRecoveryEntity entity = new ReunionOrderProductRecoveryEntity();
                entity.setOrderId(reunionOrder.getOrderId());
                entity.setRecoveryProductId(product.getProductId());
                entity.setRecoveryProductQuantity(product.getOrderCount());
                ReunionProductEntity productDefine = (ReunionProductEntity)this.reunionProductInterface.selectByPrimaryKey(product.getProductId());
                entity.setRecoveryProductUnitPrice(productDefine.getLovePrice());
                entity.setRecoveryProductAmount(entity.getRecoveryProductUnitPrice().multiply(new BigDecimal(entity.getRecoveryProductQuantity().toString())));
                this.reunionOrderProductRecoveryMapper.insert(entity);
                recoverAmount[0] = recoverAmount[0].add(entity.getRecoveryProductAmount());
            }
        });
        this.logger.info("HAHA\u4fdd\u5b58\u56de\u6536\u54c13");
        reunionOrder.setLoveRecoveryAmount(recoverAmount[0]);
        reunionOrder.setUpdateTime(DateUtils.now());
        reunionOrder.setOrderSubStatus(14);
        int k = this.reunionOrderInterface.updateByPrimaryKeySelective(reunionOrder);
        this.logger.info("HAHA\u4fdd\u5b58\u56de\u6536\u54c14,k={}", (Object)k);
        try {
            this.messageInterface.sendWechatMessage("REUNION_NOTICE_SWAP", customerId, null);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u56de\u6536\u54c1\u53d1\u901a\u77e5\u62a5\u9519\u4e86", (Throwable)e);
        }
        this.logger.info("HAHA\u4fdd\u5b58\u56de\u6536\u54c15");
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public Integer getOrderRecoveryCount(Integer orderId) {
        return this.reunionOrderProductRecoveryMapper.getOrderRecoveryCount(orderId);
    }

    @Override
    public int deleteOrderRecoveryProduct(Integer orderId) {
        return this.reunionOrderProductRecoveryMapper.deleteOrderRecoveryProduct(orderId);
    }

    @Override
    public int resetRecoveryProduct(Integer orderId) {
        ReunionOrderProductRecoveryEntity update = new ReunionOrderProductRecoveryEntity();
        update.setOrderId(orderId);
        update.setRecoveryProductAmount(BigDecimal.ZERO);
        update.setRecoveryProductQuantity(0);
        return this.reunionOrderProductRecoveryMapper.resetRecoveryProduct(update);
    }
}

