/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.active.entity.active.ActiveInviteLogEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveInviteLogInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.apiinvoke.ec.AddressInvoke;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.reunion.ReunionOrderMapper;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.reunion.ReunionCustomerLoveEntity;
import cc.lechun.mall.entity.reunion.ReunionInfoVo;
import cc.lechun.mall.entity.reunion.ReunionOrderEntity;
import cc.lechun.mall.entity.reunion.ReunionOrderVO;
import cc.lechun.mall.entity.reunion.ReunionStockEntity;
import cc.lechun.mall.entity.reunion.sfExpress.CargoDetail;
import cc.lechun.mall.entity.reunion.sfExpress.ContactInfo;
import cc.lechun.mall.entity.reunion.sfExpress.Order;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.qrcode.MiniQrcodeInterface;
import cc.lechun.mall.iservice.reunion.ReunionCustomerLoveInterface;
import cc.lechun.mall.iservice.reunion.ReunionInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderProductRecoveryInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderProductSwapInterface;
import cc.lechun.mall.iservice.reunion.ReunionProductInterface;
import cc.lechun.mall.iservice.reunion.ReunionSiteInterface;
import cc.lechun.mall.iservice.reunion.ReunionStockInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.utils.jd.JdUtils;
import cc.lechun.utils.shunfeng.ShunFenUtils;
import cc.lechun.utils.shunfeng.entity.Route;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ReunionOrderService
extends BaseService<ReunionOrderEntity, Integer>
implements ReunionOrderInterface {
    @Resource
    private ReunionOrderMapper reunionOrderMapper;
    @Autowired
    ReunionCustomerLoveInterface reunionCustomerLoveInterface;
    @Autowired
    ActiveInviteInterface activeInviteInterface;
    @Autowired
    ActiveInterface activeInterface;
    @Autowired
    ReunionProductInterface reunionProductInterface;
    @Autowired
    ReunionSiteInterface reunionSiteInterface;
    @Autowired
    ReunionOrderProductRecoveryInterface reunionOrderProductRecoveryInterface;
    @Autowired
    ReunionOrderProductSwapInterface reunionOrderProductSwapInterface;
    @Autowired
    MallProductPicInterface picInterface;
    @Autowired
    ReunionInterface reunionInterface;
    @Autowired
    MiniQrcodeInterface miniQrcodeInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    private MessageInterface messageInterface;
    @Autowired
    private ReunionStockInterface reunionStockInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private ActiveInviteLogInterface activeInviteLogInterface;
    @Autowired
    CustomerAddressInterface customerAddressInterface;
    @Autowired
    DictionaryInterface dictionaryInterface;
    @Autowired
    AddressInvoke addressInvoke;
    @Autowired
    ShunFenUtils shunFenUtils;
    @Autowired
    JdUtils jdUtils;

    @Override
    public BaseJsonVo saveActiveInvite(String inviteId, String bindCode, CustomerDetailVo customer) {
        return this.activeInviteInterface.saveActiveInvite(inviteId, bindCode, customer);
    }

    @Override
    @Transactional
    @Deprecated
    public BaseJsonVo saveReunionOrder(CustomerDetailVo customer, String bindCode, Integer siteId, String inviteId, Integer addressType) {
        ReunionOrderEntity param = new ReunionOrderEntity();
        param.setBindCode(bindCode);
        param.setCustomerId(customer.getCustomerId());
        List orders = this.reunionOrderMapper.getList(param);
        if (orders == null || orders.size() == 0) {
            BaseJsonVo canJoin = this.reunionProductInterface.checkCreatePlan(bindCode);
            if (!canJoin.isSuccess()) {
                return canJoin;
            }
            ReunionOrderEntity order = new ReunionOrderEntity();
            order.setReunionSiteId(siteId);
            order.setBindCode(bindCode);
            order.setCustomerId(customer.getCustomerId());
            order.setOrderStatus(0);
            order.setAdressType(addressType);
            if (siteId == 0) {
                order.setLoveCostRecoveryAmount(BigDecimal.ZERO);
                order.setLoveSwapAmount(BigDecimal.ZERO);
            }
            order.setCreateTime(DateUtils.now());
            int insert = this.reunionOrderMapper.insert(order);
            if (insert == 0) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25!");
            }
            ActiveInviteLogEntity activeInviteLogEntity = new ActiveInviteLogEntity();
            activeInviteLogEntity.setBindCode(bindCode);
            activeInviteLogEntity.setCustomerId(customer.getCustomerId());
            activeInviteLogEntity.setInviteId(inviteId);
            activeInviteLogEntity.setCreateTime(DateUtils.now());
            activeInviteLogEntity.setMessage("\u9009\u62e9\u7ad9\u70b9\u5730\u5740:" + siteId + "\u53c2\u4e0e\u6d3b\u52a8");
            if (StringUtils.isNotEmpty((String)inviteId) && !inviteId.equals(customer.getCustomerId()) && !inviteId.equals("undefined")) {
                activeInviteLogEntity.setMessage("\u7ad9\u70b9\u5730\u5740:" + siteId + "\u63a5\u53d7\u7528\u6237:" + inviteId + " \u9080\u8bf7\u53c2\u4e0e\u6d3b\u52a8");
                this.activeInviteInterface.saveActiveInvite(inviteId, bindCode, customer);
            }
            this.activeInviteLogInterface.saveInviteLog(activeInviteLogEntity);
        } else if (orders.size() == 1) {
            int update;
            List<Map<String, Object>> productList;
            BaseJsonVo canJoin = this.reunionProductInterface.checkEditPlan(bindCode);
            if (!canJoin.isSuccess()) {
                return canJoin;
            }
            ReunionOrderEntity order = (ReunionOrderEntity)orders.get(0);
            if (order.getOrderStatus() == 3) {
                return BaseJsonVo.error((String)"\u5f53\u524d\u8ba1\u5212\u5df2\u5173\u95ed\uff0c\u8bf7\u5230[\u4e2a\u4eba\u4e2d\u5fc3-\u5168\u90e8\u8ba1\u5212]\u9875\u9762\u91cd\u65b0\u5f00\u542f\uff01");
            }
            if (order.getOrderStatus() == 2) {
                return BaseJsonVo.error((String)"\u5f53\u524d\u8ba1\u5212\u5df2\u5151\u6362\u5b8c\u6210\uff0c\u65e0\u6cd5\u4fee\u6539!");
            }
            if (order.getOrderStatus() == 1 && siteId == 0) {
                return BaseJsonVo.error((String)"\u8ba1\u5212\u5df2\u63d0\u4ea4\u4e0d\u80fd\u4fee\u6539\u4e3a\u5f53\u524d\u5730\u5740!");
            }
            if (siteId != null) {
                order.setReunionSiteId(siteId);
            }
            ActiveInviteLogEntity activeInviteLogEntity = new ActiveInviteLogEntity();
            activeInviteLogEntity.setBindCode(bindCode);
            activeInviteLogEntity.setInviteId(inviteId);
            activeInviteLogEntity.setCustomerId(customer.getCustomerId());
            activeInviteLogEntity.setCreateTime(DateUtils.now());
            activeInviteLogEntity.setFromStatus(order.getOrderStatus());
            activeInviteLogEntity.setToStatus(0);
            activeInviteLogEntity.setOrderMainNo(order.getOrderId().toString());
            activeInviteLogEntity.setMessage("\u4fee\u6539\u8ba2\u5355:" + order.getOrderId() + ",\u7ad9\u70b9\u5730\u5740:siteId=" + order.getReunionSiteId() + ",\u4fee\u6539\u524d\u8ba2\u5355\u72b6\u6001\uff1a" + order.getOrderStatus());
            this.activeInviteLogInterface.saveInviteLog(activeInviteLogEntity);
            if ((order.getOrderStatus() == 1 || siteId == 0) && (productList = this.reunionOrderProductSwapInterface.getOrderProductVO(order.getOrderId())) != null && productList.size() > 0) {
                for (Map<String, Object> item : productList) {
                    ReunionStockEntity reunionStockEntity = new ReunionStockEntity();
                    reunionStockEntity.setUpdateTime(DateUtils.now());
                    reunionStockEntity.setBindCode(order.getBindCode());
                    reunionStockEntity.setProductId(item.get("productId").toString());
                    reunionStockEntity.setRemain(Integer.valueOf(item.get("orderCount").toString()));
                    int result = this.reunionStockInterface.retunrStock(reunionStockEntity);
                    if (result != 0) continue;
                    this.logger.error("\u4fdd\u5b58\u8ba1\u5212{}\u5931\u8d25\uff0c\u5f52\u8fd8\u5151\u6362\u54c1{}\u5e93\u5b58\u65f6\u5931\u8d25", (Object)order.getOrderId(), (Object)item.get("productId").toString());
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return BaseJsonVo.error((String)"\u4fdd\u5b58\u8ba1\u5212\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
                }
            }
            order.setUpdateTime(DateUtils.now());
            order.setOrderStatus(0);
            if (addressType != null) {
                order.setAdressType(addressType);
            }
            if (siteId == 0) {
                order.setLoveSwapAmount(BigDecimal.ZERO);
                order.setLoveRecoveryAmount(BigDecimal.ZERO);
            }
            if ((update = this.reunionOrderMapper.updateByPrimaryKeySelective(order)) == 0) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u66f4\u65b0\u8ba1\u5212\u5931\u8d25");
            }
        } else if (orders.size() > 1) {
            return BaseJsonVo.error((String)"\u5185\u90e8\u9519\u8bef\uff0c\u8ba1\u5212\u6570\u91cf\u8d85\u8fc71\u4e2a\uff0c\u5982\u679c\u6709\u5173\u95ed\u7684\u8ba1\u5212\u8bf7\u5f00\u542f\u4f7f\u7528\uff01");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo saveReunionOrder(String customerId, String bindCode, String inviteId) {
        ReunionOrderEntity param = new ReunionOrderEntity();
        param.setBindCode(bindCode);
        param.setCustomerId(customerId);
        List orders = this.reunionOrderMapper.getList(param);
        if (orders == null || orders.size() == 0) {
            int insert;
            BaseJsonVo canJoin = this.reunionProductInterface.checkCreatePlan(bindCode);
            if (!canJoin.isSuccess()) {
                return canJoin;
            }
            ReunionOrderEntity order = new ReunionOrderEntity();
            order.setBindCode(bindCode);
            order.setCustomerId(customerId);
            order.setOrderStatus(0);
            order.setOrderSubStatus(0);
            order.setCreateTime(DateUtils.now());
            if (StringUtils.isNotEmpty((String)inviteId)) {
                order.setInviteId(inviteId);
            }
            if ((insert = this.reunionOrderMapper.insertSelective(order)) == 0) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25!");
            }
            ActiveInviteLogEntity activeInviteLogEntity = new ActiveInviteLogEntity();
            activeInviteLogEntity.setBindCode(bindCode);
            activeInviteLogEntity.setCustomerId(customerId);
            activeInviteLogEntity.setInviteId(inviteId);
            activeInviteLogEntity.setCreateTime(DateUtils.now());
            activeInviteLogEntity.setMessage("V2.0\u7ebf\u4e0a\u90ae\u5bc4\u53c2\u4e0e\u6d3b\u52a8");
            if (StringUtils.isNotEmpty((String)inviteId) && !inviteId.equals(customerId) && !inviteId.equals("undefined")) {
                activeInviteLogEntity.setMessage("V2.0\u7ebf\u4e0a\u90ae\u5bc4\u53c2\u4e0e\u6d3b\u52a8\uff0c\u63a5\u53d7\u7528\u6237:" + inviteId + " \u9080\u8bf7\u53c2\u4e0e\u6d3b\u52a8");
                CustomerDetailVo vo = new CustomerDetailVo();
                vo.setCustomerId(customerId);
                this.activeInviteInterface.saveActiveInvite(inviteId, bindCode, vo);
            }
            this.activeInviteLogInterface.saveInviteLog(activeInviteLogEntity);
        } else if (orders.size() > 1) {
            return BaseJsonVo.error((String)"\u5185\u90e8\u9519\u8bef\uff0c\u8ba1\u5212\u6570\u91cf\u8d85\u8fc71\u4e2a\uff0c\u5982\u679c\u6709\u5173\u95ed\u7684\u8ba1\u5212\u8bf7\u5f00\u542f\u4f7f\u7528\uff01");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo orderDetail(String customerId, String bindCode, int platformId, String inviteId) {
        ReunionOrderVO orderVO = new ReunionOrderVO();
        ReunionOrderEntity reunionOrder = this.getReunionOrder(bindCode, customerId);
        if (reunionOrder == null) {
            BaseJsonVo b = this.saveReunionOrder(customerId, bindCode, inviteId);
            if (!b.isSuccess()) {
                return b;
            }
            reunionOrder = this.getReunionOrder(bindCode, customerId);
        }
        int[] addrType = new int[]{2};
        try {
            CustomerAddressVo customerDefaultAddress = this.customerAddressInterface.getCustomerDefaultAddress(customerId, addrType);
            orderVO.setCustomerAddressVo(customerDefaultAddress);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6709\u8da3\u6709\u7231\u8282\u5730\u5740\u9519\u8befcustomerId:[{}]", (Object)customerId);
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u5730\u5740");
        }
        orderVO.setOrderId(reunionOrder.getOrderId());
        if (StringUtils.isNotEmpty((String)reunionOrder.getMobile())) {
            orderVO.setMobile(reunionOrder.getMobile());
        } else {
            CustomerEntity customerEntity = this.customerInterface.getCustomer(customerId);
            if (customerEntity != null) {
                orderVO.setMobile(customerEntity.getMobile());
            }
        }
        orderVO.setLoveRecoveryAmount(reunionOrder.getLoveRecoveryAmount() == null ? BigDecimal.ZERO : reunionOrder.getLoveRecoveryAmount());
        orderVO.setLoveSwapAmount(reunionOrder.getLoveSwapAmount() == null ? BigDecimal.ZERO : reunionOrder.getLoveSwapAmount());
        BaseJsonVo baseJsonVo = this.reunionCustomerLoveInterface.customerLove(customerId);
        if (baseJsonVo.isSuccess()) {
            orderVO.setCustomerShareLoveAmount(((ReunionCustomerLoveEntity)baseJsonVo.getValue()).getLoveShare());
            orderVO.setRemainAmount(((ReunionCustomerLoveEntity)baseJsonVo.getValue()).getLoveRemain());
        } else {
            orderVO.setCustomerShareLoveAmount(BigDecimal.ZERO);
        }
        orderVO.setHasAmount(orderVO.getLoveRecoveryAmount().add(orderVO.getCustomerShareLoveAmount()).add(orderVO.getRemainAmount()).subtract(orderVO.getLoveSwapAmount()));
        DictionaryEntity freight_1_fen = this.dictionaryInterface.getDictionary(1000, 221, "FREIGHT_1_FEN");
        orderVO.setFreightProductId(freight_1_fen.getDictionaryName());
        orderVO.setArriveTime(this.reunionInterface.getSFarriveTime());
        DictionaryEntity orderDetailText = this.dictionaryInterface.getDictionary(1000, 60, "ORDER_DETAIL_TEXT");
        orderVO.setDetailText(orderDetailText.getDictionaryName());
        orderVO.setTemplateMessageList(this.templateMessageInterface.getTempMessageListBySence(6, platformId));
        Map<String, List<String>> productPicUrlMap = this.picInterface.getProductPicUrlMap(this.activeInterface.getActiveNoByBindCode(bindCode), SalesTypeEnum.SALES_ACTIVE.getValue());
        if (productPicUrlMap != null && productPicUrlMap.containsKey(ProductPicTypeEnum.ACT_LIST.getName())) {
            orderVO.setHeadPic(productPicUrlMap.get(ProductPicTypeEnum.ACT_LIST.getName()).get(0));
        }
        List<TemplateMessageEntity> list = this.templateMessageInterface.getTempMessageListBySence(14, platformId);
        orderVO.setTemplateMessageList(list);
        return BaseJsonVo.success((Object)orderVO);
    }

    private List<String> getAvailableDate(Date date, Date endTime, List<String> list, String openTime) {
        if (date.after(endTime)) {
            return list;
        }
        list.add(DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd") + " " + openTime);
        return this.getAvailableDate(DateUtils.getAddDateByDay((Date)date, (int)1), endTime, list, openTime);
    }

    @Override
    @Transactional
    public BaseJsonVo ensureOrder(CustomerDetailVo customer, Integer orderId, String inviteId, String arriveTime, String addrId) {
        ReunionOrderEntity order = (ReunionOrderEntity)this.selectByPrimaryKey(orderId);
        if (order == null) {
            return BaseJsonVo.error((String)(orderId + "\u8ba1\u5212\u4e0d\u5b58\u5728"));
        }
        if ("1442321054454779905".equals(order.getBindCode())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u7ed3\u675f\u5566~");
        }
        BaseJsonVo canJoin = this.reunionProductInterface.activeIsCanJoin(order.getBindCode());
        if (!canJoin.isSuccess()) {
            return canJoin;
        }
        if (order.getOrderStatus() == 1 && order.getOrderSubStatus() > 11) {
            return BaseJsonVo.error((String)"\u9884\u7ea6\u5df2\u786e\u8ba4\u8bf7\u4e0d\u8981\u91cd\u590d\u786e\u8ba4!");
        }
        if (order.getOrderStatus() == 3) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u8ba1\u5212\u5df2\u5173\u95ed\uff0c\u8bf7\u5230[\u4e2a\u4eba\u4e2d\u5fc3-\u5168\u90e8\u8ba1\u5212]\u9875\u9762\u91cd\u65b0\u5f00\u542f\uff01");
        }
        if (order.getOrderStatus() == 2) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u8ba1\u5212\u5df2\u5151\u6362\u5b8c\u6210\uff0c\u65e0\u6cd5\u4fee\u6539\uff01");
        }
        ActiveInviteLogEntity activeInviteLogEntity = new ActiveInviteLogEntity();
        activeInviteLogEntity.setBindCode(order.getBindCode());
        activeInviteLogEntity.setInviteId(inviteId);
        activeInviteLogEntity.setCustomerId(customer.getCustomerId());
        activeInviteLogEntity.setCreateTime(DateUtils.now());
        activeInviteLogEntity.setFromStatus(order.getOrderStatus());
        activeInviteLogEntity.setToStatus(1);
        activeInviteLogEntity.setOrderMainNo(order.getOrderId().toString());
        activeInviteLogEntity.setMessage("\u786e\u8ba4\u9884\u7ea6\u8ba1\u5212");
        this.activeInviteLogInterface.saveInviteLog(activeInviteLogEntity);
        CustomerAddressEntity customerAddress = this.customerAddressInterface.getCustomerAddress(addrId);
        order.setOrderStatus(1);
        order.setOrderSubStatus(11);
        order.setUpdateTime(DateUtils.now());
        order.setArriveTime(arriveTime);
        order.setMobile(customerAddress.getConsigneePhone());
        order.setArriveName(customerAddress.getConsigneeName());
        order.setArriveProvince(customerAddress.getProvinceName());
        order.setArriveCity(customerAddress.getCityName());
        order.setArriveArea(customerAddress.getAreaName());
        order.setArriveAddress(customerAddress.getAddress());
        order.setArriveTime(arriveTime);
        order.setDcId("");
        order.setDcName("\u5317\u4eac\u4eac\u4e1c\u4ed3");
        order.setDcPersonName("\u5218\u7ecf\u7406");
        order.setDcMobile("18911572551");
        order.setDcProvince("\u5317\u4eac");
        order.setDcCity("\u5317\u4eac\u5e02");
        order.setDcArea("\u901a\u5dde\u533a");
        order.setDcAddress("\u878d\u5546\u4e09\u8def32\u53f7\u4eac\u4e1c\u51b7\u94fe");
        int k = this.updateByPrimaryKeySelective(order);
        if (k == 0) {
            this.logger.error("\u8ba1\u5212{}\u63d0\u4ea4\u5931\u8d25\uff0c\u4fee\u6539\u8ba1\u5212\u72b6\u60011 \u65f6\u5931\u8d25", (Object)orderId);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u63d0\u4ea4\u8ba1\u5212\u5931\u8d25\uff1a\u8bf7\u7a0d\u5019\u518d\u8bd5");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        this.logger.info("reeeeeeeeeee11,inviteId={},customer.getCustomerId()={}", (Object)inviteId, (Object)customer.getCustomerId());
        if (StringUtils.isNotEmpty((String)inviteId) && !inviteId.equals(customer.getCustomerId())) {
            this.logger.info("reeeeeeeeeee22,inviteId={},customer.getCustomerId()={}", (Object)inviteId, (Object)customer.getCustomerId());
            BaseJsonVo inviteRst = this.activeInviteInterface.setActiveInviteSuccess(inviteId, order.getBindCode(), customer);
            this.logger.info("reeeeeeeeeee22,inviteId={},bindcode={},inviteRst={},customer={}", new Object[]{inviteId, order.getBindCode(), JsonUtils.toJson((Object)customer, (boolean)false)});
            this.logger.info("reeeeeeeeeee33,inviteRst={}", (Object)JsonUtils.toJson((Object)inviteRst, (boolean)false));
            if (inviteRst.isSuccess()) {
                this.logger.info("reeeeeeeeeee44,order.getAdressType().intValue()={},inviteRst.getValue()={}", (Object)order.getAdressType(), inviteRst.getValue());
                this.logger.info("reeeeeeeeeee55,truefalse={}", (Object)(order.getAdressType() == 1 && (Integer)inviteRst.getValue() == 1 ? 1 : 0));
                this.logger.info("\u8ba2\u5355\u5730\u5740\u7c7b\u578b:{},\u662f\u5426\u8d85\u8fc7\u6700\u5927\u9080\u8bf7\u6570\u72b6\u6001:{}", (Object)order.getAdressType(), (Object)((Integer)inviteRst.getValue()));
                if (order.getAdressType() == 1 && (Integer)inviteRst.getValue() == 1) {
                    this.logger.info("reeeeeeeeeee66");
                    BaseJsonVo increaseRst = this.reunionCustomerLoveInterface.increaseByShare(inviteId, order.getBindCode(), orderId, customer.getCustomerId());
                    this.logger.info("reeeeeeeeeee77,increaseRst={}", (Object)JsonUtils.toJson((Object)increaseRst, (boolean)false));
                    if (!increaseRst.isSuccess()) {
                        this.logger.info("reeeeeeeeeee88");
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        return BaseJsonVo.error((String)"\u63d0\u4ea4\u8ba1\u5212\u5931\u8d25\uff1a\u65e0\u6cd5\u589e\u52a0\u9080\u8bf7\u4eba\u7231\u5fc3\u503c");
                    }
                    this.logger.info("reeeeeeeeeee99");
                    map.put("nickName", StringUtils.isNotEmpty((String)customer.getNickName()) ? customer.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
                    this.reunionInterface.sendInviteMessage(map, inviteId, order.getBindCode(), inviteId, customer.getPlatformId(), this.activeInviteInterface, this.reunionCustomerLoveInterface);
                }
            }
        }
        return BaseJsonVo.success((Object)"\u63d0\u4ea4\u6210\u529f");
    }

    @Override
    public BaseJsonVo ensureOrder(CustomerDetailVo customer, Integer orderId, String inviteId) {
        ReunionOrderEntity order;
        BaseJsonVo inviteRst;
        HashMap map = new HashMap();
        if (StringUtils.isNotEmpty((String)inviteId) && !inviteId.equals(customer.getCustomerId()) && (inviteRst = this.activeInviteInterface.setActiveInviteSuccess(inviteId, (order = (ReunionOrderEntity)this.selectByPrimaryKey(orderId)).getBindCode(), customer)).isSuccess()) {
            this.logger.info("\u8ba2\u5355\u5730\u5740\u7c7b\u578b:{},\u662f\u5426\u8d85\u8fc7\u6700\u5927\u9080\u8bf7\u6570\u72b6\u6001:{}", (Object)order.getAdressType(), (Object)((Integer)inviteRst.getValue()));
            if (order.getAdressType() == 1 && (Integer)inviteRst.getValue() == 1) {
                BaseJsonVo increaseRst = this.reunionCustomerLoveInterface.tempIncreaseByShare(inviteId, order.getBindCode(), orderId, customer.getCustomerId());
                if (!increaseRst.isSuccess()) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return BaseJsonVo.error((String)"\u63d0\u4ea4\u8ba1\u5212\u5931\u8d25\uff1a\u65e0\u6cd5\u589e\u52a0\u9080\u8bf7\u4eba\u7231\u5fc3\u503c");
                }
                return BaseJsonVo.success((Object)"");
            }
        }
        return BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo myOrder(Integer platformId, String customerId, String nickName, String bindCode) {
        ReunionInfoVo reunionInfoVo = this.reunionInterface.getReunionInfoVo(bindCode);
        ReunionOrderEntity order = this.getReunionOrder(bindCode, customerId);
        if (order == null) {
            return BaseJsonVo.error((String)(order.getOrderId() + "\u8ba1\u5212\u4e0d\u5b58\u5728"));
        }
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        rtnMap.put("activePeriodName", reunionInfoVo.getActivePeriodName());
        List<String> picActiveDetailBig = reunionInfoVo.getPiclist().get("picActiveList");
        rtnMap.put("picUrl", picActiveDetailBig == null || picActiveDetailBig.size() == 0 ? "" : picActiveDetailBig.get(0));
        rtnMap.put("addrNameAndPhone", order.getArriveName() + "(" + order.getMobile() + ")");
        rtnMap.put("addr", order.getArriveProvince() + order.getArriveCity() + order.getArriveArea() + order.getArriveAddress());
        rtnMap.put("DateStr", order.getArriveTime());
        rtnMap.put("recoveryCount", this.reunionOrderProductRecoveryInterface.getOrderRecoveryCount(order.getOrderId()));
        rtnMap.put("nickName", nickName);
        rtnMap.put("qrcodeUrl", this.miniQrcodeInterface.getQrcodePath(platformId, customerId, bindCode));
        return BaseJsonVo.success(rtnMap);
    }

    @Override
    public BaseJsonVo orderList(Integer type, String customerId, String nickName) {
        List<ReunionOrderEntity> list = this.reunionOrderMapper.getOrderListByType(type, customerId);
        ArrayList rtn = new ArrayList();
        list.forEach(order -> {
            HashMap<String, Object> rtnMap = new HashMap<String, Object>();
            rtnMap.put("orderId", String.valueOf(order.getOrderId()));
            ReunionInfoVo reunionInfoVo = this.reunionInterface.getReunionInfoVo(order.getBindCode());
            rtnMap.put("activePeriodName", reunionInfoVo.getActivePeriodName());
            rtnMap.put("bindCode", order.getBindCode());
            rtnMap.put("period", reunionInfoVo.getPeriod());
            switch (order.getOrderStatus()) {
                case 0: {
                    rtnMap.put("orderStatusName", "\u8ba1\u5212\u672a\u63d0\u4ea4");
                    break;
                }
                case 1: {
                    rtnMap.put("orderStatusName", "\u8ba1\u5212\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    rtnMap.put("orderStatusName", "\u8ba1\u5212\u5df2\u5b8c\u6210");
                    break;
                }
                case 3: {
                    rtnMap.put("orderStatusName", "\u8ba1\u5212\u5173\u95ed");
                    break;
                }
                default: {
                    rtnMap.put("orderStatusName", "\u72b6\u6001\u672a\u77e5");
                }
            }
            rtnMap.put("canEdit", reunionInfoVo.getReunionStatusInfoVo().isCanEdit() && (order.getOrderStatus() == 1 || order.getOrderStatus() == 0));
            rtnMap.put("orderStatus", order.getOrderStatus());
            rtnMap.put("orderSubStatus", order.getOrderSubStatus());
            List<String> picActiveDetailBig = reunionInfoVo.getPiclist().get("picActiveYingyang");
            rtnMap.put("picUrl", picActiveDetailBig == null || picActiveDetailBig.size() == 0 ? "" : picActiveDetailBig.get(0));
            rtnMap.put("siteLocation", "");
            rtnMap.put("DateStr", "");
            rtnMap.put("siteName", reunionInfoVo.getSiteName());
            rtnMap.put("TimeStr", "");
            rtnMap.put("siteAddr", "");
            rtnMap.put("addrNameAndPhone", order.getArriveName() + "(" + order.getMobile() + ")");
            rtnMap.put("addr1", order.getArriveCity() + order.getArriveArea());
            rtnMap.put("addr2", order.getArriveAddress());
            rtnMap.put("DateStr", order.getArriveTime());
            rtnMap.put("recoveryCount", this.reunionOrderProductRecoveryInterface.getOrderRecoveryCount(order.getOrderId()));
            rtnMap.put("swapCount", this.reunionOrderProductSwapInterface.getOrderSwapCount(order.getOrderId()));
            rtnMap.put("swapList", this.reunionOrderProductSwapInterface.getSwapProductsSimple(customerId, order.getBindCode()));
            rtnMap.put("prizeList", this.reunionOrderProductSwapInterface.getSwapPrizeProductsSimple(customerId, order.getBindCode()));
            rtnMap.put("nickName", nickName);
            ReunionCustomerLoveEntity customerLoveEntity = (ReunionCustomerLoveEntity)this.reunionCustomerLoveInterface.customerLove(customerId).getValue();
            rtnMap.put("customerRemainAmout", (order.getLoveRecoveryAmount() == null ? BigDecimal.ZERO : order.getLoveRecoveryAmount()).add(customerLoveEntity.getLoveShare()).add(customerLoveEntity.getLoveRemain()).subtract(order.getLoveSwapAmount() == null ? BigDecimal.ZERO : order.getLoveSwapAmount()));
            BigDecimal sum = this.reunionOrderMapper.getHistorySum(customerId);
            rtnMap.put("totalAmount", sum);
            rtn.add(rtnMap);
        });
        return BaseJsonVo.success(rtn);
    }

    @Override
    public BaseJsonVo closeOpenOrder(Integer orderId) {
        ReunionOrderEntity reunionOrderEntity = (ReunionOrderEntity)this.selectByPrimaryKey(orderId);
        String succMsg = "";
        if (reunionOrderEntity.getOrderStatus() == 2) {
            return BaseJsonVo.error((String)"\u5df2\u5b8c\u6210\u7684\u8ba1\u5212\u4e0d\u80fd\u5173\u95ed");
        }
        if (reunionOrderEntity.getOrderStatus() == 0 || reunionOrderEntity.getOrderStatus() == 1) {
            reunionOrderEntity.setOrderStatus(3);
            reunionOrderEntity.setUpdateTime(DateUtils.now());
            this.updateByPrimaryKeySelective(reunionOrderEntity);
            succMsg = "\u5173\u95ed\u6210\u529f";
        } else if (reunionOrderEntity.getOrderStatus() == 3) {
            BaseJsonVo canJoin = this.reunionProductInterface.checkCreatePlan(reunionOrderEntity.getBindCode());
            if (!canJoin.isSuccess()) {
                return canJoin;
            }
            reunionOrderEntity.setOrderStatus(0);
            reunionOrderEntity.setUpdateTime(DateUtils.now());
            this.updateByPrimaryKeySelective(reunionOrderEntity);
            succMsg = "\u5f00\u542f\u6210\u529f";
        }
        return BaseJsonVo.success((Object)succMsg);
    }

    @Override
    public ReunionOrderEntity getReunionOrder(String bindCode, String customerId) {
        ReunionOrderEntity param = new ReunionOrderEntity();
        param.setBindCode(bindCode);
        param.setCustomerId(customerId);
        List list = this.reunionOrderMapper.getList(param);
        return list.size() > 0 ? (ReunionOrderEntity)list.get(0) : null;
    }

    @Override
    public List<Map<String, Object>> getPrizes(String mobile) {
        return this.reunionOrderMapper.getPrizes(mobile);
    }

    @Override
    public BaseJsonVo paySuccess(String customerId, String bindcode) {
        ReunionOrderEntity reunionOrder = this.getReunionOrder(bindcode, customerId);
        reunionOrder.setOrderSubStatus(12);
        reunionOrder.setUpdateTime(DateUtils.now());
        this.reunionOrderMapper.updateByPrimaryKeySelective(reunionOrder);
        if (StringUtils.isNotEmpty((String)reunionOrder.getArriveTime()) && DateUtils.getDateFromString((String)reunionOrder.getArriveTime()).before(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)3600))) {
            return this.callJDExpress(customerId, bindcode);
        }
        return BaseJsonVo.success((Object)(customerId + "-" + bindcode + "\u652f\u4ed8\u6210\u529f"));
    }

    @Override
    public BaseJsonVo batchCallSFExpress() {
        List<ReunionOrderEntity> unCallOrders = this.reunionOrderMapper.getUnCallSFOrders();
        this.logger.info("\u9700\u8981\u547c\u53eb\u7684\u4eac\u4e1c\u5feb\u9012\uff1a{}", (Object)JsonUtils.toJson(unCallOrders, (boolean)false));
        unCallOrders.forEach(order -> this.callJDExpress(order.getCustomerId(), order.getBindCode()));
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo callSFExpress(String customerId, String bindcode) {
        this.logger.info("\u547c\u53eb\u5feb\u9012\u5566\uff01customerId={},bindcode={}", (Object)customerId, (Object)bindcode);
        ReunionOrderEntity reunionOrder = this.getReunionOrder(bindcode, customerId);
        Order order = new Order();
        order.setOrderId(String.valueOf(reunionOrder.getOrderId()));
        if (reunionOrder.getArriveTime().contains("\u4e00\u5c0f\u65f6\u4ee5\u5185")) {
            order.setSendStartTm(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)600));
        } else {
            order.setSendStartTm(DateUtils.getDateFromString((String)reunionOrder.getArriveTime()));
        }
        ContactInfo customerContactInfo = new ContactInfo();
        customerContactInfo.setContactType(1);
        customerContactInfo.setContact(reunionOrder.getArriveName());
        customerContactInfo.setTel(reunionOrder.getMobile());
        customerContactInfo.setCountry("86");
        customerContactInfo.setProvince(reunionOrder.getArriveProvince());
        customerContactInfo.setCity(reunionOrder.getArriveCity());
        customerContactInfo.setCounty(reunionOrder.getArriveArea());
        customerContactInfo.setAddress(reunionOrder.getArriveAddress());
        ContactInfo dcContactInfo = new ContactInfo();
        dcContactInfo.setContactType(2);
        dcContactInfo.setContact(reunionOrder.getDcPersonName());
        dcContactInfo.setTel(reunionOrder.getDcMobile());
        dcContactInfo.setCountry("86");
        dcContactInfo.setProvince(reunionOrder.getDcProvince());
        dcContactInfo.setCity(reunionOrder.getDcCity());
        dcContactInfo.setCounty(reunionOrder.getDcArea());
        dcContactInfo.setAddress(reunionOrder.getDcAddress());
        ArrayList<ContactInfo> contactInfos = new ArrayList<ContactInfo>();
        contactInfos.add(customerContactInfo);
        contactInfos.add(dcContactInfo);
        order.setContactInfoList(contactInfos);
        CargoDetail cargoDetail = new CargoDetail();
        ArrayList<CargoDetail> cargoDetails = new ArrayList<CargoDetail>();
        cargoDetails.add(cargoDetail);
        order.setCargoDetails(cargoDetails);
        BaseJsonVo b = this.shunFenUtils.produce(order);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("mobile", reunionOrder.getMobile());
        if (!b.isSuccess()) {
            this.messageInterface.sendWechatMessage("REUNION_CALLSF_RESULT_FAIL", customerId, variableMap);
            this.logger.error("\u56de\u6536\u8ba1\u5212" + customerId + "\u53eb\u5feb\u9012\u5931\u8d25\uff1a" + b.getMessage());
        } else {
            reunionOrder.setWayNo((String)b.getValue());
            reunionOrder.setOrderSubStatus(13);
            reunionOrder.setUpdateTime(DateUtils.now());
            this.reunionOrderMapper.updateByPrimaryKeySelective(reunionOrder);
            this.messageInterface.sendWechatMessage("REUNION_CALLSF_RESULT_SUCCESS", customerId, variableMap);
            this.logger.error("\u56de\u6536\u8ba1\u5212" + customerId + "\u53eb\u5feb\u9012\u6210\u529f\uff1a" + b.getMessage());
        }
        return b;
    }

    @Override
    public BaseJsonVo callJDExpress(String customerId, String bindcode) {
        this.logger.info("\u547c\u53eb\u4eac\u4e1c\u5feb\u9012\u5566\uff01customerId={},bindcode={}");
        if (StringUtils.isEmpty((String)customerId) || StringUtils.isEmpty((String)bindcode)) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReunionOrderEntity reunionOrder = this.getReunionOrder(bindcode, customerId);
        BaseJsonVo b = BaseJsonVo.error();
        try {
            Date arriveTime = null;
            arriveTime = reunionOrder.getArriveTime().contains("\u4e00\u5c0f\u65f6\u4ee5\u5185") ? DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)600) : DateUtils.getDateFromString((String)reunionOrder.getArriveTime());
            arriveTime = DateUtils.getAddDateBySecond((Date)new Date(), (int)1800);
            String sender = reunionOrder.getArriveProvince() + reunionOrder.getArriveCity() + reunionOrder.getArriveArea() + reunionOrder.getArriveAddress();
            List<Map<String, Object>> body = this.jdUtils.buildBody(String.valueOf(reunionOrder.getOrderId()), "", reunionOrder.getArriveName(), reunionOrder.getMobile(), sender, arriveTime, DateUtils.getAddDateBySecond((Date)arriveTime, (int)60));
            b = this.jdUtils.produce(JsonUtils.toJson(body, (boolean)false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("mobile", reunionOrder.getMobile());
        if (!b.isSuccess()) {
            reunionOrder.setWayNo(b.getMessage());
            this.reunionOrderMapper.updateByPrimaryKeySelective(reunionOrder);
            this.messageInterface.sendWechatMessage("REUNION_CALLSF_RESULT_FAIL", customerId, variableMap);
            this.logger.error("\u56de\u6536\u8ba1\u5212" + customerId + "\u53eb\u5feb\u9012\u5931\u8d25\uff1a" + b.getMessage());
        } else {
            reunionOrder.setWayNo((String)b.getValue());
            reunionOrder.setOrderSubStatus(13);
            reunionOrder.setUpdateTime(DateUtils.now());
            this.reunionOrderMapper.updateByPrimaryKeySelective(reunionOrder);
            this.messageInterface.sendWechatMessage("REUNION_CALLSF_RESULT_SUCCESS", customerId, variableMap);
            this.logger.error("\u56de\u6536\u8ba1\u5212" + customerId + "\u53eb\u5feb\u9012\u6210\u529f\uff1a" + b.getMessage());
        }
        return b;
    }

    @Override
    public BaseJsonVo cancleJDExpress(String waybillCode) {
        try {
            if (StringUtils.isEmpty((String)waybillCode)) {
                return BaseJsonVo.error((String)"\u7269\u6d41\u5355\u53f7\u5fc5\u4f20");
            }
            return this.jdUtils.cancle(waybillCode);
        }
        catch (Exception e) {
            this.logger.error("\u53d6\u6d88\u5feb\u9012\u5f02\u5e38", (Throwable)e);
            return BaseJsonVo.error((String)("\u53d6\u6d88\u5feb\u9012\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    @Override
    public BaseJsonVo getReunionOrderByMobileOrBillwayNo(String mobileOrBillwayNo) {
        ReunionOrderEntity reunionOrder = this.reunionOrderMapper.getReunionOrderByMobileOrBillwayNo(mobileOrBillwayNo);
        if (reunionOrder == null) {
            return BaseJsonVo.error((String)"\u624b\u673a\u53f7\u6216\u7269\u6d41\u5355\u53f7\u9519\u8bef\uff0c\u6ca1\u6709\u67e5\u5230\u7528\u6237\u8ba1\u5212");
        }
        return BaseJsonVo.success((Object)reunionOrder.getOrderId());
    }

    @Override
    public BaseJsonVo syncCallSFResult() {
        return BaseJsonVo.error((String)"\u540c\u6b65\u56de\u6536\u8282\u5feb\u9012\u4fe1\u606f\u6682\u4e0d\u53ef\u7528");
    }

    @Override
    public BaseJsonVo modifyReunionOrderArriveTime(Integer orderId, String selectTime) {
        ReunionOrderEntity reunionOrderEntity = (ReunionOrderEntity)this.reunionOrderMapper.selectByPrimaryKey(orderId);
        if (reunionOrderEntity == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        reunionOrderEntity.setArriveTime(selectTime);
        this.reunionOrderMapper.updateByPrimaryKeySelective(reunionOrderEntity);
        return BaseJsonVo.success((String)"\u4fdd\u5b58\u6210\u529f", null);
    }

    private /* synthetic */ void lambda$syncCallSFResult$3(Boolean[] bs, ReunionOrderEntity order) {
        Boolean[] b = new Boolean[]{false};
        try {
            List<Route> trace = this.shunFenUtils.trace(order.getWayNo(), order.getMobile());
            trace.forEach(route -> {
                if ("50".equals(route.getOpcode())) {
                    b[0] = true;
                    return;
                }
            });
            if (b[0].booleanValue()) {
                String inviteId = order.getInviteId();
                HashMap<String, String> map = new HashMap<String, String>();
                this.logger.info("reeeeeeeeeee11,inviteId={},customer.getCustomerId()={}", (Object)inviteId, (Object)order.getCustomerId());
                if (StringUtils.isNotEmpty((String)inviteId) && !inviteId.equals(order.getCustomerId())) {
                    this.logger.info("reeeeeeeeeee22,inviteId={},customer.getCustomerId()={}", (Object)inviteId, (Object)order.getCustomerId());
                    BaseJsonVo inviteRst = this.activeInviteInterface.setActiveInviteSuccessByCustomerId(inviteId, order.getBindCode(), order.getCustomerId());
                    this.logger.info("reeeeeeeeeee22,inviteId={},bindcode={},inviteRst={},customerId={}", new Object[]{inviteId, order.getBindCode(), order.getCustomerId()});
                    this.logger.info("reeeeeeeeeee33,inviteRst={}", (Object)JsonUtils.toJson((Object)inviteRst, (boolean)false));
                    if (inviteRst.isSuccess()) {
                        this.logger.info("reeeeeeeeeee44,order.getAdressType().intValue()={},inviteRst.getValue()={}", (Object)order.getAdressType(), inviteRst.getValue());
                        this.logger.info("reeeeeeeeeee55,truefalse={}", (Object)(order.getAdressType() == 1 && (Integer)inviteRst.getValue() == 1 ? 1 : 0));
                        this.logger.info("\u8ba2\u5355\u5730\u5740\u7c7b\u578b:{},\u662f\u5426\u8d85\u8fc7\u6700\u5927\u9080\u8bf7\u6570\u72b6\u6001:{}", (Object)order.getAdressType(), (Object)((Integer)inviteRst.getValue()));
                        if (order.getAdressType() == 1 && (Integer)inviteRst.getValue() == 1) {
                            this.logger.info("reeeeeeeeeee66");
                            BaseJsonVo increaseRst = this.reunionCustomerLoveInterface.increaseByShare(inviteId, order.getBindCode(), order.getOrderId(), order.getCustomerId());
                            this.logger.info("reeeeeeeeeee77,increaseRst={}", (Object)JsonUtils.toJson((Object)increaseRst, (boolean)false));
                            if (!increaseRst.isSuccess()) {
                                this.logger.info("reeeeeeeeeee88");
                                bs[0] = false;
                                return;
                            }
                            this.logger.info("reeeeeeeeeee99");
                            CustomerEntity customer = this.customerInterface.getCustomer(order.getCustomerId());
                            map.put("nickName", StringUtils.isNotEmpty((String)customer.getNickName()) ? customer.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
                            this.reunionInterface.sendInviteMessage(map, inviteId, order.getBindCode(), inviteId, PlatFormEnum.LECHUN_MINI.getValue(), this.activeInviteInterface, this.reunionCustomerLoveInterface);
                        }
                    }
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("\u56de\u6536\u6d3b\u52a8\u83b7\u53d6\u987a\u4e30\u5feb\u9012\u7269\u6d41\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            bs[0] = false;
            return;
        }
        if (bs[0].booleanValue()) {
            order.setSyncSfCount(order.getSyncSfCount() + 1);
            this.reunionOrderMapper.updateByPrimaryKeySelective(order);
        }
    }
}

