/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.dao.sales.MallProductPicMapper;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import com.alibaba.fastjson.JSON;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallProductPicService
implements MallProductPicInterface {
    private static final Logger logger = LoggerFactory.getLogger(MallProductPicService.class);
    @Autowired
    private MallProductPicMapper productPicMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private OssService ossInterface;

    @Override
    @ReadThroughSingleCache(namespace="getProductPic", expiration=300)
    public List<MallProductPicEntity> getProductPics(@ParameterValueKeyProvider(order=0) String proId, @ParameterValueKeyProvider(order=1) Integer picType) {
        MallProductPicEntity params = new MallProductPicEntity();
        params.setProId(proId);
        params.setGroupType(picType);
        List<MallProductPicEntity> list = this.productPicMapper.getListBySort(params);
        list.forEach(entity -> entity.setFullRelativeUrl(this.ossInterface.getImageResoure(entity.getFullRelativeUrl())));
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="getImageList", expiration=600)
    public List<String> getProductPicUrl(@ParameterValueKeyProvider(order=0) String itemId, @ParameterValueKeyProvider(order=1) Integer picType) {
        String path = "proImgStorage/";
        MallProductPicEntity picEntity = new MallProductPicEntity();
        picEntity.setProId(itemId);
        picEntity.setGroupType(picType);
        List picEntities = this.productPicMapper.getList(picEntity);
        if (picEntities != null && picEntities.size() > 0) {
            String url = "";
            for (MallProductPicEntity p : picEntities) {
                url = p.getFullRelativeUrl();
                if (url != null && !url.isEmpty()) continue;
                p.setFullRelativeUrl(path + p.getPicAddr() + "_O." + p.getExpName());
            }
            return picEntities.stream().map(c -> this.ossInterface.getImageResoure(c.getFullRelativeUrl())).collect(Collectors.toList());
        }
        ArrayList<String> n = new ArrayList<String>();
        n.add("");
        return n;
    }

    @Override
    public List<MallProductPicEntity> getPicList(String itemId) {
        String path = "proImgStorage/";
        MallProductPicEntity picEntity = new MallProductPicEntity();
        picEntity.setProId(itemId);
        List list = this.productPicMapper.getList(picEntity);
        String url = "";
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (MallProductPicEntity p : list) {
                url = p.getFullRelativeUrl();
                if (url != null && !url.isEmpty()) continue;
                p.setFullRelativeUrl(path + p.getPicAddr() + "_O." + p.getExpName());
            }
        }
        return list;
    }

    @Override
    public List<MallProductPicEntity> getProductPics(String proId, int picType, int sort) {
        MallProductPicEntity params = new MallProductPicEntity();
        params.setProId(proId);
        params.setGroupType(picType);
        params.setSort(sort);
        List list = this.productPicMapper.getList(params);
        list.forEach(entity -> entity.setFullRelativeUrl(this.ossInterface.getImageResoure(entity.getFullRelativeUrl())));
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallProductPicService.getProductPics", expiration=240)
    public Map<String, List<String>> getProductPicUrlMap(@ParameterValueKeyProvider(order=0) String itemId, @ParameterValueKeyProvider(order=1) Integer saleType) {
        String path = "proImgStorage/";
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List<MallProductPicEntity> picEntities = this.getPicList(itemId);
        List<ProductPicTypeEnum> picTypeEnums = ProductPicTypeEnum.getList(saleType);
        picTypeEnums.forEach(c -> {
            String url = "";
            if (picEntities != null && picEntities.size() > 0) {
                List tmpPics = picEntities.stream().filter(p -> p.getGroupType().intValue() == c.getValue()).collect(Collectors.toList());
                if (tmpPics != null && tmpPics.size() > 0) {
                    for (MallProductPicEntity p2 : tmpPics) {
                        url = p2.getFullRelativeUrl();
                        if (url != null && !url.isEmpty()) continue;
                        p2.setFullRelativeUrl(path + p2.getPicAddr() + "_O." + p2.getExpName());
                    }
                    map.put(c.getName(), tmpPics.stream().map(cc -> this.ossInterface.getImageResoure(cc.getFullRelativeUrl())).collect(Collectors.toList()));
                } else {
                    ArrayList<String> n = new ArrayList<String>();
                    n.add("");
                    map.put(c.getName(), n);
                }
            } else {
                ArrayList<String> n = new ArrayList<String>();
                n.add("");
                map.put(c.getName(), n);
            }
        });
        return map;
    }

    private void removeCache(String itemId, int picType) {
        this.memcachedService.delete("getProductPic", new String[]{itemId, String.valueOf(picType)});
        this.memcachedService.delete("getImageList", new String[]{itemId, String.valueOf(picType)});
        this.memcachedService.delete("MallProductPicService.getPicList", itemId);
        this.memcachedService.delete("MallProductPicService.getProductPics", new String[]{itemId, String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue())});
        this.memcachedService.delete("MallProductPicService.getProductPics", new String[]{itemId, String.valueOf(SalesTypeEnum.SALES_GROUP.getValue())});
        this.memcachedService.delete("MallProductPicService.getProductPics", new String[]{itemId, String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue())});
        this.memcachedService.delete("MallProductPicService.getProductPics", new String[]{itemId, String.valueOf(SalesTypeEnum.SALES_ACTIVE.getValue())});
        this.memcachedService.delete("MallProductPicService.getProductPics", new String[]{itemId, "6"});
    }

    @Override
    public LinkedHashMap<String, String> getProductPic(String productId, LinkedHashMap<String, String> productPicList, int picType) {
        return this.getProductPic(productId, productPicList, picType, false);
    }

    public LinkedHashMap<String, String> getProductPic(String productId, LinkedHashMap<String, String> productPicList, int picType, Boolean human) {
        String path = "proImgStorage/";
        List<Object> productPicEntityList = new ArrayList();
        String[] picArr = new String[]{"", "picHead", "picList", "picYingyang", "picLongPeriod", "picSmall", "picDetailBig", "suggest"};
        productPicEntityList = this.productPicMapper.getProPicByProId(productId);
        if (picType != 0) {
            productPicEntityList = this.productPicMapper.getProPicByProIdType(productId, picType);
        }
        if (human.booleanValue()) {
            if (picType == 0) {
                for (int i = 1; i < picArr.length; ++i) {
                    productPicList.put(picArr[i], "");
                }
            } else {
                productPicList.put(picArr[picType], "");
            }
        }
        if (productPicEntityList != null && productPicEntityList.size() > 0) {
            for (MallProductPicEntity mallProductPicEntity : productPicEntityList) {
                String picStr = StringUtils.isNotEmpty((String)mallProductPicEntity.getFullRelativeUrl()) ? mallProductPicEntity.getFullRelativeUrl() : path + mallProductPicEntity.getPicAddr() + "_O." + mallProductPicEntity.getExpName();
                picStr = this.ossInterface.getImageResoure(picStr);
                if (human.booleanValue() && mallProductPicEntity.getPicType() < picArr.length) {
                    if (productPicList.size() <= 0 || !productPicList.get(picArr[mallProductPicEntity.getPicType()]).isEmpty()) continue;
                    productPicList.put(picArr[mallProductPicEntity.getPicType()], picStr);
                    continue;
                }
                logger.info("mallProductPicEntity={},productPicList={}", (Object)JSON.toJSONString((Object)mallProductPicEntity), (Object)JSON.toJSONString(productPicList));
                if (productPicList.size() != 0 && productPicList.get("PIC_ADDR" + mallProductPicEntity.getPicType()) != null) continue;
                productPicList.put("PIC_ADDR" + mallProductPicEntity.getPicType(), picStr);
            }
        }
        return productPicList;
    }

    @Override
    public List<String> getProPicInfo(String proId, int picType) {
        ArrayList<String> list = new ArrayList<String>();
        List<MallProductPicEntity> productPicEntityList = this.productPicMapper.getProPicInfo(proId, picType);
        if (productPicEntityList != null && productPicEntityList.size() > 0) {
            for (MallProductPicEntity mallProductPicEntity : productPicEntityList) {
                String picStr = mallProductPicEntity.getFullRelativeUrl();
                if (StringUtils.isNotEmpty((String)picStr)) {
                    picStr = this.ossInterface.getImageResoure(picStr);
                }
                list.add(picStr);
            }
        }
        return list;
    }
}

