/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.sales.MallProductSalesMapper;
import cc.lechun.mall.dao.sales.WarehouseAreaMapper;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductSalesEntityVo;
import cc.lechun.mall.entity.sales.WarehouseAreaEntity;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductSalesInterface;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallProductSalesService
implements MallProductSalesInterface {
    private static final Logger logger = LoggerFactory.getLogger(MallProductSalesService.class);
    @Autowired
    private MallProductSalesMapper mallProductSalesMapper;
    @Autowired
    private WarehouseAreaMapper warehouseAreaMapper;
    @Autowired
    private MallProductInterface mallProductInterface;

    @Override
    public List<MallProductSalesEntityVo> getProductSalesList(MallProductSalesEntityVo mallProductSalesEntityVo) {
        List<MallProductSalesEntityVo> mallProductSalesEntityList = this.mallProductSalesMapper.getProductSalesList(mallProductSalesEntityVo);
        return mallProductSalesEntityList;
    }

    @Override
    public BaseJsonVo checkSalesNum(Map<String, Integer> prodIdSalesNumMap, Integer cityId) {
        logger.info("=======\u6821\u9a8c\u63a5\u53e3checkSalesNum\u4f20\u5165\u53c2\u6570===========prodIdSalesNumMap={},cityId={}", (Object)JSON.toJSONString(prodIdSalesNumMap), (Object)cityId);
        Set<String> proIdList = prodIdSalesNumMap.keySet();
        for (String proId : proIdList) {
            MallProductEntity mallProductEntity = this.mallProductInterface.getProduct(proId);
            if (mallProductEntity != null) {
                Integer salesNumMath;
                int salesNumInt;
                WarehouseAreaEntity warehouseAreaEntity = this.warehouseAreaMapper.getWareHouseByCityId(cityId, mallProductEntity.getTransportType());
                logger.info("=======\u6821\u9a8c\u63a5\u53e3checkSalesNum\u83b7\u53d6\u57ce\u5e02\u5bf9\u5e94\u4ed3\u5e93==========warehouseAreaEntity={}", (Object)JSON.toJSONString((Object)warehouseAreaEntity));
                if (warehouseAreaEntity == null) {
                    logger.info("=======\u6821\u9a8c\u63a5\u53e3checkSalesNum\u83b7\u53d6\u57ce\u5e02\u5bf9\u5e94\u4ed3\u5e93\u4e3a\u7a7anull\u4e3a\u7a7anull\u4e3a\u7a7anull==========warehouseAreaEntity={}", (Object)JSON.toJSONString((Object)warehouseAreaEntity));
                    return BaseJsonVo.error((String)"\u5e93\u5b58\u4e0d\u8db3");
                }
                Integer salesNum = Integer.valueOf(prodIdSalesNumMap.get(proId).toString());
                MallProductSalesEntityVo mallProductSalesEntityVo = this.mallProductSalesMapper.getProductSalesNum(proId, warehouseAreaEntity.getWarehouseId());
                if (mallProductSalesEntityVo == null) continue;
                int n = salesNumInt = mallProductSalesEntityVo.getSalesNum() == null ? 0 : mallProductSalesEntityVo.getSalesNum();
                if (salesNum >= 0 || (salesNumMath = Integer.valueOf(Math.abs(salesNum))).compareTo(salesNumInt) <= 0) continue;
                logger.info("============\u6821\u9a8c\u5931\u8d25\u5e93\u5b58\u4e0d\u8db3===========proId={},proName={}", (Object)proId, (Object)mallProductSalesEntityVo.getProName());
                return BaseJsonVo.error((String)(mallProductSalesEntityVo.getProName() + " \u5e93\u5b58\u4e0d\u8db3"));
            }
            logger.info("============\u6821\u9a8c\u5931\u8d25\u4ea7\u54c1\u4e0d\u5b58\u5728==========");
            return BaseJsonVo.error((String)"\u65e0\u4ea7\u54c1\u4fe1\u606f");
        }
        return BaseJsonVo.success((Object)"\u6821\u9a8c\u901a\u8fc7");
    }
}

