/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallPromotionBuyMapper;
import cc.lechun.mall.entity.sales.MallPromotionBuyEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionTimeEntity;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionTimeInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallPromotionBuyService
extends BaseService
implements MallPromotionBuyInterface {
    @Autowired
    private MallPromotionBuyMapper promotionBuyMapper;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private MallPromotionTimeInterface promotionTimeInterface;
    @Autowired
    private MallPromotionBuyInterface promotionBuyInterface;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public int getPromotionBuyCount(@ParameterValueKeyProvider(order=0) String promotionId, @ParameterValueKeyProvider(order=1) Date beginTime, @ParameterValueKeyProvider(order=2) Date endTime) {
        String cachekey = "MallPromotionBuyService.getPromotionBuyCount." + promotionId + beginTime.getTime() + endTime.getTime();
        Object o = this.memcachedService.get(cachekey);
        if (o != null) {
            return (Integer)o;
        }
        Integer count = this.promotionBuyMapper.getPromotionBuyCount(promotionId, beginTime, endTime);
        if (count == null) {
            count = 0;
        }
        this.memcachedService.set(cachekey, (Object)count);
        return count;
    }

    @Override
    public int insertSelectiveEntity(MallPromotionEntity mallPromotionEntity, MallPromotionTimeEntity promotionTimeEntity, MallPromotionBuyEntity promotionBuyEntity) {
        Date beginTime = promotionTimeEntity.getBeginTime();
        Date endTime = promotionTimeEntity.getEndTime();
        if (mallPromotionEntity.getPromotionType() == 2) {
            beginTime = DateUtils.currentDate();
            endTime = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
        }
        this.promotionBuyInterface.clearPromotionBuyCache(promotionBuyEntity.getPromotionId(), beginTime, endTime);
        return this.promotionBuyMapper.insertSelective(promotionBuyEntity);
    }

    @Override
    public void clearPromotionBuyCache(String promotionId, Date beginTime, Date endTime) {
        String cachekey = "MallPromotionBuyService.getPromotionBuyCount." + promotionId + beginTime.getTime() + endTime.getTime();
        this.memcachedService.delete(cachekey);
    }

    @Override
    public int insertPromotionBuyBatch(List<MallPromotionBuyEntity> mallPromotionBuyEntityList) {
        return this.promotionBuyMapper.insertPromotionBuyBatch(mallPromotionBuyEntityList);
    }
}

