/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallPromotionProductMapper;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallPromotionProductService
extends BaseService
implements MallPromotionProductInterface {
    @Autowired
    private MallPromotionProductMapper promotionProductMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public MallPromotionProductEntity getPromotionProduct(String promotionId, String itemId) {
        MallPromotionProductEntity promotionProductEntity = new MallPromotionProductEntity();
        promotionProductEntity.setPromotionId(promotionId);
        promotionProductEntity.setProductId(itemId);
        promotionProductEntity = (MallPromotionProductEntity)this.promotionProductMapper.getSingle(promotionProductEntity);
        return promotionProductEntity;
    }

    @Override
    @ReadThroughSingleCache(namespace="promotionProductEntity1", expiration=3600)
    public MallPromotionProductEntity getPromotionProductEntity(@ParameterValueKeyProvider String promotionId) {
        return this.promotionProductMapper.getPromotionProducts(promotionId);
    }

    @Override
    @ReadThroughSingleCache(namespace="promotionProductEntity", expiration=3600)
    public MallPromotionProductEntity getPromotionProduct(@ParameterValueKeyProvider String promotionProductId) {
        return (MallPromotionProductEntity)this.promotionProductMapper.selectByPrimaryKey((Serializable)((Object)promotionProductId));
    }

    @Override
    public void removeCache(String promotionId) {
        MallPromotionProductEntity entity = this.promotionProductMapper.getPromotionProducts(promotionId);
        if (entity != null) {
            this.memcachedService.delete("promotionProductEntity", entity.getPromotionProductId());
        }
        this.memcachedService.delete("promotionProductEntity1", promotionId);
    }
}

