/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallPromotionMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardItemEntity;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallIndexPromotionVo;
import cc.lechun.mall.entity.sales.MallPriceVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionBuyEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionTimeEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallSaleRecommendEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionTimeInterface;
import cc.lechun.mall.iservice.sales.MallSaleRecommendInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MallPromotionService
extends BaseService
implements MallPromotionInterface {
    @Autowired
    ActiveInterface activeInterface;
    @Autowired
    MallPromotionMapper promotionMapper;
    @Autowired
    MallProductInterface productService;
    @Autowired
    MallGroupInterface groupService;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    MallVipInterface vipInterface;
    @Autowired
    MallPromotionBuyInterface promotionBuyInterface;
    @Autowired
    MallPromotionProductInterface promotionProductInterface;
    @Autowired
    MallSaleRecommendInterface saleRecommendInterface;
    @Autowired
    MallPriceCalcInterface priceCalcInterface;
    @Autowired
    MallPromotionTimeInterface promotionTimeService;
    @Autowired
    MemcachedService memcachedService;
    @Autowired
    @Lazy
    MallOrderProductInterface mallOrderProductInterface;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;

    @Override
    public void setProductPoint(MallPromotionVO promotionVO, List<PrepayCardItemEntity> pointProductList) {
        Optional<PrepayCardItemEntity> prepayCardItemEntityOption = pointProductList.stream().filter(pointProduct -> Objects.equals(pointProduct.getItemId(), promotionVO.getPromotionId()) && Objects.equals(SalesTypeEnum.SALES_PROMOTION.getValue(), (int)pointProduct.getItemType())).findFirst();
        if (prepayCardItemEntityOption.isPresent()) {
            promotionVO.setCardFactPrice(prepayCardItemEntityOption.get().getSaleValue());
            promotionVO.setCardOriginPrice(prepayCardItemEntityOption.get().getOriginPrice());
            promotionVO.setPointCardDiffPointPrice(PriceUtils.subtract((BigDecimal)promotionVO.getCardOriginPrice(), (BigDecimal)promotionVO.getCardFactPrice()));
            this.logger.info("\u4fc3\u9500:{},\u5976\u5361\u91d1\u989d:{},\u539f\u4ef7:{},\u4fc3\u9500\u4ef7\u683c:{}", new Object[]{promotionVO.getPromotionName(), promotionVO.getCardFactPrice(), promotionVO.getOriginPrice(), promotionVO.getPromotionPrice()});
        }
    }

    @Override
    public BaseJsonVo<MallPromotionVO> buildPromotionVO(List<PrepayCardBatchEntity> cardBatchEntityList) {
        for (PrepayCardBatchEntity cardBatchEntity : cardBatchEntityList) {
            BaseJsonVo baseJsonVo = this.promotionInterface.buildPromotionVO(cardBatchEntity.getCardPromotionId(), 1, true);
            if (!baseJsonVo.isSuccess()) continue;
            ((MallPromotionVO)baseJsonVo.getValue()).setBatchId(cardBatchEntity.getBatchId());
            return baseJsonVo;
        }
        return BaseJsonVo.error((String)"\u672a\u5339\u914d\u5230\u53ef\u7528\u7684\u4fc3\u9500");
    }

    @Override
    @ReadThroughSingleCache(namespace="MallPromotionService.getPromotionDeliveryType", expiration=600)
    public int getPromotionDeliveryType(@ParameterValueKeyProvider String promotionId) {
        MallPromotionProductEntity promotionProduct = this.promotionProductInterface.getPromotionProductEntity(promotionId);
        MallProductEntity productEntity = null;
        if (promotionProduct != null) {
            if (promotionProduct.getProductType().equals("2")) {
                List<MallGroupProductEntity> list = this.groupService.getGroupProducts(promotionProduct.getProductId());
                for (int i = 0; i < list.size(); ++i) {
                    productEntity = this.productService.getProduct(list.get(i).getProId());
                    if (productEntity == null) {
                        this.logger.info("\u4fc3\u9500{}\u5546\u54c1id{}\u4e0d\u5b58\u5728,promotionId:{}", (Object)promotionId, (Object)list.get(i).getProId());
                        continue;
                    }
                    if (productEntity.getTransportType() != 2 && productEntity.getTransportType() != 3) continue;
                    return productEntity.getTransportType();
                }
                return 1;
            }
            if (promotionProduct.getProductType().equals("4")) {
                productEntity = this.productService.getProduct(promotionProduct.getProductId());
                if (productEntity == null) {
                    this.logger.info("\u4fc3\u9500\u4e0d\u5b58\u5728,promotionId:" + promotionId);
                }
                return productEntity.getTransportType();
            }
        } else {
            this.logger.error("\u4fc3\u9500{}\u672a\u5173\u8054\u5546\u54c1", (Object)promotionId);
            return 0;
        }
        return 1;
    }

    @Override
    @ReadThroughSingleCache(namespace="promotionEntity", expiration=300)
    public MallPromotionEntity getPromotion(@ParameterValueKeyProvider String promotionId) {
        return (MallPromotionEntity)this.promotionMapper.selectByPrimaryKey((Serializable)((Object)promotionId));
    }

    private void removeCache(String promotionId) {
        this.memcachedService.delete("promotionEntity", promotionId);
    }

    @Override
    public List<MallPromotionVO> getCurrentPromotionList(Integer platformGroupId, boolean check) {
        ArrayList<MallPromotionVO> vos = new ArrayList<MallPromotionVO>();
        List<MallPromotionEntity> promotionEntities = this.promotionMapper.findCurrentPromotions(platformGroupId);
        if (check) {
            promotionEntities.forEach(promotionEntity -> {
                BaseJsonVo<MallPromotionVO> sr = this.buildPromotionVO(promotionEntity.getPromotionId(), 1, check);
                if (sr.isSuccess()) {
                    vos.add((MallPromotionVO)sr.getValue());
                }
            });
        } else {
            for (MallPromotionEntity promotionEntity2 : promotionEntities) {
                MallPromotionVO promotionVO = new MallPromotionVO();
                promotionVO.setPromotionName(promotionEntity2.getPromotionName());
                promotionVO.setPromotionId(promotionEntity2.getPromotionId());
                vos.add(promotionVO);
            }
        }
        return vos;
    }

    @ReadThroughSingleCache(namespace="MallPromotionService.buildPromotionVO", expiration=120)
    public BaseJsonVo<MallPromotionVO> buildPromotionVO(@ParameterValueKeyProvider(order=0) String promotionId, @ParameterValueKeyProvider(order=1) Integer quantity, @ParameterValueKeyProvider(order=2) Boolean checked) {
        BaseJsonVo sr = BaseJsonVo.success((Object)"");
        MallPromotionVO vo = new MallPromotionVO();
        MallPromotionEntity entity = this.promotionInterface.getPromotion(promotionId);
        if (entity == null) {
            sr.setError("\u4fc3\u9500\u4e0d\u5b58\u5728");
            vo.setValid(false);
            vo.setInvalidReason(sr.getError_msg());
            vo.setShoppingcartCheck(false);
            sr.setValue((Object)vo);
            return sr;
        }
        try {
            ObjectConvert.fatherConvertToChild((Object)entity, (Object)vo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            sr.setError("\u5546\u54c1\u4fe1\u606f\u9519\u8bef");
            return sr;
        }
        vo.setCount(quantity);
        vo.setQuantity(quantity);
        vo.setShort(false);
        vo.setSoldOut(false);
        vo.setPromotionId(promotionId);
        vo.setShoppingcartCheck(checked);
        MallPromotionProductEntity promotionProduct = this.promotionProductInterface.getPromotionProductEntity(promotionId);
        if (promotionProduct == null) {
            sr.setError("\u4fc3\u9500\u672a\u5173\u8054\u5546\u54c1");
            vo.setValid(false);
            vo.setInvalidReason(sr.getError_msg());
            vo.setShoppingcartCheck(false);
            sr.setValue((Object)vo);
            return sr;
        }
        vo.setProductType(promotionProduct.getProductType());
        vo.setOriginPrice(promotionProduct.getOriginPrice());
        vo.setPromotionPrice(promotionProduct.getPromotionPrice());
        vo.setLimitCount(entity.getUserLimitCount() == null || entity.getUserLimitCount() == 0 ? promotionProduct.getLimitCount() : entity.getUserLimitCount());
        vo.setPromotionProductId(promotionProduct.getPromotionProductId());
        vo.setPromotionPic(this.picService.getProductPicUrlMap(promotionProduct.getPromotionId(), SalesTypeEnum.SALES_PROMOTION.getValue()));
        if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(promotionProduct.getProductType()).intValue()) {
            BaseJsonVo<MallProductVO> buildProductVOsr = this.productService.buildProductVO(promotionProduct.getProductId(), quantity, null, promotionId, null, null, false, checked, null, null);
            if (buildProductVOsr.isSuccess()) {
                MallProductVO productVO = (MallProductVO)buildProductVOsr.getValue();
                vo.setPromotionUnit(StringUtils.isNotEmpty((String)productVO.getProDw()) ? productVO.getProDw() : "");
                if (productVO.getValid().booleanValue()) {
                    vo.setProduct((MallProductVO)buildProductVOsr.getValue());
                    vo.setProSummary(productVO.getProSummary());
                } else {
                    vo.setValid(false);
                    vo.setInvalidReason(productVO.getInvalidReason());
                    vo.setShoppingcartCheck(false);
                }
            } else {
                vo.setValid(false);
                vo.setInvalidReason(buildProductVOsr.getError_msg());
                vo.setShoppingcartCheck(false);
            }
        } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(promotionProduct.getProductType()).intValue()) {
            BaseJsonVo buildGroupVOsr = this.groupService.buildGroupVO(promotionProduct.getProductId(), quantity, promotionId, checked);
            if (buildGroupVOsr.isSuccess()) {
                MallGroupVO groupVO = (MallGroupVO)buildGroupVOsr.getValue();
                vo.setPromotionUnit(StringUtils.isNotEmpty((String)groupVO.getGroupUnit()) ? groupVO.getGroupUnit() : "");
                if (groupVO.getValid().booleanValue()) {
                    vo.setGroup((MallGroupVO)buildGroupVOsr.getValue());
                    vo.setProSummary(((MallGroupVO)buildGroupVOsr.getValue()).getSummary());
                } else {
                    vo.setGroup((MallGroupVO)buildGroupVOsr.getValue());
                    vo.setValid(false);
                    vo.setInvalidReason(groupVO.getInvalidReason());
                    vo.setShoppingcartCheck(false);
                }
            } else {
                vo.setValid(false);
                vo.setInvalidReason(buildGroupVOsr.getError_msg());
                vo.setShoppingcartCheck(false);
            }
        }
        if (!vo.getValid().booleanValue()) {
            sr.setValue((Object)vo);
            return sr;
        }
        ArrayList<MallPromotionVO> tmpVos = new ArrayList<MallPromotionVO>();
        tmpVos.add(0, vo);
        vo.setSelfModeType(this.productService.getPromotionSelfMode(tmpVos));
        BaseJsonVo checkResult = this.checkPromotion(vo);
        if (checkResult.isSuccess()) {
            vo.setValid(true);
        } else {
            vo.setValid(false);
            vo.setInvalidReason(checkResult.getMessage());
            vo.setShoppingcartCheck(false);
        }
        sr.setValue((Object)vo);
        return sr;
    }

    @Override
    public void setCardPoint(MallPromotionVO promotionVO, List<PrepayCardItemEntity> pointProductList) {
        try {
            List tempList = pointProductList.stream().filter(point -> point.getItemType() != null && StringUtils.isNotEmpty((String)point.getItemId()) && point.getSaleValue() != null).collect(Collectors.toList());
            if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(promotionVO.getProductType()).intValue()) {
                Optional<PrepayCardItemEntity> prepayCardItemEntityOption = tempList.stream().filter(pointProduct -> Objects.equals(pointProduct.getItemId(), promotionVO.getProduct().getProId()) && Objects.equals(SalesTypeEnum.SALES_PRODUCT.getValue(), (int)pointProduct.getItemType())).findFirst();
                if (prepayCardItemEntityOption.isPresent()) {
                    promotionVO.setCardFactPrice(prepayCardItemEntityOption.get().getSaleValue());
                    promotionVO.setCardOriginPrice(prepayCardItemEntityOption.get().getOriginPrice());
                    this.logger.info("\u4fc3\u9500:{} \u5173\u8054\u5355\u54c1,\u70b9\u5361\u91d1\u989d:{}", (Object)promotionVO.getPromotionName(), (Object)promotionVO.getCardFactPrice());
                }
            } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(promotionVO.getProductType()).intValue()) {
                boolean canUsePointCard = true;
                for (MallProductVO productVO : promotionVO.getGroup().getProductList()) {
                    Optional<PrepayCardItemEntity> prepayCardItemEntityOption = tempList.stream().filter(pointProduct -> Objects.equals(pointProduct.getItemId(), productVO.getProId()) && SalesTypeEnum.SALES_PRODUCT.getValue() == pointProduct.getItemType().intValue()).findFirst();
                    if (prepayCardItemEntityOption.isPresent()) {
                        promotionVO.setCardFactPrice(PriceUtils.add((BigDecimal)promotionVO.getCardFactPrice(), (BigDecimal)prepayCardItemEntityOption.get().getSaleValue()));
                        promotionVO.setCardOriginPrice(PriceUtils.add((BigDecimal)promotionVO.getCardOriginPrice(), (BigDecimal)prepayCardItemEntityOption.get().getOriginPrice()));
                        this.logger.info("\u4fc3\u9500:{} \u5173\u8054\u5957\u88c5,\u70b9\u5361\u91d1\u989d:{}", (Object)promotionVO.getPromotionName(), (Object)promotionVO.getCardFactPrice());
                        continue;
                    }
                    canUsePointCard = false;
                    break;
                }
                if (!canUsePointCard) {
                    promotionVO.setCardFactPrice(BigDecimal.ZERO);
                    promotionVO.setCardOriginPrice(BigDecimal.ZERO);
                }
                promotionVO.setPointCardDiffPointPrice(PriceUtils.subtract((BigDecimal)promotionVO.getCardOriginPrice(), (BigDecimal)promotionVO.getCardFactPrice()));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    public BaseJsonVo checkPromotion(MallPromotionVO promotionVO) {
        MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(promotionVO.getPromotionId(), DateUtils.date());
        if (promotionTimeEntity == null) {
            return BaseJsonVo.error((String)(String.format("\u4fc3\u9500%s\u4e2d\uff0c", promotionVO.getPromotionName()) + "\u5907\u8d27\u4e2d"));
        }
        BaseJsonVo baseJsonVo = this.checkBasePromotion(promotionVO.getPromotionType(), promotionTimeEntity, promotionVO.getPromotionId(), promotionVO.getPromotionName(), promotionVO.getActiveNo(), promotionVO.getBeginTime(), promotionVO.getEndTime(), promotionVO.getStatus(), promotionVO.getSaled());
        if (baseJsonVo.isSuccess()) {
            if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(promotionVO.getProductType()).intValue()) {
                if (!promotionVO.getProduct().getValid().booleanValue()) {
                    return BaseJsonVo.error((String)(String.format("\u4fc3\u9500%s\u4e2d\uff0c", promotionVO.getPromotionName()) + promotionVO.getProduct().getInvalidReason()));
                }
            } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(promotionVO.getProductType()).intValue() && !promotionVO.getGroup().getValid().booleanValue()) {
                return BaseJsonVo.error((String)(String.format("\u4fc3\u9500%s\u4e2d\uff0c", promotionVO.getPromotionName()) + promotionVO.getGroup().getInvalidReason()));
            }
            if (promotionVO.getUserLimitCount() != null && promotionVO.getUserLimitCount() > 0 && promotionVO.getCount() > promotionVO.getUserLimitCount()) {
                return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s\uff0c\u8d85\u8fc7\u6bcf\u5355\u9650\u5236\u8d2d\u4e70\u6570%s", promotionVO.getPromotionName(), promotionVO.getUserLimitCount()));
            }
            MallPromotionProductEntity promotionProductEntity = this.promotionProductInterface.getPromotionProductEntity(promotionVO.getPromotionId());
            if (promotionProductEntity != null && promotionProductEntity.getLimitCount() != 0 && promotionVO.getCount() > promotionProductEntity.getLimitCount()) {
                return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s\uff0c\u8d85\u8fc7\u8d2d\u4e70\u9650\u5236\u6570", promotionVO.getPromotionName()));
            }
        } else {
            return baseJsonVo;
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo checkBasePromotion(int promotionType, MallPromotionTimeEntity promotionTimeEntity, String promotionId, String promotionName, String activeNo, Date beginTime, Date endTime, int status, int saled) {
        if (status != 1) {
            BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
            baseJsonVo.setStatus(40002);
            baseJsonVo.setMessage(String.format("\u4fc3\u9500%s,\u672a\u542f\u7528", promotionName));
            return baseJsonVo;
        }
        if (beginTime.getTime() > DateUtils.now().getTime()) {
            return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s,\u5c1a\u672a\u5f00\u59cb", promotionName).toString());
        }
        if (endTime.getTime() < DateUtils.now().getTime()) {
            return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s,\u5df2\u7ed3\u675f", promotionName).toString());
        }
        if (promotionType == 2) {
            beginTime = DateUtils.currentDate();
            endTime = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
        }
        int buyCount = this.promotionBuyInterface.getPromotionBuyCount(promotionId, beginTime, endTime);
        if (promotionTimeEntity.getLimitCount() - (buyCount += saled) < 0) {
            return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", promotionName).toString());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public boolean updatePromotionLimitCount(String promotionId, String itemId, int quantity, Date d1, String customerId) {
        MallPromotionEntity mallPromotionEntity = this.promotionInterface.getPromotion(promotionId);
        if (d1.compareTo(DateUtils.currentDate()) == 0) {
            d1 = DateUtils.now();
        }
        if (mallPromotionEntity.getBeginTime().after(d1) || mallPromotionEntity.getEndTime().before(d1)) {
            return false;
        }
        MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(promotionId, DateUtils.date());
        if (promotionTimeEntity != null) {
            Date beginTime = promotionTimeEntity.getBeginTime();
            Date endTime = promotionTimeEntity.getEndTime();
            if (mallPromotionEntity.getPromotionType() == 2) {
                beginTime = DateUtils.currentDate();
                endTime = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
            }
            int buyCount = this.promotionBuyInterface.getPromotionBuyCount(promotionId, beginTime, endTime);
            int limitCount = promotionTimeEntity.getLimitCount() - mallPromotionEntity.getSaled() - buyCount - quantity;
            if (limitCount < 0) {
                return false;
            }
            MallPromotionBuyEntity promotionBuyEntity = new MallPromotionBuyEntity();
            promotionBuyEntity.setPromotionId(promotionId);
            promotionBuyEntity.setBuyCount(quantity);
            promotionBuyEntity.setCreateTime(d1);
            int i = this.promotionBuyInterface.insertSelectiveEntity(mallPromotionEntity, promotionTimeEntity, promotionBuyEntity);
            if (i > 0) {
                this.removeCache(promotionId);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public BaseJsonVo updatePromotionLimitCount(MallMainOrderVo mainOrderVo, boolean reverse) {
        try {
            int red = 1;
            if (reverse) {
                red = -1;
            }
            for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
                if (orderVo.getPromotions() == null || orderVo.getPromotions().size() <= 0) continue;
                for (MallPromotionVO promotionVO : orderVo.getPromotions()) {
                    if (promotionVO.getProduct() != null && !this.updatePromotionLimitCount(promotionVO.getPromotionId(), promotionVO.getProduct().getProId(), promotionVO.getProduct().getCount() * red, DateUtils.now(), mainOrderVo.getCustomerId())) {
                        return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", promotionVO.getPromotionName()));
                    }
                    if (promotionVO.getGroup() != null && !this.updatePromotionLimitCount(promotionVO.getPromotionId(), promotionVO.getGroup().getGroupId(), promotionVO.getGroup().getCount() * red, DateUtils.now(), mainOrderVo.getCustomerId())) {
                        return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", promotionVO.getPromotionName()));
                    }
                    this.removeCache(promotionVO.getPromotionId());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            throw new RuntimeException();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<Map> findRecommendPromotions(Integer platformGroupId) {
        ArrayList<Map> rtnList = new ArrayList<Map>();
        MallSaleRecommendEntity searchParam = new MallSaleRecommendEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setStatus(1);
        searchParam.setSaleType(SalesTypeEnum.SALES_PROMOTION.getValue());
        List<MallSaleRecommendEntity> sales = this.saleRecommendInterface.getList(searchParam);
        sales.forEach(entity -> {
            BaseJsonVo<MallPromotionVO> result = this.buildPromotionVO(entity.getSaleId(), 1, false);
            if (result.isSuccess() && ((MallPromotionVO)result.getValue()).getValid().booleanValue()) {
                Map promotion = ObjectConvert.objectWithSuperConvertToObjectMap((Object)result.getValue());
                promotion.put("recommendReason", entity.getRecommendReason());
                rtnList.add(promotion);
            }
        });
        return rtnList;
    }

    @Override
    @ReadThroughSingleCache(namespace="PromotionTimeService.buildIndexPromotionVo", expiration=120)
    public BaseJsonVo<MallIndexPromotionVo> buildIndexPromotionVo(@ParameterValueKeyProvider String promotionId) {
        MallPromotionEntity entity = this.getPromotion(promotionId);
        if (entity == null) {
            this.logger.info("\u4fc3\u9500\u4e0d\u5b58\u5728,promotionId:{}", (Object)promotionId);
            return BaseJsonVo.error((String)"\u4fc3\u9500\u4e0d\u5b58\u5728");
        }
        return this.buildIndexPromotionVo(entity);
    }

    @Override
    public BaseJsonVo<MallIndexPromotionVo> buildIndexPromotionVo(MallPromotionEntity mallPromotionEntity) {
        Map<Object, Object> listMap;
        MallIndexPromotionVo vo = new MallIndexPromotionVo();
        MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(mallPromotionEntity.getPromotionId(), DateUtils.date());
        if (promotionTimeEntity == null) {
            BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
            baseJsonVo.setStatus(40003);
            this.logger.info("\u4fc3\u9500\u65f6\u95f4\u4e0d\u5b58\u5728,promotionId:{}", (Object)mallPromotionEntity.getPromotionId());
            baseJsonVo.setMessage(String.format("\u4fc3\u9500%s,\u672a\u5f00\u59cb\u6216\u5df2\u7ed3\u675f", mallPromotionEntity.getPromotionName()));
            return baseJsonVo;
        }
        MallPromotionProductEntity promotionProduct = this.promotionProductInterface.getPromotionProductEntity(mallPromotionEntity.getPromotionId());
        if (promotionProduct == null) {
            this.logger.info("\u4fc3\u9500\u5546\u54c1\u4e0d\u5b58\u5728,promotionId:{}", (Object)mallPromotionEntity.getPromotionId());
            return BaseJsonVo.error((String)"\u4fc3\u9500\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        MallProductEntity productEntity = null;
        MallProductGroupEntity groupEntity = null;
        if (promotionProduct.getProductType().equals("4")) {
            productEntity = this.productService.getProduct(promotionProduct.getProductId());
            if (productEntity == null) {
                this.logger.info("\u4fc3\u9500\u4e0d\u5b58\u5728,promotionId:{}", (Object)mallPromotionEntity.getPromotionId());
                return BaseJsonVo.error((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            vo.setProductUnit(StringUtils.isNotEmpty((String)productEntity.getProDw()) ? productEntity.getProDw() : "");
        }
        if (promotionProduct.getProductType().equals("2")) {
            groupEntity = this.groupService.getGroup(promotionProduct.getProductId());
            if (groupEntity == null) {
                this.logger.info("\u4fc3\u9500\u4e0d\u5b58\u5728,promotionId:{}", (Object)mallPromotionEntity.getPromotionId());
                return BaseJsonVo.error((String)"\u5957\u88c5\u4e0d\u5b58\u5728");
            }
            vo.setProductUnit(StringUtils.isNotEmpty((String)groupEntity.getGroupUnit()) ? groupEntity.getGroupUnit() : "");
        }
        vo.setLimitBuyCount(mallPromotionEntity.getUserLimitCount() == null || mallPromotionEntity.getUserLimitCount() == 0 ? promotionProduct.getLimitCount() : mallPromotionEntity.getUserLimitCount());
        vo.setPromotionId(mallPromotionEntity.getPromotionId());
        vo.setBeginTime(mallPromotionEntity.getBeginTime());
        vo.setEndTime(mallPromotionEntity.getEndTime());
        vo.setStatus(mallPromotionEntity.getStatus());
        vo.setPromotionType(mallPromotionEntity.getPromotionType());
        vo.setFlag(mallPromotionEntity.getFlag());
        vo.setSaled(mallPromotionEntity.getSaled());
        vo.setUseCoupon(mallPromotionEntity.getUseCoupon());
        Date beginTimeType = promotionTimeEntity.getBeginTime();
        Date endTimeType = promotionTimeEntity.getEndTime();
        if (mallPromotionEntity.getPromotionType() == 2) {
            beginTimeType = DateUtils.currentDate();
            endTimeType = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
        }
        int buyCount = this.promotionBuyInterface.getPromotionBuyCount(mallPromotionEntity.getPromotionId(), beginTimeType, endTimeType);
        int balance = promotionTimeEntity.getLimitCount() - (buyCount += mallPromotionEntity.getSaled().intValue());
        vo.setBalanceCount(balance);
        vo.setGroupType(Integer.parseInt(promotionProduct.getProductType()));
        vo.setItemType(1);
        if (vo.getGroupType() == 4) {
            vo.setIsGift(productEntity.getProTypeId() == 3 ? 1 : 0);
            vo.setProductName(mallPromotionEntity.getPromotionName());
            vo.setProductTagName(productEntity.getProOtherName());
            vo.setProductUnit(productEntity.getProDw());
            vo.setProSpec(productEntity.getProSpec());
        } else {
            vo.setIsGift(0);
            vo.setProductName(mallPromotionEntity.getPromotionName());
            vo.setProductTagName(groupEntity.getGroupOtherName());
            vo.setProductUnit(groupEntity.getGroupUnit());
            vo.setProSpec(groupEntity.getSpec());
        }
        vo.setIsShow(promotionProduct.getIsshow() == null ? 1 : promotionProduct.getIsshow());
        vo.setIsVip(promotionProduct.getIsvip() == null ? 0 : promotionProduct.getIsvip());
        vo.setIsvipday(this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday");
        vo.setLimitCount(promotionTimeEntity.getLimitCount());
        HashMap map = this.picService.getProductPicUrlMap(mallPromotionEntity.getPromotionId(), SalesTypeEnum.SALES_PROMOTION.getValue());
        if (map.isEmpty() || mallPromotionEntity.getCreateTime().compareTo(DateUtils.getDateFromString((String)"2021-07-22 17:00:00")) < 0) {
            map = this.picService.getProductPicUrlMap(promotionProduct.getPromotionProductId(), SalesTypeEnum.SALES_PROMOTION.getValue());
        }
        if (vo.getGroupType() == SalesTypeEnum.SALES_GROUP.getValue()) {
            listMap = this.picService.getProductPicUrlMap(promotionProduct.getProductId(), SalesTypeEnum.SALES_GROUP.getValue());
            map.putAll(listMap == null ? new HashMap() : listMap);
        } else if (vo.getGroupType() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
            listMap = this.picService.getProductPicUrlMap(promotionProduct.getProductId(), SalesTypeEnum.SALES_PRODUCT.getValue());
            map.putAll(listMap == null ? new HashMap() : listMap);
        }
        vo.setPicMap(map == null ? new HashMap() : map);
        vo.setPrice(promotionProduct.getOriginPrice());
        vo.setProductId(promotionProduct.getProductId());
        vo.setPromotionProductId(promotionProduct.getPromotionProductId());
        vo.setSalePrice(promotionProduct.getPromotionPrice());
        vo.setVipRightType(promotionProduct.getVipRightType());
        vo.setShowVipPriceFlag(promotionProduct.getVipDayRight() != null && promotionProduct.getVipDayRight() == 1 || promotionProduct.getVipEverydayRight() != null && promotionProduct.getVipEverydayRight() == 1 ? 1 : 0);
        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)promotionTimeEntity.getEndTime());
        vo.setSeconds(seconds);
        vo.setSecond((int)(seconds % 3600L % 60L));
        vo.setHour((int)(seconds / 3600L));
        vo.setMinute((int)(seconds % 3600L / 60L));
        vo.setItemType(SalesTypeEnum.SALES_PROMOTION.getValue());
        BaseJsonVo checkResult = this.checkBasePromotion(mallPromotionEntity.getPromotionType(), promotionTimeEntity, mallPromotionEntity.getPromotionId(), mallPromotionEntity.getPromotionName(), mallPromotionEntity.getActiveNo(), promotionTimeEntity.getBeginTime(), promotionTimeEntity.getEndTime(), mallPromotionEntity.getStatus(), mallPromotionEntity.getSaled());
        vo.setValid(checkResult.isSuccess());
        vo.setInvalidReason(checkResult.isSuccess() ? "" : checkResult.getMessage());
        return BaseJsonVo.success((Object)vo);
    }

    public BaseJsonVo<MallIndexPromotionVo> buildIndexPromotionVo(String promotionId, String customerId) {
        BaseJsonVo<MallIndexPromotionVo> baseJsonVo = this.promotionInterface.buildIndexPromotionVo(promotionId);
        if (baseJsonVo.isSuccess()) {
            MallPriceVO priceVO;
            MallIndexPromotionVo mallIndexPromotionVo = (MallIndexPromotionVo)baseJsonVo.getValue();
            MallPromotionProductEntity promotionProduct = this.promotionProductInterface.getPromotionProductEntity(promotionId);
            if (promotionProduct.getIsvip() != null && promotionProduct.getIsvip() == 1 && !this.vipInterface.checkVipRightByType(customerId, promotionProduct.getVipRightType())) {
                mallIndexPromotionVo.setIsShow(0);
            }
            if ((priceVO = this.priceCalcInterface.getPrice(OrderSourceEnum.CART, SalesTypeEnum.SALES_PROMOTION, promotionId, customerId, 0)) != null && priceVO.getFactPrice() != null) {
                mallIndexPromotionVo.setSalePrice(priceVO.getFactPrice());
                mallIndexPromotionVo.setPrice(priceVO.getOriginPrice());
            }
        }
        return baseJsonVo;
    }

    @Override
    @ReadThroughSingleCache(namespace="promotionService.getPromotionUnit", expiration=300)
    public String getPromotionUnit(@ParameterValueKeyProvider String promotionId) {
        MallPromotionProductEntity promotionProduct = this.promotionProductInterface.getPromotionProductEntity(promotionId);
        if (promotionProduct == null) {
            this.logger.info("\u4fc3\u9500\u5546\u54c1\u4e0d\u5b58\u5728,promotionId:" + promotionId);
            return "";
        }
        MallProductEntity productEntity = null;
        MallProductGroupEntity groupEntity = null;
        if (promotionProduct.getProductType().equals("4")) {
            productEntity = this.productService.getProduct(promotionProduct.getProductId());
            if (productEntity == null) {
                this.logger.info("\u4fc3\u9500\u4e0d\u5b58\u5728,promotionId:" + promotionId);
                return productEntity.getProDw();
            }
            return StringUtils.isNotEmpty((String)productEntity.getProDw()) ? productEntity.getProDw() : "";
        }
        if (promotionProduct.getProductType().equals("2")) {
            groupEntity = this.groupService.getGroup(promotionProduct.getProductId());
            if (groupEntity == null) {
                this.logger.info("\u4fc3\u9500\u4e0d\u5b58\u5728,promotionId:{}", (Object)promotionId);
                return "\u7bb1";
            }
            return StringUtils.isNotEmpty((String)groupEntity.getGroupUnit()) ? groupEntity.getGroupUnit() : "";
        }
        return "";
    }

    @Override
    public List<MallSelectDataVo> getOptionPromotionList(Integer platformGroupId) {
        return this.promotionMapper.getOptionPromotionList(platformGroupId);
    }

    @Override
    public BaseJsonVo getPromotionByBindCode(String customerId, String bindCode) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u6d3b\u52a8");
        }
        MallPromotionEntity mallPromotionEntity = this.promotionInterface.getMallPromotionEntityByActiveNo(activeEntity.getActiveNo());
        if (mallPromotionEntity != null) {
            BaseJsonVo<MallIndexPromotionVo> baseJsonVo = this.buildIndexPromotionVo(mallPromotionEntity.getPromotionId(), customerId);
            if (baseJsonVo.isSuccess()) {
                MallIndexPromotionVo vo = (MallIndexPromotionVo)baseJsonVo.getValue();
                if (vo.getValid() != null && !vo.getValid().booleanValue()) {
                    vo.setStatus(4);
                    return baseJsonVo;
                }
                vo.setOrderSource(this.activeInterface.getOrderSourceByActiveType(activeEntity.getActiveType()));
                Integer userLimitCount = mallPromotionEntity.getUserLimitCount();
                if (userLimitCount != null && userLimitCount > 0) {
                    this.logger.info("\u4fc3\u9500\u9650\u5236\u8d2d\u4e70\u6b21\u6570:{}", (Object)userLimitCount);
                    int buyCount = this.mallOrderProductInterface.getUserPromotionBuyCount(mallPromotionEntity.getPromotionId(), customerId);
                    this.logger.info("\u7528\u6237\u4fc3\u9500\u5df2\u8d2d\u4e70\u6b21\u6570:{},customerid={},promotionId={}", new Object[]{buyCount, customerId, mallPromotionEntity.getPromotionId()});
                    if (buyCount >= userLimitCount) {
                        baseJsonVo.setMessage("\u8d85\u8fc7\u8d2d\u4e70\u6b21\u6570\u9650\u5236\uff01");
                        vo.setStatus(3);
                        vo.setValid(false);
                        vo.setInvalidReason("\u8d85\u8fc7\u8d2d\u4e70\u6b21\u6570\u9650\u5236\uff01");
                        return baseJsonVo;
                    }
                }
                MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
                orderMainEntity.setCustomerId(customerId);
                orderMainEntity.setStatus(1);
                orderMainEntity.setBindCode(bindCode);
                List<MallOrderMainEntity> list = this.mallOrderMainInterface.getOrderMainList(orderMainEntity);
                if (list != null && list.size() >= 1) {
                    baseJsonVo.setMessage("\u5b58\u5728\u5f85\u4ed8\u6b3e\u8ba2\u5355\uff01");
                    vo.setStatus(2);
                    vo.setValid(false);
                    vo.setInvalidReason("\u5b58\u5728\u5f85\u4ed8\u6b3e\u8ba2\u5355\uff01");
                }
            }
            return baseJsonVo;
        }
        return BaseJsonVo.error((String)"\u4fc3\u9500\u4e0d\u5b58\u5728\u6216\u88ab\u4e0b\u67b6");
    }

    @Override
    @ReadThroughSingleCache(namespace="mallPromotionService.getPromotionPicUrlMap", expiration=300)
    public Map<String, List<String>> getPromotionPicUrlMap(@ParameterValueKeyProvider String promotionId) {
        Map<String, List<String>> map = this.picService.getProductPicUrlMap(promotionId, SalesTypeEnum.SALES_PROMOTION.getValue());
        MallPromotionEntity entity = this.promotionInterface.getPromotion(promotionId);
        if (map.isEmpty() || entity.getCreateTime().compareTo(DateUtils.getDateFromString((String)"2021-07-22 17:00:00")) < 0) {
            this.logger.info("promotionId={}", (Object)promotionId);
            MallPromotionProductEntity promotionProductEntity = this.promotionProductInterface.getPromotionProductEntity(promotionId);
            this.logger.info("{}", (Object)promotionProductEntity.toString());
            map = this.picService.getProductPicUrlMap(promotionProductEntity.getPromotionProductId(), SalesTypeEnum.SALES_PROMOTION.getValue());
        }
        return map;
    }

    @Override
    public BaseJsonVo getPromotionByBindCode(String bindCode) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u6d3b\u52a8");
        }
        MallPromotionEntity mallPromotionEntity = this.promotionInterface.getMallPromotionEntityByActiveNo(activeEntity.getActiveNo());
        if (mallPromotionEntity != null) {
            BaseJsonVo<MallIndexPromotionVo> baseJsonVo = this.buildIndexPromotionVo(mallPromotionEntity);
            if (baseJsonVo.isSuccess()) {
                MallIndexPromotionVo vo = (MallIndexPromotionVo)baseJsonVo.getValue();
                if (vo.getValid() != null && !vo.getValid().booleanValue()) {
                    vo.setStatus(4);
                    return baseJsonVo;
                }
                vo.setOrderSource(this.activeInterface.getOrderSourceByActiveType(activeEntity.getActiveType()));
            }
            return baseJsonVo;
        }
        return BaseJsonVo.error((String)"\u4fc3\u9500\u4e0d\u5b58\u5728\u6216\u88ab\u4e0b\u67b6");
    }

    @Override
    @ReadThroughSingleCache(namespace="mallPromotionService.getMallPromotionEntityByActiveNo", expiration=300)
    public MallPromotionEntity getMallPromotionEntityByActiveNo(@ParameterValueKeyProvider String acitveNo) {
        MallPromotionEntity queryPromotionEntity = new MallPromotionEntity();
        queryPromotionEntity.setActiveNo(acitveNo);
        queryPromotionEntity.setStatus(1);
        return (MallPromotionEntity)this.promotionMapper.getSingle(queryPromotionEntity);
    }
}

