/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallRegularMapper;
import cc.lechun.mall.dao.sales.MallRegularProductMapper;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallRegularEntity;
import cc.lechun.mall.entity.sales.MallRegularProductEntity;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallRegularInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallRegularService
extends BaseService
implements MallRegularInterface {
    @Autowired
    private MallRegularMapper regularMapper;
    @Autowired
    private MallRegularProductMapper regularProductMapper;
    @Autowired
    private MallProductInterface productService;

    @Override
    public BaseJsonVo getRegularProductList(int platformGroupId, int channelType) {
        ArrayList productVOs = new ArrayList();
        List<MallRegularProductEntity> regularProducts = this.regularProductMapper.findChannelProducts(platformGroupId, 1);
        if (regularProducts != null && regularProducts.size() > 0) {
            regularProducts.forEach(regularProduct -> {
                BaseJsonVo<MallProductVO> sr = this.productService.buildProductVO(regularProduct.getProductId(), 1, true, true);
                if (sr.isSuccess()) {
                    productVOs.add((MallProductVO)sr.getValue());
                }
            });
        }
        return BaseJsonVo.success(productVOs);
    }

    @Override
    @ReadThroughSingleCache(namespace="getRegular4GroupDCount", expiration=7200)
    public MallRegularEntity getRegular4GroupDCount(@ParameterValueKeyProvider(order=0) Integer platformGroupId, @ParameterValueKeyProvider(order=1) Integer deliverCount) {
        MallRegularEntity regular = new MallRegularEntity();
        regular.setPlatformGroupId(platformGroupId);
        regular.setStatus(1);
        regular.setRegularDeliverCount(deliverCount);
        List regulars = this.regularMapper.getList(regular);
        if (regulars != null && regulars.size() > 0) {
            return (MallRegularEntity)regulars.get(0);
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="getRegular4GroupDType", expiration=7200)
    public MallRegularEntity getRegular4GroupDType(@ParameterValueKeyProvider(order=0) Integer platformGroupId, @ParameterValueKeyProvider(order=1) Integer deliverType) {
        MallRegularEntity regular = new MallRegularEntity();
        regular.setPlatformGroupId(platformGroupId);
        regular.setStatus(1);
        regular.setRegularType(deliverType);
        List regulars = this.regularMapper.getList(regular);
        if (regulars != null && regulars.size() > 0) {
            return (MallRegularEntity)regulars.get(0);
        }
        return null;
    }
}

