/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.shoppingcart;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.enums.sync.DataSyncTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.enums.trade.TransportTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import cc.lechun.mall.dao.shoppingcart.MallShoppingcartMapper;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.deliver.DeliverSoldProductVo;
import cc.lechun.mall.entity.deliver.DeliverVo;
import cc.lechun.mall.entity.deliver.MallFreightCalVo;
import cc.lechun.mall.entity.prepay.PrepayCardItemEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallItemVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.iservice.deliver.DeliverFreightInterface;
import cc.lechun.mall.iservice.deliver.MallFreightInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.service.deliver.DeliverNewErpService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import zipkin.internal.Nullable;

@Service
public class MallShoppingcartService
extends BaseService
implements MallShoppingcartInterface {
    private static final Logger logger = LoggerFactory.getLogger(MallShoppingcartService.class);
    @Autowired
    MallProductInterface productService;
    @Autowired
    MallGroupInterface groupService;
    @Autowired
    MallPromotionInterface promotionService;
    @Autowired
    MallFreeInterface freeService;
    @Autowired
    MallPriceCalcInterface calcService;
    @Autowired
    MallShoppingcartMapper cartMapper;
    @Autowired
    PlatFormInterface platFormService;
    @Autowired
    MallPromotionProductInterface promotionProductService;
    @Autowired
    private DeliverFreightInterface freightInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallFreightInterface mallFreightService;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    DeliverNewErpService deliverNewErpService;
    @Autowired
    MallShoppingcartInterface shoppingcartInterface;
    @Autowired
    MallFullcutInterface fullcutInterface;
    @Autowired
    MallDataSyncInterface dataSyncInterface;
    @Autowired
    private PrepayCardItemInterface prepayCardItemInterface;

    public BaseJsonVo buildShoppingcartFromShoppingcart(Integer platformId, String customerId, Boolean checked, int isQuick, String shoppingType) {
        BaseJsonVo<List<MallShoppingcartVO>> sr;
        block4: {
            sr = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platformId, customerId, checked, shoppingType);
            if (!sr.isSuccess()) break block4;
            List vos = (List)sr.getValue();
            Iterator it = vos.iterator();
            if (isQuick == 1) {
                while (it.hasNext()) {
                    MallShoppingcartVO mallShoppingcartVO = (MallShoppingcartVO)it.next();
                    if ("1".equals(mallShoppingcartVO.getSpeedUp())) continue;
                    it.remove();
                }
            } else {
                while (it.hasNext()) {
                    MallShoppingcartVO mallShoppingcartVO = (MallShoppingcartVO)it.next();
                    if (!"1".equals(mallShoppingcartVO.getSpeedUp())) continue;
                    it.remove();
                }
            }
        }
        return sr;
    }

    @Override
    public BaseJsonVo<List<MallShoppingcartVO>> buildShoppingcartFromShoppingcart(Integer platformId, String customerId, Boolean checked, String shoppingType) {
        Integer platFormGroupId = this.platFormService.getPlatForm(platformId).getPlatformGroupId();
        MallShoppingcartVO coldChainCart = new MallShoppingcartVO();
        coldChainCart.setCustomerId(customerId);
        coldChainCart.setOrderSource(OrderSourceEnum.CART.getValue());
        coldChainCart.setPlatFormId(platformId);
        coldChainCart.setPlatFormGroupId(platFormGroupId);
        coldChainCart.setProducts(new ArrayList<MallProductVO>());
        coldChainCart.setGroups(new ArrayList<MallGroupVO>());
        coldChainCart.setPromotions(new ArrayList<MallPromotionVO>());
        coldChainCart.setSelfMadeType(1);
        coldChainCart.setTransportType(TransportTypeEnum.LENG_LIAN.getValue());
        coldChainCart.setShoppingType(shoppingType);
        MallShoppingcartVO nomalTempCart = new MallShoppingcartVO();
        nomalTempCart.setCustomerId(customerId);
        nomalTempCart.setOrderSource(OrderSourceEnum.CART.getValue());
        nomalTempCart.setPlatFormId(platformId);
        nomalTempCart.setPlatFormGroupId(platFormGroupId);
        nomalTempCart.setProducts(new ArrayList<MallProductVO>());
        nomalTempCart.setGroups(new ArrayList<MallGroupVO>());
        nomalTempCart.setPromotions(new ArrayList<MallPromotionVO>());
        nomalTempCart.setSelfMadeType(2);
        nomalTempCart.setShoppingType(shoppingType);
        nomalTempCart.setTransportType(TransportTypeEnum.CHANG_WEN.getValue());
        HashMap productTypeMap = new HashMap();
        BaseJsonVo baseJsonVo = BaseJsonVo.error();
        List<MallShoppingcartEntity> cartEntityList = this.cartMapper.getWechatCart(customerId, shoppingType);
        ArrayList<MallShoppingcartVO> vos = new ArrayList<MallShoppingcartVO>();
        if (CollectionUtils.isNotEmpty(cartEntityList)) {
            List productList = cartEntityList.stream().filter(car -> Objects.equals(car.getSalesType(), SalesTypeEnum.SALES_PRODUCT.getValue())).collect(Collectors.toList());
            List groupList = cartEntityList.stream().filter(car -> Objects.equals(car.getSalesType(), SalesTypeEnum.SALES_GROUP.getValue())).collect(Collectors.toList());
            List promotionList = cartEntityList.stream().filter(car -> Objects.equals(car.getSalesType(), SalesTypeEnum.SALES_PROMOTION.getValue())).collect(Collectors.toList());
            int num = (CollectionUtils.isEmpty(productList) ? 0 : 1) + (CollectionUtils.isEmpty(groupList) ? 0 : 1) + (CollectionUtils.isEmpty(promotionList) ? 0 : 1);
            if (num > 0) {
                try {
                    BaseJsonVo promotionSR;
                    BaseJsonVo groupSR;
                    ExecutorService pool = Executors.newFixedThreadPool(num);
                    CompletableFuture<BaseJsonVo> prductCompletableFuture = CompletableFuture.supplyAsync(() -> this.buildShoppingcartProducts(customerId, productList, shoppingType), pool);
                    CompletableFuture<BaseJsonVo> groupCompletableFuture = CompletableFuture.supplyAsync(() -> this.buildShoppingcartGroups(groupList, checked, shoppingType), pool);
                    CompletableFuture<BaseJsonVo> promotionCompletableFuture = CompletableFuture.supplyAsync(() -> this.buildShoppingcartPromotions(customerId, promotionList, checked, shoppingType), pool);
                    List<MallProductVO> products = new ArrayList();
                    BaseJsonVo productSR = prductCompletableFuture.get();
                    if (productSR.isSuccess()) {
                        products = (List)productSR.getValue();
                        products.forEach(product -> {
                            if (!StringUtils.isNotEmpty((String)product.getFreeId())) {
                                if (product.getSelfMadeType() == 1) {
                                    coldChainCart.getProducts().add((MallProductVO)product);
                                    if (!productTypeMap.containsKey("cold")) {
                                        productTypeMap.put("cold", 1);
                                    }
                                } else {
                                    nomalTempCart.getProducts().add((MallProductVO)product);
                                    if (!productTypeMap.containsKey("normal")) {
                                        productTypeMap.put("normal", 1);
                                    }
                                }
                            }
                        });
                        if (baseJsonVo.isSuccess()) {
                            products.addAll(((MallItemVO)baseJsonVo.getValue()).getProductVOList());
                        }
                    }
                    if ((groupSR = groupCompletableFuture.get()).isSuccess()) {
                        List groups = (List)groupSR.getValue();
                        groups.forEach(group -> {
                            Integer coldChain = 1;
                            for (MallProductVO product : group.getProductList()) {
                                if (product.getSelfMadeType() != 2) continue;
                                coldChain = 2;
                            }
                            if (coldChain == 1) {
                                coldChainCart.getGroups().add((MallGroupVO)group);
                                if (!productTypeMap.containsKey("cold")) {
                                    productTypeMap.put("cold", 1);
                                }
                            } else if (coldChain == 2) {
                                nomalTempCart.getGroups().add((MallGroupVO)group);
                                if (!productTypeMap.containsKey("normal")) {
                                    productTypeMap.put("normal", 1);
                                }
                            }
                        });
                        if (baseJsonVo.isSuccess()) {
                            groups.addAll(((MallItemVO)baseJsonVo.getValue()).getGroupVOList());
                        }
                    }
                    if ((promotionSR = promotionCompletableFuture.join()).isSuccess() && promotionSR.getValue() != null) {
                        List promotions = (List)promotionSR.getValue();
                        promotions.forEach(promotion -> {
                            if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(promotion.getProductType())) {
                                MallProductVO product = promotion.getProduct();
                                if (product != null && product.getSelfMadeType() == 1) {
                                    coldChainCart.getPromotions().add((MallPromotionVO)promotion);
                                } else {
                                    nomalTempCart.getPromotions().add((MallPromotionVO)promotion);
                                }
                            } else if (String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(promotion.getProductType())) {
                                MallGroupVO group = promotion.getGroup();
                                Integer coldChain = 1;
                                if (group != null && group.getProductList() != null && group.getProductList().size() > 0) {
                                    for (MallProductVO product : group.getProductList()) {
                                        if (product.getSelfMadeType() != 2) continue;
                                        coldChain = 2;
                                        break;
                                    }
                                }
                                if (coldChain == 1) {
                                    coldChainCart.getPromotions().add((MallPromotionVO)promotion);
                                    if (!productTypeMap.containsKey("cold")) {
                                        productTypeMap.put("cold", 1);
                                    }
                                } else if (coldChain == 2) {
                                    nomalTempCart.getPromotions().add((MallPromotionVO)promotion);
                                    if (!productTypeMap.containsKey("normal")) {
                                        productTypeMap.put("normal", 1);
                                    }
                                }
                            }
                        });
                        if (baseJsonVo.isSuccess()) {
                            promotions.addAll(((MallItemVO)baseJsonVo.getValue()).getPromotionVOList());
                        }
                    }
                    CompletableFuture.allOf(prductCompletableFuture, groupCompletableFuture, promotionCompletableFuture);
                    pool.shutdown();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    e.printStackTrace();
                }
            }
            vos.add(coldChainCart);
            vos.add(nomalTempCart);
            this.calcService.calcShoppingcartVO(vos);
            this.freeService.buildFreeVOFromCart(coldChainCart, nomalTempCart);
            this.collectProducts(coldChainCart);
            this.collectProducts(nomalTempCart);
            this.fullcutInterface.checkShoppingcatIsEnableFullCut(coldChainCart, nomalTempCart);
        }
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        ArrayList<MallShoppingcartVO> returnList = new ArrayList<MallShoppingcartVO>();
        if (coldChainCart.getProducts() != null && coldChainCart.getProducts().size() > 0 || coldChainCart.getGroups() != null && coldChainCart.getGroups().size() > 0 || coldChainCart.getPromotions() != null && coldChainCart.getPromotions().size() > 0 || coldChainCart.getFrees() != null && coldChainCart.getFrees().size() > 0) {
            returnList.add(coldChainCart);
        }
        if (nomalTempCart.getProducts() != null && nomalTempCart.getProducts().size() > 0 || nomalTempCart.getGroups() != null && nomalTempCart.getGroups().size() > 0 || nomalTempCart.getPromotions() != null && nomalTempCart.getPromotions().size() > 0 || nomalTempCart.getFrees() != null && nomalTempCart.getFrees().size() > 0) {
            returnList.add(nomalTempCart);
        }
        result.setValue(returnList);
        return result;
    }

    @Override
    public BaseJsonVo<String> getEarlyDeliverDate(Integer platformId, String customerId, CustomerAddressVo addressVo, String promotionId, Integer quantity, String shoppingType) {
        BaseJsonVo sr = BaseJsonVo.success((Object)"");
        Integer platFormGroupId = this.platFormService.getPlatForm(platformId).getPlatformGroupId();
        MallShoppingcartVO coldChainCart = new MallShoppingcartVO();
        coldChainCart.setCustomerId(customerId);
        coldChainCart.setOrderSource(OrderSourceEnum.CART.getValue());
        coldChainCart.setPlatFormId(platformId);
        coldChainCart.setPlatFormGroupId(platFormGroupId);
        coldChainCart.setProducts(new ArrayList<MallProductVO>());
        coldChainCart.setGroups(new ArrayList<MallGroupVO>());
        coldChainCart.setPromotions(new ArrayList<MallPromotionVO>());
        coldChainCart.setSelfMadeType(1);
        coldChainCart.setShoppingType(shoppingType);
        MallShoppingcartVO nomalTempCart = new MallShoppingcartVO();
        nomalTempCart.setCustomerId(customerId);
        nomalTempCart.setOrderSource(OrderSourceEnum.CART.getValue());
        nomalTempCart.setPlatFormId(platformId);
        nomalTempCart.setPlatFormGroupId(platFormGroupId);
        nomalTempCart.setProducts(new ArrayList<MallProductVO>());
        nomalTempCart.setGroups(new ArrayList<MallGroupVO>());
        nomalTempCart.setPromotions(new ArrayList<MallPromotionVO>());
        nomalTempCart.setSelfMadeType(2);
        nomalTempCart.setShoppingType(shoppingType);
        boolean hasColdProduct = false;
        boolean hasNormalProduct = false;
        HashMap productTypeMap = new HashMap();
        ArrayList products = new ArrayList();
        BaseJsonVo promotionsr = this.promotionService.buildPromotionVO(promotionId, quantity, false);
        if (promotionsr.isSuccess() && promotionsr.getValue() != null) {
            ArrayList<Object> promotions = new ArrayList<Object>();
            promotions.add(promotionsr.getValue());
            promotions.forEach(promotion -> {
                if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(promotion.getProductType())) {
                    MallProductVO product = promotion.getProduct();
                    if (product != null && product.getSelfMadeType() == 1) {
                        coldChainCart.getPromotions().add((MallPromotionVO)promotion);
                    } else {
                        nomalTempCart.getPromotions().add((MallPromotionVO)promotion);
                    }
                } else if (String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(promotion.getProductType())) {
                    MallGroupVO group = promotion.getGroup();
                    Integer coldChain = 1;
                    if (group != null && group.getProductList() != null && group.getProductList().size() > 0) {
                        for (MallProductVO product : group.getProductList()) {
                            if (product.getSelfMadeType() != 2) continue;
                            coldChain = 2;
                        }
                    }
                    if (coldChain == 1) {
                        coldChainCart.getPromotions().add((MallPromotionVO)promotion);
                        if (!productTypeMap.containsKey("cold")) {
                            productTypeMap.put("cold", 1);
                        }
                    } else if (coldChain == 2) {
                        nomalTempCart.getPromotions().add((MallPromotionVO)promotion);
                        if (!productTypeMap.containsKey("normal")) {
                            productTypeMap.put("normal", 1);
                        }
                    }
                }
            });
        }
        ArrayList<MallShoppingcartVO> vos = new ArrayList<MallShoppingcartVO>();
        vos.add(coldChainCart);
        vos.add(nomalTempCart);
        if (CollectionUtils.isNotEmpty(coldChainCart.getProducts())) {
            logger.info("\u8d2d\u7269\u8f66\u53c2\u6570\u5bf9\u8c61:{}", (Object)JsonUtils.toJson((Object)coldChainCart, (boolean)true));
            DeliverVo deliverVo = this.deliverNewErpService.getDeliverByErp(coldChainCart, addressVo, null, 1, 1);
            logger.info("\u8fd4\u56de\u53ef\u914d\u9001\u65e5\u671f:{}", (Object)JsonUtils.toJson((Object)deliverVo, (boolean)true));
            if (deliverVo.getInventory() == 1) {
                return BaseJsonVo.success((Object)deliverVo.getDeliverDate());
            }
            return BaseJsonVo.success((Object)DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)new Date(), (int)1), (String)"yyyy-MM-dd"));
        }
        if (CollectionUtils.isNotEmpty(nomalTempCart.getProducts())) {
            logger.info("\u8d2d\u7269\u8f66\u53c2\u6570\u5bf9\u8c61:{}", (Object)JsonUtils.toJson((Object)nomalTempCart, (boolean)true));
            DeliverVo deliverVo = this.deliverNewErpService.getDeliverByErp(nomalTempCart, addressVo, null, 1, 1);
            logger.info("\u8fd4\u56de\u53ef\u914d\u9001\u65e5\u671f:{}", (Object)JsonUtils.toJson((Object)deliverVo, (boolean)true));
            if (deliverVo.getInventory() == 1) {
                return BaseJsonVo.success((Object)deliverVo.getDeliverDate());
            }
            return BaseJsonVo.success((Object)DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)new Date(), (int)8), (String)"yyyy-MM-dd"));
        }
        return BaseJsonVo.error((String)"\u672a\u5339\u914d\u5230\u6700\u65e9\u7684\u914d\u9001\u65e5\u671f");
    }

    @Override
    public BaseJsonVo<List<MallProductVO>> buildShoppingcartProducts(String customerId, Boolean checked, String shoppingType) {
        List<MallShoppingcartEntity> cartEntityList = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_PRODUCT.getValue(), checked, shoppingType);
        ArrayList<MallProductVO> productVOList = new ArrayList<MallProductVO>();
        List<PrepayCardItemEntity> pointProductList = this.prepayCardItemInterface.getCardItemEntityList(customerId, shoppingType);
        for (MallShoppingcartEntity entity : cartEntityList) {
            BaseJsonVo<MallProductVO> prosr = this.productService.buildProductVO(entity.getSalesId(), entity.getQuantity(), null, null, null, null, false, entity.getChecked() != 0, entity.getSpeedUp(), customerId);
            if (!prosr.isSuccess()) continue;
            MallProductVO productVO = (MallProductVO)prosr.getValue();
            if (CollectionUtils.isNotEmpty(pointProductList)) {
                this.productService.setProductPoint(productVO, pointProductList);
            }
            productVOList.add(productVO);
        }
        return BaseJsonVo.success(productVOList);
    }

    private BaseJsonVo<List<MallProductVO>> buildShoppingcartProducts(String customerId, List<MallShoppingcartEntity> cartEntityList, String shoppingType) {
        if (CollectionUtils.isNotEmpty(cartEntityList)) {
            ArrayList<MallProductVO> productVOList = new ArrayList<MallProductVO>();
            List<PrepayCardItemEntity> pointProductList = this.prepayCardItemInterface.getCardItemEntityList(customerId, shoppingType);
            for (MallShoppingcartEntity entity : cartEntityList) {
                BaseJsonVo<MallProductVO> prosr = this.productService.buildProductVO(entity.getSalesId(), entity.getQuantity(), null, null, null, null, false, entity.getChecked() != 0, entity.getSpeedUp());
                if (!prosr.isSuccess()) continue;
                MallProductVO productVO = (MallProductVO)prosr.getValue();
                if (CollectionUtils.isNotEmpty(pointProductList)) {
                    this.productService.setProductPoint(productVO, pointProductList);
                }
                productVOList.add(productVO);
            }
            return BaseJsonVo.success(productVOList);
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u5355\u54c1");
    }

    public BaseJsonVo<List<MallGroupVO>> buildShoppingcartGroups(String customerId, Boolean checked, String shoppingType) {
        List<MallShoppingcartEntity> cartEntityList = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_GROUP.getValue(), checked, shoppingType);
        if (CollectionUtils.isNotEmpty(cartEntityList)) {
            ArrayList<Object> groupVOList = new ArrayList<Object>();
            for (MallShoppingcartEntity entity : cartEntityList) {
                BaseJsonVo<MallGroupVO> groupsr = this.groupService.buildGroupVO(entity.getSalesId(), entity.getQuantity(), entity.getChecked() != 0);
                if (!groupsr.isSuccess()) continue;
                groupVOList.add(groupsr.getValue());
            }
            return BaseJsonVo.success(groupVOList);
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u5957\u88c5");
    }

    private BaseJsonVo<List<MallGroupVO>> buildShoppingcartGroups(List<MallShoppingcartEntity> cartEntityList, Boolean checked, String shoppingType) {
        if (CollectionUtils.isNotEmpty(cartEntityList)) {
            ArrayList<Object> groupVOList = new ArrayList<Object>();
            for (MallShoppingcartEntity entity : cartEntityList) {
                BaseJsonVo<MallGroupVO> groupsr = this.groupService.buildGroupVO(entity.getSalesId(), entity.getQuantity(), entity.getChecked() != 0);
                if (!groupsr.isSuccess()) continue;
                groupVOList.add(groupsr.getValue());
            }
            return BaseJsonVo.success(groupVOList);
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u5957\u88c5");
    }

    public BaseJsonVo<List<MallPromotionVO>> buildShoppingcartPromotions(String customerId, Boolean checked, String shoppingType) {
        List<MallShoppingcartEntity> cartEntityList = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_PROMOTION.getValue(), checked, shoppingType);
        if (CollectionUtils.isNotEmpty(cartEntityList)) {
            ArrayList<Object> promotionVOList = new ArrayList<Object>();
            List<PrepayCardItemEntity> pointProductList = this.prepayCardItemInterface.getCardItemEntityList(customerId, shoppingType);
            for (MallShoppingcartEntity entity : cartEntityList) {
                BaseJsonVo promotionsr = this.promotionService.buildPromotionVO(entity.getSalesId(), entity.getQuantity(), entity.getChecked() != 0);
                if (!promotionsr.isSuccess() || !((MallPromotionVO)promotionsr.getValue()).getValid().booleanValue()) continue;
                promotionVOList.add(promotionsr.getValue());
                this.promotionService.setCardPoint((MallPromotionVO)promotionsr.getValue(), pointProductList);
            }
            return BaseJsonVo.success(promotionVOList);
        }
        return BaseJsonVo.error((String)"\u8d2d\u7269\u8f66\u65e0\u4fc3\u9500");
    }

    private BaseJsonVo<List<MallPromotionVO>> buildShoppingcartPromotions(String customerId, List<MallShoppingcartEntity> cartEntityList, Boolean checked, String shoppingType) {
        if (CollectionUtils.isNotEmpty(cartEntityList)) {
            ArrayList<Object> promotionVOList = new ArrayList<Object>();
            List<PrepayCardItemEntity> pointProductList = this.prepayCardItemInterface.getCardItemEntityList(customerId, shoppingType);
            for (MallShoppingcartEntity entity : cartEntityList) {
                BaseJsonVo promotionsr = this.promotionService.buildPromotionVO(entity.getSalesId(), entity.getQuantity(), entity.getChecked() != 0);
                if (!promotionsr.isSuccess()) continue;
                promotionVOList.add(promotionsr.getValue());
                this.promotionService.setProductPoint((MallPromotionVO)promotionsr.getValue(), pointProductList);
            }
            return BaseJsonVo.success(promotionVOList);
        }
        return BaseJsonVo.error((String)"\u8d2d\u7269\u8f66\u65e0\u4fc3\u9500");
    }

    @Override
    public void collectProducts(MallShoppingcartVO cartVO) {
        if (cartVO == null) {
            return;
        }
        ArrayList<MallProductVO> productPool = new ArrayList<MallProductVO>();
        if (cartVO.getProducts() != null) {
            for (MallProductVO mallProductVO : cartVO.getProducts()) {
                productPool.add(mallProductVO);
            }
        }
        if (cartVO.getGroups() != null) {
            for (MallGroupVO mallGroupVO : cartVO.getGroups()) {
                if (mallGroupVO == null) continue;
                for (MallProductVO proVO : mallGroupVO.getProductList()) {
                    proVO.setValid(mallGroupVO.getValid());
                    productPool.add(proVO);
                }
            }
        }
        if (cartVO.getPromotions() != null) {
            for (MallPromotionVO mallPromotionVO : cartVO.getPromotions()) {
                if (mallPromotionVO == null) continue;
                if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(mallPromotionVO.getProductType()).intValue()) {
                    if (mallPromotionVO.getProduct() == null) continue;
                    mallPromotionVO.getProduct().setValid(mallPromotionVO.getValid());
                    mallPromotionVO.getProduct().setPromotionName(mallPromotionVO.getPromotionName());
                    mallPromotionVO.getProduct().setPromotionId(mallPromotionVO.getPromotionId());
                    productPool.add(mallPromotionVO.getProduct());
                    continue;
                }
                if (SalesTypeEnum.SALES_GROUP.getValue() != Integer.valueOf(mallPromotionVO.getProductType()).intValue() || mallPromotionVO.getGroup() == null) continue;
                for (MallProductVO proVO : mallPromotionVO.getGroup().getProductList()) {
                    proVO.setValid(mallPromotionVO.getValid());
                    proVO.setPromotionId(mallPromotionVO.getPromotionId());
                    proVO.setPromotionName(mallPromotionVO.getPromotionName());
                    productPool.add(proVO);
                }
            }
        }
        cartVO.setProductsPool(productPool);
    }

    @Override
    public BaseJsonVo buildCartCount(Integer platformId, String customerId, String shoppingType) {
        Integer cartCount = this.cartMapper.getCartCount(customerId, shoppingType);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("address", null);
        map.put("deliver", null);
        map.put("coldchainCount", 0);
        map.put("nomalCount", 0);
        map.put("invalidCount", 0);
        map.put("count", cartCount);
        map.put("factPrice", 0);
        map.put("freight", 0);
        map.put("price", 0);
        map.put("thisSaleCount", 0);
        map.put("saleCount", null);
        map.put("totalQuantity", cartCount);
        map.put("totalQuantityWithUncheck", 0);
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo buildCartListCount(Integer platformId, String customerId, String shoppingType) {
        List<Map<String, Integer>> cartListCount = this.cartMapper.getCartListCount(customerId, shoppingType);
        Integer cartCount = this.cartMapper.getCartCount(customerId, shoppingType);
        BaseJsonVo sr = BaseJsonVo.success((Object)"");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("address", null);
        map.put("deliver", null);
        map.put("coldchainCount", 0);
        map.put("nomalCount", 0);
        map.put("invalidCount", 0);
        map.put("count", cartCount);
        map.put("factPrice", 0);
        map.put("freight", 0);
        map.put("price", 0);
        map.put("thisSaleCount", 0);
        map.put("saleCount", cartListCount);
        map.put("totalQuantity", cartCount);
        map.put("totalQuantityWithUncheck", 0);
        sr.setValue(map);
        return sr;
    }

    @Override
    public BaseJsonVo buildCartCountWithSaleId(Integer platformId, String customerId, String saleId, String shoppingType) {
        Integer cartCount = this.cartMapper.getCartCount(customerId, shoppingType);
        Integer cartCountWithSaleId = this.cartMapper.getCartCountWithSaleId(customerId, saleId, shoppingType);
        BaseJsonVo sr = BaseJsonVo.success((Object)"");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("address", null);
        map.put("deliver", null);
        map.put("coldchainCount", 0);
        map.put("nomalCount", 0);
        map.put("invalidCount", 0);
        map.put("count", cartCount);
        map.put("factPrice", 0);
        map.put("freight", 0);
        map.put("price", 0);
        map.put("thisSaleCount", cartCountWithSaleId);
        map.put("saleCount", null);
        map.put("totalQuantity", cartCount);
        map.put("totalQuantityWithUncheck", 0);
        sr.setValue(map);
        return sr;
    }

    @Override
    public BaseJsonVo buildCart(Integer platformId, String customerId, CustomerAddressVo addr, Boolean isQuick, String shoppingType) {
        long startTime = System.currentTimeMillis();
        int generalSort = 0;
        String[] coldFullCutNotice = new String[1];
        String[] nomalFullCutNotice = new String[1];
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        BaseJsonVo<List<MallShoppingcartVO>> sr = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platformId, customerId, false, shoppingType);
        if (sr.isSuccess()) {
            List cartVOs = (List)sr.getValue();
            logger.info("--buildCart.cartVOs------------cartVOs={}", (Object)cartVOs.toString());
            HashMap<String, Object> generalMap = new HashMap<String, Object>();
            HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
            Integer[] count = new Integer[]{0, 0, 0, 0, 0, 0};
            BigDecimal[] price = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal[] factPrice = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal[] fullCutAmount = new BigDecimal[]{BigDecimal.ZERO};
            AtomicReference<Boolean> coldGroups = new AtomicReference<Boolean>(false);
            AtomicReference<Boolean> nomalGroups = new AtomicReference<Boolean>(false);
            String[] coldBalanceStatus = new String[]{"true"};
            String[] nomalBalanceStatus = new String[]{"true"};
            String balanceStatus = "2";
            Integer[] balanceStatusFlag = new Integer[]{0, 0};
            String[] promotionIds = new String[]{""};
            String[] groupIds = new String[]{""};
            String[] productIds = new String[]{""};
            logger.info("========buildCart======cartVOs={}", (Object)JSON.toJSONString((Object)cartVOs));
            cartVOs.forEach(cartVO -> {
                cartVO.getProducts().forEach(product -> {
                    if (product.getValid().booleanValue()) {
                        productIds[0] = productIds[0] + product.getProId() + ",";
                        count[0] = count[0] + 1;
                        count[5] = count[5] + product.getCount();
                        if (product.getShoppingcartCheck().booleanValue()) {
                            count[3] = count[3] + product.getCount();
                        }
                        if (cartVO.getSelfMadeType() == 1) {
                            count[1] = count[1] + 1;
                            if (coldBalanceStatus[0] == "true" && product.getStockCount() < product.getCount()) {
                                coldBalanceStatus[0] = "false";
                            }
                        } else {
                            count[2] = count[2] + 1;
                            if (nomalBalanceStatus[0] == "true" && product.getStockCount() < product.getCount()) {
                                nomalBalanceStatus[0] = "false";
                            }
                        }
                    } else {
                        count[4] = count[4] + 1;
                    }
                });
                cartVO.getGroups().forEach(group -> {
                    if (group.getValid().booleanValue()) {
                        groupIds[0] = groupIds[0] + group.getGroupId() + ",";
                        count[0] = count[0] + 1;
                        count[5] = count[5] + group.getCount();
                        if (group.getShoppingcartCheck().booleanValue()) {
                            count[3] = count[3] + group.getCount();
                        }
                        if (cartVO.getSelfMadeType() == 1) {
                            count[1] = count[1] + 1;
                        } else {
                            count[2] = count[2] + 1;
                        }
                    } else {
                        count[4] = count[4] + 1;
                    }
                });
                cartVO.getPromotions().forEach(promotion -> {
                    if (promotion.getValid().booleanValue()) {
                        promotionIds[0] = promotionIds[0] + promotion.getPromotionId() + ",";
                        count[0] = count[0] + 1;
                        count[5] = count[5] + promotion.getCount();
                        if (promotion.getShoppingcartCheck().booleanValue()) {
                            count[3] = count[3] + promotion.getCount();
                        }
                        if (cartVO.getSelfMadeType() == 1) {
                            count[1] = count[1] + 1;
                        } else {
                            count[2] = count[2] + 1;
                        }
                    } else {
                        count[4] = count[4] + 1;
                    }
                });
                price[0] = PriceUtils.add((BigDecimal)cartVO.getPrice(), (BigDecimal)price[0]);
                factPrice[0] = PriceUtils.add((BigDecimal)cartVO.getFactPrice(), (BigDecimal)factPrice[0]);
                fullCutAmount[0] = PriceUtils.add((BigDecimal)cartVO.getFullcutAmount(), (BigDecimal)fullCutAmount[0]);
                DeliverVo deliverVo = this.deliverNewErpService.getDeliverByErp((MallShoppingcartVO)cartVO, addr, null, 1, 1);
                if (StringUtils.isEmpty((String)deliverVo.getPickDate())) {
                    if (deliverVo.getDeliverDates() != null && deliverVo.getDeliverDates().size() > 0) {
                        balanceStatusFlag[0] = 1;
                        balanceStatusFlag[1] = 1;
                    } else if (!(balanceStatusFlag[0] == 1 && balanceStatusFlag[1] == 1 || deliverVo.getInventory() != -1 && deliverVo.getInventory() != -2 && deliverVo.getDeliverDates() != null)) {
                        balanceStatusFlag[0] = 0;
                        balanceStatusFlag[1] = 1;
                    }
                }
                if (cartVO.getSelfMadeType() == 1) {
                    generalMap.put("coldChainCart", cartVO);
                    coldFullCutNotice[0] = cartVO.getFullCutNotice() == null ? "" : cartVO.getFullCutNotice();
                    generalMap.put("coldChainDeliver", deliverVo);
                } else {
                    generalMap.put("nomalTempCart", cartVO);
                    nomalFullCutNotice[0] = cartVO.getFullCutNotice() == null ? "" : cartVO.getFullCutNotice();
                    generalMap.put("nomalTempDeliver", deliverVo);
                }
            });
            if (generalMap.containsKey("coldChainDeliver")) {
                DeliverVo coldDeliverVo = (DeliverVo)generalMap.get("coldChainDeliver");
                DeliverVo nomalDeliverVo = (DeliverVo)generalMap.get("nomalTempDeliver");
                if (nomalDeliverVo != null && nomalDeliverVo.getDeliverDates() != null && nomalDeliverVo.getDeliverDates().size() > 0) {
                    block0: for (int i = 0; i < nomalDeliverVo.getDeliverDates().size(); ++i) {
                        DeliverSoldProductVo nomalDeliverSoldProductVo = nomalDeliverVo.getDeliverDates().get(i);
                        if (coldDeliverVo == null || coldDeliverVo.getDeliverDates() == null || coldDeliverVo.getDeliverDates().size() <= 0) continue;
                        for (DeliverSoldProductVo coldDeliverSoldProductVo : coldDeliverVo.getDeliverDates()) {
                            if (!nomalDeliverSoldProductVo.getTime().equals(coldDeliverSoldProductVo.getTime())) continue;
                            coldDeliverSoldProductVo.getProductForms().addAll(nomalDeliverSoldProductVo.getProductForms());
                            nomalDeliverVo.getDeliverDates().set(i, null);
                            continue block0;
                        }
                    }
                    if (coldDeliverVo != null && coldDeliverVo.getDeliverDates() != null && coldDeliverVo.getDeliverDates().size() > 0) {
                        for (DeliverSoldProductVo deliverSoldProductVo : nomalDeliverVo.getDeliverDates()) {
                            if (deliverSoldProductVo == null) continue;
                            coldDeliverVo.getDeliverDates().add(deliverSoldProductVo);
                        }
                        coldDeliverVo.getDeliverDates().sort((f1, f2) -> String.valueOf(f1.getTime()).compareTo(String.valueOf(f2.getTime())));
                    } else {
                        coldDeliverVo = nomalDeliverVo;
                    }
                }
                returnMap.put("deliver", coldDeliverVo);
                generalMap.remove("coldChainDeliver");
                generalMap.remove("nomalTempDeliver");
            } else if (generalMap.containsKey("nomalTempDeliver")) {
                returnMap.put("deliver", (Serializable)generalMap.get("nomalTempDeliver"));
                generalMap.remove("nomalTempDeliver");
            } else {
                MallShoppingcartVO cartVO2 = new MallShoppingcartVO();
                cartVO2.setOrderSource(OrderSourceEnum.CART.getValue());
                cartVO2.setPlatFormId(platformId);
                cartVO2.setPlatFormGroupId(this.platFormService.getPlatFormGroupId(platformId));
                cartVO2.setDeliverCount(1);
                returnMap.put("deliver", null);
            }
            BigDecimal freightAmount = BigDecimal.ZERO;
            ArrayList<MallFreightCalVo> mallFreightCalVoList = new ArrayList<MallFreightCalVo>();
            String coldchainNotice = "";
            String nomalNotice = "";
            if (coldGroups.get().booleanValue()) {
                coldchainNotice = "\u5df2\u514d\u8fd0\u8d39";
                coldBalanceStatus[0] = "true";
            }
            if (nomalGroups.get().booleanValue()) {
                nomalNotice = "\u5df2\u514d\u8fd0\u8d39";
                nomalBalanceStatus[0] = "true";
            }
            if (!coldGroups.get().booleanValue() || !nomalGroups.get().booleanValue()) {
                if (count[1] + count[2] <= 0) {
                    freightAmount = BigDecimal.ZERO;
                    coldBalanceStatus[0] = "false";
                    nomalBalanceStatus[0] = "false";
                } else {
                    JSONArray freightArray;
                    MallFreightCalVo mallFreightCalVo;
                    if (count[1] + count[2] <= 0) {
                        coldBalanceStatus[0] = "false";
                        nomalBalanceStatus[0] = "false";
                    }
                    int sizeCart = cartVOs.size() - 1;
                    if (count[1] > 0) {
                        mallFreightCalVo = new MallFreightCalVo();
                        mallFreightCalVo.setCityId(addr.getCityId().toString());
                        mallFreightCalVo.setOrderSource(OrderSourceEnum.CART.getValue());
                        mallFreightCalVo.setDeliverId("1");
                        mallFreightCalVo.setPlatFormGroupId(((MallShoppingcartVO)cartVOs.get(0)).getPlatFormGroupId());
                        mallFreightCalVo.setAmount(((MallShoppingcartVO)cartVOs.get(0)).getFactPrice());
                        mallFreightCalVo.setProductId(productIds[0]);
                        mallFreightCalVo.setPromotionId(promotionIds[0]);
                        mallFreightCalVo.setGorupId(groupIds[0]);
                        mallFreightCalVo.setBindCode(((MallShoppingcartVO)cartVOs.get(0)).getBindCode());
                        mallFreightCalVoList.add(mallFreightCalVo);
                    }
                    if (count[2] > 0) {
                        mallFreightCalVo = new MallFreightCalVo();
                        mallFreightCalVo.setCityId(addr.getCityId().toString());
                        mallFreightCalVo.setOrderSource(OrderSourceEnum.CART.getValue());
                        mallFreightCalVo.setDeliverId("2");
                        mallFreightCalVo.setPlatFormGroupId(((MallShoppingcartVO)cartVOs.get(sizeCart)).getPlatFormGroupId());
                        mallFreightCalVo.setAmount(((MallShoppingcartVO)cartVOs.get(sizeCart)).getFactPrice());
                        mallFreightCalVo.setProductId(productIds[0]);
                        mallFreightCalVo.setPromotionId(promotionIds[0]);
                        mallFreightCalVo.setGorupId(groupIds[0]);
                        mallFreightCalVo.setBindCode(((MallShoppingcartVO)cartVOs.get(0)).getBindCode());
                        mallFreightCalVoList.add(mallFreightCalVo);
                    }
                    if ((freightArray = this.mallFreightService.getFreightByCityAmountDeliveryType(mallFreightCalVoList)) != null && freightArray.size() > 0) {
                        for (JSONObject freightObject : freightArray) {
                            String freightAmountStr = freightObject.getString("freightAmount");
                            String deliveryType = freightObject.getString("deliveryType");
                            if ("1".equals(deliveryType)) {
                                coldchainNotice = freightObject.getString("coldchainNotice");
                                coldBalanceStatus[0] = freightObject.getString("coldBalanceStatus");
                                freightAmount = freightAmount.add(new BigDecimal(freightAmountStr));
                                if (StringUtils.isNotEmpty((String)coldFullCutNotice[0]) && new BigDecimal(freightAmountStr).intValue() == 0) {
                                    coldchainNotice = coldFullCutNotice[0];
                                }
                            }
                            if (!"2".equals(deliveryType)) continue;
                            nomalNotice = freightObject.getString("nomalNotice");
                            nomalBalanceStatus[0] = freightObject.getString("nomalBalanceStatus");
                            freightAmount = freightAmount.add(new BigDecimal(freightAmountStr));
                            if (!StringUtils.isNotEmpty((String)nomalFullCutNotice[0]) || new BigDecimal(freightAmountStr).intValue() != 0) continue;
                            nomalNotice = nomalFullCutNotice[0];
                        }
                    } else {
                        freightAmount = BigDecimal.ZERO;
                        coldBalanceStatus[0] = "true";
                        nomalBalanceStatus[0] = "true";
                    }
                }
            }
            if ("true".equals(nomalBalanceStatus[0]) && "true".equals(coldBalanceStatus[0])) {
                balanceStatus = "1";
            }
            if (balanceStatusFlag[0] == 1 && balanceStatusFlag[1] == 1) {
                balanceStatus = "3";
            }
            generalMap.put("coldchainNotice", coldchainNotice);
            generalMap.put("nomalNotice", nomalNotice);
            generalMap.put("nomalBalanceStatus", nomalBalanceStatus[0]);
            generalMap.put("coldBalanceStatus", coldBalanceStatus[0]);
            generalMap.put("balanceStatus", balanceStatus);
            generalMap.put("count", count[0]);
            generalMap.put("invalidCount", count[4]);
            generalMap.put("coldchainCount", count[1]);
            generalMap.put("nomalCount", count[2]);
            generalMap.put("price", price[0]);
            generalMap.put("factPrice", PriceUtils.subtract((BigDecimal)factPrice[0], (BigDecimal)fullCutAmount[0]));
            generalMap.put("totalQuantity", count[3]);
            generalMap.put("totalQuantityWithUncheck", count[5]);
            generalMap.put("sort", generalSort);
            generalMap.put("freight", freightAmount);
            generalMap.put("commodityTotalPrice", price[0]);
            int totalQuantity = 0;
            int totalQuantityWithUncheck = 0;
            returnMap.put("address", addr);
            totalQuantity = count[3];
            totalQuantityWithUncheck = count[5];
            returnMap.put("totalQuantity", Integer.valueOf(totalQuantity));
            returnMap.put("totalQuantityWithUncheck", Integer.valueOf(totalQuantityWithUncheck));
            returnMap.put("generalCart", generalMap);
            result.setValue(returnMap);
            long endTime = System.currentTimeMillis();
            long time = endTime - startTime;
            if (time > 1000L) {
                logger.info("*************************cc.lechun.mall.service.shoppingcart.buildCart.Time*************************time={}", (Object)time);
            }
            return result;
        }
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WriteDataSource
    public BaseJsonVo addCart(Integer platformId, String customerId, Integer salesType, String salesId, String activeNo, Integer quantity, Boolean isQuick, String shoppingType) {
        logger.info("=====================addCart\u8abf\u7528\u6b21\u6578==================");
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        try {
            boolean tryLock;
            block37: {
                block36: {
                    MallShoppingcartEntity entity;
                    block38: {
                        block35: {
                            block39: {
                                block41: {
                                    block40: {
                                        tryLock = this.mallRedisLock.tryLock("mall_shopping_cart_entity", "mallShoppingcartEntity", 60000L);
                                        long startTime = System.nanoTime();
                                        logger.info("==============\u8bbe\u7f6e\u9501====tryLock={},\u6642\u9593\u958b\u59cbstartTime={}", (Object)tryLock, (Object)startTime);
                                        if (!tryLock) break block37;
                                        entity = this.cartMapper.getAddProduct(customerId, salesType, salesId, isQuick == null || isQuick == false ? "0" : "1", shoppingType);
                                        if (quantity <= 0) break block38;
                                        if (entity != null) break block39;
                                        entity = new MallShoppingcartEntity();
                                        entity.setCustomerId(customerId);
                                        entity.setShoppingType(shoppingType);
                                        entity.setPromotionId(SalesTypeEnum.SALES_PROMOTION.getValue() == salesType.intValue() ? salesId : "");
                                        entity.setChannelId(1);
                                        if (SalesTypeEnum.SALES_PROMOTION.getValue() != salesType.intValue()) break block40;
                                        MallPromotionProductEntity product = this.promotionProductService.getPromotionProductEntity(salesId);
                                        if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(product.getProductType())) {
                                            entity.setGroupType(SalesTypeEnum.SALES_PRODUCT.getValue());
                                            entity.setProductId(product.getProductId());
                                            break block41;
                                        } else if (String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(product.getProductType())) {
                                            entity.setGroupType(SalesTypeEnum.SALES_GROUP.getValue());
                                            entity.setGroupId(product.getProductId());
                                        }
                                        break block41;
                                    }
                                    if (SalesTypeEnum.SALES_PRODUCT.getValue() == salesType.intValue()) {
                                        entity.setGroupType(salesType);
                                        entity.setProductId(salesId);
                                    } else if (SalesTypeEnum.SALES_GROUP.getValue() == salesType.intValue()) {
                                        entity.setGroupType(salesType);
                                        entity.setGroupId(salesId);
                                    }
                                }
                                entity.setQuantity(0);
                                entity.setCreateTime(DateUtils.now());
                                entity.setUpdateTime(entity.getCreateTime());
                                entity.setActiveNo(activeNo);
                                entity.setActiveName(activeNo);
                                entity.setSalesType(salesType);
                                entity.setSalesId(salesId);
                                entity.setChecked(1);
                                String speedupStr = isQuick != false ? "1" : "0";
                                logger.info("isQuick={},speedupStr={}", (Object)isQuick, (Object)speedupStr);
                                entity.setSpeedUp(speedupStr);
                                entity.setUniqueId(platformId + customerId + speedupStr + salesId + shoppingType);
                                entity.setPlatformGroupId(this.platFormService.getPlatFormGroupId(platformId));
                            }
                            if (SalesTypeEnum.SALES_PRODUCT.getValue() == salesType.intValue()) {
                                BaseJsonVo<MallProductVO> productSR = this.productService.buildProductVO(entity.getSalesId(), entity.getQuantity() + quantity, null, null, null, null, false, false, entity.getSpeedUp(), null);
                                if (productSR.isSuccess() && productSR.getValue() != null) {
                                    entity.setTransportType(((MallProductVO)productSR.getValue()).getTransportType());
                                    break block35;
                                } else {
                                    result.setError("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728");
                                    BaseJsonVo baseJsonVo = result;
                                    return baseJsonVo;
                                }
                            }
                            if (SalesTypeEnum.SALES_GROUP.getValue() == salesType.intValue()) {
                                BaseJsonVo<MallGroupVO> groupSR = this.groupService.buildGroupVO(salesId, entity.getQuantity() + quantity, false);
                                if (groupSR.isSuccess() && groupSR != null) {
                                    MallGroupVO group = (MallGroupVO)groupSR.getValue();
                                    if (!group.getValid().booleanValue()) {
                                        result.setError(group.getInvalidReason());
                                        BaseJsonVo baseJsonVo = result;
                                        return baseJsonVo;
                                    }
                                    boolean hasCold = group.getProductList().stream().anyMatch(pro -> pro.getTransportType() == 1);
                                    entity.setTransportType(hasCold ? 1 : 2);
                                    break block35;
                                } else {
                                    result.setError("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728");
                                    BaseJsonVo group = result;
                                    return group;
                                }
                            }
                            if (SalesTypeEnum.SALES_PROMOTION.getValue() == salesType.intValue()) {
                                BaseJsonVo promotionSR = this.promotionService.buildPromotionVO(salesId, entity.getQuantity() + quantity, false);
                                if (!promotionSR.isSuccess()) {
                                    result.setError("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728");
                                    BaseJsonVo baseJsonVo = result;
                                    return baseJsonVo;
                                }
                                MallPromotionVO promotion = (MallPromotionVO)promotionSR.getValue();
                                if (!promotion.getValid().booleanValue()) {
                                    result.setError(promotion.getInvalidReason());
                                    BaseJsonVo hasCold = result;
                                    return hasCold;
                                }
                                if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(promotion.getProductType())) {
                                    MallProductVO product = promotion.getProduct();
                                    entity.setTransportType(product.getTransportType());
                                } else {
                                    if (!String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(promotion.getProductType())) {
                                        result.setError("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728");
                                        BaseJsonVo baseJsonVo = result;
                                        return baseJsonVo;
                                    }
                                    MallGroupVO group = promotion.getGroup();
                                    boolean hasCold = group.getProductList().stream().anyMatch(pro -> pro.getTransportType() == 1);
                                    entity.setTransportType(hasCold ? 1 : 2);
                                }
                            }
                        }
                        entity.setQuantity(entity.getQuantity() + quantity);
                        logger.info("------------addCart----------------Quantity={}", (Object)entity.getQuantity());
                        if (entity.getShoppingId() == null) {
                            logger.info("------------addCart----------------entity={}", (Object)JSON.toJSONString((Object)entity));
                            this.cartMapper.insert(entity);
                            break block36;
                        } else {
                            entity.setChecked(1);
                            this.cartMapper.updateByPrimaryKeySelective(entity);
                        }
                        break block36;
                    }
                    if (entity == null) {
                        BaseJsonVo promotionSR = result;
                        return promotionSR;
                    }
                    if (entity.getQuantity() > 0 && entity.getQuantity() > Math.abs(quantity)) {
                        entity.setQuantity(entity.getQuantity() + quantity);
                        entity.setChecked(1);
                        this.cartMapper.updateByPrimaryKeySelective(entity);
                    } else {
                        BaseJsonVo removeResult = this.removeCartProduct(entity.getShoppingId());
                        if (!removeResult.isSuccess()) {
                            result.setError(removeResult.getError_msg());
                        }
                    }
                }
                this.removeCache(customerId);
            }
            long endTime = System.nanoTime();
            logger.info("==============\u8bbe\u7f6e\u9501====tryLock={},\u6642\u9593\u7d50\u675fendTime={}", (Object)tryLock, (Object)endTime);
            logger.info("===================\u67b7\u9396\u4ee3\u78bc\u584a\u57f7\u884c\u5b8c\u7562=================");
            return result;
        }
        finally {
            logger.info("===============redisLock.unlock============");
            this.mallRedisLock.unlock("mall_shopping_cart_entity");
        }
    }

    @Override
    public BaseJsonVo removeCartProduct(Integer shoppingId) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        MallShoppingcartEntity entity = (MallShoppingcartEntity)this.cartMapper.selectByPrimaryKey(shoppingId);
        if (entity == null) {
            return result;
        }
        int affectedRows = this.cartMapper.deleteByPrimaryKey(shoppingId);
        if (affectedRows > 0) {
            return result;
        }
        result.setError("\u5220\u9664\u5931\u8d25");
        return result;
    }

    @Override
    public BaseJsonVo removeCartProduct(String customerId, String saleId, String shoppingType) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        int affectedRows = this.cartMapper.deleteCartProduct(customerId, saleId, shoppingType);
        this.removeCache(customerId);
        if (affectedRows > 0) {
            return result;
        }
        result.setError("\u5220\u9664\u5931\u8d25");
        return result;
    }

    @Override
    public BaseJsonVo removeCartInvalid(Integer platformId, String customerId, String shoppingType) {
        BaseJsonVo<List<MallShoppingcartVO>> sr = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platformId, customerId, false, shoppingType);
        if (sr.isSuccess()) {
            List cartList = (List)sr.getValue();
            cartList.forEach(cart -> {
                cart.getProducts().forEach(product -> {
                    if (!product.getValid().booleanValue()) {
                        this.removeCartProduct(customerId, product.getProId(), shoppingType);
                    }
                });
                cart.getGroups().forEach(group -> {
                    if (!group.getValid().booleanValue()) {
                        this.removeCartProduct(customerId, group.getGroupId(), shoppingType);
                    }
                });
                cart.getPromotions().forEach(promotion -> {
                    if (!promotion.getValid().booleanValue()) {
                        this.removeCartProduct(customerId, promotion.getPromotionId(), shoppingType);
                    }
                });
            });
        }
        this.removeCache(customerId);
        return sr;
    }

    @Override
    public BaseJsonVo removeCartChecked(Integer platformId, String customerId, Boolean checked, Integer isQuick, String shoppingType) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        logger.info("customerId={},checked={},isQuick={}", new Object[]{customerId, checked, isQuick});
        int rmCount = this.cartMapper.removeChecked(customerId, checked, isQuick, shoppingType);
        if (rmCount == 0) {
            result.setError("\u6e05\u9664\u8d2d\u7269\u8f66\u5931\u8d25");
        } else {
            this.dataSyncInterface.producerData(customerId, DataSyncTypeEnum.BI_CART, "\u8d2d\u7269\u8f66\u540c\u6b65");
            result.setValue((Object)rmCount);
        }
        this.removeCache(customerId);
        return result;
    }

    @Override
    public BaseJsonVo findAddOnProducts(Integer platformId, String customerId, Integer selfMadeType, String shoppingType) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ArrayList addOnProducts = new ArrayList();
        List<MallProductEntity> allProducts = this.productService.getOnAndShowProductList(this.platFormService.getPlatForm(platformId).getPlatformGroupId());
        List<MallShoppingcartEntity> cartProducts = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_PRODUCT.getValue(), false, shoppingType);
        if (allProducts != null && cartProducts != null && allProducts.size() > 0) {
            allProducts.forEach(allProduct -> {
                BaseJsonVo<MallProductVO> prosr;
                List filterList;
                if (selfMadeType.equals(allProduct.getSelfMadeType()) && ((filterList = cartProducts.stream().filter(cartProduct -> cartProduct.getSalesId().equals(allProduct.getProId())).collect(Collectors.toList())) == null || filterList.size() == 0) && (prosr = this.productService.buildProductVO(allProduct.getProId(), 1, null, null, null, null, false, false, null, null)).isSuccess()) {
                    addOnProducts.add((MallProductVO)prosr.getValue());
                }
            });
        }
        returnMap.put("addOnProducts", addOnProducts);
        BaseJsonVo<List<MallShoppingcartVO>> sr = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platformId, customerId, false, shoppingType);
        if (sr.isSuccess()) {
            List cartVOs = (List)sr.getValue();
            cartVOs.get(selfMadeType - 1);
            returnMap.put("notice", "");
            returnMap.put("count", ((MallShoppingcartVO)cartVOs.get(selfMadeType - 1)).getProducts().size() + ((MallShoppingcartVO)cartVOs.get(selfMadeType - 1)).getGroups().size() + ((MallShoppingcartVO)cartVOs.get(selfMadeType - 1)).getPromotions().size());
            returnMap.put("price", ((MallShoppingcartVO)cartVOs.get(selfMadeType - 1)).getPrice());
            returnMap.put("factPrice", ((MallShoppingcartVO)cartVOs.get(selfMadeType - 1)).getFactPrice());
            result.setValue(returnMap);
            return result;
        }
        return sr;
    }

    @Override
    public BaseJsonVo checkCart(Integer platformId, String customerId, Integer checkType, String salesId, String shoppingType) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        if (1 == checkType) {
            this.cartMapper.checkAll(customerId, true, shoppingType);
        } else if (-1 == checkType) {
            this.cartMapper.checkAll(customerId, false, shoppingType);
        } else if (2 == checkType) {
            BaseJsonVo<List<MallShoppingcartVO>> sr = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platformId, customerId, false, shoppingType);
            if (sr.isSuccess()) {
                List shoppingcartVOs = (List)sr.getValue();
                MallShoppingcartVO coldChainCart = (MallShoppingcartVO)shoppingcartVOs.get(0);
                coldChainCart.getProducts().forEach(product -> this.cartMapper.checkProduct(customerId, product.getProId(), true, shoppingType));
                coldChainCart.getGroups().forEach(group -> this.cartMapper.checkProduct(customerId, group.getGroupId(), true, shoppingType));
                coldChainCart.getPromotions().forEach(promotion -> this.cartMapper.checkProduct(customerId, promotion.getPromotionId(), true, shoppingType));
            }
        } else if (-2 == checkType) {
            BaseJsonVo<List<MallShoppingcartVO>> sr = this.buildShoppingcartFromShoppingcart(platformId, customerId, false, shoppingType);
            if (sr.isSuccess()) {
                List shoppingcartVOs = (List)sr.getValue();
                MallShoppingcartVO coldChainCart = (MallShoppingcartVO)shoppingcartVOs.get(0);
                coldChainCart.getProducts().forEach(product -> this.cartMapper.checkProduct(customerId, product.getProId(), false, shoppingType));
                coldChainCart.getGroups().forEach(group -> this.cartMapper.checkProduct(customerId, group.getGroupId(), false, shoppingType));
                coldChainCart.getPromotions().forEach(promotion -> this.cartMapper.checkProduct(customerId, promotion.getPromotionId(), false, shoppingType));
            }
        } else if (3 == checkType) {
            BaseJsonVo<List<MallShoppingcartVO>> sr = this.buildShoppingcartFromShoppingcart(platformId, customerId, false, shoppingType);
            if (sr.isSuccess()) {
                List shoppingcartVOs = (List)sr.getValue();
                MallShoppingcartVO nomalCart = (MallShoppingcartVO)shoppingcartVOs.get(1);
                nomalCart.getProducts().forEach(product -> this.cartMapper.checkProduct(customerId, product.getProId(), true, shoppingType));
                nomalCart.getGroups().forEach(group -> this.cartMapper.checkProduct(customerId, group.getGroupId(), true, shoppingType));
                nomalCart.getPromotions().forEach(promotion -> this.cartMapper.checkProduct(customerId, promotion.getPromotionId(), true, shoppingType));
            }
        } else if (-3 == checkType) {
            BaseJsonVo<List<MallShoppingcartVO>> sr = this.buildShoppingcartFromShoppingcart(platformId, customerId, false, shoppingType);
            if (sr.isSuccess()) {
                List shoppingcartVOs = (List)sr.getValue();
                MallShoppingcartVO nomalCart = (MallShoppingcartVO)shoppingcartVOs.get(1);
                nomalCart.getProducts().forEach(product -> this.cartMapper.checkProduct(customerId, product.getProId(), false, shoppingType));
                nomalCart.getGroups().forEach(group -> this.cartMapper.checkProduct(customerId, group.getGroupId(), false, shoppingType));
                nomalCart.getPromotions().forEach(promotion -> this.cartMapper.checkProduct(customerId, promotion.getPromotionId(), false, shoppingType));
            }
        } else if (4 == checkType) {
            this.cartMapper.checkProduct(customerId, salesId, true, shoppingType);
        } else if (-4 == checkType) {
            this.cartMapper.checkProduct(customerId, salesId, false, shoppingType);
        }
        this.removeCache(customerId);
        return result;
    }

    @Override
    public List<Object> findRecommends(Integer platformGroupId, String shoppingType) {
        ArrayList<Object> objs = new ArrayList<Object>();
        List<Map> products = this.productService.findRecommendProducts(platformGroupId);
        List<Map> groups = this.groupService.findRecommendGroups(platformGroupId);
        List<Map> promotions = this.promotionService.findRecommendPromotions(platformGroupId);
        if (products != null && products.size() > 0) {
            objs.addAll(products);
        }
        if (groups != null && groups.size() > 0) {
            objs.addAll(groups);
        }
        if (promotions != null && promotions.size() > 0) {
            objs.addAll(promotions);
        }
        return objs;
    }

    @Override
    public BaseJsonVo buildEmptyCart() {
        BaseJsonVo sr = BaseJsonVo.success((Object)"");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("address", null);
        map.put("deliver", null);
        map.put("coldchainCount", 0);
        map.put("count", 0);
        map.put("factPrice", 0);
        map.put("freight", 0);
        map.put("invalidCount", 0);
        map.put("nomalCount", 0);
        map.put("price", 0);
        map.put("totalQuantity", 0);
        map.put("totalQuantityWithUncheck", 0);
        map.put("shoppingType", 0);
        sr.setValue(map);
        return sr;
    }

    private void removeCache(String customerId) {
        this.memcachedService.delete("shoppingcart", new String[]{customerId, String.valueOf(true)});
        this.memcachedService.delete("shoppingcart", new String[]{customerId, String.valueOf(false)});
    }

    @Override
    public MallShoppingcartEntity getShoppingCart(String customerId, String salesId, String shoppingType) {
        MallShoppingcartEntity search = new MallShoppingcartEntity();
        search.setCustomerId(customerId);
        search.setProductId(salesId);
        search.setShoppingType(shoppingType);
        return (MallShoppingcartEntity)this.cartMapper.getSingle(search);
    }

    @Override
    public MallShoppingcartEntity getShoppingCart(String customerId, String salesId, Integer itemType, String shoppingType) {
        MallShoppingcartEntity search = new MallShoppingcartEntity();
        search.setCustomerId(customerId);
        if (Objects.equals(itemType, SalesTypeEnum.SALES_PRODUCT.getValue())) {
            search.setProductId(salesId);
        } else if (Objects.equals(itemType, SalesTypeEnum.SALES_PROMOTION.getValue())) {
            search.setPromotionId(salesId);
        }
        search.setShoppingType(shoppingType);
        return (MallShoppingcartEntity)this.cartMapper.getSingle(search);
    }

    @Override
    public List<MallShoppingcartEntity> getShoppingCart(String customerId, String shoppingType) {
        MallShoppingcartEntity search = new MallShoppingcartEntity();
        search.setCustomerId(customerId);
        search.setShoppingType(shoppingType);
        return this.cartMapper.getList(search);
    }

    @Override
    public List<MallOrderCacheInItemVo> getCacheInItemVoByShoppingCart(String customerId, @Nullable String salesId, String shoppingType) {
        MallShoppingcartEntity search = new MallShoppingcartEntity();
        if (StringUtils.isEmpty((String)customerId) || StringUtils.isEmpty((String)shoppingType)) {
            return new ArrayList<MallOrderCacheInItemVo>();
        }
        search.setCustomerId(customerId);
        search.setProductId(salesId);
        search.setShoppingType(shoppingType);
        List cartList = this.cartMapper.getList(search);
        ArrayList<MallOrderCacheInItemVo> cacheInItemVos = new ArrayList<MallOrderCacheInItemVo>();
        for (MallShoppingcartEntity c : cartList) {
            MallOrderCacheInItemVo itemVo = new MallOrderCacheInItemVo();
            if (Objects.equals(c.getSalesType(), SalesTypeEnum.SALES_PRODUCT.getValue())) {
                itemVo.setItemId(c.getProductId());
            } else if (Objects.equals(c.getSalesType(), SalesTypeEnum.SALES_PROMOTION.getValue())) {
                itemVo.setItemId(c.getPromotionId());
            }
            itemVo.setItemType(c.getSalesType());
            itemVo.setQuantity(c.getQuantity());
            cacheInItemVos.add(itemVo);
        }
        return cacheInItemVos;
    }
}

