/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.shoppingcart;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.UuidUtil;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.shoppingcart.ShoppingcartSoldoutRecordMapper;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.deliver.DeliverVo;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.shoppingcart.ShoppingcartSoldoutRecordEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.shoppingcart.ShoppingcartSoldoutRecordInterface;
import cc.lechun.mall.service.deliver.DeliverProductVo;
import cc.lechun.mall.service.deliver.GroupProductEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ShoppingcartSoldoutRecordService
extends BaseService<ShoppingcartSoldoutRecordEntity, Integer>
implements ShoppingcartSoldoutRecordInterface {
    @Resource
    private ShoppingcartSoldoutRecordMapper shoppingcartSoldoutRecordMapper;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;

    @Override
    public void recode(List<GroupProductEntity> gpList, MallShoppingcartVO shoppingcartVO, DeliverVo deliverVo, CustomerAddressVo addressVo, int saleOutType) {
        this.logger.info("\u5f00\u59cb\u4fdd\u5b58\u7f3a\u8d27\u65e5\u5fd71");
        String requestId = UuidUtil.get32UUID();
        Date now = DateUtils.now();
        gpList.forEach(pro -> {
            if (pro.getInventory() != 1) {
                ShoppingcartSoldoutRecordEntity record = new ShoppingcartSoldoutRecordEntity();
                record.setRequestId(requestId);
                record.setCreateTime(now);
                record.setCustomerId(shoppingcartVO.getCustomerId());
                record.setProvince(addressVo.getProvinceName());
                record.setCity(addressVo.getCityName());
                record.setArea(addressVo.getAreaName());
                record.setProductCount(pro.getQuantity());
                record.setProductId(pro.getProductId());
                record.setProductName(pro.getProductName());
                record.setGroupId(pro.getGroupId());
                record.setGroupName(StringUtils.isEmpty((String)record.getGroupId()) ? "" : this.groupInterface.getGroup(record.getGroupId()).getGroupName());
                record.setPromotionId(pro.getPromotionId());
                record.setPromotionName(StringUtils.isEmpty((String)record.getPromotionId()) ? "" : this.promotionInterface.getPromotion(record.getPromotionId()).getPromotionName());
                record.setGplistStr(JsonUtils.toJson((Object)gpList, (boolean)false));
                record.setShoppintcartStr(JsonUtils.toJson((Object)shoppingcartVO, (boolean)false));
                record.setDelivervoStr(JsonUtils.toJson((Object)deliverVo, (boolean)false));
                record.setSaleOutType(saleOutType);
                this.logger.info("\u5f00\u59cb\u4fdd\u5b58\u7f3a\u8d27\u65e5\u5fd72");
                this.shoppingcartSoldoutRecordMapper.insert(record);
            }
        });
        this.logger.info("\u7ed3\u675f\u4fdd\u5b58\u7f3a\u8d27\u65e5\u5fd7");
    }

    @Override
    @Async
    public void saveSaleOut(JSONObject objectResult, MallShoppingcartVO shoppingcartVO, DeliverVo deliverVo, CustomerAddressVo addressVo, int saleOutType) {
        try {
            JSONArray jsonArrayProduct = (JSONArray)objectResult.get((Object)"wxProductForms");
            if (jsonArrayProduct != null && jsonArrayProduct.size() > 0 && deliverVo.getSpeedupInventory() != 1) {
                List deliverProductVoList = JSON.parseArray((String)jsonArrayProduct.toJSONString(), DeliverProductVo.class);
                String requestId = UuidUtil.get32UUID();
                Date now = DateUtils.now();
                for (DeliverProductVo deliverProductVo : deliverProductVoList) {
                    if (!StringUtils.isEmpty((String)deliverProductVo.getDeliverDate())) continue;
                    ShoppingcartSoldoutRecordEntity record = new ShoppingcartSoldoutRecordEntity();
                    record.setRequestId(requestId);
                    record.setCreateTime(now);
                    record.setCustomerId(shoppingcartVO.getCustomerId());
                    record.setProvince(addressVo.getProvinceName());
                    record.setCity(addressVo.getCityName());
                    record.setArea(addressVo.getAreaName());
                    record.setProductCount(deliverProductVo.getProductCount());
                    record.setProductId(deliverProductVo.getProId());
                    record.setProductName(deliverProductVo.getProductName());
                    record.setGroupId("");
                    record.setGroupName(StringUtils.isEmpty((String)record.getGroupId()) ? "" : this.groupInterface.getGroup(record.getGroupId()).getGroupName());
                    record.setPromotionId("");
                    record.setPromotionName(StringUtils.isEmpty((String)record.getPromotionId()) ? "" : this.promotionInterface.getPromotion(record.getPromotionId()).getPromotionName());
                    record.setGplistStr(JsonUtils.toJson((Object)deliverProductVoList, (boolean)false));
                    record.setShoppintcartStr(JsonUtils.toJson((Object)shoppingcartVO, (boolean)false));
                    record.setDelivervoStr(JsonUtils.toJson((Object)deliverVo, (boolean)false));
                    record.setSaleOutType(saleOutType);
                    this.logger.info("\u4fdd\u5b58\u7f3a\u8d27\u8bb0\u5f55:{}", (Object)JsonUtils.toJson((Object)record, (boolean)false));
                    this.shoppingcartSoldoutRecordMapper.insert(record);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.info("\u7ed3\u675f\u4fdd\u5b58\u7f3a\u8d27\u65e5\u5fd7");
    }
}

