/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.thirdparty;

import cc.lechun.framework.common.utils.http.HttpComponentUtil;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OldApiUtil {
    private Log log = LogFactory.getLog(OldApiUtil.class);
    @Value(value="${lechun.oldapi.domain:}")
    private String host;

    public Map<String, Object> sendCashTicket(String customerId, String bindCode) throws IOException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("customerId", customerId);
        param.put("bindcode", bindCode);
        String json = HttpComponentUtil.execute((HttpRequest)new HttpRequest(this.host + "mallcashticket/sendcashticket", param));
        if (json == null) {
            this.log.error((Object)("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25 \uff1a " + this.host + "mallcashticket/sendcashticket"));
            this.log.error((Object)("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25 \uff1a " + ((Object)param).toString()));
        } else {
            Map result = (Map)JsonUtils.fromJson((String)json, Map.class);
            if ("1".equals(result.get("status"))) {
                return (Map)result.get("cash");
            }
        }
        return null;
    }

    public Boolean orderRefund(String orderMainNo, String orderNo, String selReason, int refundOrderType, int totalAmount) throws IOException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderMainNo", orderMainNo);
        param.put("orderNo", orderNo);
        param.put("selReason", selReason);
        param.put("refundOrderType", refundOrderType);
        param.put("totalAmount", totalAmount);
        String json = HttpComponentUtil.execute((HttpRequest)new HttpRequest(this.host + "mallorder/orderRefund", param));
        if (json == null) {
            this.log.error((Object)("\u8c03\u7528ERP\u9000\u6b3e\u5931\u8d25 \uff1a " + JsonUtils.toJson(param, (boolean)false)));
        } else {
            Map result = (Map)JsonUtils.fromJson((String)json, Map.class);
            if ("1".equals(result.get("success"))) {
                return true;
            }
        }
        return false;
    }

    @Async
    public void sendRedpackageRechange(String orderMainNo, String customerId) throws IOException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("orderNo", orderMainNo);
        param.put("customerId", customerId);
        HttpComponentUtil.execute((HttpRequest)new HttpRequest(this.host + "mallredpackets/sendRedpackageRechange", param));
    }

    @Async
    public void pushMessageAfterOrder(String orderMainNo, String customerId) throws IOException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("orderNo", orderMainNo);
        param.put("customerId", customerId);
        HttpComponentUtil.execute((HttpRequest)new HttpRequest(this.host + "mallcustomerqrcode/pushMessageAfterOrder", param));
    }

    @Async
    public void activePaySuccessRecord(String orderMainNo, String customerId) throws IOException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("orderNo", orderMainNo);
        param.put("customerId", customerId);
        HttpComponentUtil.execute((HttpRequest)new HttpRequest(this.host + "mallactive/activePaySuccessRecord", param));
    }
}

