/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerOpenidEntity;
import cc.lechun.mall.entity.deliver.LogisticsEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerOpenidInterface;
import cc.lechun.mall.iservice.deliver.LogisticsInterface;
import cc.lechun.mall.iservice.trade.MallMiniShopInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.shop.LogisticsAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.shop.logistics.Logistics;
import weixin.popular.bean.shop.logistics.LogisticsListResult;

@Service
public class MallMiniShopService
extends BaseService
implements MallMiniShopInterface {
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private CustomerOpenidInterface customerOpenidInterface;
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private LogisticsInterface logisticsInterface;

    @Override
    public BaseJsonVo orderSend(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!Integer.valueOf(1).equals(orderMainEntity.getMiniShop())) {
            return BaseJsonVo.success((Object)"\u4e0d\u662f\u5c0f\u5546\u5e97\u8ba2\u5355\uff0c\u4e0d\u540c\u6b65");
        }
        CustomerOpenidEntity search = new CustomerOpenidEntity();
        search.setCustomerId(orderMainEntity.getCustomerId());
        search.setPlatformId(orderMainEntity.getPlatformId());
        CustomerOpenidEntity customerOpenidEntity = (CustomerOpenidEntity)this.customerOpenidInterface.getSingle(search);
        if (customerOpenidEntity == null) {
            return BaseJsonVo.error((String)"\u7528\u6237OPENID\u4e0d\u5b58\u5728");
        }
        List<MallOrderEntity> orderEntityList = this.orderInterface.getOrderList(orderMainNo);
        Integer finishAll = 0;
        ArrayList<Logistics> delivery = new ArrayList<Logistics>();
        for (MallOrderEntity o : orderEntityList) {
            if (!StringUtils.isNotEmpty((String)o.getDeliverId()) || !StringUtils.isNotEmpty((String)o.getWaybillNo())) continue;
            Logistics loginstics = new Logistics();
            LogisticsEntity logisticsEntity = (LogisticsEntity)this.logisticsInterface.selectByPrimaryKey((Serializable)((Object)o.getDeliverId()));
            if (logisticsEntity == null) {
                loginstics.setDelivery_id("OTHERS");
            } else if (StringUtils.isEmpty((String)logisticsEntity.getShopId())) {
                loginstics.setDelivery_id("OTHERS");
            } else {
                loginstics.setDelivery_id(logisticsEntity.getShopId());
            }
            loginstics.setWaybill_id(o.getWaybillNo());
            delivery.add(loginstics);
        }
        if (delivery.size() == orderEntityList.size()) {
            finishAll = 1;
        }
        String accessToken = this.weiXinBaseInterface.getAccessTokenByPlatformId(orderMainEntity.getPlatformId()).getAccessToken();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("out_order_id", orderMainNo);
        map.put("openid", customerOpenidEntity.getOpenId());
        map.put("finish_all_delivery", finishAll);
        map.put("delivery_list", delivery);
        BaseResult baseResult = LogisticsAPI.orderSend((String)accessToken, (String)JsonUtils.toJson(map, (boolean)false));
        this.logger.info("********MiniShopService.orderSend********param:{},result:{}", (Object)JsonUtils.toJson(map, (boolean)false), (Object)JsonUtils.toJson((Object)baseResult, (boolean)false));
        if (baseResult.isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)(baseResult.getErrcode() + baseResult.getErrmsg()));
    }

    @Override
    public BaseJsonVo orderSendByOrderNo(String orderNo) {
        MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
        if (orderEntity != null) {
            return this.orderSend(orderEntity.getOrderMainNo());
        }
        return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
    }

    @Override
    public BaseJsonVo orderRecieve(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        CustomerOpenidEntity search = new CustomerOpenidEntity();
        search.setCustomerId(orderMainEntity.getCustomerId());
        search.setPlatformId(orderMainEntity.getPlatformId());
        CustomerOpenidEntity customerOpenidEntity = (CustomerOpenidEntity)this.customerOpenidInterface.getSingle(search);
        if (customerOpenidEntity == null) {
            return BaseJsonVo.error((String)"\u7528\u6237OPENID\u4e0d\u5b58\u5728");
        }
        String accessToken = this.weiXinBaseInterface.getAccessTokenByPlatformId(orderMainEntity.getPlatformId()).getAccessToken();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("out_order_id", orderMainNo);
        map.put("openid", customerOpenidEntity.getOpenId());
        BaseResult baseResult = LogisticsAPI.orderRecieve((String)accessToken, (String)JsonUtils.toJson(map, (boolean)false));
        this.logger.info("********MiniShopService.orderRecieve********param:{},result:{}", (Object)JsonUtils.toJson(map, (boolean)false), (Object)JsonUtils.toJson((Object)baseResult, (boolean)false));
        if (baseResult.isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)(baseResult.getErrcode() + baseResult.getErrmsg()));
    }

    @Override
    @ReadThroughSingleCache(namespace="cc.lechun.mall.service.trade.MallMiniShopService.getLogisticsList", expiration=86400)
    public BaseJsonVo getLogisticsList() {
        String accessToken = this.weiXinBaseInterface.getAccessTokenByPlatformId(4).getAccessToken();
        LogisticsListResult baseResult = LogisticsAPI.getLogisticsList((String)accessToken);
        if (baseResult.isSuccess()) {
            return BaseJsonVo.success((Object)baseResult.getCompany_list());
        }
        return BaseJsonVo.error((String)(baseResult.getErrcode() + baseResult.getErrmsg()));
    }
}

