/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.mall.dao.trade.MallOrderCacheMapper;
import cc.lechun.mall.entity.trade.MallOrderCacheEntity;
import cc.lechun.mall.iservice.trade.MallOrderCacheInterface;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderCacheService
implements MallOrderCacheInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallOrderCacheMapper orderCacheMapper;
    @Autowired
    private RedisCacheUtil redisCacheUtil;

    @Override
    public MallOrderCacheEntity getOrderCacheEntity(String cacheId) {
        this.logger.info("\u67e5\u8be2\u8ba2\u5355\u7f13\u5b58:{}", (Object)cacheId);
        try {
            Object o = this.redisCacheUtil.get(cacheId);
            if (o != null) {
                MallOrderCacheEntity orderCacheEntity = new MallOrderCacheEntity();
                orderCacheEntity.setCacheId(cacheId);
                orderCacheEntity.setCacheContent(o.toString());
                orderCacheEntity.setCreateTime(DateUtils.now());
                return orderCacheEntity;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (MallOrderCacheEntity)this.orderCacheMapper.selectByPrimaryKey((Serializable)((Object)cacheId));
    }

    @Override
    public Boolean insertOrderCacheEntity(String cacheId, String cacheContent) {
        MallOrderCacheEntity orderCacheEntity = new MallOrderCacheEntity();
        orderCacheEntity.setCacheId(cacheId);
        orderCacheEntity.setCacheContent(cacheContent);
        orderCacheEntity.setCreateTime(DateUtils.now());
        this.redisCacheUtil.set(cacheId, (Object)cacheContent, Long.valueOf(7200L));
        return this.orderCacheMapper.insertSelective(orderCacheEntity) > 0;
    }

    @Override
    public Boolean deleteOrderCacheEntity(String cacheId) {
        this.removeCache(cacheId);
        return this.orderCacheMapper.deleteByPrimaryKey((Serializable)((Object)cacheId)) > 0;
    }

    private void removeCache(String cacheId) {
        this.redisCacheUtil.remove(cacheId);
    }
}

