/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.common.vo.jms.MessageResult;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.cashticket.CashticketEntity;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderMessageQueueInterface;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderMessageQueueService
extends BaseService
implements MallOrderMessageQueueInterface {
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private CashticketInterface cashticketInterface;
    @Autowired
    private RedisService redisService;

    @Override
    public void sendCommitOrderQueue(MallMainOrderVo mallMainOrderVo) {
        try {
            CashticketEntity cashticket;
            List<CashticketVo> cashticketVos;
            HashMap<String, String> cot = new HashMap<String, String>();
            cot.put("userId", mallMainOrderVo.getCustomerId());
            cot.put("orderMainNo", mallMainOrderVo.getMainOrderNo());
            String ticketNo = "";
            if (mallMainOrderVo.getCashticketVos() != null && (cashticketVos = mallMainOrderVo.getCashticketVos()) != null && cashticketVos.size() > 0 && cashticketVos.get(0).getEnable() == 1 && (cashticket = this.cashticketInterface.getCashticket(cashticketVos.get(0).getTicketCustomerId())) != null) {
                ticketNo = cashticket.getTicketNo();
            }
            cot.put("ticketNo", ticketNo);
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.orderSubmit, MessageParam.messageParam((String)mallMainOrderVo.getMainOrderNo(), cot));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendPaySuccessOrderQueue(MallOrderMainEntity orderMainEntity, Integer activeType) {
        this.logger.info("\u5f00\u59cb\u63a8\u9001\u6d88\u606f1,\u8ba2\u5355\u53f7:" + orderMainEntity.getOrderMainNo());
        try {
            boolean setResult = this.redisService.sadd(DateUtils.date().toString() + ":Order", orderMainEntity.getOrderMainNo());
            if (setResult) {
                String versionKey;
                LinkedHashMap record;
                this.logger.info("\u5f00\u59cb\u63a8\u9001\u6d88\u606f2,\u8ba2\u5355\u53f7:" + orderMainEntity.getOrderMainNo());
                HashMap<String, Object> messageBody = new HashMap<String, Object>();
                messageBody.put("userId", orderMainEntity.getCustomerId());
                messageBody.put("orderMainNo", orderMainEntity.getOrderMainNo());
                messageBody.put("channelId", orderMainEntity.getChannelId());
                messageBody.put("activeType", activeType);
                MessageResult messsagResult = this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.orderPay, MessageParam.messageParam((String)orderMainEntity.getOrderMainNo(), messageBody));
                this.logger.info("\u8bbe\u7f6e\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u6d88\u606f\u4e3a\u5df2\u63a8\u9001...\u63a8\u9001\u72b6\u6001:" + messsagResult.isStatus() + "\uff0c\u8ba2\u5355\u53f7:" + orderMainEntity.getOrderMainNo());
                if (!orderMainEntity.getBindCode().isEmpty() && orderMainEntity.getOrderClass() == 1 && (record = (LinkedHashMap)this.memcachedService.get(versionKey = orderMainEntity.getCustomerId() + ":" + orderMainEntity.getBindCode() + ":version")) != null) {
                    HashMap<String, Object> messageBody2 = new HashMap<String, Object>();
                    messageBody2.put("userId", orderMainEntity.getCustomerId());
                    messageBody2.put("dataFrom", "\u65b0\u5173\u6ce8\u5f39\u51fa\u8d2d\u4e70\u5b8c\u6210");
                    messageBody2.put("bindCode", "");
                    messageBody2.put("activeNo", orderMainEntity.getActiveNo());
                    messageBody2.put("versionName", record == null ? "" : (record.size() > 0 ? record.get("VERSION").toString() : ""));
                    messageBody2.put("createTime", DateUtils.now());
                    this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.activeData, MessageParam.messageParam((String)orderMainEntity.getOrderMainNo(), messageBody2));
                }
                HashMap<String, String> detailmessageBody = new HashMap<String, String>();
                detailmessageBody.put("userId", orderMainEntity.getCustomerId());
                detailmessageBody.put("orderMainNo", orderMainEntity.getOrderMainNo());
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.orderDetail, MessageParam.messageParam((String)orderMainEntity.getOrderMainNo(), detailmessageBody));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u8ba2\u5355" + orderMainEntity.getOrderMainNo() + "\u6d88\u606f\u63a8\u9001\u6d88\u606f\u961f\u5217\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    public void sendConfirmGoodsQueue(String customerId, String orderMainNo, String orderNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("userId", customerId);
        cot.put("orderMainNo", orderMainNo);
        cot.put("orderNo", orderNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.confirmGoods, MessageParam.messageParam((String)orderMainNo, cot));
    }

    @Override
    public void sendCancelOrderQueue(String orderMainNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("orderMainNo", orderMainNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.omsOrderCancel, MessageParam.messageParam((String)orderMainNo, cot));
    }

    @Override
    public void sendDeliverGoodsQueue(String orderMainNo, String orderNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("orderMainNo", orderMainNo);
        cot.put("orderNo", orderNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.ecOrderTakeGood, MessageParam.messageParam((String)orderMainNo, cot));
    }

    @Override
    public void sendRefundApplyQueue(String orderMainNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("orderMainNo", orderMainNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.ecOrderRefundApply, MessageParam.messageParam((String)orderMainNo, cot));
    }

    @Override
    public void sendRefundQueue(String orderMainNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("orderMainNo", orderMainNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.ecOrderRefund, MessageParam.messageParam((String)orderMainNo, cot));
    }

    @Override
    public void sendOrderUpdateQueue(String orderMainNo, String orderNo, Integer type, String editHistoryId) {
        HashMap<String, Object> cot = new HashMap<String, Object>();
        cot.put("orderMainNo", orderMainNo);
        cot.put("orderNo", orderNo);
        cot.put("modifyType", type);
        cot.put("editHistoryId", editHistoryId);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.omsOrderUpdate, MessageParam.messageParam((String)orderMainNo, cot));
    }
}

