/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.constants.message.MessageActionConstants;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMessageInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderMessageService
extends BaseService
implements MallOrderMessageInterface {
    @Autowired
    private MessageInterface messageInterface;
    @Autowired
    private MallOrderPayInterface payInterface;
    @Autowired
    private MallOrderInterface orderInterface;

    @Override
    public void sendOrderPaySuccessTextMessage(MallOrderMainEntity orderMainEntity) {
        if (orderMainEntity == null) {
            return;
        }
        int orderClass = orderMainEntity.getOrderClass();
        try {
            if (orderClass == OrderClassEnum.CROWD_ORDER.getValue()) {
                this.messageInterface.sendWechatMessage(MessageActionConstants.orderpaysuccessCrowd, orderMainEntity.getCustomerId(), null);
                return;
            }
            List<MallOrderPayEntity> orderPayEntities = this.payInterface.getList(orderMainEntity.getOrderMainNo());
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainEntity.getOrderMainNo());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("orderMainNo", orderMainEntity.getOrderMainNo());
            if (orderEntities != null && orderEntities.size() > 0) {
                map.put("orderNo", orderEntities.get(0).getOrderNo());
            }
            if (orderPayEntities.stream().filter(c -> c.getPaytypeId() == 8).count() > 0L) {
                this.messageInterface.sendWechatMessage(MessageActionConstants.orderpaysuccessMessageUsed, orderMainEntity.getCustomerId(), map);
            } else {
                this.messageInterface.sendWechatMessage(MessageActionConstants.orderpaysuccessmessage, orderMainEntity.getCustomerId(), map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

