/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.trade.MallOrderPayMapper;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.MallPayTypeVo;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.service.trade.cache.MallOrderPayCacheService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallOrderPayService
extends MallOrderPayCacheService
implements MallOrderPayInterface {
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderPayMapper mallOrderPayMapper;
    @Autowired
    private MallPayTypeInterface payTypeInterface;
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;

    @Override
    public boolean checkMilkCardOrder(String orderMainNo) {
        List<MallOrderPayEntity> list = this.getList(orderMainNo);
        return list.stream().anyMatch(p -> p.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue());
    }

    @Override
    public BaseJsonVo updatePayTypeByOrderMainNo(String orderMainNo, int payTypeId, int payTypeSubId) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        MallPayTypeEntity mallPayTypeEntity = this.payTypeInterface.getPayType(payTypeId);
        if (mallPayTypeEntity == null) {
            result.setError("\u652f\u4ed8\u7c7b\u578b\u9519\u8bef");
            return result;
        }
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        if (mallOrderMainEntity == null) {
            result.setError("\u8ba2\u5355\u4e0d\u5b58\u5728No:" + orderMainNo);
            return result;
        }
        if (mallOrderMainEntity.getStatus().intValue() != OrderStatusEnum.UNPAY.getValue()) {
            result.setError("\u672a\u4ed8\u6b3e\u7684\u8ba2\u5355\u624d\u80fd\u4fee\u6539\u8ba2\u5355\u72b6\u6001");
            return result;
        }
        if (mallPayTypeEntity.getCashType() != 1) {
            result.setError("\u53ea\u6709\u73b0\u91d1\u7c7b\u578b\u7684\u652f\u4ed8\u65b9\u5f0f\u624d\u53ef\u4ee5\u66f4\u6539");
            return result;
        }
        mallPayTypeEntity = this.payTypeInterface.getPayType(payTypeSubId);
        if (mallPayTypeEntity == null) {
            result.setError("\u652f\u4ed8\u7c7b\u578b\u9519\u8bef");
            return result;
        }
        if (mallPayTypeEntity.getCashType() != 1) {
            result.setError("\u53ea\u6709\u73b0\u91d1\u7c7b\u578b\u7684\u652f\u4ed8\u65b9\u5f0f\u624d\u53ef\u4ee5\u66f4\u6539");
            return result;
        }
        MallOrderPayEntity mallOrderPayEntity = new MallOrderPayEntity();
        mallOrderPayEntity.setOrderMainNo(orderMainNo);
        mallOrderPayEntity.setCashType(1);
        List mallOrderPayEntityList = this.mallOrderPayMapper.getList(mallOrderPayEntity);
        if (mallOrderPayEntityList == null || mallOrderPayEntityList.size() == 0) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (mallOrderPayEntityList.size() > 1) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u5f02\u5e38");
            return result;
        }
        mallOrderPayEntity = (MallOrderPayEntity)mallOrderPayEntityList.get(0);
        if (mallOrderPayEntity.getIssuccess() == 1) {
            result.setError("\u8be5\u652f\u4ed8\u65b9\u5f0f\u5df2\u7ecf\u652f\u4ed8\uff0c\u4e0d\u80fd\u66f4\u6539");
            return result;
        }
        result.setValue((Object)mallOrderPayEntity);
        if (mallOrderPayEntity.getPaytypeId() == payTypeId && mallOrderPayEntity.getPaySubtypeId() == payTypeSubId) {
            result.setResult((Object)"0");
            return result;
        }
        mallOrderPayEntity.setTradeNo(IDGenerate.getUniqueIdStr());
        mallOrderPayEntity.setPaytypeId(payTypeId);
        mallOrderPayEntity.setPaySubtypeId(payTypeSubId);
        if (!this.updateByPrimaryKey(mallOrderPayEntity)) {
            result.setError("\u66f4\u65b0\u5931\u8d25");
        }
        return result;
    }

    @Override
    public boolean updateByPrimaryKey(MallOrderPayEntity mallOrderPayEntity) {
        int i = this.mallOrderPayMapper.updateByPrimaryKeySelective(mallOrderPayEntity);
        return i == 1;
    }

    @Override
    public boolean insertOrderPay(MallOrderPayEntity orderPayEntity) {
        int i = this.mallOrderPayMapper.insertSelective(orderPayEntity);
        return i == 1;
    }

    public boolean deleteByPrimaryKey(String payId) {
        return this.mallOrderPayMapper.deleteByPrimaryKey((Serializable)((Object)payId)) == 1;
    }

    @Override
    public MallOrderPayEntity getSingle(String payId) {
        return (MallOrderPayEntity)this.mallOrderPayMapper.selectByPrimaryKey((Serializable)((Object)payId));
    }

    @Override
    public MallOrderPayEntity getOrderPayInfoByTradeNo(String tradeNo) {
        return this.mallOrderPayMapper.getOrderPayInfoByTradeNo(tradeNo);
    }

    @Override
    public BaseJsonVo buildOrderPayEntities(MallMainOrderVo mainOrderVo) {
        if (Objects.equals(mainOrderVo.getOrderCacheVo().getOrderSource(), OrderSourceEnum.CART.getValue()) && mainOrderVo.getOrderCacheVo().getCardBatchId() != null && StringUtils.isNotEmpty((String)mainOrderVo.getOrderCacheVo().getSourceOrderNo())) {
            return this.buildDeliveryCardOrderPayEntities(mainOrderVo);
        }
        if (mainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.SPLITE_CARD_ORDER.getValue()) {
            return this.buildBuyCardOrderPayEntities(mainOrderVo);
        }
        return this.buildCommonOrderPayEntities(mainOrderVo);
    }

    private BaseJsonVo buildBuyCardOrderPayEntities(MallMainOrderVo mainOrderVo) {
        String sourceOrderMainNo = mainOrderVo.getOrderCacheVo().getSourceOrderNo();
        List<MallOrderPayEntity> sourcePayEntityList = this.getList(sourceOrderMainNo);
        List<MallOrderProductEntity> products = this.orderProductInterface.getOrderProductInfoByOrderMianNo(sourceOrderMainNo);
        if (CollectionUtils.isEmpty(products)) {
            this.logger.info("\u67e5\u8be2\u8d2d\u4e70\u5361\u4f18\u60e0\u4e3b\u5355\uff1a{}\u5546\u54c1\u51fa\u9519:{}", (Object)sourceOrderMainNo, (Object)"\u672a\u67e5\u8be2\u8ba2\u5355\u5546\u54c1");
            return BaseJsonVo.error((String)"\u751f\u6210\u8ba2\u5355\u5546\u54c1\u9519\u8bef");
        }
        ArrayList tempList = new ArrayList();
        for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
            List productList = products.stream().filter(product -> Objects.equals(product.getGroupType(), SalesTypeEnum.SALES_PROMOTION.getValue()) && Objects.equals(product.getPromotionId(), orderVo.getPromotions().get(0).getPromotionId())).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(productList)) continue;
            tempList.addAll(productList);
        }
        mainOrderVo.setPayAmount(BigDecimal.ZERO);
        mainOrderVo.getMallOrderVos().get(0).setPayAmount(BigDecimal.ZERO);
        ArrayList<MallOrderPayEntity> subOrderPayList = new ArrayList<MallOrderPayEntity>();
        BigDecimal payDiff = BigDecimal.ZERO;
        sourcePayEntityList = sourcePayEntityList.stream().sorted((a, b) -> b.getPayamount().compareTo(a.getPayamount())).collect(Collectors.toList());
        for (MallOrderPayEntity orderPayEntity : sourcePayEntityList) {
            this.logger.info("\u6e90\u5355\u652f\u4ed8\u4fe1\u606f:{}", (Object)JsonUtils.toJson((Object)orderPayEntity, (boolean)false));
            MallOrderPayEntity subOrderPay = new MallOrderPayEntity();
            subOrderPay.setPayId(String.valueOf(IDGenerate.getUniqueID()));
            boolean allPayFlag = false;
            if (orderPayEntity.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue() || orderPayEntity.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()) {
                BeanUtils.copyProperties((Object)orderPayEntity, (Object)subOrderPay);
                subOrderPay.setPayId(String.valueOf(IDGenerate.getUniqueID()));
                subOrderPay.setThirdTradeNo(orderPayEntity.getThirdTradeNo());
                subOrderPay.setTradeNo(orderPayEntity.getTradeNo());
                subOrderPay.setOrderMainNo(mainOrderVo.getMainOrderNo());
                subOrderPay.setCreateTime(DateUtils.now());
                subOrderPay.setIssuccess(0);
                if (orderPayEntity.getPayamount().compareTo(PriceUtils.subtract((BigDecimal)tempList.stream().map(MallOrderProductEntity::getTotalPrice).reduce(BigDecimal::add).get(), (BigDecimal)tempList.stream().map(MallOrderProductEntity::getTicketAmount).reduce(BigDecimal::add).get())) >= 0) {
                    subOrderPay.setPayamount(PriceUtils.subtract((BigDecimal)tempList.stream().map(MallOrderProductEntity::getTotalPrice).reduce(BigDecimal::add).get(), (BigDecimal)tempList.stream().map(MallOrderProductEntity::getTicketAmount).reduce(BigDecimal::add).get()).setScale(2, 1));
                    allPayFlag = true;
                } else if (payDiff.compareTo(BigDecimal.ZERO) > 0) {
                    subOrderPay.setPayamount(payDiff);
                    this.logger.info("\u7528\u5dee\u4ef7{}\u8865\u4e0d\u8db3", (Object)payDiff);
                } else {
                    subOrderPay.setPayamount(orderPayEntity.getPayamount());
                    payDiff = PriceUtils.subtract((BigDecimal)PriceUtils.subtract((BigDecimal)tempList.stream().map(MallOrderProductEntity::getTotalPrice).reduce(BigDecimal::add).get(), (BigDecimal)tempList.stream().map(MallOrderProductEntity::getTicketAmount).reduce(BigDecimal::add).get()).setScale(2, 1), (BigDecimal)orderPayEntity.getPayamount());
                }
                if (orderPayEntity.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue()) {
                    mainOrderVo.setPayAmount(subOrderPay.getPayamount());
                    mainOrderVo.getMallOrderVos().get(0).setPayAmount(subOrderPay.getPayamount());
                }
            }
            if (orderPayEntity.getPaytypeId().intValue() == PayTypeEnum.COUPON_PAY.getValue() && orderPayEntity.getPayamount().compareTo(tempList.stream().map(MallOrderProductEntity::getTicketAmount).reduce(BigDecimal::add).get()) > 0) {
                subOrderPay.setOrderMainNo(mainOrderVo.getMainOrderNo());
                subOrderPay.setCreateTime(DateUtils.now());
                subOrderPay.setIssuccess(0);
                subOrderPay.setPayamount(PriceUtils.subtract((BigDecimal)tempList.stream().map(MallOrderProductEntity::getTicketAmount).reduce(BigDecimal::add).get(), (BigDecimal)tempList.stream().map(MallOrderProductEntity::getTicketAmount).reduce(BigDecimal::add).get()).setScale(2, 1));
                this.logger.info("\u8ba2\u5355:{}\u8d2d\u4e70\u5361\u4f7f\u7528\u4f18\u60e0\u5238:{}", (Object)mainOrderVo.getMainOrderNo(), (Object)subOrderPay.getPayamount());
            }
            this.logger.info("\u8ba2\u5355:{}\u652f\u4ed8\u7c7b\u578b:{}\u62c6\u5206\u540e\u7684\u4e3b\u5355\u652f\u4ed8\u91d1\u989d:{}", new Object[]{mainOrderVo.getMainOrderNo(), subOrderPay.getPaytypeName(), subOrderPay.getPayamount()});
            this.logger.info("\u652f\u4ed8\u5bf9\u8c61:{}", (Object)JsonUtils.toJson((Object)subOrderPay, (boolean)false));
            if (subOrderPay.getPayamount().compareTo(BigDecimal.ZERO) > 0) {
                subOrderPayList.add(subOrderPay);
            }
            if (!allPayFlag) continue;
            break;
        }
        if (CollectionUtils.isNotEmpty(subOrderPayList)) {
            mainOrderVo.setOrderPayEntities(subOrderPayList);
            return BaseJsonVo.success(subOrderPayList);
        }
        return BaseJsonVo.error((String)"\u6784\u5efa\u8ba2\u5355\u652f\u4ed8\u8868\u5f02\u5e38");
    }

    private BaseJsonVo buildDeliveryCardOrderPayEntities(MallMainOrderVo mainOrderVo) {
        String sourceOrderMainNo = mainOrderVo.getOrderCacheVo().getSourceOrderNo();
        List<MallOrderPayEntity> sourcePayEntityList = this.getList(sourceOrderMainNo);
        List<MallOrderMainEntity> orderMainEntityList = this.mallOrderMainInterface.getMallOrderMainEntityList(sourceOrderMainNo);
        if (CollectionUtils.isEmpty(orderMainEntityList)) {
            this.logger.error("\u6e90\u5355:{}\u4e0d\u5b58\u5728\u62c6\u5206\u540e\u7684\u8ba2\u5355", (Object)sourceOrderMainNo);
            return BaseJsonVo.error((String)"\u4e0d\u5b58\u5728\u62c6\u5206\u7684\u8ba2\u5355");
        }
        MallOrderMainEntity cardMallOrder = orderMainEntityList.stream().filter(orderMainEntity -> orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.SPLITE_CARD_ORDER.getValue()).findFirst().get();
        if (CollectionUtils.isEmpty(orderMainEntityList)) {
            this.logger.error("\u6e90\u5355:{}\u4e0d\u5b58\u5728\u62c6\u5206\u540e\u7684\u5361\u8ba2\u5355", (Object)sourceOrderMainNo);
            return BaseJsonVo.error((String)"\u4e0d\u5b58\u5728\u62c6\u5206\u7684\u5361\u8ba2\u5355");
        }
        List<MallOrderPayEntity> cardPayEntityList = this.getList(cardMallOrder.getOrderMainNo());
        PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(mainOrderVo.getOrderCacheVo().getCardBatchId());
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(sourceOrderMainNo);
        mainOrderVo.setTotalAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getTotalAmount(), (BigDecimal)mallOrderMainEntity.getPointCut()));
        mainOrderVo.setOrderAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getOrderAmount(), (BigDecimal)mallOrderMainEntity.getPointCut()));
        mainOrderVo.setPayAmount(BigDecimal.ZERO);
        mainOrderVo.getMallOrderVos().get(0).setPayAmount(BigDecimal.ZERO);
        ArrayList<MallOrderPayEntity> payEntities = new ArrayList<MallOrderPayEntity>();
        BigDecimal rate = prepayCardBatchEntity.getRate() == null || prepayCardBatchEntity.getRate().compareTo(BigDecimal.ZERO) == 0 ? prepayCardBatchEntity.getSaleValue().divide(prepayCardBatchEntity.getCardPrice(), 2, 1) : prepayCardBatchEntity.getRate();
        payEntities.add(this.createEntity(mainOrderVo.getMainOrderNo(), PayTypeEnum.BALANCE_PAY.getValue(), PayTypeEnum.getPayTypeName((int)PayTypeEnum.BALANCE_PAY.getValue()), 0, "", PriceUtils.divide((BigDecimal)mallOrderMainEntity.getPoints(), (BigDecimal)rate, (int)2, (Integer)1), PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue(), 1, 0, mainOrderVo.getCardType()));
        for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
            orderVo.setTotalAmount(PriceUtils.subtract((BigDecimal)orderVo.getTotalAmount(), (BigDecimal)orderVo.getUseCardCutAmount()));
            orderVo.setOrderAmount(PriceUtils.subtract((BigDecimal)orderVo.getOrderAmount(), (BigDecimal)orderVo.getUseCardCutAmount()));
            orderVo.setPayAmount(mainOrderVo.getPayAmount());
            orderVo.setBalanceAmount(orderVo.getOrderAmount().subtract(orderVo.getPayAmount()));
        }
        for (MallOrderPayEntity orderPayEntity : sourcePayEntityList) {
            this.logger.info("\u6e90\u5355\u652f\u4ed8:{}", (Object)JsonUtils.toJson((Object)orderPayEntity, (boolean)false));
            MallOrderPayEntity deliverOrderPay = new MallOrderPayEntity();
            BeanUtils.copyProperties((Object)orderPayEntity, (Object)deliverOrderPay);
            Optional<MallOrderPayEntity> cardPayOptional = cardPayEntityList.stream().filter(cardPay -> Objects.equals(cardPay.getPaySubtypeId(), orderPayEntity.getPaySubtypeId())).findFirst();
            if (cardPayOptional.isPresent()) {
                BigDecimal tempAmount = PriceUtils.subtract((BigDecimal)orderPayEntity.getPayamount(), (BigDecimal)cardPayOptional.get().getPayamount());
                if (orderPayEntity.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue()) {
                    mainOrderVo.setPayAmount(tempAmount);
                    mainOrderVo.getMallOrderVos().get(0).setPayAmount(tempAmount);
                }
                if (cardPayOptional.get().getPayamount().compareTo(orderPayEntity.getPayamount()) == 0 || tempAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                deliverOrderPay.setPayamount(tempAmount);
            }
            deliverOrderPay.setPayId(String.valueOf(IDGenerate.getUniqueID()));
            deliverOrderPay.setOrderMainNo(mainOrderVo.getMainOrderNo());
            deliverOrderPay.setIssuccess(0);
            this.logger.info("\u5b9e\u7269\u5355\u652f\u4ed8:{}", (Object)deliverOrderPay);
            payEntities.add(deliverOrderPay);
        }
        this.logger.info("\u5b9e\u7269\u8ba2\u5355:{}\u652f\u4ed8\u4fe1\u606f:{}", (Object)mainOrderVo.getMainOrderNo(), (Object)JsonUtils.toJson(payEntities, (boolean)false));
        if (CollectionUtils.isNotEmpty(payEntities)) {
            mainOrderVo.setOrderPayEntities(payEntities);
            return BaseJsonVo.success(payEntities);
        }
        return BaseJsonVo.error((String)"\u6784\u5efa\u8ba2\u5355\u652f\u4ed8\u8868\u5f02\u5e38");
    }

    private BaseJsonVo buildCommonOrderPayEntities(MallMainOrderVo mainOrderVo) {
        BaseJsonVo<List<MallPayTypeVo>> baseJsonVo = this.payTypeInterface.getOrderPayList(mainOrderVo);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        List payTypeVos = (List)baseJsonVo.getValue();
        ArrayList<MallOrderPayEntity> payEntities = new ArrayList<MallOrderPayEntity>();
        int couponId = 0;
        String couponNo = "";
        for (MallPayTypeVo p : payTypeVos) {
            boolean couponFlag = false;
            if (p.getPaytypeId().intValue() == PayTypeEnum.COUPON_PAY.getValue()) {
                List<CashticketVo> cashticketVos = mainOrderVo.getCashticketVos();
                if (cashticketVos == null || cashticketVos.size() == 0) {
                    return BaseJsonVo.error((String)"\u4f18\u60e0\u5238\u5904\u7406\u5f02\u5e38");
                }
                if (mainOrderVo.getOrderCacheVo().getSelectCashList().size() > 0) {
                    for (Integer cashId : mainOrderVo.getOrderCacheVo().getSelectCashList()) {
                        CashticketVo useCash = (CashticketVo)cashticketVos.stream().filter(cashticketVo -> cashticketVo.getTicketCustomerId().equals(cashId)).collect(Collectors.toList()).get(0);
                        couponNo = useCash.getTicketBatchName();
                        if (couponNo.length() > 20) {
                            couponNo = couponNo.substring(0, 19);
                        }
                        couponFlag = true;
                        payEntities.add(this.createEntity(mainOrderVo.getMainOrderNo(), p.getPaytypeId(), p.getPaytypeName(), cashId, couponNo, useCash.getEnableCashticketAmount(), p.getPaySubTypeId(), p.getSort(), p.getCashType(), null));
                    }
                }
            } else {
                couponId = 0;
                couponNo = "";
            }
            if (couponFlag) continue;
            this.logger.info("\u652f\u4ed8\u65b9\u5f0f:{},\u652f\u4ed8\u91d1\u989d:{}", (Object)p.getPaySubTypeId(), (Object)p.getPayAmount());
            payEntities.add(this.createEntity(mainOrderVo.getMainOrderNo(), p.getPaytypeId(), p.getPaytypeName(), couponId, couponNo, p.getPayAmount(), p.getPaySubTypeId(), p.getSort(), p.getCashType(), mainOrderVo.getCardType()));
        }
        if (CollectionUtils.isNotEmpty(payEntities)) {
            mainOrderVo.setOrderPayEntities(payEntities);
            return BaseJsonVo.success(payEntities);
        }
        return BaseJsonVo.error((String)"\u6784\u5efa\u8ba2\u5355\u652f\u4ed8\u8868\u5f02\u5e38");
    }

    private MallOrderPayEntity createEntity(String orderMainNo, int payTypeId, String payTypeName, int couponId, String couponNo, BigDecimal amount, int paySubTypeId, int sort, int cashType, Integer cardType) {
        MallOrderPayEntity orderPayEntity = new MallOrderPayEntity();
        String payId = String.valueOf(IDGenerate.getUniqueID());
        orderPayEntity.setCreateTime(DateUtils.now());
        orderPayEntity.setOrderMainNo(orderMainNo);
        orderPayEntity.setSort(sort);
        orderPayEntity.setTradeNo(payId);
        orderPayEntity.setPaySubtypeId(paySubTypeId);
        orderPayEntity.setCashticketId(couponId);
        orderPayEntity.setCashticketNo(couponNo);
        orderPayEntity.setCashType(cashType);
        orderPayEntity.setIssuccess(0);
        orderPayEntity.setPayamount(amount);
        orderPayEntity.setPaytypeId(payTypeId);
        orderPayEntity.setPaytypeName(payTypeName);
        orderPayEntity.setPrePayId("");
        orderPayEntity.setSuccessTime(null);
        orderPayEntity.setThirdTradeNo("");
        orderPayEntity.setPayId(payId);
        orderPayEntity.setCardType(cardType);
        return orderPayEntity;
    }

    @Override
    @Transactional
    public void splitOrderPayForSubType(MallOrderPayEntity orderPayEntity, Map<String, Object> wealth) {
        try {
            BigDecimal store = new BigDecimal(wealth.get("store").toString());
            BigDecimal present = new BigDecimal(wealth.get("present").toString());
            BigDecimal card = new BigDecimal(wealth.get("card").toString());
            BigDecimal cardPlan = new BigDecimal(wealth.get("cardPlan").toString());
            if (orderPayEntity.getIssuccess() == 1) {
                MallOrderPayEntity tempOrderPay;
                if (store.doubleValue() != 0.0) {
                    store = store.divide(new BigDecimal(100));
                    orderPayEntity.setPaySubtypeId(PaySubTypeEnum.BALANCE_SUB_CHARGE_PAY.getValue());
                    orderPayEntity.setPayamount(store);
                    orderPayEntity.setThirdTradeNo(wealth.get("thirdTradeNo") != null ? wealth.get("thirdTradeNo").toString() : "");
                    if (!this.updateByPrimaryKey(orderPayEntity)) {
                        throw new RuntimeException("\u66f4\u65b0\u5b50\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38");
                    }
                } else {
                    this.deleteByPrimaryKey(orderPayEntity.getPayId());
                }
                if (present.doubleValue() != 0.0) {
                    present = present.divide(new BigDecimal(100));
                    tempOrderPay = new MallOrderPayEntity();
                    BeanUtils.copyProperties((Object)orderPayEntity, (Object)tempOrderPay);
                    tempOrderPay.setPaySubtypeId(PaySubTypeEnum.BALANCE_SUB_GIVE_PAY.getValue());
                    tempOrderPay.setPayamount(present);
                    tempOrderPay.setPayId(String.valueOf(IDGenerate.getUniqueID()));
                    tempOrderPay.setTradeNo(tempOrderPay.getPayId());
                    tempOrderPay.setThirdTradeNo(wealth.get("thirdTradeNo") != null ? wealth.get("thirdTradeNo").toString() : "");
                    if (!this.insertOrderPay(tempOrderPay)) {
                        throw new RuntimeException("\u6dfb\u52a0\u5b50\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38");
                    }
                }
                if (card.doubleValue() != 0.0) {
                    card = card.divide(new BigDecimal(100));
                    tempOrderPay = new MallOrderPayEntity();
                    BeanUtils.copyProperties((Object)orderPayEntity, (Object)tempOrderPay);
                    tempOrderPay.setPaySubtypeId(PaySubTypeEnum.BALANCE_SUB_GIFTCARD_PAY.getValue());
                    tempOrderPay.setPayamount(card);
                    tempOrderPay.setPayId(String.valueOf(IDGenerate.getUniqueID()));
                    tempOrderPay.setTradeNo(tempOrderPay.getPayId());
                    tempOrderPay.setThirdTradeNo(wealth.get("thirdTradeNo") != null ? wealth.get("thirdTradeNo").toString() : "");
                    if (!this.insertOrderPay(tempOrderPay)) {
                        throw new RuntimeException("\u6dfb\u52a0\u5b50\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38");
                    }
                }
                if (cardPlan.compareTo(BigDecimal.ZERO) > 0) {
                    cardPlan = cardPlan.divide(new BigDecimal(100));
                    tempOrderPay = new MallOrderPayEntity();
                    BeanUtils.copyProperties((Object)orderPayEntity, (Object)tempOrderPay);
                    tempOrderPay.setPaySubtypeId(PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue());
                    tempOrderPay.setPayamount(cardPlan);
                    this.logger.info("\u8ba2\u5355\u53f7:{},cardPlan:{}", (Object)orderPayEntity.getOrderMainNo(), (Object)cardPlan);
                    if (wealth.containsKey("pointCard")) {
                        this.logger.info("\u8ba2\u5355\u53f7:{},\u70b9\u5361\u6298\u5408\u5b9e\u9645\u652f\u4ed8\u91d1\u989d:{}", (Object)orderPayEntity.getOrderMainNo(), (Object)wealth.get("pointCard").toString());
                        tempOrderPay.setPayamount(new BigDecimal(wealth.get("pointCard").toString()));
                    }
                    tempOrderPay.setPayId(String.valueOf(IDGenerate.getUniqueID()));
                    tempOrderPay.setTradeNo(tempOrderPay.getPayId());
                    tempOrderPay.setThirdTradeNo(wealth.get("thirdTradeNo") != null ? wealth.get("thirdTradeNo").toString() : "");
                    this.logger.info("\u62c6\u5206\u5b50\u652f\u4ed8\u65b9\u5f0f:{}", (Object)tempOrderPay.toString());
                    if (!this.insertOrderPay(tempOrderPay)) {
                        throw new RuntimeException("\u6dfb\u52a0\u5b50\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38");
                    }
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.logger.error(e.toString());
        }
    }

    @Override
    public MallOrderPayEntity getOrderPayInfoByOrderMainNoPayType(int paytypeId, String orderMainNo) {
        return this.getOrderPayInfoByOrderMainNoPayList(paytypeId, orderMainNo).get(0);
    }

    @Override
    public List<MallOrderPayEntity> getOrderPayInfoByOrderMainNoPayList(int paytypeId, String orderMainNo) {
        return this.mallOrderPayMapper.getOrderPayInfoByOrderMainNoPayType(paytypeId, orderMainNo);
    }
}

