/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.apiinvoke.oms.WxOrderClient;
import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.framework.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.dao.trade.DetailOrderGroupMapper;
import cc.lechun.mall.dao.trade.DetailOrderMapper;
import cc.lechun.mall.dao.trade.DetailOrderProductMapper;
import cc.lechun.mall.dao.trade.MallOrderSyncInfoMapper;
import cc.lechun.mall.dao.trade.MallOrderUpdateHistoryMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.ShopChannelEnum;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.trade.DetailOrderEntity;
import cc.lechun.mall.entity.trade.DetailOrderGroupEntity;
import cc.lechun.mall.entity.trade.DetailOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductDeliverEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderSyncInfoEntity;
import cc.lechun.mall.entity.trade.MallOrderUpdateHistoryProductEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductDeliverInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallOrderUpdateHistoryProductInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.omsv2.entity.order.third.weixin.WxOrderDetailVO;
import cc.lechun.omsv2.entity.order.third.weixin.WxOrderEntityVO;
import cc.lechun.omsv2.entity.order.third.weixin.WxOrderProductVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import weixin.popular.api.DeliveryMessageAPI;
import weixin.popular.bean.message.DeliverMessage;
import weixin.popular.bean.message.FollowWaybillResult;

@Service
public class MallOrderSyncInfoService
extends BaseService
implements MallOrderSyncInfoInterface {
    @Autowired
    private MallOrderSyncInfoMapper orderSyncInfoMapper;
    @Autowired
    DetailOrderMapper detailOrderMapper;
    @Autowired
    DetailOrderGroupMapper detailOrderGroupMapper;
    @Autowired
    DetailOrderProductMapper detailOrderProductMapper;
    @Autowired
    MallOrderMainInterface orderMainInterface;
    @Autowired
    MallOrderInterface orderInterface;
    @Autowired
    MallOrderPayInterface orderPayInterface;
    @Autowired
    MallOrderProductInterface orderGroupInterface;
    @Autowired
    MallOrderGroupProductInterface orderProductInterface;
    @Autowired
    MallGroupInterface groupInterface;
    @Autowired
    MallProductInterface mallProductInterface;
    @Autowired
    WxOrderClient wxOrderClient;
    @Autowired
    CustomerInterface customerService;
    @Autowired
    MallOrderUpdateHistoryMapper orderUpdateHistoryMapper;
    @Autowired
    MallOrderUpdateHistoryProductInterface orderUpdateHistoryProductInterface;
    @Autowired
    MallOrderGroupProductDeliverInterface orderGroupProductDeliverInterface;
    @Autowired
    PrepayCardPlanDetailInterface prepayCardPlanDetailInterface;
    @Autowired
    PrepayCardInterface prepayCardInterface;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;

    @Override
    public BaseJsonVo recordOMSInfo(String orderMainNo, String orderNo, String methodName, Map<String, Object> params, BaseJsonVo syncResult) {
        MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
        entity.setApiName(methodName);
        entity.setApiParam(JsonUtils.toJson(params, (boolean)false));
        entity.setDirection(3);
        entity.setCreateTime(DateUtils.now());
        entity.setSyncName("lechun-mall");
        entity.setApiReturn(syncResult != null ? JsonUtils.toJson((Object)syncResult, (boolean)false) : "");
        entity.setWarnLevel(5);
        entity.setOrderNo(orderNo);
        entity.setOrderMainNo(orderMainNo);
        entity.setSuccess(syncResult != null && syncResult.isSuccess() ? 1 : 0);
        if (syncResult != null && !syncResult.isSuccess()) {
            this.logger.error("\u540c\u6b65OMS\u9519\u8bef[{}][orderMainNo={}][orderNo={}]:{}", new Object[]{methodName, orderMainNo, orderNo, syncResult.getError_msg()});
        }
        return this.recordInfo(entity);
    }

    @Override
    public BaseJsonVo recordInfo(MallOrderSyncInfoEntity entity) {
        if (entity == null) {
            return BaseJsonVo.error((String)"\u8c03\u7528\u4fe1\u606f\u4e3a\u7a7a");
        }
        int insertResult = this.orderSyncInfoMapper.insert(entity);
        if (insertResult > 0) {
            this.logger.info("\u65e5\u5fd7\u4fdd\u5b58\u6210\u529f");
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        this.logger.info("\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25");
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public List<MallOrderSyncInfoEntity> getList(MallOrderSyncInfoEntity syncInfo) {
        return this.orderSyncInfoMapper.getList(syncInfo);
    }

    @Override
    public Boolean isSuccessSyncEdb(String orderMainNo, String orderNo) {
        MallOrderSyncInfoEntity syncInfoEntity = new MallOrderSyncInfoEntity();
        if (orderMainNo != null && !orderMainNo.isEmpty()) {
            syncInfoEntity.setOrderMainNo(orderMainNo);
        }
        if (orderNo != null && !orderNo.isEmpty()) {
            syncInfoEntity.setOrderNo(orderNo);
        }
        syncInfoEntity.setSuccess(1);
        List<MallOrderSyncInfoEntity> syncInfoEntities = this.getList(syncInfoEntity);
        if (syncInfoEntities == null || syncInfoEntities.size() == 0) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public BaseJsonVo toDetailOrderModifyProducts(String orderNo, String editHistoryId) {
        List detailOrderEntities;
        List oldProducts;
        List oldGroups;
        ArrayList products;
        ArrayList details;
        BaseJsonVo<WxOrderEntityVO> syncResult;
        String orderMainNo;
        block9: {
            BaseJsonVo splitRst;
            block8: {
                List list;
                block7: {
                    orderMainNo = null;
                    syncResult = null;
                    details = new ArrayList();
                    products = new ArrayList();
                    MallOrderUpdateHistoryProductEntity param = new MallOrderUpdateHistoryProductEntity();
                    param.setHistoryId(editHistoryId);
                    list = this.orderUpdateHistoryProductInterface.getList(param);
                    if (list != null && list.size() != 0) break block7;
                    BaseJsonVo baseJsonVo = BaseJsonVo.error((String)("t_mall_order_update_history_product\u4e0d\u5b58\u5728\u7684history_id\uff1a" + editHistoryId));
                    this.recordOMSInfo(orderMainNo, orderNo, "updateSunOrderByOid", (Map<String, Object>)new HashMap<String, Object>(orderNo, editHistoryId){
                        final /* synthetic */ String val$orderNo;
                        final /* synthetic */ String val$editHistoryId;
                        {
                            this.val$orderNo = string;
                            this.val$editHistoryId = string2;
                            this.put("orderNo", this.val$orderNo);
                            this.put("editHistoryId", this.val$editHistoryId);
                        }
                    }, (BaseJsonVo)syncResult);
                    return baseJsonVo;
                }
                MallOrderUpdateHistoryProductEntity historyProductEntity = (MallOrderUpdateHistoryProductEntity)list.get(0);
                oldGroups = (List)JsonUtils.fromJson((String)historyProductEntity.getOldValueGroup(), ArrayList.class);
                oldProducts = (List)JsonUtils.fromJson((String)historyProductEntity.getOldValueProduct(), ArrayList.class);
                orderMainNo = (String)((LinkedHashMap)oldGroups.get(0)).get("orderMainNo");
                splitRst = this.toDetailOrder(orderMainNo, orderNo);
                if (splitRst.isSuccess()) break block8;
                BaseJsonVo baseJsonVo = splitRst;
                this.recordOMSInfo(orderMainNo, orderNo, "updateSunOrderByOid", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, (BaseJsonVo)syncResult);
                return baseJsonVo;
            }
            detailOrderEntities = (List)splitRst.getValue();
            if (detailOrderEntities != null && detailOrderEntities.size() != 0) break block9;
            BaseJsonVo baseJsonVo = BaseJsonVo.error((String)("\u6ca1\u6709\u62c6\u5206\u7ed3\u679c:" + orderMainNo));
            this.recordOMSInfo(orderMainNo, orderNo, "updateSunOrderByOid", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, (BaseJsonVo)syncResult);
            return baseJsonVo;
        }
        try {
            WxOrderEntityVO wxOrderEntityVO = this.buildVO((DetailOrderEntity)detailOrderEntities.get(0));
            oldGroups.forEach(oldGroup -> {
                WxOrderDetailVO detail = new WxOrderDetailVO();
                detail.setCguid((String)oldGroup.get("orderProductNo"));
                detail.setExternalOrderNo(orderNo);
                detail.setOid((String)oldGroup.get("orderProductNo"));
                detail.setOperation(Integer.valueOf(1));
                detail.setProductNum(new BigDecimal((Integer)oldGroup.get("quantity")));
                if ((Integer)oldGroup.get("groupType") == 1) {
                    if (oldGroup.get("productId") != null && StringUtils.isNotEmpty((String)((String)oldGroup.get("productId"))) && !"0".equals(oldGroup.get("productId"))) {
                        oldGroup.put("groupType", 4);
                    }
                    if (oldGroup.get("groupId") != null && StringUtils.isNotEmpty((String)((String)oldGroup.get("groupId"))) && !"0".equals(oldGroup.get("groupId"))) {
                        oldGroup.put("groupType", 2);
                    }
                }
                if ((Integer)oldGroup.get("groupType") == 4) {
                    MallProductEntity product = this.mallProductInterface.getProduct((String)oldGroup.get("productId"));
                    detail.setProductCbarcode(product.getBarCode());
                    if (product.getTransportType() == 3) {
                        detail.setProductType(Integer.valueOf(2));
                    } else {
                        detail.setProductType(Integer.valueOf(3));
                    }
                } else {
                    detail.setProductType(Integer.valueOf(1));
                    detail.setProductCbarcode((String)oldGroup.get("groupId"));
                }
                details.add(detail);
            });
            wxOrderEntityVO.getWxOrderDetailVOList().forEach(detail -> detail.setOperation(Integer.valueOf(2)));
            oldProducts.forEach(oldProduct -> {
                WxOrderProductVO product = new WxOrderProductVO();
                product.setExternalOrderNo(orderNo);
                product.setOid((String)oldProduct.get("orderGroupId"));
                product.setParentOid((String)oldProduct.get("orderProductNo"));
                product.setOperation(Integer.valueOf(1));
                product.setProductNum(new BigDecimal((Integer)oldProduct.get("quantity")));
                MallProductEntity productEntity = this.mallProductInterface.getProduct((String)oldProduct.get("productId"));
                product.setProductCbarcode(productEntity.getBarCode());
                if (productEntity.getTransportType() == 3) {
                    product.setProductType(Integer.valueOf(2));
                } else {
                    product.setProductType(Integer.valueOf(3));
                }
                products.add(product);
            });
            wxOrderEntityVO.getWxOrderProductVOList().forEach(product -> product.setOperation(Integer.valueOf(2)));
            wxOrderEntityVO.getWxOrderDetailVOList().addAll(details);
            wxOrderEntityVO.getWxOrderProductVOList().addAll(products);
            this.logger.info(orderNo + " eidt order product param : " + JsonUtils.toJson((Object)wxOrderEntityVO, (boolean)false));
            syncResult = this.wxOrderClient.updateSunOrderByOid(wxOrderEntityVO);
            this.recordOMSInfo(orderMainNo, orderNo, "updateSunOrderByOid", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, syncResult);
        }
        catch (Exception e) {
            try {
                syncResult = BaseJsonVo.error((String)e.getMessage());
                this.recordOMSInfo(orderMainNo, orderNo, "updateSunOrderByOid", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, (BaseJsonVo)syncResult);
            }
            catch (Throwable throwable) {
                this.recordOMSInfo(orderMainNo, orderNo, "updateSunOrderByOid", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, (BaseJsonVo)syncResult);
                throw throwable;
            }
        }
        return syncResult;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public BaseJsonVo toDetailOrderModifyOrder(String orderNo, Integer modifyType) {
        BaseJsonVo<WxOrderEntityVO> syncResult = null;
        String orderMainNo = null;
        try {
            MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
            orderMainNo = orderEntity.getOrderMainNo();
            WxOrderEntityVO order = new WxOrderEntityVO();
            order.setExternalOrderNo(orderNo);
            if (modifyType == 1) {
                order.setConsigneeName(orderEntity.getConsigneeName());
                order.setConsigneeMobile(orderEntity.getConsigneePhone());
                order.setConsigneeAddress(orderEntity.getConsigneeAddr());
                order.setConsigneeProvince(orderEntity.getConsigneeProvincename());
                order.setConsigneeCity(orderEntity.getConsigneeCityname());
                order.setConsigneeArea(orderEntity.getConsigneeAreaname());
                order.setConsigneeAreaid(orderEntity.getConsigneeAreaid().toString());
                order.setAddressType(orderEntity.getAddressType());
                order.setPickupTime(orderEntity.getPickupTime());
                order.setDeliveryTime(orderEntity.getDeliverDate());
                order.setStoreId(StringUtils.isNotEmpty((String)orderEntity.getDcId()) && orderEntity.getDcId().contains("|") ? orderEntity.getDcId().split("\\|")[0] : orderEntity.getDcId());
                order.setLogisticsId(orderEntity.getDeliverId().toString());
                order.setLogisticsName(orderEntity.getDeliverName());
            } else if (modifyType == 2) {
                order.setPickupTime(orderEntity.getPickupTime());
                order.setDeliveryTime(orderEntity.getDeliverDate());
                order.setStoreId(StringUtils.isNotEmpty((String)orderEntity.getDcId()) && orderEntity.getDcId().contains("|") ? orderEntity.getDcId().split("\\|")[0] : orderEntity.getDcId());
                order.setLogisticsId(orderEntity.getDeliverId().toString());
                order.setLogisticsName(orderEntity.getDeliverName());
            }
            this.logger.info("print order toDetailOrderModifyOrder : " + JsonUtils.toJson((Object)order, (boolean)false));
            syncResult = this.wxOrderClient.updateMainOrderByOrderMainNo(order);
            if (!syncResult.isSuccess()) {
                this.logger.error("toDetailOrderModifyOrder[{}]:{}", (Object)orderNo, (Object)syncResult.getError_msg());
            }
            this.recordOMSInfo(orderMainNo, orderNo, "toDetailOrderModifyOrder", (Map<String, Object>)new HashMap<String, Object>(orderNo, modifyType){
                final /* synthetic */ String val$orderNo;
                final /* synthetic */ Integer val$modifyType;
                {
                    this.val$orderNo = string;
                    this.val$modifyType = n;
                    this.put("orderNo", this.val$orderNo);
                    this.put("modifyType", this.val$modifyType);
                }
            }, syncResult);
        }
        catch (Exception e) {
            try {
                syncResult = BaseJsonVo.error((String)e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.recordOMSInfo(orderMainNo, orderNo, "toDetailOrderModifyOrder", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, (BaseJsonVo)syncResult);
                throw throwable;
            }
        }
        return syncResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo toDetailOrderStatus(final String orderMainNo, final String orderNo, final OrderStatusEnum orderStatus) {
        ArrayList syncResult = new ArrayList();
        Boolean[] allSuccess = new Boolean[]{true};
        try {
            if (StringUtils.isEmpty((String)orderNo) && StringUtils.isEmpty((String)orderMainNo)) {
                BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u540c\u6b65\u8ba2\u5355\u72b6\u6001\u5230OMS\u5931\u8d25\uff1a\u6ca1\u6709\u4f20\u8ba2\u5355\u53f7");
                return baseJsonVo;
            }
            DetailOrderEntity param = new DetailOrderEntity();
            if (StringUtils.isEmpty((String)orderNo) && StringUtils.isNotEmpty((String)orderMainNo)) {
                param.setOrderMainNo(orderMainNo);
            } else {
                param.setOrderNo(orderNo);
            }
            List orderList = this.detailOrderMapper.getList(param);
            orderList.forEach(order -> {
                try {
                    MallOrderMainEntity mallOrderMainEntity;
                    WxOrderEntityVO omsOrderVo = new WxOrderEntityVO();
                    omsOrderVo.setExternalOrderNo(order.getOrderNo());
                    omsOrderVo.setExternalOrderStatus(String.valueOf(orderStatus.getValue()));
                    if (orderStatus == OrderStatusEnum.DELETE) {
                        MallOrderEntity mallOrderEntity = this.orderInterface.getmallOrder(order.getOrderNo());
                        omsOrderVo.setDeleteTime(mallOrderEntity.getDeleteTime() == null ? DateUtils.now() : mallOrderEntity.getDeleteTime());
                    } else if (orderStatus == OrderStatusEnum.PAYCONFIRM) {
                        mallOrderMainEntity = this.orderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
                        omsOrderVo.setPayTime(mallOrderMainEntity.getPayTime());
                    } else if (orderStatus == OrderStatusEnum.CANCEL) {
                        mallOrderMainEntity = this.orderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
                        omsOrderVo.setCancelTime(mallOrderMainEntity.getCancelTime());
                    } else if (orderStatus == OrderStatusEnum.COMPLETION) {
                        mallOrderMainEntity = this.orderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
                        omsOrderVo.setCancelTime(mallOrderMainEntity.getCompleteTime());
                    } else if (orderStatus == OrderStatusEnum.DELIVERED) {
                        MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
                        if (StringUtils.isEmpty((String)order.getDcId())) {
                            omsOrderVo.setStoreId("1364523716756639744");
                        } else {
                            omsOrderVo.setStoreId(order.getDcId().contains("|") ? order.getDcId().split("\\|")[0] : order.getDcId());
                        }
                        omsOrderVo.setLogisticsId(StringUtils.isEmpty((String)order.getDeliverId()) || "0".equals(order.getDeliverId()) ? "1364524343020752896" : order.getDeliverId());
                        omsOrderVo.setLogisticsName(StringUtils.isEmpty((String)order.getDeliverName()) ? "\u865a\u62df\u7269\u6d41" : order.getDeliverName());
                        omsOrderVo.setLogisticsNo(orderEntity.getWaybillNo());
                        omsOrderVo.setPickupTime(orderEntity.getPickupTime());
                        omsOrderVo.setDeliverdTime(orderEntity.getDeliverDate());
                    }
                    this.logger.info("print order toDetailOrderStatus : " + JsonUtils.toJson((Object)omsOrderVo, (boolean)false));
                    BaseJsonVo<WxOrderEntityVO> rst = this.wxOrderClient.upstatusByOrderMainNo(omsOrderVo);
                    this.logger.info(JsonUtils.toJson(rst, (boolean)false));
                    syncResult.add(rst);
                    if (!rst.isSuccess()) {
                        this.logger.error(JsonUtils.toJson(rst, (boolean)true));
                        allSuccess[0] = false;
                    }
                }
                catch (Exception e) {
                    syncResult.add(BaseJsonVo.error((String)e.getMessage()));
                    allSuccess[0] = false;
                }
            });
        }
        finally {
            syncResult.forEach(syncRst -> this.recordOMSInfo(orderMainNo, orderNo, "toDetailOrderStatus", (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("orderMainNo", orderMainNo);
                    this.put("orderNo", orderNo);
                    this.put("orderStatus", orderStatus.getValue());
                }
            }, (BaseJsonVo)syncRst));
        }
        return allSuccess[0] == true ? BaseJsonVo.success(null) : BaseJsonVo.error((String)"\u90e8\u5206\u5931\u8d25\u6216\u5168\u90e8\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo toDetailOrderDelivered(final WxOrderEntityVO wxOrderEntityVO) {
        ArrayList<BaseJsonVo<WxOrderEntityVO>> syncResult = new ArrayList<BaseJsonVo<WxOrderEntityVO>>();
        Boolean[] allSuccess = new Boolean[]{true};
        try {
            wxOrderEntityVO.setExternalOrderStatus(String.valueOf(OrderStatusEnum.DELIVERED.getValue()));
            this.logger.info("print order toDetailOrderDelivered : " + JsonUtils.toJson((Object)wxOrderEntityVO, (boolean)false));
            BaseJsonVo<WxOrderEntityVO> rst = this.wxOrderClient.upstatusByOrderMainNo(wxOrderEntityVO);
            syncResult.add(rst);
            BaseJsonVo<WxOrderEntityVO> baseJsonVo = rst;
            return baseJsonVo;
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355\u53d1\u8d27[" + wxOrderEntityVO.getExternalOrderNo() + "]\u53cd\u5411\u540c\u6b65OMS\u5931\u8d25", (Throwable)e);
            BaseJsonVo baseJsonVo = BaseJsonVo.error((String)e.getMessage());
            return baseJsonVo;
        }
        finally {
            syncResult.forEach(syncRst -> this.recordOMSInfo(wxOrderEntityVO.getExternalMainOrderNo(), wxOrderEntityVO.getExternalOrderNo(), "toDetailOrderDelivered", (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("orderMainNo", wxOrderEntityVO.getExternalMainOrderNo());
                    this.put("orderNo", wxOrderEntityVO.getExternalOrderNo());
                }
            }, (BaseJsonVo)syncRst));
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void deleteDetailOrder(String orderNo) {
        this.detailOrderMapper.deleteOrder(orderNo);
    }

    @Override
    @Transactional
    public BaseJsonVo toDetailOrder(String orderMainNo, String orderNo) {
        try {
            ArrayList rtnDetailOrderList = new ArrayList();
            MallOrderMainEntity orderMain = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainNo);
            this.logger.info("mainfindsuborder:{}{}", (Object)orderMainNo, (Object)JsonUtils.toJson(orderEntities, (boolean)false));
            List<MallOrderPayEntity> orderPays = this.orderPayInterface.getList(orderMainNo);
            String[] thirdTradeNo = new String[]{null};
            String[] tradeNo = new String[]{null};
            Integer[] payType = new Integer[]{null};
            BigDecimal[] payAmount = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal[] wechatPayAmount = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal[] aliPayAmount = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal[] bankPayAmount = new BigDecimal[]{BigDecimal.ZERO};
            String[] cashtickNo = new String[]{null};
            BigDecimal[] balance = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
            BigDecimal[] prepayAmount = new BigDecimal[]{BigDecimal.ZERO};
            this.logger.info("\u6253\u53701-1:{}", (Object)orderMainNo);
            orderPays.forEach(pay -> {
                if (pay.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue()) {
                    thirdTradeNo[0] = pay.getThirdTradeNo();
                    tradeNo[0] = pay.getTradeNo();
                    wechatPayAmount[0] = pay.getPayamount();
                    payType[0] = pay.getPaytypeId();
                    payAmount[0] = pay.getPayamount();
                } else if (pay.getPaytypeId().intValue() == PayTypeEnum.ALIPAY_PAY.getValue()) {
                    thirdTradeNo[0] = pay.getThirdTradeNo();
                    tradeNo[0] = pay.getTradeNo();
                    aliPayAmount[0] = pay.getPayamount();
                    payType[0] = pay.getPaytypeId();
                    payAmount[0] = pay.getPayamount();
                } else if (pay.getPaytypeId().intValue() == PayTypeEnum.BANK_PAY.getValue()) {
                    thirdTradeNo[0] = pay.getThirdTradeNo();
                    tradeNo[0] = pay.getTradeNo();
                    bankPayAmount[0] = pay.getPayamount();
                    payType[0] = pay.getPaytypeId();
                    payAmount[0] = pay.getPayamount();
                } else if (pay.getPaytypeId().intValue() == PayTypeEnum.MILKBANK_PAY.getValue()) {
                    payType[0] = pay.getPaytypeId();
                    thirdTradeNo[0] = pay.getThirdTradeNo();
                    tradeNo[0] = pay.getTradeNo();
                    payAmount[0] = pay.getPayamount();
                }
                if (pay.getPaytypeId() == 3) {
                    cashtickNo[0] = pay.getCashticketNo();
                }
                if (pay.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_CHARGE_PAY.getValue()) {
                    balance[0] = pay.getPayamount();
                } else if (pay.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_GIVE_PAY.getValue()) {
                    balance[1] = pay.getPayamount();
                } else if (pay.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_GIFTCARD_PAY.getValue()) {
                    balance[2] = pay.getPayamount();
                } else if (pay.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue()) {
                    prepayAmount[0] = pay.getPayamount();
                }
            });
            balance[3] = balance[0].add(balance[1]).add(balance[2]);
            orderEntities.forEach(order -> {
                Integer[] deliverType = new Integer[]{2};
                if (StringUtils.isNotEmpty((String)orderNo) && !orderNo.equals(order.getOrderNo())) {
                    this.logger.info("\u6253\u53701-2:{},{},{},{},{}", new Object[]{orderMainNo, orderNo, order.getOrderNo(), StringUtils.isNotEmpty((String)orderNo), !orderNo.equals(order.getOrderNo())});
                } else {
                    this.logger.info("\u6253\u53701-3:{}", (Object)orderMainNo);
                    this.detailOrderMapper.deleteOrder(order.getOrderNo());
                    BigDecimal orderRate = BigDecimal.ZERO;
                    orderRate = orderMain.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? order.getTotalAmount().divide(orderMain.getTotalAmount(), 10, RoundingMode.HALF_EVEN) : order.getOrderAmount().divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN);
                    DetailOrderEntity detailOrder = new DetailOrderEntity();
                    detailOrder.setOrderNo(order.getOrderNo());
                    detailOrder.setOrderMainNo(order.getOrderMainNo());
                    detailOrder.setPlatformId(orderMain.getPlatformId());
                    detailOrder.setCustomerId(orderMain.getCustomerId());
                    detailOrder.setOrderClass(orderMain.getOrderClass());
                    detailOrder.setOrderSource(orderMain.getOrderSource());
                    detailOrder.setDeliverType(1);
                    detailOrder.setStatus(order.getStatus());
                    detailOrder.setCreateTime(orderMain.getCreateTime());
                    detailOrder.setPayTime(orderMain.getPayTime());
                    detailOrder.setCancelTime(null);
                    detailOrder.setPickupTime(order.getPickupTime() == null ? orderMain.getCreateTime() : order.getPickupTime());
                    detailOrder.setDeliverDate(order.getDeliverDate() == null ? orderMain.getCreateTime() : order.getDeliverDate());
                    detailOrder.setDeliverDateFlag(order.getDeliverDate() == null && orderMain.getOrderSource().intValue() != cc.lechun.common.enums.trade.OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue() ? 0 : 1);
                    detailOrder.setDelivingTime(null);
                    detailOrder.setDelivedTime(null);
                    detailOrder.setArrivedTime(null);
                    detailOrder.setCompleteTime(null);
                    detailOrder.setDeleteTime(null);
                    detailOrder.setConsigneeName(order.getConsigneeName());
                    detailOrder.setConsigneePhone(order.getConsigneePhone());
                    detailOrder.setConsigneeAddr(order.getConsigneeAddr());
                    detailOrder.setConsigneeProvincename(order.getConsigneeProvincename());
                    detailOrder.setConsigneeCityname(order.getConsigneeCityname());
                    detailOrder.setConsigneeAreaname(order.getConsigneeAreaname());
                    detailOrder.setConsigneeAreaid(order.getConsigneeAreaid());
                    detailOrder.setAddressType(order.getAddressType());
                    if (StringUtils.isEmpty((String)order.getDcId())) {
                        detailOrder.setDcId("1364523716756639744");
                    } else {
                        detailOrder.setDcId(order.getDcId().contains("|") ? order.getDcId().split("\\|")[0] : order.getDcId());
                    }
                    detailOrder.setDeliverId(StringUtils.isEmpty((String)order.getDeliverId()) || "0".equals(order.getDeliverId()) ? "1364524343020752896" : order.getDeliverId());
                    detailOrder.setDeliverName(StringUtils.isEmpty((String)order.getDeliverName()) ? "\u865a\u62df\u7269\u6d41" : order.getDeliverName());
                    detailOrder.setWaybillNo(null);
                    detailOrder.setPsTimes(order.getPsTimes());
                    detailOrder.setQuantity(order.getQuantity());
                    detailOrder.setEvaluateStatus(order.getEvaluateStatus());
                    detailOrder.setRemark(order.getRemark());
                    detailOrder.setDeliverRequest(order.getDeliverRequest());
                    detailOrder.setThirdTradeNo(thirdTradeNo[0]);
                    detailOrder.setTradeNo(tradeNo[0]);
                    detailOrder.setCashticketNo(cashtickNo[0]);
                    detailOrder.setSourceOrderMainNo(orderMain.getSourceOrderNo());
                    detailOrder.setTotalAmount(order.getTotalAmount());
                    detailOrder.setOrderAmount(order.getOrderAmount());
                    detailOrder.setPayAmount(order.getPayAmount().add(order.getBalanceAmount()));
                    detailOrder.setFreight(order.getFreight());
                    detailOrder.setBalanceAmount(balance[3].multiply(orderRate).setScale(6, 4));
                    detailOrder.setBalanceChargeAmount(balance[0].multiply(orderRate).setScale(6, 4));
                    detailOrder.setBalanceFreeAmount(balance[1].multiply(orderRate).setScale(6, 4));
                    detailOrder.setBalanceGiftAmount(balance[2].multiply(orderRate).setScale(6, 4));
                    detailOrder.setPrepayAmount(prepayAmount[0].multiply(orderRate).setScale(6, 4));
                    detailOrder.setCouponAmount(order.getCouponAmount());
                    detailOrder.setPayType(payType[0]);
                    detailOrder.setCashAmount(payAmount[0].multiply(orderRate).setScale(6, 4));
                    detailOrder.setWechatPayAmount(wechatPayAmount[0].multiply(orderRate).setScale(6, 4));
                    detailOrder.setAliPayAmount(aliPayAmount[0].multiply(orderRate).setScale(6, 4));
                    detailOrder.setBankPayAmount(bankPayAmount[0].multiply(orderRate).setScale(6, 4));
                    HashSet giftSet = new HashSet();
                    List<MallOrderProductEntity> orderGroups = this.orderGroupInterface.getOrderProductInfoByOrderNo(order.getOrderNo());
                    BigDecimal groupDenominator = orderGroups.stream().map(orderGroup -> orderGroup.getUnitPrice().multiply(new BigDecimal(orderGroup.getQuantity().toString()))).reduce(BigDecimal.ZERO, BigDecimal::add);
                    orderGroups.forEach(orderGroup -> {
                        BigDecimal groupRate = BigDecimal.ZERO.compareTo(groupDenominator) == 0 ? BigDecimal.ONE : orderGroup.getUnitPrice().multiply(new BigDecimal(orderGroup.getQuantity().toString())).divide(groupDenominator, 10, RoundingMode.HALF_EVEN);
                        DetailOrderGroupEntity detailOrderGroup = new DetailOrderGroupEntity();
                        detailOrderGroup.setOrderGroupId(orderGroup.getOrderProductNo());
                        detailOrderGroup.setStatus(5);
                        detailOrderGroup.setOrderNo(order.getOrderNo());
                        detailOrderGroup.setOrderMainNo(order.getOrderMainNo());
                        if (orderGroup.getGroupType() == 1) {
                            if (orderGroup.getGroupId() != null && StringUtils.isNotEmpty((String)orderGroup.getGroupId()) && !"0".equals(orderGroup.getGroupId())) {
                                orderGroup.setGroupType(2);
                            } else if (orderGroup.getProductId() != null && StringUtils.isNotEmpty((String)orderGroup.getProductId()) && !"0".equals(orderGroup.getProductId())) {
                                orderGroup.setGroupType(4);
                            }
                        }
                        if (orderGroup.getGroupType() == 4) {
                            MallProductEntity product = this.mallProductInterface.getProduct(orderGroup.getProductId());
                            detailOrderGroup.setBarCode(product.getBarCode());
                            detailOrderGroup.setProductId(orderGroup.getProductId());
                            if (product.getTransportType() == 3) {
                                detailOrderGroup.setGroupType(2);
                            } else {
                                detailOrderGroup.setGroupType(3);
                            }
                        } else {
                            detailOrderGroup.setGroupType(1);
                            detailOrderGroup.setProductId("");
                        }
                        if (StringUtils.isEmpty((String)orderGroup.getGroupId()) || "0".equals(orderGroup.getGroupId())) {
                            detailOrderGroup.setGroupId(null);
                            detailOrderGroup.setGroupName(null);
                        } else {
                            detailOrderGroup.setGroupId(orderGroup.getGroupId());
                            detailOrderGroup.setGroupName(this.groupInterface.getGroup(detailOrderGroup.getGroupId()).getGroupName());
                        }
                        detailOrderGroup.setProductName(orderGroup.getProductName());
                        detailOrderGroup.setQuantity(orderGroup.getQuantity());
                        detailOrderGroup.setIsGift(orderGroup.getTotalPrice().equals(BigDecimal.ZERO) ? 1 : 2);
                        if (orderGroup.getTotalPrice().equals(BigDecimal.ZERO)) {
                            giftSet.add(detailOrderGroup.getOrderGroupId());
                        }
                        detailOrderGroup.setOriginPrice(orderGroup.getOriginalPrice());
                        detailOrderGroup.setUnitPrice(orderGroup.getUnitPrice());
                        detailOrderGroup.setTotalAmount(order.getTotalAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setOrderAmount(order.getOrderAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setPayAmount(order.getPayAmount().add(order.getBalanceAmount()).multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setFreight(order.getFreight().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setBalanceAmount(detailOrder.getBalanceAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setBalanceChargeAmount(detailOrder.getBalanceChargeAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setBalanceFreeAmount(detailOrder.getBalanceFreeAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setBalanceGiftAmount(detailOrder.getBalanceGiftAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setPrepayAmount(detailOrder.getPrepayAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setCouponAmount(detailOrder.getCouponAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setPayType(detailOrder.getPayType());
                        detailOrderGroup.setCashAmount(detailOrder.getCashAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setWechatPayAmount(detailOrder.getWechatPayAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setAliPayAmount(detailOrder.getAliPayAmount().multiply(groupRate).setScale(6, 4));
                        detailOrderGroup.setBankPayAmount(detailOrder.getBankPayAmount().multiply(groupRate).setScale(6, 4));
                        this.detailOrderGroupMapper.insert(detailOrderGroup);
                    });
                    List<MallOrderGroupProductEntity> orderProducts = this.orderProductInterface.getOrderGroupProductListByOrderNo(order.getOrderNo());
                    BigDecimal productDenominator = orderProducts.stream().map(orderProduct -> orderProduct.getUnitPrice().multiply(new BigDecimal(orderProduct.getQuantity().toString()))).reduce(BigDecimal.ZERO, BigDecimal::add);
                    orderProducts.forEach(orderProduct -> {
                        BigDecimal productRate = BigDecimal.ZERO.compareTo(productDenominator) == 0 ? BigDecimal.ONE : orderProduct.getUnitPrice().multiply(new BigDecimal(orderProduct.getQuantity().toString())).divide(productDenominator, 10, RoundingMode.HALF_EVEN);
                        DetailOrderProductEntity detailOrderProduct = new DetailOrderProductEntity();
                        detailOrderProduct.setOrderProductId(orderProduct.getOrderGroupId());
                        detailOrderProduct.setOrderGroupId(orderProduct.getOrderProductNo());
                        detailOrderProduct.setStatus(5);
                        detailOrderProduct.setOrderNo(order.getOrderNo());
                        detailOrderProduct.setOrderMainNo(order.getOrderMainNo());
                        MallProductEntity product = this.mallProductInterface.getProduct(orderProduct.getProductId());
                        detailOrderProduct.setBarCode(product.getBarCode());
                        this.logger.info("toDetailOrder\u5224\u65adTransportType[{}]\uff1a{}", (Object)orderProduct.getProductId(), (Object)product.getTransportType());
                        if (product.getTransportType() == 3) {
                            detailOrderProduct.setGroupType(2);
                            deliverType[0] = 3;
                        } else {
                            detailOrderProduct.setGroupType(3);
                            if (product.getTransportType() == 1) {
                                deliverType[0] = 1;
                            }
                        }
                        this.logger.info("toDetailOrder\u5224\u65ad\u5b8c\u6210deliverType[0]\uff1a{}", (Object)deliverType[0]);
                        if (StringUtils.isEmpty((String)orderProduct.getGroupId()) || "0".equals(orderProduct.getGroupId())) {
                            detailOrderProduct.setGroupId(null);
                            detailOrderProduct.setGroupName(null);
                        } else {
                            detailOrderProduct.setGroupId(orderProduct.getGroupId());
                            detailOrderProduct.setGroupName(this.groupInterface.getGroup(detailOrderProduct.getGroupId()).getGroupName());
                        }
                        detailOrderProduct.setProductId(orderProduct.getProductId());
                        detailOrderProduct.setProductName(orderProduct.getProductName());
                        detailOrderProduct.setQuantity(orderProduct.getQuantity());
                        detailOrderProduct.setIsGift(giftSet.contains(detailOrderProduct.getOrderGroupId()) ? 1 : 2);
                        detailOrderProduct.setOriginPrice(orderProduct.getOriginPrice());
                        detailOrderProduct.setUnitPrice(orderProduct.getUnitPrice());
                        detailOrderProduct.setTotalAmount(order.getTotalAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setOrderAmount(order.getOrderAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setPayAmount(order.getPayAmount().add(order.getBalanceAmount()).multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setFreight(order.getFreight().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setBalanceAmount(detailOrder.getBalanceAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setBalanceChargeAmount(detailOrder.getBalanceChargeAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setBalanceFreeAmount(detailOrder.getBalanceFreeAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setBalanceGiftAmount(detailOrder.getBalanceGiftAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setPrepayAmount(detailOrder.getPrepayAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setCouponAmount(detailOrder.getCouponAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setPayType(detailOrder.getPayType());
                        detailOrderProduct.setCashAmount(detailOrder.getCashAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setWechatPayAmount(detailOrder.getWechatPayAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setAliPayAmount(detailOrder.getAliPayAmount().multiply(productRate).setScale(6, 4));
                        detailOrderProduct.setBankPayAmount(detailOrder.getBankPayAmount().multiply(productRate).setScale(6, 4));
                        int i = this.detailOrderProductMapper.insert(detailOrderProduct);
                        this.logger.info("\u540c\u6b65OMS\u8ba2\u5355\u5546\u54c1\u660e\u7ec6\u603b\u51fa\u9519\uff0c\u8fd9\u6b21\u540c\u6b65\u7ed3\u679c\u662f\uff1a[{}]\uff0c\u540c\u6b65\u7684\u5546\u54c1\u662f\uff1a{}", (Object)i, (Object)JsonUtils.toJson((Object)detailOrderProduct, (boolean)false));
                    });
                    detailOrder.setDeliverType(deliverType[0]);
                    this.logger.info("toDetailOrder\u5b58\u5230detail_order\u8868\u91cc\u7684\u8fd0\u8f93\u7c7b\u578b\uff1a{}", (Object)detailOrder.getDeliverType());
                    this.detailOrderMapper.insert(detailOrder);
                    rtnDetailOrderList.add(detailOrder);
                }
            });
            return BaseJsonVo.success(rtnDetailOrderList);
        }
        catch (Exception e) {
            this.logger.error("MallOrderSyncInfoService split order error \u62c6\u5206\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
            return BaseJsonVo.error((String)JsonUtils.toJson((Object)e, (boolean)false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public BaseJsonVo syncToOMS(final String orderMainNo) {
        this.logger.info("\u6253\u53701:{}", (Object)orderMainNo);
        BaseJsonVo splitRst = ((MallOrderSyncInfoService)SpringContextUtil.getBean(this.getClass())).toDetailOrder(orderMainNo, null);
        this.logger.info("\u6253\u53702:{}:{}", (Object)orderMainNo, (Object)JsonUtils.toJson((Object)splitRst, (boolean)false));
        if (!splitRst.isSuccess()) {
            return splitRst;
        }
        this.logger.info("\u6253\u53703");
        ArrayList syncResult = new ArrayList();
        Boolean[] allSuccess = new Boolean[]{true};
        try {
            this.logger.info("\u6253\u53704");
            DetailOrderEntity param = new DetailOrderEntity();
            param.setOrderMainNo(orderMainNo);
            List orderList = this.detailOrderMapper.getList(param);
            this.logger.info("\u6253\u53705");
            orderList.forEach(order -> {
                try {
                    MallOrderSyncInfoEntity existEntity = new MallOrderSyncInfoEntity();
                    existEntity.setSuccess(1);
                    existEntity.setOrderNo(order.getOrderNo());
                    this.logger.info("\u6253\u53706");
                    if (this.orderSyncInfoMapper.existsByEntity(existEntity) == 0) {
                        WxOrderEntityVO omsOrderVo = this.buildVO((DetailOrderEntity)order);
                        this.logger.info("\u6253\u53707");
                        BaseJsonVo rst = this.wxOrderClient.addOrder(omsOrderVo);
                        this.logger.info("\u67e5\u770boms\u540c\u6b65\u8fd4\u56de\u503c\uff1a" + JsonUtils.toJson((Object)rst, (boolean)false));
                        syncResult.add(rst);
                        if (!rst.isSuccess()) {
                            allSuccess[0] = false;
                        }
                    }
                }
                catch (Exception e) {
                    BaseJsonVo error = BaseJsonVo.error((String)e.getMessage());
                    error.setValue((Object)order.getOrderNo());
                    syncResult.add(error);
                    allSuccess[0] = false;
                    this.logger.error("\u540c\u6b65\u8ba2\u5355\u5f02\u5e38[" + orderMainNo + "]", (Throwable)e);
                }
            });
        }
        finally {
            syncResult.forEach(syncRst -> this.recordOMSInfo(orderMainNo, (String)syncRst.getValue(), "syncToOMS", (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("orderMainNo", orderMainNo);
                }
            }, (BaseJsonVo)syncRst));
        }
        return allSuccess[0] == true ? BaseJsonVo.success(null) : BaseJsonVo.error((String)("[" + orderMainNo + "]\u90e8\u5206\u5931\u8d25\u6216\u5168\u90e8\u5931\u8d25"));
    }

    @Override
    public BaseJsonVo syncOrder(String orderNo) {
        DetailOrderEntity order = (DetailOrderEntity)this.detailOrderMapper.selectByPrimaryKey((Serializable)((Object)orderNo));
        WxOrderEntityVO omsOrderVo = this.buildVO(order);
        return this.wxOrderClient.addOrder(omsOrderVo);
    }

    private WxOrderEntityVO buildVO(DetailOrderEntity order) {
        DetailOrderGroupEntity paramGroup = new DetailOrderGroupEntity();
        paramGroup.setOrderNo(order.getOrderNo());
        List groupList = this.detailOrderGroupMapper.getList(paramGroup);
        DetailOrderProductEntity paramProduct = new DetailOrderProductEntity();
        paramProduct.setOrderNo(order.getOrderNo());
        List productList = this.detailOrderProductMapper.getList(paramProduct);
        this.logger.info("\u6253\u53708");
        if (groupList.size() > productList.size()) {
            this.logger.error("\u8b66\u544a\uff01\uff01\u8b66\u544a\uff01\uff01\u540c\u6b65\u8ba2\u5355\u51fa\u73b0\u95ee\u9898\uff0c\u660e\u7ec6\u6570\u91cf\u5c11\u4e8edetail\u6570\u91cf\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)order.getOrderMainNo());
            throw new RuntimeException("\u540c\u6b65\u8ba2\u5355\u51fa\u73b0\u95ee\u9898\uff0c\u660e\u7ec6\u6570\u91cf\u5c11\u4e8edetail\u6570\u91cf");
        }
        this.logger.info("\u6253\u53709");
        return this.transferToOmsVo(order, groupList, productList);
    }

    private WxOrderEntityVO transferToOmsVo(DetailOrderEntity order, List<DetailOrderGroupEntity> groupList, List<DetailOrderProductEntity> productList) {
        MallOrderMainEntity mallOrderMainEntity;
        PrepayCardEntity prepayCardEntity;
        WxOrderEntityVO vo = new WxOrderEntityVO();
        vo.setExternalOrderNo(order.getOrderNo());
        vo.setOrderMainNo(order.getOrderMainNo());
        vo.setExternalMainOrderNo(order.getOrderMainNo());
        CustomerEntity customer = this.customerService.getCustomer(order.getCustomerId());
        vo.setBuyerId(customer == null ? "" : order.getCustomerId());
        vo.setBuyerNickname(customer == null ? "" : customer.getNickName());
        vo.setCreatedTime(order.getCreateTime());
        vo.setExternalCreateTime(order.getCreateTime());
        vo.setPayTime(order.getPayTime());
        vo.setConsigneeName(order.getConsigneeName());
        vo.setConsigneeMobile(order.getConsigneePhone());
        vo.setConsigneeAddress(order.getConsigneeAddr());
        vo.setConsigneeProvince(order.getConsigneeProvincename());
        vo.setConsigneeCity(order.getConsigneeCityname());
        vo.setConsigneeArea(order.getConsigneeAreaname());
        vo.setConsigneeAreaid(String.valueOf(order.getConsigneeAreaid()));
        vo.setDeliveryTime(order.getDeliverDateFlag() == 1 ? order.getDeliverDate() : null);
        this.logger.info("\u8bbe\u7f6e\u540c\u6b65\u914d\u8d27\u65e5\u671f:{},{}", new Object[]{vo.getDeleteTime(), order.getDeliverDateFlag(), order.getDeliverDateFlag()});
        vo.setLogisticsId(String.valueOf(order.getDeliverId()));
        vo.setLogisticsNo(StringUtils.isNotEmpty((String)order.getWaybillNo()) ? order.getWaybillNo() : null);
        vo.setLogisticsName(order.getDeliverName());
        vo.setConsigneeRemark(order.getDeliverRequest());
        vo.setRemark(order.getRemark());
        vo.setExternalOrderStatus(String.valueOf(order.getStatus()));
        vo.setCancelTime(order.getCancelTime());
        vo.setDelivingTime(order.getDelivingTime());
        vo.setDeliverdTime(order.getDeliverDate());
        vo.setArrivedTime(order.getArrivedTime());
        vo.setCompleteTime(order.getCompleteTime());
        vo.setPickupTime(order.getDeliverDateFlag() == 1 ? order.getPickupTime() : null);
        this.logger.info("\u8bbe\u7f6e\u540c\u6b65\u63d0\u8d27\u65e5\u671f:{},{}", (Object)vo.getPickupTime(), (Object)order.getDeliverDateFlag());
        vo.setDeleteTime(order.getDeleteTime());
        vo.setPsTims(order.getPsTimes());
        vo.setQuantity(order.getQuantity());
        vo.setStoreId(order.getDcId());
        vo.setAddressType(order.getAddressType());
        vo.setOrderClass(order.getOrderClass());
        vo.setOrderSource(order.getOrderSource());
        vo.setSourceOrderMainNo(order.getSourceOrderMainNo());
        vo.setOrderType(Integer.valueOf(order.getDeliverType() == 2 ? 1 : order.getDeliverType()));
        if (order.getDeliverType() == 3) {
            vo.setOrderSonType(Integer.valueOf(12));
        } else if (order.getOrderSource().intValue() == OrderSourceEnum.LONGPERIOD_BUY.getValue()) {
            vo.setOrderSonType(Integer.valueOf(2));
        } else if (order.getOrderSource().intValue() == cc.lechun.common.enums.trade.OrderSourceEnum.COMMUNITY_GROUP.getValue()) {
            vo.setOrderSonType(Integer.valueOf(15));
        } else {
            vo.setOrderSonType(Integer.valueOf(1));
        }
        vo.setPlatform_type(order.getPlatformId());
        vo.setEvaluateStatus(Integer.valueOf(0));
        vo.setOrderIsCw(order.getDeliverType());
        vo.setThirdTradeNo(order.getThirdTradeNo());
        vo.setTradeNo(order.getTradeNo());
        vo.setCashticketNo(order.getCashticketNo());
        vo.setOrderAmount(order.getTotalAmount().setScale(6, 4));
        vo.setPayAmount(order.getPayAmount().setScale(6, 4));
        vo.setPostAmount(order.getFreight().setScale(6, 4));
        vo.setPayBalancePerAmount(order.getBalanceAmount().setScale(6, 4));
        vo.setPayBalanceChargePerAmount(order.getBalanceChargeAmount().setScale(6, 4));
        vo.setPayBalanceFreePerAmount(order.getBalanceFreeAmount().setScale(6, 4));
        vo.setPayBalanceGiftPerAmount(order.getBalanceGiftAmount().setScale(6, 4));
        vo.setPayPrepayPerAmount(order.getPrepayAmount().setScale(6, 4));
        vo.setPayCouponPerAmount(order.getCouponAmount().setScale(6, 4));
        vo.setPayType(order.getPayType());
        vo.setCashAmount(order.getCashAmount().setScale(6, 4));
        vo.setPayWechatPerAmount(order.getWechatPayAmount().setScale(6, 4));
        vo.setPayAlipayPerAmount(order.getAliPayAmount().setScale(6, 4));
        vo.setPayUnionpayPerAmount(order.getBankPayAmount().setScale(6, 4));
        vo.setOrderCreateMethod(Integer.valueOf(1));
        String prepayShopId = null;
        String sourceOrderNo = null;
        List<PrepayCardDetailEntity> planDetailListByOrderMainNo = this.prepayCardPlanDetailInterface.getPlanDetailListByOrderMainNo(order.getOrderMainNo());
        if (planDetailListByOrderMainNo != null && planDetailListByOrderMainNo.size() > 0 && (prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)planDetailListByOrderMainNo.get(0).getCardId()))) != null && StringUtils.isNotEmpty((String)prepayCardEntity.getShopId())) {
            prepayShopId = prepayCardEntity.getShopId();
            sourceOrderNo = prepayCardEntity.getOrderMainNo();
        }
        if (prepayShopId != null) {
            vo.setShopId(prepayShopId);
            if (StringUtils.isEmpty((String)order.getSourceOrderMainNo()) && sourceOrderNo != null) {
                vo.setSourceOrderMainNo(sourceOrderNo);
            }
        } else if (order.getOrderSource() != null && order.getOrderSource().intValue() == cc.lechun.common.enums.trade.OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
            mallOrderMainEntity = this.orderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
            if (mallOrderMainEntity.getChannelId() != 86) {
                vo.setShopId(ShopChannelEnum.getShopId(mallOrderMainEntity.getChannelId()));
            } else if (order.getSourceOrderMainNo().startsWith("49") || order.getSourceOrderMainNo().startsWith("50")) {
                vo.setShopId("1431102310229086208");
            } else {
                vo.setShopId("1133282653733261312");
            }
        } else if (order.getOrderSource() != null && order.getOrderSource().intValue() == cc.lechun.common.enums.trade.OrderSourceEnum.CARDPLAN.getValue()) {
            mallOrderMainEntity = this.orderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
            vo.setShopId(ShopChannelEnum.getShopId(mallOrderMainEntity.getChannelId()));
        } else {
            vo.setShopId(order.getPlatformId() == 4 ? "1325743461067264001" : "1325743461067264000");
        }
        List<WxOrderProductVO> omsOrderProductVos = this.transferToOmsProcutVo(vo.getShopId(), order, productList);
        List<WxOrderDetailVO> omsOrderDetailVos = this.transferToOmsGroupVo(vo.getShopId(), order, groupList, omsOrderProductVos);
        if (!("1325743461067264000".equals(vo.getShopId()) || "1325743461067264001".equals(vo.getShopId()) || "1480435319658778624".equals(vo.getShopId()))) {
            List<WxOrderDetailVO> realGroupVOs = omsOrderDetailVos.stream().filter(omsOrderDetailVo -> omsOrderDetailVo.getProductType() == 1).collect(Collectors.toList());
            realGroupVOs.forEach(realGroupVO -> {
                List realProductVOs = omsOrderProductVos.stream().filter(omsOrderProductVo -> omsOrderProductVo.getParentOid().equals(realGroupVO.getOid())).collect(Collectors.toList());
                if (realProductVOs.size() > 1) {
                    for (WxOrderProductVO realProductVO : omsOrderProductVos) {
                        if (!realProductVO.getParentOid().equals(realGroupVO.getOid())) continue;
                        WxOrderDetailVO singleDetailVO = this.buildSingleDetailVO(order, realProductVO);
                        omsOrderDetailVos.add(singleDetailVO);
                    }
                    omsOrderDetailVos.removeIf(origin -> origin.getCguid().equals(realGroupVO.getCguid()));
                }
            });
        }
        vo.setWxOrderDetailVOList(omsOrderDetailVos);
        vo.setWxOrderProductVOList(omsOrderProductVos);
        this.logger.info("\u540c\u6b65\u7684VO\u662f\uff1a{}", (Object)JsonUtils.toJson((Object)vo, (boolean)false));
        return vo;
    }

    private WxOrderDetailVO buildSingleDetailVO(DetailOrderEntity order, WxOrderProductVO wxProduct) {
        WxOrderDetailVO vo = new WxOrderDetailVO();
        vo.setCguid(IDGenerate.getUniqueIdStr());
        vo.setExternalOrderNo(wxProduct.getExternalOrderNo());
        vo.setOid(vo.getCguid());
        wxProduct.setParentOid(vo.getOid());
        wxProduct.setSuitId(null);
        wxProduct.setSuitName(null);
        wxProduct.setDetailId(vo.getCguid());
        vo.setExternalMainOrderNo(wxProduct.getExternalMainOrderNo());
        vo.setDeliveryTime(order.getDeliverDate());
        vo.setStatus(order.getStatus());
        vo.setPartMjzDiscount(BigDecimal.ZERO);
        vo.setDiscountFee(wxProduct.getDiscountFee());
        vo.setPostFee(wxProduct.getPostFee());
        vo.setProductId(wxProduct.getProductId());
        vo.setProductIsGift(wxProduct.getProductIsGift());
        vo.setProductCode(vo.getProductId());
        vo.setProductCbarcode(wxProduct.getProductCbarcode());
        vo.setProductName(wxProduct.getProductName());
        vo.setProductType(wxProduct.getProductType());
        vo.setProductNum(wxProduct.getProductNum());
        vo.setProductPrice(wxProduct.getProductPrice().setScale(6, 4));
        vo.setProductAmount(wxProduct.getProductAmount());
        vo.setProductSellPrice(wxProduct.getProductSellPrice());
        vo.setProductSellAmount(wxProduct.getProductSellAmount());
        vo.setProductSaleAmount(wxProduct.getProductSaleAmount());
        vo.setProductSalePrice(wxProduct.getProductSalePrice());
        vo.setIsPromotion(Integer.valueOf(2));
        vo.setLogisticsId(order.getDeliverId());
        vo.setLogisticsNo(order.getWaybillNo());
        vo.setStoreId(order.getDcId());
        vo.setCustomerId(order.getCustomerId());
        vo.setPickupTime(order.getPickupTime());
        vo.setPayTime(order.getPayTime());
        vo.setPayAmount(wxProduct.getPayAmount());
        vo.setPayBalancePerAmount(wxProduct.getPayBalancePerAmount());
        vo.setPayBalanceChargePerAmount(wxProduct.getPayBalanceChargePerAmount());
        vo.setPayBalanceFreePerAmount(wxProduct.getPayBalanceFreePerAmount());
        vo.setPayBalanceGiftPerAmount(wxProduct.getPayBalanceGiftPerAmount());
        vo.setPayPrepayPerAmount(wxProduct.getPayPrepayPerAmount());
        vo.setPayCouponPerAmount(wxProduct.getPayCouponPerAmount());
        vo.setPayType(wxProduct.getPayType());
        vo.setCashAmount(wxProduct.getCashAmount());
        vo.setPayWechatPerAmount(wxProduct.getPayWechatPerAmount());
        vo.setPayAlipayPerAmount(wxProduct.getPayAlipayPerAmount());
        vo.setPayUnionpayPerAmount(wxProduct.getPayUnionpayPerAmount());
        vo.setExternalMainOrderStatus(String.valueOf(order.getStatus()));
        vo.setArrivedTime(order.getArrivedTime());
        return vo;
    }

    private List<WxOrderDetailVO> transferToOmsGroupVo(String shopId, DetailOrderEntity order, List<DetailOrderGroupEntity> groupList, List<WxOrderProductVO> omsOrderProductVos) {
        boolean b;
        ArrayList<WxOrderDetailVO> vos = new ArrayList<WxOrderDetailVO>();
        if (!"1325743461067264000".equals(shopId) && !"1325743461067264001".equals(shopId) && !"1435846040181936128".equals(shopId) && (b = groupList.stream().anyMatch(group -> group.getGroupType() == 1))) {
            List<DetailOrderGroupEntity> groups = groupList.stream().filter(group -> group.getGroupType() == 1).collect(Collectors.toList());
            groups.forEach(group -> omsOrderProductVos.forEach(productVO -> {
                if (productVO.getOid().equals(group.getOrderGroupId())) {
                    WxOrderDetailVO vo = new WxOrderDetailVO();
                    vo.setCguid(IDGenerate.getUniqueIdStr());
                    productVO.setDetailId(vo.getCguid());
                    productVO.setParentOid(null);
                    productVO.setSuitName(null);
                    productVO.setSuitId(null);
                    vo.setExternalOrderNo(order.getOrderNo());
                    vo.setOid(vo.getCguid());
                    vo.setExternalMainOrderNo(order.getOrderMainNo());
                    vo.setDeliveryTime(order.getDeliverDate());
                    vo.setStatus(order.getStatus());
                    vo.setPartMjzDiscount(BigDecimal.ZERO);
                    vo.setDiscountFee(productVO.getDiscountFee());
                    vo.setPostFee(productVO.getPostFee());
                    vo.setProductId(productVO.getProductId());
                    vo.setProductIsGift(productVO.getProductIsGift());
                    vo.setProductCode(vo.getProductId());
                    vo.setProductCbarcode(productVO.getProductCbarcode());
                    vo.setProductName(productVO.getProductName());
                    vo.setProductType(Integer.valueOf(3));
                    vo.setProductNum(productVO.getProductNum());
                    vo.setProductPrice(productVO.getProductPrice());
                    vo.setProductAmount(productVO.getProductAmount());
                    vo.setProductSellPrice(productVO.getProductSellPrice());
                    vo.setProductSellAmount(productVO.getProductSellAmount());
                    vo.setProductSaleAmount(productVO.getProductSaleAmount());
                    vo.setProductSalePrice(productVO.getProductSalePrice());
                    vo.setIsPromotion(Integer.valueOf(2));
                    vo.setLogisticsId(order.getDeliverId());
                    vo.setLogisticsNo(order.getWaybillNo());
                    vo.setStoreId(order.getDcId());
                    vo.setCustomerId(order.getCustomerId());
                    vo.setPickupTime(order.getPickupTime());
                    vo.setPayTime(order.getPayTime());
                    vo.setPayAmount(productVO.getPayAmount());
                    vo.setPayBalancePerAmount(productVO.getPayBalancePerAmount());
                    vo.setPayBalanceChargePerAmount(productVO.getPayBalanceChargePerAmount());
                    vo.setPayBalanceFreePerAmount(productVO.getPayBalanceFreePerAmount());
                    vo.setPayBalanceGiftPerAmount(productVO.getPayBalanceGiftPerAmount());
                    vo.setPayPrepayPerAmount(productVO.getPayPrepayPerAmount());
                    vo.setPayCouponPerAmount(productVO.getPayCouponPerAmount());
                    vo.setPayType(productVO.getPayType());
                    vo.setCashAmount(productVO.getCashAmount());
                    vo.setPayWechatPerAmount(productVO.getPayWechatPerAmount());
                    vo.setPayAlipayPerAmount(productVO.getPayAlipayPerAmount());
                    vo.setPayUnionpayPerAmount(productVO.getPayUnionpayPerAmount());
                    vo.setExternalMainOrderStatus(String.valueOf(order.getStatus()));
                    vo.setArrivedTime(order.getArrivedTime());
                    vos.add(vo);
                }
            }));
        }
        groupList.forEach(group -> {
            if (!("1325743461067264000".equals(shopId) || "1325743461067264001".equals(shopId) || "1435846040181936128".equals(shopId) || group.getGroupType() != 1)) {
                return;
            }
            WxOrderDetailVO vo = new WxOrderDetailVO();
            vo.setCguid(group.getOrderGroupId());
            vo.setExternalOrderNo(group.getOrderNo());
            vo.setOid(group.getOrderGroupId());
            vo.setExternalMainOrderNo(group.getOrderMainNo());
            vo.setDeliveryTime(order.getDeliverDate());
            vo.setStatus(order.getStatus());
            vo.setPartMjzDiscount(BigDecimal.ZERO);
            vo.setDiscountFee(group.getCouponAmount());
            vo.setPostFee(group.getFreight());
            vo.setProductId(StringUtils.isEmpty((String)group.getProductId()) ? group.getGroupId() : group.getProductId());
            vo.setProductIsGift(group.getIsGift());
            vo.setProductCode(vo.getProductId());
            vo.setProductCbarcode(group.getGroupType() == 1 ? vo.getProductId() : group.getBarCode());
            vo.setProductName(group.getProductName());
            vo.setProductType(group.getGroupType());
            vo.setProductNum(new BigDecimal(group.getQuantity().toString()));
            vo.setProductPrice(group.getOriginPrice().setScale(6, 4));
            vo.setProductAmount(group.getOriginPrice().multiply(vo.getProductNum()).setScale(6, 4));
            vo.setProductSellPrice(group.getPayAmount().divide(vo.getProductNum(), 6).setScale(6, 4));
            vo.setProductSellAmount(group.getPayAmount().setScale(6, 4));
            vo.setProductSaleAmount(omsOrderProductVos.stream().filter(productVO -> productVO.getDetailId().equals(vo.getOid())).map(pro -> new BigDecimal(pro.getProductSaleAmount())).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(6, 4).toString());
            vo.setProductSalePrice(new BigDecimal(vo.getProductSaleAmount()).divide(vo.getProductNum()).setScale(6, 4).setScale(6, 4).toString());
            vo.setIsPromotion(Integer.valueOf(2));
            vo.setLogisticsId(order.getDeliverId().toString());
            vo.setLogisticsNo(order.getWaybillNo());
            vo.setStoreId(order.getDcId());
            vo.setCustomerId(order.getCustomerId());
            vo.setPickupTime(order.getPickupTime());
            vo.setPayTime(order.getPayTime());
            vo.setPayAmount(group.getPayAmount().setScale(6, 4));
            vo.setPayBalancePerAmount(group.getBalanceAmount().setScale(6, 4));
            vo.setPayBalanceChargePerAmount(group.getBalanceChargeAmount().setScale(6, 4));
            vo.setPayBalanceFreePerAmount(group.getBalanceFreeAmount().setScale(6, 4));
            vo.setPayBalanceGiftPerAmount(group.getBalanceGiftAmount().setScale(6, 4));
            vo.setPayPrepayPerAmount(group.getPrepayAmount().setScale(6, 4));
            vo.setPayCouponPerAmount(group.getCouponAmount().setScale(6, 4));
            vo.setPayType(Integer.valueOf(group.getPayType() == null ? 0 : group.getPayType()));
            vo.setCashAmount(group.getCashAmount().setScale(6, 4));
            vo.setPayWechatPerAmount(group.getWechatPayAmount().setScale(6, 4));
            vo.setPayAlipayPerAmount(group.getAliPayAmount().setScale(6, 4));
            vo.setPayUnionpayPerAmount(group.getBankPayAmount().setScale(6, 4));
            vo.setExternalMainOrderStatus(String.valueOf(order.getStatus()));
            vo.setArrivedTime(order.getArrivedTime());
            vos.add(vo);
        });
        return vos;
    }

    private List<WxOrderProductVO> transferToOmsProcutVo(String shopId, DetailOrderEntity order, List<DetailOrderProductEntity> productList) {
        ArrayList<WxOrderProductVO> vos = new ArrayList<WxOrderProductVO>();
        productList.forEach(product -> {
            WxOrderProductVO vo = new WxOrderProductVO();
            this.logger.info(">>>>>>>>>>>>>" + product.getOrderGroupId());
            vo.setDetailId(product.getOrderGroupId());
            vo.setExternalOrderNo(product.getOrderNo());
            if (!("1325743461067264000".equals(shopId) || "1325743461067264001".equals(shopId) || "1435846040181936128".equals(shopId))) {
                vo.setOid(product.getOrderGroupId());
            } else {
                vo.setOid(product.getOrderProductId());
            }
            vo.setParentOid(product.getOrderGroupId());
            vo.setExternalMainOrderNo(product.getOrderMainNo());
            vo.setDeliveryTime(order.getDeliverDate());
            vo.setStatus(order.getStatus());
            vo.setPartMjzDiscount(BigDecimal.ZERO);
            vo.setDiscountFee(product.getCouponAmount());
            vo.setPostFee(product.getFreight());
            vo.setProductId(product.getProductId());
            vo.setProductIsGift(product.getIsGift());
            vo.setProductCode(vo.getProductId());
            vo.setProductCbarcode(product.getBarCode());
            vo.setProductName(product.getProductName());
            vo.setProductType(product.getGroupType());
            vo.setProductNum(new BigDecimal(product.getQuantity().toString()));
            vo.setProductPrice(product.getOriginPrice().setScale(6, 4));
            vo.setProductAmount(product.getOriginPrice().multiply(vo.getProductNum()).setScale(6, 4));
            vo.setProductSellPrice(product.getPayAmount().divide(vo.getProductNum(), 6));
            vo.setProductSellAmount(product.getPayAmount().setScale(6, 4));
            vo.setProductSalePrice(product.getOriginPrice().toString());
            vo.setProductSaleAmount(product.getOriginPrice().multiply(vo.getProductNum()).setScale(6, 4).toString());
            vo.setIsPromotion(Integer.valueOf(2));
            vo.setLogisticsId(order.getDeliverId().toString());
            vo.setLogisticsNo(order.getWaybillNo());
            vo.setStoreId(order.getDcId());
            vo.setCustomerId(order.getCustomerId());
            vo.setPickupTime(order.getPickupTime());
            vo.setPayTime(order.getPayTime());
            vo.setPayAmount(product.getPayAmount().setScale(6, 4));
            vo.setPayBalancePerAmount(product.getBalanceAmount().setScale(6, 4));
            vo.setPayBalanceChargePerAmount(product.getBalanceChargeAmount().setScale(6, 4));
            vo.setPayBalanceFreePerAmount(product.getBalanceFreeAmount().setScale(6, 4));
            vo.setPayBalanceGiftPerAmount(product.getBalanceGiftAmount().setScale(6, 4));
            vo.setPayPrepayPerAmount(product.getPrepayAmount().setScale(6, 4));
            vo.setPayCouponPerAmount(product.getCouponAmount().setScale(6, 4));
            vo.setPayType(Integer.valueOf(product.getPayType() == null ? 0 : product.getPayType()));
            vo.setCashAmount(product.getCashAmount().setScale(6, 4));
            vo.setPayWechatPerAmount(product.getWechatPayAmount().setScale(6, 4));
            vo.setPayAlipayPerAmount(product.getAliPayAmount().setScale(6, 4));
            vo.setPayUnionpayPerAmount(product.getBankPayAmount().setScale(6, 4));
            vo.setExternalMainOrderStatus(String.valueOf(order.getStatus()));
            vo.setArrivedTime(order.getArrivedTime());
            vo.setSuitId(product.getGroupId());
            vo.setSuitName(product.getGroupName());
            vos.add(vo);
        });
        return vos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo<String> syncDeliverdStatusFromOMS2Mall(final WxOrderEntityVO wxOrderEntityVO) {
        MallOrderEntity orderEntity;
        BaseJsonVo syncResult;
        block18: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                this.logger.info("[{}]\u8ba2\u5355\u53d1\u8d27\u8c03\u7528:{}", (Object)wxOrderEntityVO.getExternalOrderNo(), (Object)JsonUtils.toJson((Object)wxOrderEntityVO, (boolean)false));
                                syncResult = null;
                                if (wxOrderEntityVO != null && !StringUtils.isEmpty((String)wxOrderEntityVO.getExternalOrderNo())) break block13;
                                BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"WxOrderEntityVO\u7684externalOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
                                this.recordOMSInfo(wxOrderEntityVO.getExternalMainOrderNo(), wxOrderEntityVO.getExternalOrderNo(), "syncDeliverdStatusFromOMS2Mall", (Map<String, Object>)new HashMap<String, Object>(wxOrderEntityVO){
                                    final /* synthetic */ WxOrderEntityVO val$wxOrderEntityVO;
                                    {
                                        this.val$wxOrderEntityVO = wxOrderEntityVO;
                                        this.put("wxOrderEntityVO", this.val$wxOrderEntityVO);
                                    }
                                }, syncResult);
                                return baseJsonVo;
                            }
                            orderEntity = this.orderInterface.getmallOrder(wxOrderEntityVO.getExternalOrderNo());
                            if (orderEntity != null) break block14;
                            BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
                            this.recordOMSInfo(wxOrderEntityVO.getExternalMainOrderNo(), wxOrderEntityVO.getExternalOrderNo(), "syncDeliverdStatusFromOMS2Mall", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, syncResult);
                            return baseJsonVo;
                        }
                        if (!StringUtils.isEmpty((String)wxOrderEntityVO.getStoreId()) && !StringUtils.isEmpty((String)wxOrderEntityVO.getLogisticsId()) && !StringUtils.isEmpty((String)wxOrderEntityVO.getLogisticsName()) && !StringUtils.isEmpty((String)wxOrderEntityVO.getLogisticsNo()) && wxOrderEntityVO.getDeliverdTime() != null) break block15;
                        this.logger.info("storeId={},logisticsId={},logisticsName={},logisticsNo={},deliverdTime={}", new Object[]{wxOrderEntityVO.getStoreId(), wxOrderEntityVO.getLogisticsId(), wxOrderEntityVO.getLogisticsName(), wxOrderEntityVO.getLogisticsNo(), wxOrderEntityVO.getDeliverdTime()});
                        BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u53c2\u6570:storeId\u3001logisticsId\uff0clogisticsName\u3001logisticsNo\u3001deliverdTime\u662f\u5426\u4e3a\u7a7a\uff01");
                        this.recordOMSInfo(wxOrderEntityVO.getExternalMainOrderNo(), wxOrderEntityVO.getExternalOrderNo(), "syncDeliverdStatusFromOMS2Mall", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, syncResult);
                        return baseJsonVo;
                    }
                    Boolean[] missOid = new Boolean[]{false};
                    if (wxOrderEntityVO.getWxOrderProductVOList() == null || wxOrderEntityVO.getWxOrderProductVOList().size() <= 0) break block16;
                    wxOrderEntityVO.getWxOrderProductVOList().forEach(product -> {
                        if (StringUtils.isEmpty((String)product.getOid())) {
                            missOid[0] = true;
                            return;
                        }
                    });
                    if (!missOid[0].booleanValue()) break block16;
                    BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u5b50\u8ba2\u5355\u5546\u54c1\u7684oid\u4e0d\u80fd\u4e3a\u7a7a");
                    this.recordOMSInfo(wxOrderEntityVO.getExternalMainOrderNo(), wxOrderEntityVO.getExternalOrderNo(), "syncDeliverdStatusFromOMS2Mall", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, syncResult);
                    return baseJsonVo;
                }
                syncResult = this.orderInterface.updateOrderStatusByEdb(wxOrderEntityVO.getExternalOrderNo(), String.valueOf(OrderStatusEnum.DELIVERED.getValue()), DateUtils.formatDate((Date)wxOrderEntityVO.getDeliverdTime(), (String)""), wxOrderEntityVO.getLogisticsNo(), wxOrderEntityVO.getLogisticsId(), wxOrderEntityVO.getLogisticsName(), wxOrderEntityVO.getDeleteTime());
                if (syncResult.isSuccess()) break block17;
                BaseJsonVo baseJsonVo = syncResult;
                this.recordOMSInfo(wxOrderEntityVO.getExternalMainOrderNo(), wxOrderEntityVO.getExternalOrderNo(), "syncDeliverdStatusFromOMS2Mall", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, syncResult);
                return baseJsonVo;
            }
            if (wxOrderEntityVO.getWxOrderProductVOList() != null && wxOrderEntityVO.getWxOrderProductVOList().size() > 0) {
                wxOrderEntityVO.getWxOrderProductVOList().forEach(wxOrderProductVO -> {
                    MallOrderGroupProductDeliverEntity entity = new MallOrderGroupProductDeliverEntity();
                    entity.setOrderGroupId(wxOrderProductVO.getOid());
                    entity.setOrderNo(wxOrderProductVO.getExternalOrderNo());
                    entity.setProductId(wxOrderProductVO.getProductId());
                    entity.setPickupTime(wxOrderProductVO.getPickupTime());
                    entity.setDeliverDate(wxOrderProductVO.getDeliveryTime());
                    entity.setDcId(wxOrderProductVO.getLogisticsId());
                    entity.setWayBillNo(wxOrderProductVO.getLogisticsNo());
                    this.orderGroupProductDeliverInterface.insertOrUpdate(entity);
                });
            }
            if ((syncResult = this.toDetailOrderDelivered(wxOrderEntityVO)).isSuccess()) break block18;
            BaseJsonVo baseJsonVo = syncResult;
            this.recordOMSInfo(wxOrderEntityVO.getExternalMainOrderNo(), wxOrderEntityVO.getExternalOrderNo(), "syncDeliverdStatusFromOMS2Mall", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, syncResult);
            return baseJsonVo;
        }
        try {
            try {
                ExecutorService pool = Executors.newFixedThreadPool(1);
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        orderEntity.setWaybillNo(wxOrderEntityVO.getLogisticsNo());
                        MallOrderSyncInfoService.this.sendDeliverMessage(orderEntity, wxOrderEntityVO.getWxOrderProductVOList());
                    }
                });
                pool.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error(e.getMessage());
            }
            this.recordOMSInfo(wxOrderEntityVO.getExternalMainOrderNo(), wxOrderEntityVO.getExternalOrderNo(), "syncDeliverdStatusFromOMS2Mall", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, syncResult);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.logger.error("\u5f02\u5e38", (Throwable)e);
                syncResult = BaseJsonVo.error((String)e.getMessage());
                this.recordOMSInfo(wxOrderEntityVO.getExternalMainOrderNo(), wxOrderEntityVO.getExternalOrderNo(), "syncDeliverdStatusFromOMS2Mall", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, syncResult);
            }
            catch (Throwable throwable) {
                this.recordOMSInfo(wxOrderEntityVO.getExternalMainOrderNo(), wxOrderEntityVO.getExternalOrderNo(), "syncDeliverdStatusFromOMS2Mall", (Map<String, Object>)new /* invalid duplicate definition of identical inner class */, syncResult);
                throw throwable;
            }
        }
        return syncResult == null ? BaseJsonVo.error((String)"\u5185\u90e8\u9519\u8bef") : syncResult;
    }

    private void sendDeliverMessage(MallOrderEntity orderEntity, List<WxOrderProductVO> productVOList) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderEntity.getOrderMainNo());
        String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(orderMainEntity.getPlatformId());
        if (StringUtils.isNotEmpty((String)accessToken)) {
            if (CollectionUtils.isNotEmpty(productVOList)) {
                List<MallOrderPayEntity> payList = this.orderPayInterface.getList(orderMainEntity.getOrderMainNo());
                Optional<MallOrderPayEntity> payEntityOptional = payList.stream().filter(pay -> Objects.equals(pay.getPaytypeId(), PayTypeEnum.WECHAT_PAY.getValue())).findAny();
                if (payEntityOptional.isPresent()) {
                    CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId());
                    DeliverMessage deliverMessage = new DeliverMessage();
                    deliverMessage.setOpenid(customerDetailVo.getOpenId());
                    deliverMessage.setReceiver_phone(orderEntity.getConsigneePhone());
                    deliverMessage.setOrder_detail_path("account/pages/order_detail/index?orderMainNo=" + orderEntity.getOrderMainNo() + "&orderNo=" + orderEntity.getOrderNo() + "");
                    deliverMessage.setTrans_id(payEntityOptional.get().getThirdTradeNo());
                    deliverMessage.setWaybill_id(orderEntity.getWaybillNo());
                    DeliverMessage.GoodsInfo goodsInfo = new DeliverMessage.GoodsInfo();
                    ArrayList detail_list = new ArrayList();
                    goodsInfo.setDetail_list(detail_list);
                    deliverMessage.setGoods_info(goodsInfo);
                    List<MallOrderGroupProductEntity> orderProducts = this.orderProductInterface.getOrderGroupProductListByOrderNo(orderEntity.getOrderNo());
                    orderProducts.forEach(product -> {
                        if (product.getQuantity() > product.getRefundCount()) {
                            DeliverMessage.Detail detail = new DeliverMessage.Detail();
                            detail.setGoods_name(product.getProductName());
                            Map<String, List<String>> map = this.mallProductInterface.getProductPicUrlMap(product.getProductId());
                            detail.setGoods_img_url(map.containsKey(ProductPicTypeEnum.PRO_SAMLL.getName()) ? map.get(ProductPicTypeEnum.PRO_SAMLL.getName()).get(0) : "");
                            detail_list.add(detail);
                        }
                    });
                    this.logger.info("\u8ba2\u5355:{}\u8c03\u7528\u7269\u6d41\u7ec4\u4ef6\u53c2\u6570:{}", (Object)orderEntity.getOrderNo(), (Object)deliverMessage.toString());
                    FollowWaybillResult followWaybillResult = DeliveryMessageAPI.follow_waybill((String)accessToken, (DeliverMessage)deliverMessage);
                    this.logger.info("\u8ba2\u5355:{},\u8c03\u7528\u7269\u6d41\u7ec4\u4ef6:{}", (Object)orderEntity.getOrderNo(), (Object)followWaybillResult.toString());
                    if (followWaybillResult.isSuccess()) {
                        MallOrderEntity update = new MallOrderEntity();
                        update.setOrderNo(orderEntity.getOrderNo());
                        update.setWaybillToken(followWaybillResult.getWaybill_token());
                        this.orderInterface.updateOrder(update);
                        this.logger.info("\u8ba2\u5355:{} \u7269\u6d41id:{} \u66f4\u65b0\u6210\u529f", (Object)orderEntity.getOrderNo(), (Object)followWaybillResult.getWaybill_token());
                    }
                } else {
                    this.logger.info("\u8ba2\u5355:{} \u975e\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355 \u65e0\u6cd5\u63a8\u9001\u7269\u6d41\u6d88\u606f", (Object)orderEntity.getOrderNo());
                }
            } else {
                this.logger.error("\u8ba2\u5355:{},\u5546\u54c1\u4e3a\u7a7a", (Object)orderEntity.getOrderNo());
            }
        }
    }

    private BaseJsonVo checkOrderParma(WxOrderEntityVO wxOrderEntityVO) {
        if (StringUtils.isEmpty((String)wxOrderEntityVO.getStoreId()) || StringUtils.isEmpty((String)wxOrderEntityVO.getLogisticsName()) || StringUtils.isEmpty((String)wxOrderEntityVO.getLogisticsNo()) || wxOrderEntityVO.getDeliverdTime() == null) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u53c2\u6570:storeId\u3001logisticsId\uff0clogisticsName\u3001logisticsNo\u3001deliverdTime\u662f\u5426\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((String)wxOrderEntityVO.getLogisticsId())) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u53c2\u6570: logisticsId\uff0c \u662f\u5426\u4e3a\u7a7a\uff01");
        }
        return BaseJsonVo.success((Object)"");
    }
}

