/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.framework.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.mall.dao.trade.MallPayTypeMapper;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.MallPayTypeVo;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.service.trade.cache.MallPayTypeCacheService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallPayTypeService
extends MallPayTypeCacheService
implements MallPayTypeInterface {
    @Autowired
    private MallPayTypeMapper mallPayTypeMapper;

    @Override
    @ReadDataSource
    @ReadThroughSingleCache(namespace="getPayType", expiration=86400)
    public MallPayTypeEntity getPayType(@ParameterValueKeyProvider int payTypeId) {
        return (MallPayTypeEntity)this.mallPayTypeMapper.selectByPrimaryKey(Integer.valueOf(payTypeId));
    }

    @Override
    public BaseJsonVo<List<MallPayTypeVo>> getOrderPayList(MallMainOrderVo mainOrderVo) {
        ArrayList<MallPayTypeVo> mallPayTypeEntities = new ArrayList<MallPayTypeVo>();
        HashMap<Integer, BigDecimal> pays = new HashMap<Integer, BigDecimal>();
        if (mainOrderVo.getOrderCacheVo() != null && mainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CROWD.getValue()) {
            this.logger.error("errrrrrrrror:" + JsonUtils.toJson((Object)mainOrderVo, (boolean)false));
        }
        if (mainOrderVo.getOrderCacheVo().getOrderSource() == cc.lechun.common.enums.trade.OrderSourceEnum.PLEASE_MILK_CHANGE.getValue()) {
            pays.put(PaySubTypeEnum.GIFT_SUB_PAY.getValue(), mainOrderVo.getTotalAmount());
        } else if (mainOrderVo.getOrderCacheVo().getOrderSource() == cc.lechun.common.enums.trade.OrderSourceEnum.RECHANGE_CARD.getValue()) {
            this.logger.info("\u70b9\u5361\u652f\u4ed8\u91d1\u989d:{},\u8865\u5fae\u4fe1\u652f\u4ed8\u91d1\u989d:{}", (Object)mainOrderVo.getCardBalanceAmount(), (Object)mainOrderVo.getPayAmount());
            if (mainOrderVo.getCardBalanceAmount().compareTo(BigDecimal.ZERO) > 0) {
                pays.put(PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue(), mainOrderVo.getCardBalanceAmount());
            }
            if (mainOrderVo.getPayAmount().setScale(2, RoundingMode.DOWN).compareTo(BigDecimal.ZERO) > 0) {
                pays.put(mainOrderVo.getOrderCacheVo().getPayType(), mainOrderVo.getPayAmount());
            }
        } else {
            if (mainOrderVo.isUseCoupon()) {
                pays.put(PaySubTypeEnum.COUPON_SUB_PAY.getValue(), mainOrderVo.getCouponAmount());
            }
            if (mainOrderVo.getOrderCacheVo().getMildCardPay() == 0) {
                if (mainOrderVo.getBalanceAmount().setScale(2, RoundingMode.DOWN).doubleValue() > 0.0) {
                    pays.put(PaySubTypeEnum.BALANCE_SUB_CHARGE_PAY.getValue(), mainOrderVo.getBalanceAmount());
                }
            } else if (mainOrderVo.getBalanceAmount().setScale(2, RoundingMode.DOWN).doubleValue() > 0.0) {
                pays.put(PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue(), mainOrderVo.getBalanceAmount());
            }
            if (mainOrderVo.getSourceOrderAmount().setScale(2, RoundingMode.DOWN).doubleValue() > 0.0) {
                this.logger.info("paySubType:" + JsonUtils.toJson((Object)PaySubTypeEnum.getList(), (boolean)true));
                this.logger.info("paySubType:" + PaySubTypeEnum.ORDER_SUB_AMOUNT_PAY);
                pays.put(PaySubTypeEnum.ORDER_SUB_AMOUNT_PAY.getValue(), mainOrderVo.getSourceOrderAmount());
            }
            if (mainOrderVo.getPayAmount().setScale(2, RoundingMode.DOWN).doubleValue() > 0.0) {
                pays.put(mainOrderVo.getOrderCacheVo().getPayType(), mainOrderVo.getPayAmount());
            }
        }
        if (pays.size() < 1) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u53ef\u7528\u7684\u652f\u4ed8\u65b9\u5f0f");
        }
        this.logger.info("\u652f\u4ed8\u65b9\u5f0f1\uff1a{}", (Object)JsonUtils.toJson(pays, (boolean)false));
        for (Integer key : pays.keySet()) {
            MallPayTypeEntity payTypeEntity = this.getPayType(key);
            this.logger.info("\u652f\u4ed8\u65b9\u5f0f\u95192\uff1a{}", (Object)JsonUtils.toJson((Object)payTypeEntity, (boolean)false));
            if (payTypeEntity == null) {
                return BaseJsonVo.error((String)"\u652f\u4ed8\u65b9\u5f0f\u9519\u8bef1");
            }
            if (payTypeEntity.getpPaytypeId() == 0 || payTypeEntity.getpPaytypeId() == 1) {
                return BaseJsonVo.error((String)"\u652f\u4ed8\u65b9\u5f0f\u9519\u8bef2222");
            }
            if (payTypeEntity.getIsleaf().intValue() == 0) {
                return BaseJsonVo.error((String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u662f\u5b50\u652f\u4ed8\u65b9\u5f0f");
            }
            MallPayTypeEntity parentPayTypeEntity = this.getPayType(payTypeEntity.getpPaytypeId());
            if (parentPayTypeEntity == null) {
                return BaseJsonVo.error((String)"\u7236\u652f\u4ed8\u65b9\u5f0f\u9519\u8bef");
            }
            MallPayTypeVo payTypeVo = new MallPayTypeVo();
            try {
                ObjectConvert.fatherConvertToChild((Object)parentPayTypeEntity, (Object)payTypeVo);
                payTypeVo.setPayAmount((BigDecimal)pays.get(key));
                payTypeVo.setPaySubTypeId(key);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error(e.toString());
                BaseJsonVo.error((String)"\u5bf9\u8c61\u8f6c\u6362\u5931\u8d25");
            }
            mallPayTypeEntities.add(payTypeVo);
        }
        mallPayTypeEntities.stream().sorted((p1, p2) -> p1.getSort().compareTo(p2.getSort())).collect(Collectors.toList());
        return BaseJsonVo.success(mallPayTypeEntities);
    }

    @Override
    public MallPayTypeEntity getDefaultPayType() {
        return this.mallPayTypeMapper.getDefaultPayType();
    }
}

