/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.ChannelEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.sales.MallProductService;
import com.github.pagehelper.util.StringUtil;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallTradeCommonService
extends BaseService
implements MallTradeCommonInterface {
    @Autowired
    private MallProductService productService;

    @Override
    public MallOrderMainEntity getUpdateStatusOrderMainEntity(String orderMainNo, int status, int oldStatus) {
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        if (oldStatus < 1 && status > 1) {
            return null;
        }
        orderMainEntity.setStatus(status);
        orderMainEntity.setOrderMainNo(orderMainNo);
        Date date = DateUtils.now();
        switch (status) {
            case -1: {
                orderMainEntity.setDeleteTime(date);
                break;
            }
            case 0: {
                orderMainEntity.setCancelTime(date);
                break;
            }
            case 2: {
                orderMainEntity.setPayTime(date);
                break;
            }
            case 3: {
                orderMainEntity.setPayTime(date);
                orderMainEntity.setConfirmPaytime(date);
                break;
            }
            case 15: {
                orderMainEntity.setCompleteTime(date);
                break;
            }
            case 16: {
                orderMainEntity.setCompleteTime(date);
                break;
            }
        }
        return orderMainEntity;
    }

    @Override
    public MallOrderEntity getUpdateStatusOrderEntity(String orderNo, int status) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        orderEntity.setStatus(status);
        orderEntity.setOrderNo(orderNo);
        Date date = DateUtils.now();
        switch (status) {
            case -1: {
                orderEntity.setDeleteTime(date);
                break;
            }
            case 0: {
                orderEntity.setCancelTime(date);
                break;
            }
            case 6: {
                orderEntity.setExportTime(date);
                break;
            }
            case 7: {
                orderEntity.setDelivingTime(date);
                break;
            }
            case 9: {
                orderEntity.setDelivedTime(date);
                break;
            }
            case 10: {
                orderEntity.setDelivedTime(date);
                break;
            }
            case 12: {
                orderEntity.setArrivedTime(date);
                break;
            }
            case 15: {
                orderEntity.setCompleteTime(date);
                break;
            }
            case 16: {
                orderEntity.setCompleteTime(date);
                break;
            }
        }
        return orderEntity;
    }

    @Override
    public int platformConvertChannel(int platformId) {
        if (PlatFormEnum.LECHUN_WECHAT_MAIN.getValue() == platformId) {
            return ChannelEnum.WECHAT.getValue();
        }
        if (PlatFormEnum.LECHUN_MINI.getValue() == platformId) {
            return ChannelEnum.MINI.getValue();
        }
        if (PlatFormEnum.LECHUN_WEP.getValue() == platformId) {
            return ChannelEnum.WAP.getValue();
        }
        if (PlatFormEnum.YUANQI_WECHAT_MALL.getValue() == platformId) {
            return ChannelEnum.WECHAT.getValue();
        }
        return 0;
    }

    @Override
    public int orderSourceConvertOrderClass(MallMainOrderVo mallMainOrderVo) {
        int orderSource = mallMainOrderVo.getOrderCacheVo().getOrderSource();
        int orderClass = 1;
        switch (orderSource) {
            case 1: {
                orderClass = 4;
                break;
            }
            case 5: {
                orderClass = 4;
                break;
            }
            case 25: {
                orderClass = 3;
                break;
            }
            case 27: {
                orderClass = 3;
                break;
            }
            default: {
                orderClass = 1;
            }
        }
        if (CollectionUtils.isNotEmpty(mallMainOrderVo.getOrderCacheVo().getCardList())) {
            orderClass = OrderClassEnum.BUY_CARD_CUT_ORDER.getValue();
        }
        if (Objects.equals(orderSource, OrderSourceEnum.CART.getValue()) && StringUtils.isNotEmpty((String)mallMainOrderVo.getOrderCacheVo().getSourceOrderNo()) && mallMainOrderVo.getOrderCacheVo().getCardBatchId() != null) {
            orderClass = OrderClassEnum.SPLITE_DELIVERY_ORDER.getValue();
        }
        if (orderClass == 1 && this.isNoDeliverOrder(mallMainOrderVo)) {
            orderClass = 18;
        }
        return orderClass;
    }

    @Override
    public boolean isNoDeliverOrder(MallMainOrderVo mallMainOrderVo) {
        int orderSource = mallMainOrderVo.getOrderCacheVo().getOrderSource();
        if (orderSource == OrderSourceEnum.PLEASE_MILK.getValue() || orderSource == OrderSourceEnum.ACTIVE.getValue()) {
            this.logger.info("\u8ba2\u5355\u6765\u6e90\u4e3a\u8bf7\u9178\u5976\u6216\u662f\u6d3b\u52a8\u8ba2\u5355\uff0c\u4e3a\u4e0d\u914d\u9001\u8ba2\u5355");
            return true;
        }
        for (MallOrderVo o : mallMainOrderVo.getMallOrderVos()) {
            if (this.productService.getTransportType(o) != TransportTypeEnum.ONLINE_SEND.getValue()) continue;
            this.logger.info("\u5546\u54c1\u914d\u9001\u7c7b\u578b\u4e3a\u7ebf\u4e0a\u5151\u6362\uff0c\u4e3a\u4e0d\u914d\u9001\u8ba2\u5355");
            return true;
        }
        return false;
    }

    @Override
    public String getDelayDateName(String beginDate, String deliverDate, String pickupDate, String printTime, int orderSource, int transportId, int openCityStatus, int statusClass, int deliverType, int orderClass) {
        if (transportId == 2 && deliverType == 1) {
            if (!printTime.isEmpty()) {
                return "\u5df2\u4e8e" + DateUtils.formatDateChina((String)printTime, (String)"MM\u6708dd\u65e5HH:00") + "\u51fa\u5e93";
            }
            return " ";
        }
        if (transportId == 1 && openCityStatus == 1) {
            if (orderSource == OrderSourceEnum.GROUP_BUY.getValue()) {
                return " ";
            }
            return " ";
        }
        if (StringUtil.isEmpty((String)deliverDate)) {
            if (StringUtils.isNotEmpty((String)pickupDate)) {
                String dates = DateUtils.formatDateChina((String)pickupDate, (String)"M\u6708d\u65e5");
                return dates + "(" + DateUtils.getShortWeekOfDate((Date)DateUtils.getDateFromString((String)pickupDate, (String)"yyyy-MM-dd")) + ") \u53d1\u8d27";
            }
            return " ";
        }
        String dates = DateUtils.formatDateChina((String)deliverDate, (String)"M\u6708d\u65e5");
        int l = (int)DateUtils.getDateDiff((String)DateUtils.date(), (String)deliverDate);
        if (l == 0) {
            return dates + "(\u4eca\u65e5)";
        }
        if (l == 1) {
            return dates + "(\u660e\u65e5)";
        }
        if (l == 2) {
            return dates + "(\u540e\u65e5)";
        }
        return dates + "(" + DateUtils.getShortWeekOfDate((Date)DateUtils.getDateFromString((String)deliverDate, (String)"yyyy-MM-dd")) + ")";
    }
}

