/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.apiinvoke.refund.CsmsRefundInvoke;
import cc.lechun.common.constants.trade.OrderStatusClassConstants;
import cc.lechun.common.enums.customer.PasswordTypeEnum;
import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.ChannelEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.deliver.MallAreaEntity;
import cc.lechun.mall.entity.deliver.MallCityEntity;
import cc.lechun.mall.entity.deliver.OrderDeliverRecordVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardRecommendEntity;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.OrderProductTypeEnum;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.CancelOrderVo;
import cc.lechun.mall.entity.trade.CutStatusEnum;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheEntity;
import cc.lechun.mall.entity.trade.MallOrderCacheInCardVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderDetailVo;
import cc.lechun.mall.entity.trade.MallOrderEntitiesVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupAndProductVo;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductVo;
import cc.lechun.mall.entity.trade.MallOrderItemVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPackagePrintrecordEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductDo;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderProductVo;
import cc.lechun.mall.entity.trade.MallOrderRecordEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.MallPlatformPayTypeEntity;
import cc.lechun.mall.entity.trade.MallRepurchaseVo;
import cc.lechun.mall.entity.trade.MiniShopOrderVO;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import cc.lechun.mall.iservice.deliver.MallOrderDeliverRecordInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.inventory.InventoryInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardRecommendInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.trade.MallMiniShopInterface;
import cc.lechun.mall.iservice.trade.MallOrderCacheInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderLogCacheInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPackagePrintrecordInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderRecordInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallPlatformPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.iservice.trade.MiniShopOrderInterface;
import cc.lechun.mall.iservice.trade.SetCacheCheckInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.service.trade.MallOrderSaleNewErpService;
import cc.lechun.mall.service.trade.defineFieldHandle.DefineFiledHandleInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import cc.lechun.mall.service.youshu.OrderDataService;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.util.StringUtil;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class MallTradeService
extends BaseService
implements MallTradeInterface {
    private final Map<String, OrderHandleInterface> orderHandleInterfaces = new TreeMap<String, OrderHandleInterface>();
    @Autowired
    private InventoryInterface inventoryInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;
    @Autowired
    private DefineFiledHandleInterface defineFiledHandleInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private SetCacheCheckInterface setCacheCheckInterface;
    @Autowired
    private MallProductPicInterface productPicInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallAreaInterface areaInterface;
    @Autowired
    private MallCityInterface cityInterface;
    @Autowired
    private MallOrderPackagePrintrecordInterface packagePrintrecordInterface;
    @Autowired
    private MallOrderDeliverRecordInterface deliverRecordInterface;
    @Autowired
    private MallOrderRecordInterface orderRecordInterface;
    @Autowired
    private MessageInterface messageInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private MallOrderCacheInterface orderCacheInterface;
    @Autowired
    private MallPromotionProductInterface mallPromotionProductInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private MallOrderSaleNewErpService mallOrderSaleNewErpService;
    @Autowired
    private MallTradeInterface mallTradeInterface;
    @Autowired
    private MallPayTypeInterface payTypeInterface;
    @Autowired
    private MallOrderLogCacheInterface logCacheInterface;
    @Autowired
    MallPlatformPayTypeInterface mallPlatformPayTypeInterface;
    @Autowired
    private MallOrderSyncInfoInterface orderSyncInfoInterface;
    @Autowired
    private MiniShopOrderInterface miniShopOrderInterface;
    @Autowired
    private MallMiniShopInterface mallMiniShopInterface;
    @Autowired
    OrderDataService orderDataService;
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    @Autowired
    DictionaryInterface dictionaryInterface;
    @Autowired
    private CsmsRefundInvoke csmsRefundInvoke;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private PrepayCardRecommendInterface prepayCardRecommendInterface;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Lazy
    @Autowired
    PrepayCardOrderPlanInterface prepayCardOrderPlanService;

    @Autowired
    public MallTradeService(Map<String, OrderHandleInterface> orderHandleInterfaces) {
        this.orderHandleInterfaces.clear();
        orderHandleInterfaces.forEach((k, v) -> this.orderHandleInterfaces.put((String)k, (OrderHandleInterface)v));
    }

    @Override
    public BaseJsonVo spliteSourceOrder(Date date) {
        List<MallOrderMainEntity> list = this.orderMainInterface.getMallOrderMainEntityList(date, OrderClassEnum.BUY_CARD_CUT_ORDER.getValue(), 15, 5);
        for (MallOrderMainEntity orderMainEntity : list) {
            try {
                this.tradeInterface.spliteSourceOrder(orderMainEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo spliteSourceOrder(MallOrderMainEntity orderMainEntity) {
        if (orderMainEntity.getStatus().intValue() == OrderStatusEnum.PAYCONFIRM.getValue()) {
            String orderMainNo = orderMainEntity.getOrderMainNo();
            List<MallOrderMainEntity> orderMainEntityList = this.orderMainInterface.getMallOrderMainEntityList(orderMainNo);
            List<MallOrderPayEntity> orderMainEntityPayList = this.orderPayInterface.getList(orderMainEntityList.get(0).getSourceOrderNo());
            for (MallOrderMainEntity order : orderMainEntityList) {
                BaseJsonVo baseJsonVo;
                List<MallOrderPayEntity> payEntityList = this.orderPayInterface.getList(order.getOrderMainNo());
                for (MallOrderPayEntity orderPayEntity : payEntityList) {
                    orderPayEntity.setIssuccess(1);
                    orderPayEntity.setSuccessTime(DateUtils.now());
                    Optional<MallOrderPayEntity> payEntityOptional = orderMainEntityPayList.stream().filter(pay -> Objects.equals(orderPayEntity.getTradeNo(), pay.getTradeNo())).findFirst();
                    if (payEntityOptional.isPresent() && StringUtils.isNotEmpty((String)payEntityOptional.get().getThirdTradeNo())) {
                        orderPayEntity.setThirdTradeNo(payEntityOptional.get().getThirdTradeNo());
                    }
                    this.logger.info("\u66f4\u65b0\u652f\u4ed8:{}", (Object)JsonUtils.toJson((Object)orderPayEntity, (boolean)false));
                    this.orderPayInterface.updateByPrimaryKey(orderPayEntity);
                }
                if (order.getOrderClass().intValue() == OrderClassEnum.SPLITE_DELIVERY_ORDER.getValue()) {
                    boolean updateStatus = this.orderMainInterface.updateOrderMainStatus(order.getOrderMainNo(), OrderStatusEnum.PAYCONFIRM.getName(), (int)order.getStatus());
                    this.logger.info("\u8ba2\u5355:{},\u4fee\u6539\u72b6\u6001:{}", (Object)order.getOrderMainNo(), (Object)updateStatus);
                    if (!updateStatus) {
                        throw new RuntimeException("\u66f4\u65b0\u5b9e\u7269\u914d\u9001\u5355\u72b6\u6001\u5931\u8d25");
                    }
                    BaseJsonVo result = this.accountBalanceInterface.useGiftBalance(orderMainEntity.getCustomerId(), order.getOrderMainNo(), orderMainEntity.getPoints(), PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue(), PrepayCardTypeEnum.yogurt_card.getValue());
                    this.logger.info("\u5b9e\u7269\u8ba2\u5355:{}\u6263\u51cf\u70b9\u6570:{}\u7ed3\u679c:{}", new Object[]{order.getOrderMainNo(), order.getPoints(), result.isSuccess()});
                    if (!result.isSuccess()) {
                        this.logger.error("\u5b9e\u7269\u8ba2\u5355:{}\u6263\u51cf\u5976\u5361\u4f59\u989d\u5f02\u5e38,\u9519\u8bef\u6d88\u606f:{}", (Object)order.getOrderMainNo(), (Object)result.getMessage());
                        throw new RuntimeException("\u6263\u51cf\u4f59\u989d\u70b9\u6570\u5931\u8d25");
                    }
                }
                if (!(baseJsonVo = this.defineFiledHandleInterface.orderPaySuccessAfter(order)).isSuccess()) {
                    this.logger.error("\u8ba2\u5355:{}\u8bbe\u7f6e\u652f\u4ed8\u6210\u529f\u5f02\u5e38,\u9519\u8bef\u6d88\u606f:{}", (Object)order.getOrderMainNo(), (Object)baseJsonVo.getMessage());
                    throw new RuntimeException("\u8bbe\u7f6e\u652f\u4ed8\u6210\u529f\u5f02\u5e38");
                }
                MallOrderMainEntity update = new MallOrderMainEntity();
                update.setIsshow((short)1);
                update.setOrderMainNo(order.getOrderMainNo());
                this.orderMainInterface.updateOrderMain(update);
            }
            this.orderMainInterface.updateOrderMainStatus(orderMainNo, OrderStatusEnum.DELETE.getName(), OrderStatusEnum.PAYCONFIRM.getValue());
            MallOrderMainEntity update = new MallOrderMainEntity();
            update.setIsshow((short)0);
            update.setOrderMainNo(orderMainNo);
            this.orderMainInterface.updateOrderMain(update);
        }
        return BaseJsonVo.success((Object)"");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseJsonVo<MallMainOrderVo> toPayPage(int platFormId, String customerId, MallOrderCacheVo orderCacheVo) {
        MallPlatformPayTypeEntity defaultPayType = this.mallPlatformPayTypeInterface.getDefaultPayType(platFormId);
        if (defaultPayType == null) {
            MallPayTypeEntity mallPayTypeEntity = this.payTypeInterface.getDefaultPayType();
            if (mallPayTypeEntity == null) return BaseJsonVo.paramError((String)"\u65e0\u652f\u4ed8\u65b9\u5f0f");
            orderCacheVo.setPayType(mallPayTypeEntity.getPaytypeId());
        } else {
            orderCacheVo.setPayType(defaultPayType.getPaytypeSubId());
        }
        if (orderCacheVo == null) {
            return BaseJsonVo.paramError((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (OrderSourceEnum.getName(orderCacheVo.getOrderSource()).isEmpty()) {
            return BaseJsonVo.paramError((String)"\u8f93\u5165\u4fe1\u606f\u8ba2\u5355\u6765\u6e90\u9519\u8bef");
        }
        MallMainOrderVo mallMainOrderVo = this.getMainMainOrderVo(customerId, platFormId, orderCacheVo);
        this.logger.info("+++++++++++toPayPage+++++++++++mallMainOrderVo={}", (Object)mallMainOrderVo.toString());
        if (!mallMainOrderVo.isBaseSuccess()) {
            return BaseJsonVo.error((String)mallMainOrderVo.getBaseErrMsg());
        }
        if (StringUtils.isNotEmpty((String)orderCacheVo.getBindCode()) && Objects.equals(orderCacheVo.getOrderSource(), OrderSourceEnum.RECHANGE_CARD.getValue())) {
            mallMainOrderVo.setCardType(this.prepayCardBatchInterface.getPrepayCardType(orderCacheVo.getBindCode()));
            if (mallMainOrderVo.getCardType() == null) {
                if (orderCacheVo.getBindCode().length() > 2) {
                    mallMainOrderVo.setCardType(PrepayCardTypeEnum.yogurt_card.getValue());
                } else {
                    mallMainOrderVo.setCardType(Integer.valueOf(orderCacheVo.getBindCode()));
                }
            }
        }
        for (String key : this.orderHandleInterfaces.keySet()) {
            this.logger.info("\u4e1a\u52a1\u903b\u8f91\u6267\u884c\uff1a{}", (Object)key);
            try {
                BaseJsonVo baseJsonVo = this.orderHandleInterfaces.get(key).orderHandle(mallMainOrderVo);
                if (baseJsonVo.isSuccess()) continue;
                return baseJsonVo;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u4e1a\u52a1\u903b\u8f91\u5f02\u5e38\uff1a" + key, (Throwable)e);
                return BaseJsonVo.error((String)("\u4e1a\u52a1\u903b\u8f91\u5f02\u5e38\uff1a" + key));
            }
        }
        this.defineFiledHandleInterface.toPayPage(mallMainOrderVo);
        return BaseJsonVo.success((Object)mallMainOrderVo);
    }

    @Override
    public BaseJsonVo addFreeProduct(String orderMainNo) {
        try {
            ArrayList<MallOrderProductDo> tempList = new ArrayList<MallOrderProductDo>();
            int temp = Math.abs(orderMainNo.hashCode()) % 2;
            this.logger.info("\u968f\u673a\u4e34\u65f6\u5e8f\u5217\uff1a{}", (Object)temp);
            tempList.add(this.getList(orderMainNo).get(temp));
            BaseJsonVo baseJsonVo = this.tradeInterface.addProduct(tempList);
            this.logger.info("\u8ba2\u5355:{},\u8d60\u54c1\u6dfb\u52a0:{}", (Object)orderMainNo, (Object)baseJsonVo.isSuccess());
            return baseJsonVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u52a0\u8d60\u54c1\u51fa\u9519:{}", (Object)e.getMessage());
            return BaseJsonVo.success((Object)"");
        }
    }

    private List<MallOrderProductDo> getList(String orderMainNo) {
        ArrayList<MallOrderProductDo> list = new ArrayList<MallOrderProductDo>();
        MallOrderProductDo mallOrderProductDo = new MallOrderProductDo();
        mallOrderProductDo.setGroupId("");
        mallOrderProductDo.setGroupType(SalesTypeEnum.SALES_PRODUCT.getValue());
        mallOrderProductDo.setOrderMainNo(orderMainNo);
        mallOrderProductDo.setOrderNo("");
        mallOrderProductDo.setProductId("1387406207627038720");
        mallOrderProductDo.setProductName("\u55b5\u661f\u4eba\u53e3\u7f69");
        mallOrderProductDo.setQuantity(1);
        mallOrderProductDo.setUnitPrice(new BigDecimal(0));
        list.add(mallOrderProductDo);
        MallOrderProductDo mallOrderProductDo2 = new MallOrderProductDo();
        mallOrderProductDo2.setGroupId("");
        mallOrderProductDo2.setGroupType(SalesTypeEnum.SALES_PRODUCT.getValue());
        mallOrderProductDo2.setOrderMainNo(orderMainNo);
        mallOrderProductDo2.setOrderNo("");
        mallOrderProductDo2.setProductId("1387403932174258176");
        mallOrderProductDo2.setProductName("\u6c6a\u661f\u4eba\u53e3\u7f69");
        mallOrderProductDo2.setQuantity(1);
        mallOrderProductDo2.setUnitPrice(new BigDecimal(0));
        list.add(mallOrderProductDo2);
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallTradeService.getMainMainOrderVo", expiration=300)
    public MallMainOrderVo getMainMainOrderVo(@ParameterValueKeyProvider(order=0) String customerId, @ParameterValueKeyProvider(order=1) int platFormId, @ParameterValueKeyProvider(order=2) int orderSource, @ParameterValueKeyProvider(order=3) String cacheId, @ParameterValueKeyProvider(order=4) String bindCode) {
        MallOrderCacheVo cacheVo = new MallOrderCacheVo();
        cacheVo.setBindCode(bindCode);
        cacheVo.setCacheId(cacheId);
        cacheVo.setOrderSource(orderSource);
        return this.getMainMainOrderVo(customerId, platFormId, cacheVo);
    }

    /*
     * Enabled aggressive block sorting
     */
    private MallMainOrderVo getMainMainOrderVo(String customerId, int platFormId, MallOrderCacheVo orderCacheVo) {
        MallMainOrderVo mallMainOrderVo = new MallMainOrderVo();
        List<Object> orderVos = new ArrayList();
        if (orderCacheVo.getOrderSource() == OrderSourceEnum.CART.getValue()) {
            BaseJsonVo<List<MallShoppingcartVO>> result = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platFormId, customerId, true, orderCacheVo.getIsQuick(), "0");
            if (!result.isSuccess()) {
                mallMainOrderVo.setBaseError(result.getError_msg());
                return mallMainOrderVo;
            }
            orderVos = this.orderInterface.ShoppingConvertOrder((List)result.getValue());
            if (orderVos.size() == 0) {
                mallMainOrderVo.setBaseError("\u5f53\u524d\u8d2d\u7269\u8f66\u6ca1\u6709\u53ef\u7ed3\u7b97\u7684\u5546\u54c1");
                return mallMainOrderVo;
            }
        } else {
            BaseJsonVo<List<MallOrderVo>> baseJsonVo = this.orderInterface.getOrderVoFromCache(platFormId, customerId, orderCacheVo);
            if (!baseJsonVo.isSuccess()) {
                mallMainOrderVo.setBaseError(baseJsonVo.getMessage());
                return mallMainOrderVo;
            }
            orderVos = (List)baseJsonVo.getValue();
        }
        this.logger.info("orderVos:{}", (Object)orderVos.toString());
        return this.orderMainInterface.getMainOrderVo(platFormId, customerId, orderVos, orderCacheVo);
    }

    @Override
    public BaseJsonVo<MallOrderCacheVo> setOrderCache(int platFormId, String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        if (mallOrderCacheInVo == null) {
            return BaseJsonVo.paramError((String)"\u8f93\u5165\u4fe1\u606f\u9519\u8bef");
        }
        if (OrderSourceEnum.getName(mallOrderCacheInVo.getOrderSource()).isEmpty()) {
            return BaseJsonVo.paramError((String)"\u8f93\u5165\u4fe1\u606f\u8ba2\u5355\u6765\u6e90\u9519\u8bef");
        }
        if (mallOrderCacheInVo.getMallOrderCacheInItemVoList() == null || mallOrderCacheInVo.getMallOrderCacheInItemVoList().size() == 0) {
            return BaseJsonVo.paramError((String)"\u8f93\u5165\u4fe1\u606f\u5546\u54c1\u4fe1\u606f\u9519\u8bef");
        }
        BaseJsonVo jsonVo = this.setCacheCheckInterface.setCacheCheck(platFormId, customerId, mallOrderCacheInVo);
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        if (OrderSourceEnum.LONGPERIOD_BUY.getValue() == mallOrderCacheInVo.getOrderSource()) {
            BigDecimal amount = new BigDecimal(90);
            BigDecimal saleAmount = BigDecimal.ZERO;
            for (MallOrderCacheInItemVo c : mallOrderCacheInVo.getMallOrderCacheInItemVoList()) {
                BaseJsonVo<MallProductVO> sr = this.productInterface.buildProductVO(c.getItemId(), c.getQuantity(), true, true);
                if (!sr.isSuccess()) continue;
                saleAmount = saleAmount.add(((MallProductVO)sr.getValue()).getFactPrice().multiply(new BigDecimal(c.getQuantity())));
            }
            if (amount.compareTo(saleAmount) > 0) {
                return BaseJsonVo.error((String)("\u64cd\u4f5c\u5931\u8d25,\u957f\u671f\u8ba2\u8d2d\u6ee1" + amount + "\u8d77\u9001,\u8fd8\u5dee" + PriceUtils.subtract((BigDecimal)amount, (BigDecimal)saleAmount) + ""));
            }
        }
        int transportType = this.getTransportType(mallOrderCacheInVo.getMallOrderCacheInItemVoList());
        mallOrderCacheInVo.setTransportType(transportType);
        mallOrderCacheInVo.setPayJumpType(1);
        String cacheId = "MallTreadeService_setOrderCache_" + platFormId + "_" + customerId + "_" + mallOrderCacheInVo.getOrderSource() + DateUtils.now().getTime();
        if (this.orderCacheInterface.insertOrderCacheEntity(cacheId, JsonUtils.toJson((Object)mallOrderCacheInVo, (boolean)false)).booleanValue()) {
            MallOrderCacheVo orderCacheVo = new MallOrderCacheVo();
            orderCacheVo.setCacheId(cacheId);
            orderCacheVo.setTransportType(mallOrderCacheInVo.getTransportType());
            orderCacheVo.setOrderSource(mallOrderCacheInVo.getOrderSource());
            orderCacheVo.setBindCode(mallOrderCacheInVo.getBindCode());
            if (mallOrderCacheInVo.getChannel() != null) {
                orderCacheVo.setChannel(mallOrderCacheInVo.getChannel());
            }
            this.logger.info("this customerId wants to pay this orderSource : {}", (Object)mallOrderCacheInVo.getOrderSource());
            if (mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.EXCLUSIVE.getValue() || mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.INVITE_GIFT.getValue()) {
                orderCacheVo.setUseAccountBalance(0);
            } else if (mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.CARDPLAN.getValue() || mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.CARD_PREPAY_JD_POP.getValue() || mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.CARD_PREPAY_CHANNEL.getValue() || mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.CARD_PREPAY_JD_SELF_RUN.getValue() || mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_CHANNEL.getValue() || mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_STRATEGY.getValue() || mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.CARD_PREPAY_SHOP.getValue() || mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
                orderCacheVo.setCacheType(2);
            } else if (mallOrderCacheInVo.getOrderSource() != OrderSourceEnum.LONGPERIOD_BUY.getValue() && mallOrderCacheInVo.getOrderSource() != OrderSourceEnum.FULLCUT.getValue() && mallOrderCacheInVo.getOrderSource() != OrderSourceEnum.COLLAGE.getValue() && mallOrderCacheInVo.getOrderSource() != OrderSourceEnum.LIMIT_BUY.getValue() && mallOrderCacheInVo.getOrderSource() != OrderSourceEnum.CART.getValue()) {
                orderCacheVo.setUseAccountBalance(0);
                orderCacheVo.setCacheType(2);
            }
            this.defineFiledHandleInterface.setCache(platFormId, customerId, cacheId, mallOrderCacheInVo);
            return BaseJsonVo.success((Object)orderCacheVo);
        }
        this.logger.error("\u8bbe\u7f6e\u7f13\u5b58\u9519\u8bef,\u7528\u6237:{},{}", (Object)customerId, (Object)mallOrderCacheInVo.toString());
        return BaseJsonVo.error((String)"\u7f13\u5b58\u9519\u8bef");
    }

    @Override
    public MallOrderCacheEntity getOrderCache(String cacheId) {
        return this.orderCacheInterface.getOrderCacheEntity(cacheId);
    }

    @Override
    public BaseJsonVo createOrder(int platFormId, String customerId, MallOrderCacheVo orderCacheVo) throws InvalidKeySpecException, NoSuchAlgorithmException {
        MallOrderEntitiesVo orderEntitiesVo;
        this.logger.info("+++++++++++createOrder+++++++++++orderCacheVo={}", (Object)JSON.toJSONString((Object)orderCacheVo));
        BaseJsonVo checkBaseJsonVo = this.checkStopDilveryDate(orderCacheVo);
        if (!checkBaseJsonVo.isSuccess()) {
            return checkBaseJsonVo;
        }
        BaseJsonVo baseJsonVo = this.toPayPage(platFormId, customerId, orderCacheVo);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallMainOrderVo mallMainOrderVo = (MallMainOrderVo)baseJsonVo.getValue();
        if (mallMainOrderVo == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u521b\u5efa\u5931\u8d25");
        }
        if (mallMainOrderVo.getOrderPayEntities() != null) {
            BaseJsonVo validPass;
            boolean balancePay = mallMainOrderVo.getOrderPayEntities().stream().anyMatch(p -> p.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_CHARGE_PAY.getValue() || p.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_GIVE_PAY.getValue());
            boolean bl = balancePay = balancePay && mallMainOrderVo.getBalanceAmount().compareTo(new BigDecimal(0)) > 0 && mallMainOrderVo.getPayAmount().compareTo(new BigDecimal(0)) == 0;
            if (balancePay && !(validPass = this.customerInterface.validatePassword(customerId, orderCacheVo.getPayPassword(), PasswordTypeEnum.pay_password)).isSuccess()) {
                return validPass;
            }
        }
        if (!(orderEntitiesVo = this.getOrderEntities(mallMainOrderVo)).isBaseSuccess()) {
            return BaseJsonVo.error((String)orderEntitiesVo.getBaseErrMsg());
        }
        baseJsonVo = this.defineFiledHandleInterface.createOrderBefore(mallMainOrderVo);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        baseJsonVo = this.mallTradeInterface.buildOrder(orderEntitiesVo, mallMainOrderVo);
        if (baseJsonVo.isSuccess()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("mainOrderNo", baseJsonVo.getValue());
            resultMap.put("payAmount", mallMainOrderVo.getPayAmount());
            this.logCacheInterface.saveOrderLog(orderEntitiesVo);
            this.defineFiledHandleInterface.createOrderAfter(mallMainOrderVo, orderCacheVo, baseJsonVo.isSuccess());
            if (CollectionUtils.isNotEmpty(orderCacheVo.getCardList()) && !(baseJsonVo = this.spliteBuyCardCutOrder(platFormId, customerId, orderCacheVo, mallMainOrderVo, resultMap)).isSuccess()) {
                return baseJsonVo;
            }
            if (orderEntitiesVo.getOrderMainEntity().getMiniShop() == 1) {
                MiniShopOrderVO miniShopOrderVO = this.miniShopOrderInterface.buildMiniShopOrder(mallMainOrderVo, orderEntitiesVo);
                resultMap.put("orderInfo", miniShopOrderVO);
            } else {
                resultMap.put("orderInfo", null);
            }
            return BaseJsonVo.success(resultMap);
        }
        return baseJsonVo;
    }

    private BaseJsonVo checkStopDilveryDate(MallOrderCacheVo orderCacheVo) {
        if (orderCacheVo.getDeliverDate() != null) {
            List<DictionaryEntity> getValidDictionaryStopDeliverList = this.dictionaryInterface.getValidDictionaryList(1000, 202);
            if (CollectionUtils.isNotEmpty(getValidDictionaryStopDeliverList)) {
                String stopDeliver = "";
                stopDeliver = getValidDictionaryStopDeliverList.get(0).getDictionaryName();
                if (StringUtils.isNotEmpty((String)stopDeliver)) {
                    String[] arr = stopDeliver.split("-");
                    String startStr = arr[0].replace(".", "-");
                    String endStr = arr[1].replace(".", "-");
                    this.logger.info("\u505c\u6b62\u914d\u9001\u5f00\u59cb\u65e5\u671f:{},\u505c\u6b62\u914d\u9001\u7ed3\u675f\u65e5\u671f:{},\u9009\u62e9\u7684\u914d\u9001\u65e5\u671f:{}", new Object[]{startStr, endStr, orderCacheVo.getDeliverDate()});
                    Date startDate = new Date();
                    Date endDate = new Date();
                    startDate = DateUtils.getDateFromString((String)startStr, (String)"yyyy-MM-dd");
                    endDate = DateUtils.getDateFromString((String)endStr, (String)"yyyy-MM-dd");
                    if (orderCacheVo.getDeliverDate().after(startDate) && orderCacheVo.getDeliverDate().before(endDate) || orderCacheVo.getDeliverDate().compareTo(startDate) == 0) {
                        return BaseJsonVo.error((String)("\u9009\u62e9\u7684\u914d\u9001\u65e5\u671f\u662f:" + DateUtils.formatDate((Date)orderCacheVo.getDeliverDate(), (String)"yyyy-MM-dd") + " \u671f\u95f4\u4e0d\u53d1\u8d27,\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65e5\u671f!"));
                    }
                } else {
                    this.logger.info("\u672a\u914d\u7f6e\u505c\u914d\u65e5\u671f1");
                }
            } else {
                this.logger.info("\u672a\u914d\u7f6e\u505c\u914d\u65e5\u671f2");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo spliteBuyCardCutOrder(int platFormId, String customerId, MallOrderCacheVo orderCacheVo, MallMainOrderVo mallMainOrderVo, Map<String, Object> resultMap) throws InvalidKeySpecException, NoSuchAlgorithmException {
        BaseJsonVo<MallOrderCacheVo> cacheVoBaseJsonVo = this.setBuyCardCache(platFormId, customerId, orderCacheVo.getCardList());
        this.logger.info("\u8bbe\u7f6e\u7528\u6237:{}\u8d2d\u4e70\u5976\u5361\u8ba2\u5355\u7f13\u5b58:{}", (Object)customerId, (Object)cacheVoBaseJsonVo.isSuccess());
        if (cacheVoBaseJsonVo.isSuccess()) {
            ((MallOrderCacheVo)cacheVoBaseJsonVo.getValue()).setSourceOrderNo(resultMap.get("mainOrderNo").toString());
            ((MallOrderCacheVo)cacheVoBaseJsonVo.getValue()).setChanId(orderCacheVo.getChanId());
            BaseJsonVo baseJsonVo = this.tradeInterface.createOrder(platFormId, customerId, (MallOrderCacheVo)cacheVoBaseJsonVo.getValue());
            this.logger.info("\u7528\u6237:{}\u8d2d\u4e70\u5976\u5361\u521b\u5efa\u8ba2\u5355:{},{}", new Object[]{customerId, baseJsonVo.isSuccess(), baseJsonVo.getError_msg()});
            if (!baseJsonVo.isSuccess()) {
                throw new RuntimeException("\u521b\u5efa\u5361\u8ba2\u5355\u5931\u8d25");
            }
            List<MallOrderProductEntity> products = this.orderProductInterface.getOrderProductInfoByOrderMianNo(resultMap.get("mainOrderNo").toString());
            if (CollectionUtils.isEmpty(products)) {
                this.logger.info("\u67e5\u8be2\u8d2d\u4e70\u5361\u4f18\u60e0\u4e3b\u5355\uff1a{}\u5546\u54c1\u51fa\u9519:{}", (Object)resultMap.get("mainOrderNo").toString(), (Object)"\u672a\u67e5\u8be2\u8ba2\u5355\u5546\u54c1");
                return baseJsonVo;
            }
            ArrayList<MallOrderProductEntity> tempList = new ArrayList<MallOrderProductEntity>();
            for (MallOrderCacheInCardVo cardVo : orderCacheVo.getCardList()) {
                List productList = products.stream().filter(product -> {
                    boolean flag = Objects.equals(product.getGroupType(), cardVo.getItemType()) && Objects.equals(product.getPromotionId(), cardVo.getItemId());
                    return !flag;
                }).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(productList)) continue;
                tempList.addAll(productList);
            }
            if (orderCacheVo.getOrderSource() == OrderSourceEnum.CART.getValue()) {
                for (MallOrderProductEntity mallOrderProductEntity : tempList) {
                    if (mallOrderProductEntity.getUnitPrice().compareTo(BigDecimal.ZERO) <= 0 || !Objects.equals(mallOrderProductEntity.getOrderProductType(), OrderProductTypeEnum.normal_product.getValue())) continue;
                    String itemId = mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_PRODUCT.getValue() ? mallOrderProductEntity.getProductId() : (mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_PROMOTION.getValue() ? mallOrderProductEntity.getPromotionId() : mallOrderProductEntity.getGroupId());
                    baseJsonVo = this.shoppingcartInterface.addCart(platFormId, customerId, (int)mallOrderProductEntity.getGroupType(), itemId, "", mallOrderProductEntity.getQuantity(), false, "0");
                    this.logger.info("\u7528\u6237:{}\u5546\u54c1:{}\u52a0\u5165\u8d2d\u7269\u8f66:{} {}", new Object[]{customerId, itemId, baseJsonVo.isSuccess(), baseJsonVo.getMessage()});
                    if (baseJsonVo.isSuccess()) continue;
                    this.logger.error("\u5546\u54c1:{}\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25:{}", (Object)itemId, (Object)baseJsonVo.getMessage());
                    throw new RuntimeException("\u521b\u5efa\u8ba2\u5355\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                orderCacheVo.setCardBatchId(mallMainOrderVo.getOrderCacheVo().getCardList().get(0).getBatchId());
                orderCacheVo.setChanId(orderCacheVo.getChanId());
                orderCacheVo.setCardList(new ArrayList<MallOrderCacheInCardVo>());
                if (CollectionUtils.isNotEmpty(mallMainOrderVo.getOrderCacheVo().getExchangeVoList())) {
                    orderCacheVo.setExchangeVoList(mallMainOrderVo.getOrderCacheVo().getExchangeVoList());
                }
                orderCacheVo.setSourceOrderNo(resultMap.get("mainOrderNo").toString());
                this.logger.info("\u7528\u6237:{}\u5f00\u59cb\u521b\u5efa\u914d\u9001\u8ba2\u5355", (Object)customerId);
                baseJsonVo = this.createOrder(platFormId, customerId, orderCacheVo);
                this.logger.info("\u7528\u6237:{}\u901a\u8fc7\u8d2d\u7269\u8f66\u521b\u5efa\u5b9e\u7269\u914d\u9001\u8ba2\u5355:{}", (Object)customerId, (Object)baseJsonVo.isSuccess());
                return baseJsonVo;
            }
            cacheVoBaseJsonVo = this.setDeliveryOrderCache(platFormId, customerId, orderCacheVo, tempList);
            this.logger.info("\u8bbe\u7f6e\u7528\u6237:{}\u5b9e\u7269\u8ba2\u5355\u7f13\u5b58:{}", (Object)customerId, (Object)cacheVoBaseJsonVo.isSuccess());
            if (cacheVoBaseJsonVo.isSuccess()) {
                ((MallOrderCacheVo)cacheVoBaseJsonVo.getValue()).setCardList(new ArrayList<MallOrderCacheInCardVo>());
                ((MallOrderCacheVo)cacheVoBaseJsonVo.getValue()).setSourceOrderNo(resultMap.get("mainOrderNo").toString());
                ((MallOrderCacheVo)cacheVoBaseJsonVo.getValue()).setCacheType(2);
                ((MallOrderCacheVo)cacheVoBaseJsonVo.getValue()).setAddressId(orderCacheVo.getAddressId());
                ((MallOrderCacheVo)cacheVoBaseJsonVo.getValue()).setDeliverDate(orderCacheVo.getDeliverDate());
                ((MallOrderCacheVo)cacheVoBaseJsonVo.getValue()).setDeliverDate2(orderCacheVo.getDeliverDate());
                ((MallOrderCacheVo)cacheVoBaseJsonVo.getValue()).setCardBatchId(mallMainOrderVo.getOrderCacheVo().getCardList().get(0).getBatchId());
                baseJsonVo = this.tradeInterface.createOrder(platFormId, customerId, (MallOrderCacheVo)cacheVoBaseJsonVo.getValue());
                this.logger.info("\u7528\u6237:{}\u901a\u8fc7\u7f13\u5b58\u521b\u5efa\u5b9e\u7269\u914d\u9001\u8ba2\u5355:{}", (Object)customerId, (Object)baseJsonVo.isSuccess());
                return baseJsonVo;
            }
        }
        return cacheVoBaseJsonVo;
    }

    private BaseJsonVo<MallOrderCacheVo> setDeliveryOrderCache(int platFormId, String customerId, MallOrderCacheVo orderCacheVo, List<MallOrderProductEntity> productList) {
        MallOrderCacheInVo inVo = new MallOrderCacheInVo();
        inVo.setDeliverCount(1);
        inVo.setDeliverPeriod(1);
        inVo.setDeliverType(1);
        inVo.setOrderSource(orderCacheVo.getOrderSource());
        inVo.setBindCode("");
        inVo.setDefineField("");
        ArrayList<MallOrderCacheInItemVo> itemVoList = new ArrayList<MallOrderCacheInItemVo>();
        for (MallOrderProductEntity orderProductEntity : productList) {
            MallOrderCacheInItemVo itemVo = new MallOrderCacheInItemVo();
            String itemId = "";
            if (Objects.equals(orderProductEntity.getGroupType(), SalesTypeEnum.SALES_PRODUCT.getValue())) {
                itemId = orderProductEntity.getProductId();
            } else if (Objects.equals(orderProductEntity.getGroupType(), SalesTypeEnum.SALES_PROMOTION.getValue())) {
                itemId = orderProductEntity.getPromotionId();
            } else if (Objects.equals(orderProductEntity.getGroupType(), SalesTypeEnum.SALES_GROUP.getValue())) {
                itemId = orderProductEntity.getGroupId();
            }
            itemVo.setItemId(itemId);
            itemVo.setItemType(orderProductEntity.getGroupType());
            itemVo.setQuantity(orderProductEntity.getQuantity());
            itemVoList.add(itemVo);
        }
        inVo.setMallOrderCacheInItemVoList(itemVoList);
        try {
            return this.tradeInterface.setOrderCache(platFormId, customerId, inVo);
        }
        catch (Exception e) {
            e.getStackTrace();
            this.logger.error("setOrderCache-error:", (Throwable)e);
            return BaseJsonVo.error((String)"\u8bbe\u7f6e\u914d\u9001\u8ba2\u5355\u7f13\u5b58\u51fa\u9519");
        }
    }

    private BaseJsonVo<MallOrderCacheVo> setBuyCardCache(int platFormId, String customerId, List<MallOrderCacheInCardVo> cardList) {
        MallOrderCacheInVo inVo = new MallOrderCacheInVo();
        inVo.setDeliverCount(1);
        inVo.setDeliverPeriod(1);
        inVo.setDeliverType(1);
        inVo.setOrderSource(OrderSourceEnum.SPLITE_CARD_ORDER.getValue());
        inVo.setBindCode("");
        inVo.setDefineField("");
        ArrayList<MallOrderCacheInItemVo> itemVoList = new ArrayList<MallOrderCacheInItemVo>();
        MallOrderCacheInItemVo itemVo = new MallOrderCacheInItemVo();
        itemVo.setItemId(cardList.get(0).getItemId());
        itemVo.setItemType(cardList.get(0).getItemType());
        itemVo.setQuantity(1);
        itemVoList.add(itemVo);
        inVo.setMallOrderCacheInItemVoList(itemVoList);
        try {
            return this.tradeInterface.setOrderCache(platFormId, customerId, inVo);
        }
        catch (Exception e) {
            e.getStackTrace();
            this.logger.error("setOrderCache-error:", (Throwable)e);
            return BaseJsonVo.error((String)"");
        }
    }

    @Override
    public BaseJsonVo addProduct(List<MallOrderProductDo> list) {
        String message = "";
        String orderNo = this.orderInterface.findOrders(list.get(0).getOrderMainNo()).get(0).getOrderNo();
        for (MallOrderProductDo op : list) {
            MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
            orderProductEntity.setActivityNo("");
            orderProductEntity.setChannelOrderproductNo("");
            orderProductEntity.setDeliverQuantity(0);
            orderProductEntity.setFullCutAmount(new BigDecimal(0));
            orderProductEntity.setGroupId("");
            orderProductEntity.setGroupType(SalesTypeEnum.SALES_PRODUCT.getValue());
            orderProductEntity.setOrderMainNo(op.getOrderMainNo());
            orderProductEntity.setOrderNo(orderNo);
            orderProductEntity.setOrderProductNo(String.valueOf(IDGenerate.getUniqueID()));
            orderProductEntity.setOriginalPrice(new BigDecimal(0));
            orderProductEntity.setQuantity(op.getQuantity());
            orderProductEntity.setProductId(op.getProductId());
            orderProductEntity.setProductName(op.getProductName());
            orderProductEntity.setPromotionProductId("");
            orderProductEntity.setTicketAmount(new BigDecimal(0));
            orderProductEntity.setTicketFlag((short)1);
            orderProductEntity.setTotalPrice(PriceUtils.multiply((BigDecimal)new BigDecimal(0), (Integer)op.getQuantity()));
            orderProductEntity.setUnitPrice(new BigDecimal(0));
            boolean success = this.orderProductInterface.insertOrderProduct(orderProductEntity);
            if (!success) {
                message = "\u751f\u6210\u8ba2\u5355\u5546\u54c1\u8868\u5f02\u5e38";
                this.logger.error(message + op.getOrderMainNo().toString());
                throw new RuntimeException(message);
            }
            MallOrderGroupProductEntity groupProductEntity = new MallOrderGroupProductEntity();
            groupProductEntity.setUnitPrice(new BigDecimal(0));
            groupProductEntity.setGroupId("");
            groupProductEntity.setGroupType(4);
            groupProductEntity.setOrderGroupId(String.valueOf(IDGenerate.getUniqueID()));
            groupProductEntity.setOrderMainNo(op.getOrderMainNo());
            groupProductEntity.setOrderNo(orderNo);
            groupProductEntity.setOrderProductNo(orderProductEntity.getOrderProductNo());
            groupProductEntity.setProductId(op.getProductId());
            groupProductEntity.setProductName(op.getProductName());
            groupProductEntity.setQuantity(op.getQuantity());
            groupProductEntity.setOriginPrice(new BigDecimal(0));
            success = this.orderGroupProductInterface.insertOrderGroupProduct(groupProductEntity);
            if (success) continue;
            message = "\u751f\u6210\u8ba2\u5355\u5546\u54c1\u660e\u7ec6\u8868\u5f02\u5e38";
            this.logger.error(message + op.getOrderMainNo().toString());
            throw new RuntimeException(message);
        }
        return BaseJsonVo.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, timeout=100, isolation=Isolation.SERIALIZABLE)
    public BaseJsonVo buildOrder(MallOrderEntitiesVo orderEntitiesVo, MallMainOrderVo mainOrderVo) {
        this.logger.info("=====================\u8fdb\u5165=======buildOrder==================orderEntitiesVo={},mainOrderVo={}", (Object)JSON.toJSONString((Object)orderEntitiesVo), (Object)JSON.toJSONString((Object)mainOrderVo));
        String message = "";
        boolean isSuccess = false;
        try {
            boolean updateStock;
            if (!orderEntitiesVo.isBaseSuccess()) {
                message = orderEntitiesVo.getBaseErrMsg();
                throw new RuntimeException(message);
            }
            BaseJsonVo baseJsonVo = this.defineFiledHandleInterface.createOrderBeforeWithTransaction(mainOrderVo);
            if (!baseJsonVo.isSuccess()) {
                message = baseJsonVo.getMessage();
                throw new RuntimeException(message);
            }
            boolean bl = updateStock = (mainOrderVo.getOrderCacheVo().getCardBatchId() == null || !StringUtils.isNotEmpty((String)mainOrderVo.getOrderCacheVo().getSourceOrderNo())) && mainOrderVo.getOrderCacheVo().getOrderSource() != OrderSourceEnum.SPLITE_CARD_ORDER.getValue() && mainOrderVo.getOrderCacheVo().getOrderSource() != OrderSourceEnum.COMMUNITY_GROUP.getValue() && mainOrderVo.getOrderCacheVo().getOrderSource() != OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue();
            if (updateStock && !(baseJsonVo = this.promotionInterface.updatePromotionLimitCount(mainOrderVo, false)).isSuccess()) {
                message = baseJsonVo.getMessage();
                throw new RuntimeException(message);
            }
            boolean success = this.orderMainInterface.insertOrderMain(orderEntitiesVo.getOrderMainEntity());
            if (!success) {
                message = "\u751f\u6210\u8ba2\u5355\u4e3b\u8868\u5f02\u5e38";
                this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                throw new RuntimeException(message);
            }
            for (MallOrderEntity mallOrderEntity : orderEntitiesVo.getOrderEntities()) {
                success = this.orderInterface.insertOrder(mallOrderEntity);
                if (success) continue;
                message = "\u751f\u6210\u8ba2\u5355\u8868\u5f02\u5e38";
                this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                throw new RuntimeException(message);
            }
            for (MallOrderProductEntity mallOrderProductEntity : orderEntitiesVo.getOrderProductEntities()) {
                success = this.orderProductInterface.insertOrderProduct(mallOrderProductEntity);
                if (success) continue;
                message = "\u751f\u6210\u8ba2\u5355\u5546\u54c1\u8868\u5f02\u5e38";
                this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                throw new RuntimeException(message);
            }
            for (MallOrderGroupProductEntity mallOrderGroupProductEntity : orderEntitiesVo.getOrderGroupProductEntities()) {
                success = this.orderGroupProductInterface.insertOrderGroupProduct(mallOrderGroupProductEntity);
                if (success) continue;
                message = "\u751f\u6210\u8ba2\u5355\u5546\u54c1\u660e\u7ec6\u8868\u5f02\u5e38";
                this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                throw new RuntimeException(message);
            }
            for (MallOrderPayEntity mallOrderPayEntity : orderEntitiesVo.getOrderPayEntities()) {
                success = this.orderPayInterface.insertOrderPay(mallOrderPayEntity);
                if (success) continue;
                message = "\u751f\u6210\u8ba2\u5355\u652f\u4ed8\u8868\u5f02\u5e38";
                this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                throw new RuntimeException(message);
            }
            if (!this.tradeCommonInterface.isNoDeliverOrder(mainOrderVo) && updateStock) {
                Optional<MallOrderVo> mallOrderVoOptional = mainOrderVo.getMallOrderVos().stream().filter(c -> "\u7f8e\u56e2\u914d\u9001".equals(c.getDeliverVo().getDeliverName())).findFirst();
                if (mallOrderVoOptional.isPresent()) {
                    this.logger.info("\u914d\u9001\u65b9\u5f0f\u662f : " + mallOrderVoOptional.get().getDeliverVo().getDeliverName());
                    baseJsonVo = this.inventoryInterface.lockProductInventory(mainOrderVo);
                    this.logger.info("\u6263\u51cf\u5e93\u5b58\uff1a" + baseJsonVo.isSuccess() + "," + baseJsonVo.getMessage());
                    if (!baseJsonVo.isSuccess()) {
                        this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                        message = baseJsonVo.getMessage();
                        throw new RuntimeException(message);
                    }
                } else if (!baseJsonVo.isSuccess()) {
                    this.logger.error(message + orderEntitiesVo.getOrderMainEntity().toString());
                    message = baseJsonVo.getMessage();
                    throw new RuntimeException(message);
                }
                if ((mallOrderVoOptional = mainOrderVo.getMallOrderVos().stream().filter(c -> !"\u7f8e\u56e2\u914d\u9001".equals(c.getDeliverVo().getDeliverName())).findFirst()).isPresent() && mainOrderVo.getOrderCacheVo().getDeliverDate() != null && updateStock && CollectionUtils.isNotEmpty(orderEntitiesVo.getOrderEntities())) {
                    String string = this.mallOrderSaleNewErpService.checkOrderSaleCold(orderEntitiesVo, mainOrderVo);
                    if (string != null) {
                        message = string;
                        throw new RuntimeException(message);
                    }
                    String messageByNomal = this.mallOrderSaleNewErpService.checkOrderSaleNomal(orderEntitiesVo, mainOrderVo);
                    if (messageByNomal != null && !Objects.equals("\u5546\u54c1\u5df2\u552e\u7f44,\u8bf7\u7a0d\u540e", messageByNomal)) {
                        message = messageByNomal;
                        throw new RuntimeException(message);
                    }
                }
            }
            isSuccess = true;
            this.logger.info("\u6e05\u9664\u8d2d\u7269\u8f66\u6807\u8bc6:{},isquik={},customerId={}", new Object[]{mainOrderVo.getOrderCacheVo().getOrderSource(), mainOrderVo.getOrderCacheVo().getIsQuick(), mainOrderVo.getCustomerId()});
            if (mainOrderVo.getOrderCacheVo().getOrderSource() != OrderSourceEnum.CART.getValue()) {
                this.orderCacheInterface.deleteOrderCacheEntity(mainOrderVo.getOrderCacheVo().getCacheId());
            } else {
                this.shoppingcartInterface.removeCartChecked(mainOrderVo.getPlatFormId(), mainOrderVo.getCustomerId(), true, mainOrderVo.getOrderCacheVo().getIsQuick(), StringUtils.isEmpty((String)mainOrderVo.getOrderCacheVo().getBindCode()) ? "0" : mainOrderVo.getOrderCacheVo().getBindCode());
            }
            Iterator<Serializable> iterator = BaseJsonVo.success((Object)mainOrderVo.getMainOrderNo());
            return iterator;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("buildOrder\u5199\u8868\uff1a" + message + e.getMessage());
            message = message.isEmpty() ? "\u8ba2\u5355\u521b\u5efa\u5f02\u5e38" : e.getMessage();
        }
        finally {
            this.defineFiledHandleInterface.createOrderAfterWithTransaction(mainOrderVo, isSuccess);
        }
        return BaseJsonVo.error((String)message);
    }

    private MallOrderEntitiesVo getOrderEntities(MallMainOrderVo mainOrderVo) {
        this.logger.info("buildOrder:{}", (Object)JsonUtils.toJson((Object)mainOrderVo, (boolean)false));
        MallOrderEntitiesVo orderEntitiesVo = new MallOrderEntitiesVo();
        try {
            BaseJsonVo baseJsonVo = this.orderMainInterface.buildOrderMainEntity(mainOrderVo);
            if (!baseJsonVo.isSuccess()) {
                orderEntitiesVo.setBaseError(baseJsonVo.getError_msg());
                return orderEntitiesVo;
            }
            orderEntitiesVo.setOrderMainEntity((MallOrderMainEntity)baseJsonVo.getValue());
            baseJsonVo = this.orderInterface.buildOrderEntities(mainOrderVo);
            if (!baseJsonVo.isSuccess()) {
                orderEntitiesVo.setBaseError(baseJsonVo.getError_msg());
                return orderEntitiesVo;
            }
            orderEntitiesVo.setOrderEntities((List)baseJsonVo.getValue());
            baseJsonVo = this.orderProductInterface.buildOrderProductEntities(mainOrderVo);
            if (!baseJsonVo.isSuccess()) {
                orderEntitiesVo.setBaseError(baseJsonVo.getError_msg());
                return orderEntitiesVo;
            }
            MallOrderGroupAndProductVo orderGroupAndProductVo = (MallOrderGroupAndProductVo)baseJsonVo.getValue();
            orderEntitiesVo.setOrderProductEntities(orderGroupAndProductVo.getOrderProductEntities());
            orderEntitiesVo.setOrderGroupProductEntities(orderGroupAndProductVo.getOrderGroupProductEntities());
            if (mainOrderVo.getOrderPayEntities() == null || mainOrderVo.getOrderPayEntities().size() <= 0) {
                orderEntitiesVo.setBaseError("\u652f\u4ed8\u4fe1\u606f\u6784\u5efa\u5f02\u5e38:" + JsonUtils.toJson((Object)mainOrderVo, (boolean)false));
                return orderEntitiesVo;
            }
            orderEntitiesVo.setOrderPayEntities(mainOrderVo.getOrderPayEntities());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.toString());
            orderEntitiesVo.setBaseError("\u8ba2\u5355\u4fe1\u606f\u6784\u5efa\u5f02\u5e38");
        }
        return orderEntitiesVo;
    }

    @Override
    public BaseJsonVo cancelCustomerOrder(String customerId, String orderMainNo, int cancelSource) {
        this.logger.info("*************\u8fdb\u5165\u53d6\u6d88\u8ba2\u5355service********\u65b9\u6cd5cancelCustomerOrder*************");
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.defineFiledHandleInterface.cancelOrderBefore(customerId, orderMainNo, cancelSource);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (customerId == null || customerId.isEmpty()) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!customerId.equals(orderMainEntity.getCustomerId())) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0e\u8ba2\u5355\u4e0d\u4e00\u81f4");
        }
        if (orderMainEntity.getStatus().intValue() == OrderStatusEnum.CANCEL.getValue()) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u5df2\u7ecf\u53d6\u6d88");
        }
        if (orderMainEntity.getStatus().intValue() != OrderStatusEnum.UNPAY.getValue()) {
            return BaseJsonVo.error((String)"\u8be5\u72b6\u6001\u4e0d\u80fd\u53d6\u6d88");
        }
        if (orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.RECHANGE_CARD.getValue()) {
            boolean milkCardOrder = this.orderPayInterface.checkMilkCardOrder(orderMainNo);
            if (milkCardOrder) {
                return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u4e3a\u5976\u5361\u8ba2\u5355\uff0c\u4e0d\u80fd\u53d6\u6d88");
            }
        } else {
            List<MallOrderEntity> list = this.orderInterface.getOrderList(orderMainNo);
            for (MallOrderEntity order : list) {
                this.prepayCardOrderPlanService.refundPrepayCardOrder(orderMainNo, order.getOrderNo(), customerId);
            }
        }
        Date createTime = orderMainEntity.getCreateTime();
        String canCancelTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)-10, (String)"yyyy-MM-dd HH:mm:ss");
        if (DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)createTime, (String)"yyyy-MM-dd HH:mm:ss"), (String)canCancelTime) < 0L) {
            this.logger.info("======cancelCustomerOrder====createTime:[{}],canCancelTime:[{}],DateDiff:[{}]", new Object[]{createTime, canCancelTime, DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)createTime, (String)"yyyy-MM-dd HH:mm:ss"), (String)canCancelTime)});
            return BaseJsonVo.error((String)"\u6682\u65f6\u65e0\u6cd5\u53d6\u6d88");
        }
        try {
            this.logger.info("*************\u8fdb\u5165\u53d6\u6d88\u8ba2\u5355service********\u5173\u95ed\u652f\u4ed8************");
            BaseJsonVo result = this.payOrderInterface.payClose(customerId, orderMainNo);
            this.logger.info("-------------------\u5173\u95ed\u652f\u4ed8\u7ed3\u679c------result={}", (Object)JSON.toJSONString((Object)result));
            if (!result.isSuccess()) {
                return BaseJsonVo.error((String)result.getError_msg());
            }
            this.logger.info("*************\u8fdb\u5165\u53d6\u6d88\u8ba2\u5355service********\u4e0b\u4e00\u6b65\u91ca\u653e\u5e93\u5b58*************");
            BaseJsonVo baseJsonVo = this.inventoryInterface.unLockProductInventory(orderMainNo, orderMainEntity.getPlatformId());
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            if (this.orderMainInterface.cancelOrderMain(orderMainNo, customerId)) {
                this.defineFiledHandleInterface.cancelOrderAfter(customerId, orderMainNo, cancelSource);
                return BaseJsonVo.success((Object)"");
            }
            BaseJsonVo.error((String)"\u53d6\u6d88\u8ba2\u5355\u5931\u8d25");
            this.orderDataService.updateOrder(orderMainNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u53d6\u6d88\u8ba2\u5355\u9519\u8bef", (Throwable)e);
        }
        return BaseJsonVo.error((String)"\u53d6\u6d88\u8ba2\u5355\u9519\u8bef");
    }

    @Override
    public BaseJsonVo updateOrderPaySuccess(String tradeNo, String thirdTradeNo) {
        String orderMainNo = "";
        MallOrderPayEntity orderPayEntity = this.orderPayInterface.getSingleOrderPayByTradeNo(tradeNo);
        String message = "\u66f4\u65b0\u8ba2\u5355\u5931\u8d25";
        if (orderPayEntity == null && (orderPayEntity = this.orderPayInterface.getSingle(tradeNo)) == null) {
            return BaseJsonVo.error((String)"\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        BaseJsonVo updateOrderPaySuccessVO = this.tradeInterface.updateOrderPaySuccess(orderPayEntity, thirdTradeNo);
        if (updateOrderPaySuccessVO.isSuccess()) {
            BaseJsonVo orderPaySuccessAfterVO = this.defineFiledHandleInterface.orderPaySuccessAfter(orderPayEntity.getOrderMainNo());
            return orderPaySuccessAfterVO;
        }
        return updateOrderPaySuccessVO;
    }

    @Override
    public BaseJsonVo updateOrderPaySuccess(MallOrderPayEntity orderPayEntity, String thirdTradeNo) {
        String orderMainNo = "";
        String message = "\u66f4\u65b0\u8ba2\u5355\u5931\u8d25";
        try {
            BaseJsonVo baseJsonVo;
            orderMainNo = orderPayEntity.getOrderMainNo();
            if (orderPayEntity.getIssuccess() == 0) {
                orderPayEntity.setIssuccess(1);
                orderPayEntity.setSuccessTime(DateUtils.now());
                orderPayEntity.setThirdTradeNo(thirdTradeNo);
            }
            if (!(baseJsonVo = this.tradeInterface.updateOrderSuccess(orderMainNo, orderPayEntity)).isSuccess()) {
                message = baseJsonVo.getMessage();
                throw new Exception();
            }
            return BaseJsonVo.success((Object)"");
        }
        catch (Exception e) {
            this.logger.error(message + ",\u8ba2\u5355\u53f7\uff1a" + orderMainNo + e.toString());
            return BaseJsonVo.error((String)message);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo updateOrderSuccess(String orderMainNo, MallOrderPayEntity orderPayEntity) {
        String message = "";
        try {
            boolean flag2;
            if (orderPayEntity != null && StringUtils.isNotEmpty((String)orderPayEntity.getPayId())) {
                this.orderPayInterface.updateByPrimaryKey(orderPayEntity);
            }
            List<MallOrderPayEntity> orderPayEntities = this.orderPayInterface.getList(orderMainNo);
            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            if (orderMainEntity == null || orderPayEntities == null) {
                throw new Exception("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            if (orderMainEntity.getStatus() > 1) {
                this.logger.info("\u8ba2\u5355" + orderMainNo + ",\u72b6\u6001\u5df2\u7ecf\u66f4\u65b0\u4e3a\uff1a" + orderMainEntity.getStatus());
                return BaseJsonVo.success((Object)"");
            }
            if (orderPayEntity != null && StringUtils.isNotEmpty((String)orderPayEntity.getPayId())) {
                for (int i = 0; i < orderPayEntities.size(); ++i) {
                    if (!orderPayEntity.getPayId().equals(orderPayEntities.get(i).getPayId())) continue;
                    orderPayEntities.set(i, orderPayEntity);
                    break;
                }
            }
            BigDecimal payAmount = orderPayEntities.stream().filter(c -> c.getIssuccess() == 1).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            boolean flag1 = orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue();
            this.logger.info("\u652f\u4ed8\u91d1\u989d:{},\u8ba2\u5355\u603b\u989d:{},\u8ba2\u5355\u70b9\u6570:{}", new Object[]{payAmount, orderMainEntity.getTotalAmount(), orderMainEntity.getPoints()});
            boolean bl = flag2 = payAmount.compareTo(orderMainEntity.getTotalAmount()) == 0;
            if (flag1 || flag2) {
                if (!this.orderMainInterface.paySuccessOrderMain(orderMainNo)) {
                    throw new Exception("[updateOrderSuccess]\u66f4\u65b0\u8ba2\u5355\u65b9\u6cd5\u5f02\u5e38:\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
                }
            } else {
                this.logger.info("updateOrderSuccess\u66f4\u65b0\u8ba2\u5355" + orderMainNo + "\u65b9\u6cd5\u5f02\u5e38:\u652f\u4ed8\u91d1\u989d\u4e0e\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26\uff0c\u8ba2\u5355\u91d1\u989d\uff1a" + orderMainEntity.getTotalAmount().doubleValue() + "\uff0c\u652f\u4ed8\u91d1\u989d\uff1a" + payAmount.doubleValue());
                throw new Exception("[updateOrderSuccess]\u66f4\u65b0\u8ba2\u5355\u65b9\u6cd5\u5f02\u5e38:\u652f\u4ed8\u91d1\u989d\u4e0e\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26\uff0c\u8ba2\u5355\u91d1\u989d\uff1a" + orderMainEntity.getTotalAmount().doubleValue() + "\uff0c\u652f\u4ed8\u91d1\u989d\uff1a" + payAmount.doubleValue());
            }
            return BaseJsonVo.success((Object)"");
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("[updateOrderSuccess]\u66f4\u65b0\u8ba2\u5355\u65b9\u6cd5\u5f02\u5e38:" + orderMainNo, (Throwable)e);
            return BaseJsonVo.error((String)"\u66f4\u65b0\u8ba2\u5355\u5f02\u5e38");
        }
    }

    @Override
    public Map<String, Long> getOrderCount(String customerId) {
        return this.orderInterface.getCustomerOrderCount(customerId);
    }

    @Override
    public List<OrderListVo> getOrderList(String customerId, int statusClass, int pageSize, int pageCount) {
        List<OrderListVo> orderMainEntities;
        int[] statusArr = null;
        if (statusClass != 0) {
            statusArr = OrderStatusClassConstants.getStatusByStatusClass(statusClass);
        }
        if ((orderMainEntities = this.orderMainInterface.getOrderMainList(customerId, statusArr, statusClass, -1, pageSize, pageCount)) == null || orderMainEntities.size() == 0) {
            return null;
        }
        this.getOrderDetail(orderMainEntities);
        if (statusClass == 4) {
            orderMainEntities.removeIf(c -> c.getOrderClass() != 1 || c.getEvaluateStatus() == 1 || c.getOrderNo() == null);
        }
        return orderMainEntities;
    }

    @Override
    @ReadThroughSingleCache(namespace="getOrderList", expiration=600)
    public List<OrderListVo> getOrderList(@ParameterValueKeyProvider(order=0) String customerId, @ParameterValueKeyProvider(order=1) int statusClass, @ParameterValueKeyProvider(order=2) int orderSource, @ParameterValueKeyProvider(order=3) int pageSize, @ParameterValueKeyProvider(order=4) int pageCount) {
        List<OrderListVo> orderMainEntities;
        int[] statusArr = new int[]{OrderStatusEnum.PART_COMPLETION.getValue(), OrderStatusEnum.COMPLETION.getValue(), OrderStatusEnum.PART_DELIVERED.getValue(), OrderStatusEnum.DELIVERED.getValue(), OrderStatusEnum.ARRIVED.getValue()};
        if (statusClass != 0) {
            statusArr = OrderStatusClassConstants.getStatusByStatusClass(statusClass);
        }
        if ((orderMainEntities = this.orderMainInterface.getOrderMainList(customerId, statusArr, statusClass, orderSource, pageSize, pageCount)) == null || orderMainEntities.size() == 0) {
            return Collections.emptyList();
        }
        ExecutorService pool = Executors.newFixedThreadPool(10);
        for (final OrderListVo orderMain : orderMainEntities) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    MallTradeService.this.processOrderListInfo(orderMain);
                }
            });
        }
        pool.shutdown();
        try {
            boolean loop = true;
            while (loop = !pool.awaitTermination(2L, TimeUnit.SECONDS)) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        orderMainEntities.removeIf(c -> c.getOrderSource() != OrderSourceEnum.RECHANGE_CARD.getValue() && this.orderPayInterface.checkMilkCardOrder(c.getOrderMainNo()) && c.getPickUpDate().compareTo(DateUtils.now()) > 0);
        if (statusClass == 4) {
            orderMainEntities.removeIf(c -> c.getOrderClass() != 1 || c.getEvaluateStatus() == 1 || c.getOrderNo() == null);
        }
        return orderMainEntities;
    }

    private void getOrderDetail(List<OrderListVo> orderMainEntities) {
        ExecutorService pool = Executors.newFixedThreadPool(10);
        for (final OrderListVo orderMain : orderMainEntities) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    MallTradeService.this.processOrderInfo(orderMain);
                    if (orderMain.getStatus() >= 20 || orderMain.getStatus() <= 2 || orderMain.getOrderClass() == 18 || orderMain.getOrderClass() == 2 || orderMain.getOrderSource() == 21 || orderMain.getOrderSource() == 22 || orderMain.getCreateTime().before(DateUtils.getDateFromString((String)"2020-01-01 00:00:00"))) {
                        orderMain.setCanShare(2);
                    } else {
                        orderMain.setCanShare(1);
                    }
                }
            });
        }
        pool.shutdown();
        try {
            boolean loop = true;
            while (loop = !pool.awaitTermination(2L, TimeUnit.SECONDS)) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processOrderInfo(OrderListVo orderMain) {
        MallCityEntity cityEntity;
        BaseJsonVo orderIsFullyRefunded;
        String orderNo = orderMain.getOrderNo();
        this.orderInterface.getOrderInfo(orderMain);
        if (orderMain.getOrderNo() == null || orderMain.getOrderNo().isEmpty()) {
            return;
        }
        orderMain.setChannelName(ChannelEnum.getName(orderMain.getChannelId()));
        orderMain.setStatusName(OrderStatusEnum.getName(orderMain.getStatus()));
        int statusClass1 = this.orderInterface.getStatusClass(orderMain.getStatus(), orderMain.getEvaluateStatus(), orderMain.getOrderClass());
        orderMain.setStatusClass(statusClass1);
        if (orderMain.getStatus() == OrderStatusEnum.UNPAY.getValue()) {
            int cancelTimes = 570;
            long i = DateUtils.getDateDiffSecond((String)DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"), (String)DateUtils.getAddDateBySecond((Date)orderMain.getCreateTime(), (int)cancelTimes, (String)"yyyy-MM-dd HH:mm:ss"));
            if (i < 0L) {
                i = 0L;
            }
            orderMain.setCancelTimes(i);
            if (i == 0L) {
                statusClass1 = this.orderInterface.getStatusClass(orderMain.getStatus(), orderMain.getEvaluateStatus(), orderMain.getOrderClass());
                orderMain.setStatusClass(statusClass1);
            }
        } else {
            orderMain.setCancelTimes(0L);
        }
        boolean isEdit = this.orderMainInterface.iseditOrder(orderMain.getOrderNo(), orderMain.getDeliverDate(), orderMain.getPickUpDate(), orderMain.getPlatformGroupId(), orderMain.getStatus()).isSuccess();
        orderMain.setEdit(isEdit);
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setOrderMainNo(orderMain.getOrderMainNo());
        if (orderNo != null && !orderNo.isEmpty()) {
            orderProductEntity.setOrderNo(orderNo);
        }
        List<MallOrderProductEntity> orderProductEntities = this.orderProductInterface.getOrderProductList(orderProductEntity);
        ArrayList<MallOrderProductVo> orderProductVos = new ArrayList<MallOrderProductVo>();
        int transportType = 1;
        Boolean orderRefundable = true;
        if (orderMain.getPickUpDate() != null && orderMain.getPickUpDate().before(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)-90))) {
            orderRefundable = false;
        }
        if (orderMain.getCreateTime() != null && orderMain.getCreateTime().before(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)-180))) {
            orderRefundable = false;
        }
        for (MallOrderProductEntity p : orderProductEntities) {
            List<MallOrderGroupProductEntity> orderGroupProductList;
            String oids;
            BaseJsonVo orderIsFullyRefunded2;
            MallOrderProductVo orderProductVo = new MallOrderProductVo();
            BeanUtils.copyProperties((Object)p, (Object)orderProductVo);
            if (p.getGroupType() == 1) {
                orderProductVo.setItemId(p.getPromotionProductId());
                List<String> productPicUrl = this.productPicInterface.getProductPicUrl(p.getPromotionProductId() == null ? "" : p.getPromotionProductId(), ProductPicTypeEnum.PROMO_SAMLL.getValue());
                if (productPicUrl == null || productPicUrl.size() == 0 || StringUtils.isEmpty((String)productPicUrl.get(0))) {
                    productPicUrl = this.productPicInterface.getProductPicUrl(p.getPromotionId() == null ? "" : p.getPromotionId(), ProductPicTypeEnum.PROMO_SAMLL.getValue());
                }
                orderProductVo.setPicUrl(productPicUrl != null && productPicUrl.size() > 0 ? productPicUrl.get(0) : "");
            }
            if (p.getGroupType() == 2) {
                orderProductVo.setItemId(p.getGroupId());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getGroupId() == null ? "" : p.getGroupId(), ProductPicTypeEnum.GRO_SAMLL.getValue()).get(0));
            }
            if (p.getGroupType() == 4) {
                orderProductVo.setItemId(p.getProductId());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getProductId() == null ? "" : p.getProductId(), ProductPicTypeEnum.PRO_SAMLL.getValue()).get(0));
            }
            if (p.getGroupType() == 5) {
                orderProductVo.setItemId(p.getActivityNo());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getActivityNo() == null ? "" : p.getActivityNo(), ProductPicTypeEnum.ACT_SAMLL.getValue()).get(0));
            }
            orderProductVo.setProductType(p.getGroupType());
            orderProductVo.setFactPrice(p.getUnitPrice());
            orderProductVo.setItemName(p.getProductName());
            orderProductVo.setQuantity(p.getQuantity() - (p.getRefundCount() == null ? 0 : p.getRefundCount()));
            orderProductVo.setTotalPrice(p.getTotalPrice().subtract(p.getRefundAmount() == null ? BigDecimal.ZERO : p.getRefundAmount()).setScale(2, 4));
            orderProductVo.setUnitPrice(p.getOriginalPrice());
            orderProductVo.setOrderProductId(p.getOrderProductNo());
            if (StringUtils.isNotEmpty((String)p.getProductId())) {
                MallProductEntity productEntity = this.productInterface.getProduct(p.getProductId());
                if (productEntity != null) {
                    orderProductVo.setProDw(productEntity.getProDw());
                    orderProductVo.setProTypeId(productEntity.getProTypeId());
                    orderProductVo.setProTitle(productEntity.getProTitle());
                } else {
                    orderProductVo.setProDw("\u5957");
                }
            } else {
                orderProductVo.setProDw("\u5957");
            }
            orderProductVo.setRefundable(0);
            if (orderRefundable.booleanValue() && orderMain.getStatus() >= OrderStatusEnum.PART_DELIVERED.getValue() && orderMain.getStatus() <= OrderStatusEnum.COMPLETION.getValue() && (orderIsFullyRefunded2 = this.csmsRefundInvoke.orderProductIsFullyRefunded(orderNo, oids = (orderGroupProductList = this.orderGroupProductInterface.getOrderGroupProductList(p.getOrderProductNo())).stream().map(MallOrderGroupProductEntity::getOrderGroupId).collect(Collectors.joining(",")))).isSuccess()) {
                Map refundableRst = (Map)orderIsFullyRefunded2.getValue();
                if (((Boolean)refundableRst.get("refunding")).booleanValue()) {
                    orderProductVo.setRefundingNo((String)refundableRst.get("refundNo"));
                    orderProductVo.setRefundable(2);
                } else if (((Boolean)refundableRst.get("allRefunded")).booleanValue()) {
                    orderProductVo.setRefundingNo((String)refundableRst.get("refundNo"));
                    orderProductVo.setRefundable(3);
                } else {
                    orderProductVo.setRefundable(1);
                }
            }
            orderProductVos.add(orderProductVo);
        }
        orderMain.setRefundable(0);
        if (orderRefundable.booleanValue() && orderMain.getStatus() > OrderStatusEnum.UNCONFIRM.getValue() && (orderMain.getStatus() < OrderStatusEnum.PART_DELIVERED.getValue() || orderMain.getStatus() > OrderStatusEnum.COMPLETION.getValue()) && (orderIsFullyRefunded = this.csmsRefundInvoke.orderIsFullyRefunded(orderNo)).isSuccess()) {
            Map refundableRst = (Map)orderIsFullyRefunded.getValue();
            if (((Boolean)refundableRst.get("refunding")).booleanValue()) {
                orderMain.setRefundingNo((String)refundableRst.get("refundNo"));
                orderMain.setRefundable(2);
            } else if (((Boolean)refundableRst.get("allRefunded")).booleanValue()) {
                orderMain.setRefundingNo((String)refundableRst.get("refundNo"));
                orderMain.setRefundable(3);
            } else {
                orderMain.setRefundable(1);
            }
        }
        transportType = this.productInterface.getTransportType(this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(orderMain.getOrderNo()));
        orderMain.setOrderProductVos(orderProductVos);
        MallAreaEntity areaEntity = this.areaInterface.getArea(orderMain.getConsigneeAreaid());
        if (areaEntity != null && (cityEntity = this.cityInterface.getCity(areaEntity.getCityId())) != null) {
            orderMain.setOpenCityStatus(cityEntity.getOpenCityStatus());
        }
        orderMain.setTransportType(transportType);
        if (transportType == 2) {
            orderMain.setDeliverDateShow(this.tradeCommonInterface.getDelayDateName(DateUtils.formatDate((Date)orderMain.getCreateTime(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getDeliverDate(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getPickUpDate(), (String)"yyyy-MM-dd"), "", orderMain.getOrderSource(), orderMain.getTransportType(), orderMain.getOpenCityStatus(), orderMain.getStatusClass(), orderMain.getDeliverType(), orderMain.getOrderClass()));
        } else {
            orderMain.setDeliverDateShow(this.tradeCommonInterface.getDelayDateName(DateUtils.formatDate((Date)orderMain.getCreateTime(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getDeliverDate(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getPickUpDate(), (String)"yyyy-MM-dd"), "", orderMain.getOrderSource(), orderMain.getTransportType(), orderMain.getOpenCityStatus(), orderMain.getStatusClass(), orderMain.getDeliverType(), orderMain.getOrderClass()));
        }
        orderMain.setStatusClass(this.orderInterface.getStatusClass(orderMain.getStatus(), orderMain.getEvaluateStatus(), orderMain.getOrderClass()));
        orderMain.setStatusClassName(OrderStatusClassConstants.getStatusClassName(orderMain.getStatusClass()));
        if ("\u5f85\u8bc4\u4ef7".equals(orderMain.getStatusClassName()) && orderMain.getCanEvaluateStatus() == 0) {
            orderMain.setStatusClassName("\u5df2\u5b8c\u6210");
        }
    }

    private void processOrderListInfo(OrderListVo orderMain) {
        String orderNo = orderMain.getOrderNo();
        this.orderInterface.getOrderInfo(orderMain);
        if (orderMain.getOrderNo() == null || orderMain.getOrderNo().isEmpty()) {
            return;
        }
        orderMain.setChannelName(ChannelEnum.getName(orderMain.getChannelId()));
        orderMain.setStatusName(OrderStatusEnum.getName(orderMain.getStatus()));
        int statusClass1 = this.orderInterface.getStatusClass(orderMain.getStatus(), orderMain.getEvaluateStatus(), orderMain.getOrderClass());
        orderMain.setStatusClass(statusClass1);
        orderMain.setCancelTimes(0L);
        orderMain.setEdit(false);
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setOrderMainNo(orderMain.getOrderMainNo());
        if (orderNo != null && !orderNo.isEmpty()) {
            orderProductEntity.setOrderNo(orderNo);
        }
        List<MallOrderProductEntity> orderProductEntities = this.orderProductInterface.getOrderProductList(orderProductEntity);
        ArrayList<MallOrderProductVo> orderProductVos = new ArrayList<MallOrderProductVo>();
        for (MallOrderProductEntity p : orderProductEntities) {
            MallOrderProductVo orderProductVo = new MallOrderProductVo();
            orderProductVo.setProductType(p.getGroupType());
            orderProductVo.setFactPrice(p.getUnitPrice());
            orderProductVo.setItemName(p.getProductName());
            orderProductVo.setQuantity(p.getQuantity() - (p.getRefundCount() == null ? 0 : p.getRefundCount()));
            orderProductVo.setTotalPrice(p.getTotalPrice().subtract(p.getRefundAmount() == null ? BigDecimal.ZERO : p.getRefundAmount()).setScale(2, 4));
            orderProductVo.setUnitPrice(p.getOriginalPrice());
            orderProductVo.setOrderProductId(p.getOrderProductNo());
            orderProductVo.setItemId(p.getGroupType().intValue() == SalesTypeEnum.SALES_PROMOTION.getValue() ? p.getPromotionId() : p.getProductId());
            orderProductVos.add(orderProductVo);
        }
        orderMain.setOrderProductVos(orderProductVos);
    }

    @Override
    public OrderListVo getOrderDetail(String customerId, String orderMainNo, String orderNo) {
        try {
            List<DictionaryEntity> noticeList;
            OrderListVo orderListVo = this.orderMainInterface.getOrderMainDetail(customerId, orderMainNo);
            if (orderListVo == null) {
                return null;
            }
            if (Objects.equals(orderListVo.getOrderSource(), OrderSourceEnum.RECHANGE_CARD.getValue())) {
                orderListVo.setCardType(StringUtils.isNotEmpty((String)orderListVo.getBindCode()) ? Integer.valueOf(orderListVo.getBindCode().length() > 2 ? PrepayCardTypeEnum.yogurt_card.getValue() : Integer.valueOf(orderListVo.getBindCode()).intValue()) : null);
            } else {
                orderListVo.setCardType(null);
            }
            orderListVo.setOrderNo(orderNo);
            this.processOrderInfo(orderListVo);
            orderListVo.setRepurchaseStatus(orderListVo.getOrderSource() == OrderSourceEnum.CART.getValue() && orderListVo.getStatus() != 1 ? 1 : 0);
            if (orderListVo.getRepurchaseStatus() == 1) {
                orderListVo.setClearProductList(this.getShoppingCarProductList(customerId, orderListVo.getBindCode()));
            }
            if (orderListVo.getStatus() >= 1 && orderListVo.getStatus() < 20 && CollectionUtils.isNotEmpty(noticeList = this.dictionaryInterface.getValidDictionaryList(225))) {
                List tempList;
                if (orderListVo.getDeliverDate() == null) {
                    tempList = noticeList.stream().filter(dictionaryEntity -> Objects.equals(dictionaryEntity.getDictionaryKey(), "1")).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(tempList)) {
                        orderListVo.setNoticeContent(((DictionaryEntity)tempList.get(0)).getDictionaryName());
                    }
                    if (orderListVo.getStatus() >= 16 && Objects.equals(orderListVo.getDeliverDateShow(), "\u5c3d\u5feb\u53d1\u8d27")) {
                        orderListVo.setDeliverDateShow(OrderStatusEnum.getName(orderListVo.getStatus()));
                    }
                } else {
                    tempList = noticeList.stream().filter(dictionaryEntity -> Objects.equals(dictionaryEntity.getDictionaryKey(), "2")).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(tempList)) {
                        orderListVo.setNoticeContent(((DictionaryEntity)tempList.get(0)).getDictionaryName());
                    } else {
                        tempList = noticeList.stream().filter(dictionaryEntity -> Objects.equals(dictionaryEntity.getDictionaryKey(), "1")).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(tempList)) {
                            orderListVo.setNoticeContent(((DictionaryEntity)tempList.get(0)).getDictionaryName());
                        }
                    }
                }
            }
            orderListVo.setClearShoppingCarFlag(CollectionUtils.isEmpty(orderListVo.getClearProductList()) ? 0 : 1);
            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            List<MallOrderPayEntity> orderPayEntities = this.orderPayInterface.getList(orderMainNo);
            if (orderPayEntities != null) {
                orderListVo.setCouponAmount(orderPayEntities.stream().filter(c -> c.getPaytypeId().intValue() == PayTypeEnum.COUPON_PAY.getValue()).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add));
                orderListVo.setBalanceAmount(orderPayEntities.stream().filter(c -> c.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add));
                if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY.getValue()) {
                    orderListVo.setSourceOrderAmount(orderPayEntities.stream().filter(c -> c.getPaytypeId().intValue() == PayTypeEnum.ORDERAMOUNT_PAY.getValue()).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add));
                }
                if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                    orderListVo.setCardBalanceAmount(orderMainEntity.getPoints());
                    orderListVo.setCardCouponAmount(orderPayEntities.stream().filter(c -> c.getPaytypeId().intValue() == PayTypeEnum.COUPON_PAY.getValue()).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add));
                }
            }
            int productQuantity = 0;
            BigDecimal vipCutAmount = BigDecimal.ZERO;
            BigDecimal exchangeCutAmount = BigDecimal.ZERO;
            BigDecimal promtionCutAmount = BigDecimal.ZERO;
            BigDecimal fullCutAmount = BigDecimal.ZERO;
            BigDecimal pointCut = BigDecimal.ZERO;
            if (orderListVo.getOrderProductVos() != null) {
                for (MallOrderProductVo orderProductVo : orderListVo.getOrderProductVos()) {
                    List<MallOrderGroupProductEntity> orderGroupProductEntities;
                    if (Objects.equals(orderProductVo.getProTypeId(), SalesTypeEnum.SALES_PROMOTION.getValue()) && orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                        orderProductVo.setCardFactPrice(orderProductVo.getFactPrice());
                        orderProductVo.setCardTotalPrice(orderProductVo.getTotalPrice());
                    }
                    if (CollectionUtils.isNotEmpty(orderGroupProductEntities = this.orderGroupProductInterface.getOrderGroupProductList(orderProductVo.getOrderProductId()))) {
                        ArrayList<MallOrderGroupProductVo> orderGroupProductVos = new ArrayList<MallOrderGroupProductVo>();
                        for (MallOrderGroupProductEntity g : orderGroupProductEntities) {
                            MallOrderGroupProductVo orderGroupProductVo = new MallOrderGroupProductVo();
                            MallProductEntity productEntity = this.productInterface.getProduct(g.getProductId());
                            orderGroupProductVo.setProTypeId(productEntity == null ? 0 : productEntity.getProTypeId());
                            orderGroupProductVo.setProType(productEntity == null ? "" : productEntity.getProType());
                            orderGroupProductVo.setGetProductNameEx(productEntity == null ? "" : productEntity.getProNameSx());
                            orderGroupProductVo.setProductId(productEntity == null ? g.getProductId() : productEntity.getProId());
                            orderGroupProductVo.setProductName(productEntity == null ? g.getProductName() : productEntity.getProName());
                            orderGroupProductVo.setTransportType(productEntity == null ? 1 : productEntity.getTransportType());
                            orderGroupProductVos.add(orderGroupProductVo);
                            if (orderMainEntity.getOrderSource().intValue() != OrderSourceEnum.RECHANGE_CARD.getValue() || !Objects.equals(orderListVo.getCardType(), PrepayCardTypeEnum.yogurt_card.getValue())) continue;
                            orderProductVo.setCardFactPrice(PriceUtils.divide((BigDecimal)g.getCardPrice(), (BigDecimal)new BigDecimal(g.getQuantity())));
                            orderProductVo.setCardTotalPrice(g.getCardPrice());
                        }
                        orderProductVo.setOrderGroupProductVos(orderGroupProductVos);
                    }
                    productQuantity += orderProductVo.getQuantity();
                    if (Objects.equals(orderProductVo.getOrderProductType(), 3)) {
                        if (orderProductVo.getUnitPrice().compareTo(orderProductVo.getFactPrice()) <= 0) continue;
                        exchangeCutAmount = PriceUtils.add((BigDecimal)exchangeCutAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)orderProductVo.getUnitPrice(), (BigDecimal)orderProductVo.getFactPrice()), (Integer)orderProductVo.getQuantity()));
                        continue;
                    }
                    if (orderProductVo.getFullCutAmount() != null && orderProductVo.getFullCutAmount().compareTo(BigDecimal.ZERO) > 0) {
                        fullCutAmount = PriceUtils.add((BigDecimal)fullCutAmount, (BigDecimal)orderProductVo.getFullCutAmount());
                        continue;
                    }
                    if (orderProductVo.getProductType() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
                        if (orderProductVo.getUnitPrice().compareTo(orderProductVo.getFactPrice()) <= 0) continue;
                        promtionCutAmount = PriceUtils.add((BigDecimal)promtionCutAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)orderProductVo.getUnitPrice(), (BigDecimal)orderProductVo.getFactPrice()), (Integer)orderProductVo.getQuantity()));
                        continue;
                    }
                    if (orderProductVo.getProductType() != SalesTypeEnum.SALES_PRODUCT.getValue() || orderProductVo.getUnitPrice().compareTo(orderProductVo.getFactPrice()) <= 0) continue;
                    vipCutAmount = PriceUtils.add((BigDecimal)vipCutAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)orderProductVo.getUnitPrice(), (BigDecimal)orderProductVo.getFactPrice()), (Integer)orderProductVo.getQuantity()));
                }
                orderListVo.setSubOrderProductQuantity(productQuantity);
            }
            if (orderListVo.getOrderDetailVos().size() == 1) {
                vipCutAmount = orderListVo.getVipCutAmount();
                promtionCutAmount = orderListVo.getPromtionCutAmount();
            }
            MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
            orderListVo.setWaybillToken(orderEntity.getWaybillToken());
            if (StringUtils.isNotEmpty((String)orderEntity.getWaybillToken()) && orderEntity.getWaybillToken().length() < 51) {
                orderListVo.setWaybillToken(null);
            }
            if ((orderListVo.getStatusClass() == 3 || orderListVo.getStatusClass() == 4 || orderListVo.getStatusClass() == 5 || orderListVo.getStatusClass() == 7) && orderListVo.getOrderClass() == OrderClassEnum.MALL_ORDER.getValue()) {
                OrderDeliverRecordVo deliverRecordVo;
                List<OrderDeliverRecordVo> orderDeliverRecordVos = this.deliverRecordInterface.getDeliverRecordList(orderListVo.getOrderNo());
                this.logger.info("AUV0\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={},orderDeliverRecordVos={}", (Object)orderNo, (Object)JsonUtils.toJson(orderDeliverRecordVos, (boolean)false));
                if (orderDeliverRecordVos == null) {
                    this.logger.info("AUV1\uff0c\u6ca1\u83b7\u53d6\u5230\u7269\u6d41\u4fe1\u606f\uff1aorderNo={}", (Object)orderNo);
                    orderDeliverRecordVos = new ArrayList<OrderDeliverRecordVo>();
                }
                this.logger.info("AUV2\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={}", (Object)orderNo);
                MallOrderPackagePrintrecordEntity packagePrintrecordEntity = this.packagePrintrecordInterface.getSingle(orderNo);
                if (packagePrintrecordEntity != null) {
                    this.logger.info("AUV3\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={}", (Object)orderNo);
                    if (packagePrintrecordEntity.getPrintTime() != null && orderListVo.getWayBillNo() != null) {
                        this.logger.info("AUV4\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={}", (Object)orderNo);
                        deliverRecordVo = new OrderDeliverRecordVo();
                        deliverRecordVo.setContent("\u7269\u6d41\u5355\u53f7\uff1a" + orderListVo.getWayBillNo());
                        deliverRecordVo.setCreateTime(DateUtils.getDateFromString((String)packagePrintrecordEntity.getPrintTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        deliverRecordVo.setPushTime(deliverRecordVo.getCreateTime());
                        orderDeliverRecordVos.add(deliverRecordVo);
                        this.logger.info("AUV5\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={},orderDeliverRecordVos={}", (Object)orderNo, (Object)JsonUtils.toJson(orderDeliverRecordVos, (boolean)false));
                    }
                }
                this.logger.info("AUV6\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={}", (Object)orderNo);
                if (orderDeliverRecordVos.size() == 0) {
                    this.logger.info("AUV7\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={}", (Object)orderNo);
                    deliverRecordVo = new OrderDeliverRecordVo();
                    deliverRecordVo.setContent(orderListVo.getStatusClassName());
                    deliverRecordVo.setCreateTime(orderListVo.getCreateTime());
                    deliverRecordVo.setPushTime(deliverRecordVo.getCreateTime());
                    orderDeliverRecordVos.add(deliverRecordVo);
                    this.logger.info("AUV8\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={},orderDeliverRecordVos={}", (Object)orderNo, (Object)JsonUtils.toJson(orderDeliverRecordVos, (boolean)false));
                }
                if (orderDeliverRecordVos != null && orderDeliverRecordVos.size() > 0) {
                    this.logger.info("AUV9\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={}", (Object)orderNo);
                    orderDeliverRecordVos.forEach(d -> {
                        if (d != null && StringUtils.isNotEmpty((String)d.getContent())) {
                            d.setContent(d.getContent().replace("\u6ede\u7559\u539f\u56e0:\u914d\u9001\u5ef6\u8bef \u914d\u9001\u529b\u4e0d\u8db3-\u914d\u9001\u529b\u4e0d\u8db3", "\u5ba2\u6237\u60a8\u597d\uff0c\u60a8\u7684\u5305\u88f9\u6b63\u5728\u5168\u529b\u914d\u9001\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85"));
                        }
                    });
                    this.logger.info("AUV10\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={},orderDeliverRecordVos={}", (Object)orderNo, (Object)JsonUtils.toJson(orderDeliverRecordVos, (boolean)false));
                }
                orderListVo.setOrderDeliverRecordVos(orderDeliverRecordVos);
                this.logger.info("AUV11\uff0c\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\uff1aorderNo={},orderListVo={}", (Object)orderNo, (Object)JsonUtils.toJson((Object)orderListVo, (boolean)false));
            }
            if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                orderListVo.setCardTotalAmount(orderMainEntity.getPoints());
                orderListVo.setCardOrderAmount(orderListVo.getCardTotalAmount().subtract(orderListVo.getFreight()));
                orderListVo.setCardPayAmount(orderListVo.getCardOrderAmount());
            }
            orderListVo.setTotalAmount(orderListVo.getTotalAmount().add(orderListVo.getVipCutAmount()).add(orderListVo.getPromtionCutAmount()).add(orderListVo.getPointCut()).add(orderListVo.getFullCutAmount()));
            if (orderListVo.getCardCut() != null) {
                orderListVo.setTotalAmount(orderListVo.getTotalAmount().add(orderListVo.getCardCut()));
            }
            orderListVo.setOrderAmount(orderListVo.getTotalAmount().subtract(orderListVo.getFreight()));
            for (MallOrderDetailVo orderDetailVo : orderListVo.getOrderDetailVos()) {
                if (!Objects.equals(orderDetailVo.getOrderNo(), orderNo)) continue;
                orderDetailVo.setExchangeCutAmount(exchangeCutAmount);
                orderDetailVo.setVipCutAmount(vipCutAmount);
                orderDetailVo.setPromtionCutAmount(promtionCutAmount);
                orderDetailVo.setPointCut(pointCut);
                orderDetailVo.setFullCutAmount(fullCutAmount);
                orderDetailVo.setSubBalanceAmount(orderEntity.getBalanceAmount());
                orderDetailVo.setSubCouponAmount(orderEntity.getCouponAmount());
                orderDetailVo.setSubFreight(orderEntity.getFreight());
                orderDetailVo.setCutStatus(CutStatusEnum.normal.getValue());
                orderDetailVo.setCutStatusName(CutStatusEnum.normal.getName());
                if (orderEntity.getTotalAmount().compareTo(BigDecimal.ZERO) > 0) {
                    orderDetailVo.setSubTotalAmount(orderEntity.getTotalAmount().add(vipCutAmount).add(promtionCutAmount).add(pointCut).add(fullCutAmount).add(exchangeCutAmount));
                    orderDetailVo.setSubOrderAmount(orderDetailVo.getSubTotalAmount().subtract(orderEntity.getFreight()));
                    orderDetailVo.setSubPayAmount(orderEntity.getPayAmount());
                    continue;
                }
                orderDetailVo.setSubTotalAmount(orderListVo.getTotalAmount().add(vipCutAmount).add(promtionCutAmount).add(pointCut).add(fullCutAmount).add(exchangeCutAmount));
                orderDetailVo.setSubOrderAmount(orderDetailVo.getSubTotalAmount().subtract(orderEntity.getFreight()));
                orderDetailVo.setSubPayAmount(orderEntity.getPayAmount());
            }
            this.logger.info("\u8ba2\u5355\u660e\u7ec6:{}", (Object)JsonUtils.toJson((Object)orderListVo, (boolean)false));
            return orderListVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u67e5\u8be2\u8ba2\u5355:{},{},\u51fa\u9519", new Object[]{orderMainNo, orderNo, e});
            return null;
        }
    }

    @Override
    public OrderListVo getOrderDetail(MallOrderMainEntity orderMainEntity) {
        OrderListVo orderListVo = this.orderMainInterface.getOrderMainDetail(orderMainEntity.getCustomerId(), orderMainEntity.getOrderMainNo());
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setOrderMainNo(orderMainEntity.getOrderMainNo());
        List<MallOrderProductEntity> orderProductEntities = this.orderProductInterface.getOrderProductList(orderProductEntity);
        ArrayList<MallOrderProductVo> orderProductVos = new ArrayList<MallOrderProductVo>();
        for (MallOrderProductEntity p : orderProductEntities) {
            MallOrderProductVo orderProductVo = new MallOrderProductVo();
            if (p.getGroupType() == 1) {
                orderProductVo.setItemId(p.getPromotionId());
            } else if (p.getGroupType() == 2) {
                orderProductVo.setItemId(p.getGroupId());
            } else if (p.getGroupType() == 4) {
                orderProductVo.setItemId(p.getProductId());
            } else if (p.getGroupType() == 5) {
                orderProductVo.setItemId(p.getActivityNo());
            }
            orderProductVo.setProductType(p.getGroupType());
            orderProductVo.setFactPrice(p.getUnitPrice());
            orderProductVo.setItemName(p.getProductName());
            orderProductVo.setQuantity(p.getQuantity() - (p.getRefundCount() == null ? 0 : p.getRefundCount()));
            orderProductVo.setTotalPrice(p.getTotalPrice().subtract(p.getRefundAmount() == null ? BigDecimal.ZERO : p.getRefundAmount()).setScale(2, 4));
            orderProductVo.setUnitPrice(p.getOriginalPrice());
            orderProductVo.setOrderProductId(p.getOrderProductNo());
            orderProductVos.add(orderProductVo);
        }
        orderListVo.setOrderProductVos(orderProductVos);
        this.logger.info("\u8ba2\u5355\u660e\u7ec6:{}", (Object)orderListVo.toString());
        return orderListVo;
    }

    @Override
    public BaseJsonVo repurchase(String orderMainNo, String orderNo, int clearStatus, int platformId, String customerId) {
        MallRepurchaseVo mallRepurchaseVo = new MallRepurchaseVo();
        ArrayList<MallOrderItemVo> failList = new ArrayList<MallOrderItemVo>();
        if (clearStatus == 1) {
            BaseJsonVo baseJsonVo = this.shoppingcartInterface.removeCartChecked(platformId, customerId, true, -1, "0");
            this.logger.info("\u6e05\u9664\u7528\u6237:{}\u8d2d\u7269\u8f66\u5546\u54c1{}", (Object)customerId, (Object)baseJsonVo.isSuccess());
        }
        ArrayList<String> orderList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)orderNo)) {
            orderList.add(orderNo);
        } else {
            List<MallOrderEntity> orderEntityList = this.orderInterface.getOrderList(orderMainNo);
            if (CollectionUtils.isEmpty(orderEntityList)) {
                return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u8ba2\u5355\u53f7");
            }
            orderList.addAll(orderEntityList.stream().map(MallOrderEntity::getOrderNo).collect(Collectors.toList()));
        }
        List<MallOrderProductEntity> mallOrderProductEntityList = this.orderMainInterface.getOrderProductList(orderNo);
        StringBuffer sb = new StringBuffer();
        if (mallOrderProductEntityList != null && mallOrderProductEntityList.size() > 0) {
            for (MallOrderProductEntity mallOrderProductEntity : mallOrderProductEntityList) {
                Map<String, List<String>> map;
                String itemId;
                if (!Objects.equals(mallOrderProductEntity.getOrderProductType(), 1)) continue;
                String string = mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_PRODUCT.getValue() ? mallOrderProductEntity.getProductId() : (itemId = mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_PROMOTION.getValue() ? mallOrderProductEntity.getPromotionId() : mallOrderProductEntity.getGroupId());
                BaseJsonVo baseJsonVo = this.shoppingcartInterface.addCart(platformId, customerId, (int)mallOrderProductEntity.getGroupType(), itemId, "", mallOrderProductEntity.getQuantity(), false, "0");
                if (baseJsonVo.isSuccess()) continue;
                MallOrderItemVo mallOrderItemVo = new MallOrderItemVo();
                mallOrderItemVo.setProductName(mallOrderProductEntity.getProductName());
                mallOrderItemVo.setQuantity(mallOrderProductEntity.getQuantity());
                mallOrderItemVo.setItemType(mallOrderProductEntity.getGroupType());
                if (mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_PRODUCT.getValue() || mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_OFF_PRODUCT.getValue()) {
                    mallOrderItemVo.setItemId(mallOrderProductEntity.getProductId());
                    sb.append("\u5546\u54c1:" + mallOrderProductEntity.getProductName() + "\u6dfb\u52a0\u5931\u8d25," + baseJsonVo.getMessage() + ",");
                    map = this.productInterface.getProductPicUrlMap(mallOrderProductEntity.getProductId());
                    mallOrderItemVo.setSmallPicUrl(map.containsKey(ProductPicTypeEnum.PRO_SAMLL.getName()) ? map.get(ProductPicTypeEnum.PRO_SAMLL.getName()).get(0) : "");
                } else if (mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_GROUP.getValue()) {
                    sb.append("\u5546\u54c1:" + mallOrderProductEntity.getProductName() + "\u6dfb\u52a0\u5931\u8d25," + baseJsonVo.getMessage() + ",");
                    mallOrderItemVo.setItemId(mallOrderProductEntity.getGroupId());
                    map = this.groupInterface.getGroupPicUrlMap(mallOrderProductEntity.getGroupId());
                    mallOrderItemVo.setSmallPicUrl(map.containsKey(ProductPicTypeEnum.GRO_SAMLL.getName()) ? map.get(ProductPicTypeEnum.GRO_SAMLL.getName()).get(0) : "");
                } else if (mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
                    sb.append("\u5546\u54c1:" + mallOrderProductEntity.getProductName() + "\u6dfb\u52a0\u5931\u8d25," + baseJsonVo.getMessage() + ",");
                    mallOrderItemVo.setItemId(mallOrderProductEntity.getPromotionId());
                    map = this.promotionInterface.getPromotionPicUrlMap(mallOrderProductEntity.getPromotionId());
                    try {
                        mallOrderItemVo.setSmallPicUrl(map.isEmpty() ? "" : (map.containsKey(ProductPicTypeEnum.PROMO_SAMLL.getName()) ? map.get(ProductPicTypeEnum.PROMO_SAMLL.getName()).get(0) : ""));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                failList.add(mallOrderItemVo);
            }
            mallRepurchaseVo.setFailList(failList);
        }
        if (sb.length() > 0) {
            mallRepurchaseVo.setMessage(sb.substring(0, sb.length() - 1));
        }
        return BaseJsonVo.success((Object)mallRepurchaseVo);
    }

    private List<MallOrderItemVo> getShoppingCarProductList(String customerId, String shoppingType) {
        ArrayList<MallOrderItemVo> result = new ArrayList<MallOrderItemVo>();
        boolean checked = false;
        try {
            BaseJsonVo promotionSR;
            BaseJsonVo groupSR;
            BaseJsonVo<List<MallProductVO>> productSR = this.shoppingcartInterface.buildShoppingcartProducts(customerId, false, shoppingType);
            if (productSR.isSuccess()) {
                for (Object productVO : (List)productSR.getValue()) {
                    MallOrderItemVo mallOrderItemVo = new MallOrderItemVo();
                    mallOrderItemVo.setItemId(((MallProductEntity)productVO).getProId());
                    mallOrderItemVo.setItemType(SalesTypeEnum.SALES_PRODUCT.getValue());
                    mallOrderItemVo.setQuantity(((MallProductVO)productVO).getCount());
                    mallOrderItemVo.setProductName(((MallProductEntity)productVO).getProName());
                    mallOrderItemVo.setSmallPicUrl(((MallProductVO)productVO).getProductPic() != null && ((MallProductVO)productVO).getProductPic().get((Object)ProductPicTypeEnum.PRO_SAMLL) != null ? ((MallProductVO)productVO).getProductPic().get((Object)ProductPicTypeEnum.PRO_SAMLL).get(0) : "");
                    result.add(mallOrderItemVo);
                }
            }
            if ((groupSR = this.shoppingcartInterface.buildShoppingcartGroups(customerId, checked, shoppingType)).isSuccess()) {
                for (MallGroupVO groupVO : (List)groupSR.getValue()) {
                    MallOrderItemVo mallOrderItemVo = new MallOrderItemVo();
                    mallOrderItemVo.setItemId(groupVO.getGroupId());
                    mallOrderItemVo.setItemType(SalesTypeEnum.SALES_GROUP.getValue());
                    mallOrderItemVo.setQuantity(groupVO.getCount());
                    mallOrderItemVo.setProductName(groupVO.getGroupName());
                    mallOrderItemVo.setSmallPicUrl(groupVO.getGroupPic() != null && groupVO.getGroupPic().get((Object)ProductPicTypeEnum.GRO_SAMLL) != null ? groupVO.getGroupPic().get((Object)ProductPicTypeEnum.GRO_SAMLL).get(0) : "");
                    result.add(mallOrderItemVo);
                }
            }
            if ((promotionSR = this.shoppingcartInterface.buildShoppingcartPromotions(customerId, checked, shoppingType)).isSuccess() && promotionSR.getValue() != null) {
                for (MallPromotionVO promotionVO : (List)promotionSR.getValue()) {
                    MallOrderItemVo mallOrderItemVo = new MallOrderItemVo();
                    mallOrderItemVo.setItemId(promotionVO.getPromotionId());
                    mallOrderItemVo.setItemType(SalesTypeEnum.SALES_PROMOTION.getValue());
                    mallOrderItemVo.setQuantity(promotionVO.getCount());
                    mallOrderItemVo.setProductName(promotionVO.getPromotionName());
                    mallOrderItemVo.setSmallPicUrl(promotionVO.getPromotionPic() != null && promotionVO.getPromotionPic().get((Object)ProductPicTypeEnum.PROMO_SAMLL) != null ? promotionVO.getPromotionPic().get((Object)ProductPicTypeEnum.PROMO_SAMLL).get(0) : "");
                    result.add(mallOrderItemVo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void batchCancelOrder() {
        this.logger.info("*************\u8fdb\u5165\u6279\u91cf\u53d6\u6d88\u8ba2\u5355\u65b9\u6cd5*****batchCancelOrder************");
        int sendMessageSecond = 300;
        int second = 600;
        int size = 50;
        String sendMessageTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)(-sendMessageSecond), (String)"yyyy-MM-dd HH:mm:ss");
        String cancelTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)(-second), (String)"yyyy-MM-dd HH:mm:ss");
        List<CancelOrderVo> cancelOrderVos = this.orderMainInterface.getBacthCancelMainOrderList(sendMessageTime, size);
        String memcacheKey = "lechun_sendmessage_cancelorder_";
        for (CancelOrderVo c : cancelOrderVos) {
            int balanceTime = second / 60 - sendMessageSecond / 60;
            this.logger.info("*************\u8fdb\u5165\u6279\u91cf\u53d6\u6d88\u8ba2\u5355\u65b9\u6cd5********batchCancelOrder*********CreateTime={},cancelTime={}", (Object)DateUtils.formatDate((Date)c.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (Object)cancelTime);
            this.logger.info("****************DateUtils.getDateDiffSecond(DateUtils.formatDate(c.getCreateTime(),\"yyyy-MM-dd HH:mm:ss\"),cancelTime)>=0**********res={}", (Object)(DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)c.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)cancelTime) >= 0L ? 1 : 0));
            if (DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)c.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)cancelTime) >= 0L) {
                BaseJsonVo baseJsonVo = this.cancelCustomerOrder(c.getCustomerId(), c.getOrderMainNo(), 2);
                MallOrderRecordEntity orderRecordEntity = new MallOrderRecordEntity();
                orderRecordEntity.setOrderMainNo(c.getOrderMainNo());
                orderRecordEntity.setCancelCount(c.getIsExists() + 1);
                if (c.getIsExists() == 0) {
                    this.orderRecordInterface.insert(orderRecordEntity);
                    continue;
                }
                orderRecordEntity.setRecordId(c.getRecordId());
                this.orderRecordInterface.update(orderRecordEntity);
                continue;
            }
            if (this.memcachedService.get("", memcacheKey + c.getOrderMainNo()) != null) continue;
            CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(c.getCustomerId(), c.getPlatformId());
            if (customerDetailVo != null && customerDetailVo.getOpenId() != null && !customerDetailVo.getOpenId().isEmpty()) {
                this.memcachedService.set("", memcacheKey + c.getOrderMainNo(), (Object)c);
                continue;
            }
            WeiXinKeywordEntity keywordEntity = this.keywordInterface.getKeywordByKeyword("ordertopaymessage", c.getPlatformId());
            if (keywordEntity == null) {
                this.memcachedService.set("", memcacheKey + c.getOrderMainNo(), (Object)c);
                return;
            }
            String content = keywordEntity.getTitle();
            content = MessageFormat.format(content.replace("'", "''"), customerDetailVo.getNickName(), balanceTime);
            this.messageInterface.sendCustomerTextMessage(customerDetailVo.getOpenId(), c.getPlatformId(), content, 0);
            this.memcachedService.set("", memcacheKey + c.getOrderMainNo(), (Object)c);
        }
    }

    @Override
    public BaseJsonVo deleteCustomerOrder(String customerId, String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.defineFiledHandleInterface.deleteOrderBefore(customerId, orderMainNo);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (customerId == null || customerId.isEmpty()) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!customerId.equals(orderMainEntity.getCustomerId())) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0e\u8ba2\u5355\u4e0d\u4e00\u81f4");
        }
        if (orderMainEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue()) {
            return BaseJsonVo.error((String)"\u8be5\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
        }
        if (!this.orderMainInterface.deleteOrderMain(orderMainNo, customerId)) {
            return BaseJsonVo.error((String)"\u5220\u9664\u8ba2\u5355\u5931\u8d25");
        }
        this.defineFiledHandleInterface.deleteOrderAfter(customerId, orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo confirmGoods(String customerId, String orderMainNo, String orderNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.defineFiledHandleInterface.confirmGoodsBefore(customerId, orderMainNo, orderNo);
        if (orderMainEntity == null || !orderMainEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        ArrayList sqlUpdate = new ArrayList();
        List<MallOrderEntity> orderList = this.orderInterface.getOrderList(orderMainNo);
        if (orderList == null || orderList.size() == 0) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        boolean isAllComplete = true;
        boolean success = false;
        try {
            for (MallOrderEntity order : orderList) {
                int statusSubClass = this.orderInterface.getStatusClass(order.getStatus(), order.getEvaluateStatus(), orderMainEntity.getOrderClass());
                if (StringUtils.isNotEmpty((String)orderNo)) {
                    if (orderNo.equals(order.getOrderNo()) && statusSubClass == 3) {
                        success = this.orderInterface.updateOrderStatus(orderNo, OrderStatusEnum.COMPLETION.getName(), customerId, order.getStatus());
                        if (!success) {
                            throw new RuntimeException("\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
                        }
                        statusSubClass = 4;
                    }
                } else if (statusSubClass == 3) {
                    success = this.orderInterface.updateOrderStatus(order.getOrderNo(), OrderStatusEnum.COMPLETION.getName(), customerId, order.getStatus());
                    if (!success) {
                        throw new RuntimeException("\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
                    }
                    statusSubClass = 4;
                }
                if (statusSubClass != 0 && statusSubClass != 1 && statusSubClass != 2 && statusSubClass != 3) continue;
                isAllComplete = false;
            }
            if (isAllComplete && !(success = this.orderMainInterface.updateOrderMainStatus(orderMainNo, OrderStatusEnum.COMPLETION.getName(), customerId, orderMainEntity.getStatus()))) {
                throw new RuntimeException("\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
            }
            this.defineFiledHandleInterface.confirmGoodsAfter(orderMainEntity, orderNo);
            this.mallMiniShopInterface.orderRecieve(orderMainNo);
            return BaseJsonVo.success((Object)"\u786e\u8ba4\u6536\u8d27\u6210\u529f");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.logger.error("user:" + customerId + ",\u4e3b\u8ba2\u5355\uff1a" + orderMainNo + ",\u5b50\u8ba2\u5355\uff1a" + orderNo + ",\u5f02\u5e38\uff1a" + e.getMessage());
            return BaseJsonVo.error((String)"\u786e\u8ba4\u6536\u8d27\u5931\u8d25");
        }
    }

    public int getTransportType(List<MallOrderCacheInItemVo> itemVoList) {
        int type = 0;
        boolean normatTransport = false;
        if (itemVoList == null || itemVoList.size() == 0) {
            this.logger.error("\u8f93\u5165\u5546\u54c1\u96c6\u5408\u4e3a\u4e3a\u7a7a");
            return type;
        }
        block16: for (MallOrderCacheInItemVo vo : itemVoList) {
            if (vo.getItemType() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                type = this.getType(vo.getItemId());
                switch (type) {
                    case 1: {
                        continue block16;
                    }
                    case 2: {
                        normatTransport = true;
                        continue block16;
                    }
                }
                continue;
            }
            if (vo.getItemType() == SalesTypeEnum.SALES_GROUP.getValue()) {
                List<MallProductEntity> list = this.productInterface.getProductListByGroupId(vo.getItemId());
                type = this.getType(list);
                switch (type) {
                    case 1: {
                        continue block16;
                    }
                    case 2: {
                        normatTransport = true;
                        break;
                    }
                }
                continue;
            }
            if (vo.getItemType() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
                MallPromotionProductEntity mallPromotionProductEntity = this.mallPromotionProductInterface.getPromotionProductEntity(vo.getItemId());
                this.logger.info("\u4fc3\u9500\u7ed1\u5b9a\u5957\u88c5\u7c7b\u578b:{}", (Object)Integer.valueOf(mallPromotionProductEntity.getProductType()));
                if (mallPromotionProductEntity != null) {
                    if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(mallPromotionProductEntity.getProductType()).intValue()) {
                        List<MallProductEntity> list = this.productInterface.getProductListByGroupId(mallPromotionProductEntity.getProductId());
                        type = this.getType(list);
                        switch (type) {
                            case 1: {
                                continue block16;
                            }
                            case 2: {
                                normatTransport = true;
                                break;
                            }
                        }
                        continue;
                    }
                    if (SalesTypeEnum.SALES_PRODUCT.getValue() != Integer.valueOf(mallPromotionProductEntity.getProductType()).intValue()) continue;
                    type = this.getType(mallPromotionProductEntity.getProductId());
                    switch (type) {
                        case 1: {
                            continue block16;
                        }
                        case 2: {
                            normatTransport = true;
                            break;
                        }
                    }
                    continue;
                }
                this.logger.error("\u4fc3\u9500id\u4e0d\u5b58\u5728,promotionId=" + vo.getItemId());
                throw new RuntimeException("\u4fc3\u9500\u4e0d\u5b58\u5728");
            }
            this.logger.error("\u65e0\u6548\u7684\u7c7b\u578b, ItemType=" + vo.getItemType());
            throw new RuntimeException("\u65e0\u6548\u7684\u7c7b\u578b");
        }
        if (normatTransport && type == 3) {
            type = 2;
        }
        return type;
    }

    private int getType(String productId) {
        int type = 0;
        Integer transportType = this.productInterface.getProduct(productId).getTransportType();
        if (transportType != null) {
            if (TransportTypeEnum.COLD_CHAIN.getValue() == transportType.intValue()) {
                type = 1;
            } else if (TransportTypeEnum.NORMAL_CHAIN.getValue() == transportType.intValue()) {
                type = 2;
            } else if (TransportTypeEnum.ONLINE_SEND.getValue() == transportType.intValue()) {
                type = 3;
            }
        }
        return type;
    }

    private int getType(List<MallProductEntity> list) {
        int type = 0;
        boolean normatTransport = false;
        for (MallProductEntity item : list) {
            this.logger.info("\u904d\u5386\u5957\u88c5\u4ea7\u54c1:{}", (Object)item.getProId());
            type = this.getType(item.getProId());
            this.logger.info("\u904d\u5386\u5957\u88c5\u4ea7\u54c1,type={}", (Object)type);
            switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    normatTransport = true;
                    break;
                }
            }
        }
        if (normatTransport && type == 3) {
            type = 2;
        }
        this.logger.info("\u8fd4\u56de\u503c,type={}", (Object)type);
        return type;
    }

    @Override
    public BaseJsonVo deletePrepayCardOrder(String orderMainNo) throws Exception {
        if (StringUtil.isEmpty((String)orderMainNo)) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e3a\u7a7a\uff0c\u65e0\u9700\u4fee\u6539\u8ba2\u5355");
        }
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5220\u9664\u8ba2\u5355");
        }
        if (orderMainEntity.getStatus() != 3) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u5904\u7406\u4e2d\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainNo);
        if (orderEntities == null || orderEntities.size() == 0) {
            return BaseJsonVo.error((String)"\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539\u8be5\u8ba2\u5355");
        }
        if (orderEntities.stream().filter(c -> c.getPickupTime() == null).count() > 0L) {
            return BaseJsonVo.error((String)"\u5b50\u8ba2\u5355\u53d1\u8d27\u65e5\u671f\u4e3a\u7a7a");
        }
        long count = orderEntities.stream().filter(c -> c.getPickupTime().before(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1))).count();
        if (count > 0L) {
            return BaseJsonVo.error((String)"\u53d1\u8d27\u65e5\u671f\u5df2\u5230\uff0c\u4e0d\u80fd\u4fee\u6539\u8ba2\u5355");
        }
        for (MallOrderEntity order : orderEntities) {
            BaseJsonVo baseJsonVo = this.orderSyncInfoInterface.toDetailOrderStatus(orderMainNo, order.getOrderNo(), cc.lechun.framework.common.enums.trade.OrderStatusEnum.DELETE);
            this.logger.info("\u540c\u6b65oms \u8ba2\u5355\u53f7:{} ,{}", (Object)order.getOrderNo(), (Object)baseJsonVo.isSuccess());
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            boolean success = this.orderInterface.deleteOrder(order.getOrderNo(), orderMainEntity.getCustomerId());
            this.logger.info("\u5220\u9664\u5b50\u8ba2\u5355:{} ,{}", (Object)order.getOrderNo(), (Object)success);
            if (success) continue;
            return BaseJsonVo.error((String)"\u5220\u9664\u5b50\u8ba2\u5355\u5931\u8d25");
        }
        boolean success = this.orderMainInterface.deleteOrderMain(orderMainNo, orderMainEntity.getCustomerId());
        if (!success) {
            return BaseJsonVo.error((String)"\u5220\u9664\u4e3b\u8ba2\u5355\u5931\u8d25");
        }
        BaseJsonVo baseJsonVo = this.inventoryInterface.unLockProductInventory(orderMainNo, orderMainEntity.getPlatformId());
        if (!baseJsonVo.isSuccess()) {
            throw new Exception(baseJsonVo.getMessage());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo setOrderCacheByShoppingcat(String customerId, Integer platFormId, Integer orderSource, String bindCode, Integer deliverType, Integer deliverCount, Integer deliverPeriod, String defineField) {
        if (StringUtils.isEmpty((String)bindCode) && orderSource == null) {
            return BaseJsonVo.error((String)"\u7ed1\u5b9a\u7801\u548c\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u7a7a");
        }
        MallOrderCacheInVo inVo = new MallOrderCacheInVo();
        inVo.setDeliverCount(deliverCount);
        inVo.setDeliverPeriod(deliverPeriod);
        inVo.setDeliverType(deliverType);
        inVo.setOrderSource(orderSource);
        inVo.setBindCode(bindCode);
        inVo.setDefineField(defineField);
        List<MallOrderCacheInItemVo> itemVoList = this.shoppingcartInterface.getCacheInItemVoByShoppingCart(customerId, null, bindCode);
        inVo.setMallOrderCacheInItemVoList(itemVoList);
        return this.tradeInterface.setOrderCache(platFormId, customerId, inVo);
    }

    @Override
    public BaseJsonVo removeCartChecked(Integer platformId, String customerId, Boolean checked, Integer isQuick, String shoppingType) {
        return this.shoppingcartInterface.removeCartChecked(platformId, customerId, checked, isQuick, shoppingType);
    }

    @Override
    public BaseJsonVo buyCardRefundLastOrder(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        List<MallOrderEntity> orderList = this.orderInterface.getOrderList(orderMainEntity.getSourceOrderNo());
        Date deliverDate = null;
        String addrId = null;
        for (MallOrderEntity order : orderList) {
            if (StringUtils.isNotEmpty((String)order.getAddrId())) {
                addrId = order.getAddrId();
            }
            if (order.getDeliverDate() == null) continue;
            deliverDate = order.getDeliverDate();
        }
        BaseJsonVo result = this.csmsRefundInvoke.refundDirect(orderMainEntity.getSourceOrderNo(), "WechatBuyCardRefundLastOrder");
        if (!result.isSuccess()) {
            return result;
        }
        List<MallOrderGroupProductEntity> products = this.orderGroupProductInterface.getOrderGroupProductListByMianOrderNo(orderMainEntity.getSourceOrderNo());
        this.shoppingcartInterface.removeCartChecked(orderMainEntity.getPlatformId(), orderMainEntity.getCustomerId(), true, 0, orderMainEntity.getBindCode());
        for (MallOrderGroupProductEntity product : products) {
            BaseJsonVo baseJsonVo = this.shoppingcartInterface.addCart(orderMainEntity.getPlatformId(), orderMainEntity.getCustomerId(), SalesTypeEnum.SALES_PRODUCT.getValue(), product.getProductId(), null, product.getQuantity(), false, orderMainEntity.getBindCode());
            if (baseJsonVo.isSuccess()) continue;
            return baseJsonVo;
        }
        BaseJsonVo jsonVo = this.tradeInterface.setOrderCacheByShoppingcat(orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId(), OrderSourceEnum.RECHANGE_CARD.getValue(), orderMainEntity.getBindCode(), 1, 1, 1, "");
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        String cacheId = ((MallOrderCacheVo)jsonVo.getValue()).getCacheId();
        MallOrderCacheVo orderCacheVo = new MallOrderCacheVo();
        orderCacheVo.setCacheType(2);
        orderCacheVo.setOrderSource(OrderSourceEnum.RECHANGE_CARD.getValue());
        orderCacheVo.setCacheId(cacheId);
        orderCacheVo.setBindCode(orderMainEntity.getBindCode());
        orderCacheVo.setAddressId(addrId);
        if (deliverDate != null) {
            orderCacheVo.setDeliverDate(deliverDate);
        }
        orderCacheVo.setUseAccountBalance(1);
        orderCacheVo.setPayType(12);
        orderCacheVo.setIsQuick(-1);
        orderCacheVo.setSpeedUp(0);
        orderCacheVo.setDeliveryType(0);
        orderCacheVo.setNoticeType(0);
        orderCacheVo.setScene(1001);
        orderCacheVo.setMildCardPay(1);
        BaseJsonVo createOrderResult = null;
        try {
            createOrderResult = this.tradeInterface.createOrder(orderMainEntity.getPlatformId(), orderMainEntity.getCustomerId(), orderCacheVo);
        }
        catch (InvalidKeySpecException e) {
            this.logger.error("[{}]\u5b9e\u7269\u5355\u4e0b\u5355\u540e\uff0c\u8d2d\u4e70\u63a8\u8350\u5976\u5361\uff0c\u539f\u5b9e\u7269\u5355\u5168\u989d\u9000\u6b3e\uff0c\u4e0b\u5355\u5f02\u5e38", (Object)orderMainNo, (Object)e);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("[{}]\u5b9e\u7269\u5355\u4e0b\u5355\u540e\uff0c\u8d2d\u4e70\u63a8\u8350\u5976\u5361\uff0c\u539f\u5b9e\u7269\u5355\u5168\u989d\u9000\u6b3e\uff0c\u4e0b\u5355\u5f02\u5e38", (Object)orderMainNo, (Object)e);
        }
        if (!createOrderResult.isSuccess()) {
            return createOrderResult;
        }
        Map newOrderMain = (Map)createOrderResult.getValue();
        String newOrderMainNo = newOrderMain.get("mainOrderNo").toString();
        PayOutputEntity payOutputEntity = this.payOrderInterface.topay(orderMainEntity.getCustomerId(), newOrderMainNo, "127.0.0.1");
        if (payOutputEntity == null) {
            this.logger.error("[{}]\u5b9e\u7269\u5355\u4e0b\u5355\u540e\uff0c\u8d2d\u4e70\u63a8\u8350\u5976\u5361\uff0c\u539f\u5b9e\u7269\u5355\u5168\u989d\u9000\u6b3e\uff0c\u65b0\u8ba2\u5355\u652f\u4ed8\u5931\u8d25", (Object)orderMainNo);
        }
        PrepayCardRecommendEntity param = new PrepayCardRecommendEntity();
        param.setOrderMainNo(orderMainEntity.getSourceOrderNo());
        List list = this.prepayCardRecommendInterface.getList(param);
        list.forEach(entity -> {
            entity.setSucc(1);
            this.prepayCardRecommendInterface.updateByPrimaryKeySelective(entity);
        });
        MallOrderMainEntity sourceOrderMainEntity = new MallOrderMainEntity();
        sourceOrderMainEntity.setOrderMainNo(orderMainEntity.getSourceOrderNo());
        sourceOrderMainEntity.setIsshow(Short.valueOf("0"));
        boolean b = this.orderMainInterface.updateOrderMain(sourceOrderMainEntity);
        return b ? BaseJsonVo.success((String)"", null) : BaseJsonVo.error((String)"\u9690\u85cf\u539f\u8ba2\u5355\u5931\u8d25");
    }

    @Override
    public BaseJsonVo recommendCards(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        List<MallOrderEntity> orderList = this.orderInterface.getOrderList(orderMainNo);
        MallMainOrderVo mainOrderVo = new MallMainOrderVo();
        ArrayList<MallOrderVo> orderVos = new ArrayList<MallOrderVo>();
        orderList.forEach(order -> {
            MallOrderVo orderVo = new MallOrderVo();
            orderVo.setOrderAmount(order.getOrderAmount());
            List<MallOrderGroupProductEntity> products = this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(order.getOrderNo());
            int transportType = this.mallProductInterface.getTransportType(products);
            orderVo.setTransportType(transportType);
            ArrayList<MallProductVO> productVOS = new ArrayList<MallProductVO>();
            products.forEach(product -> {
                MallProductVO productVO = new MallProductVO();
                productVO.setProId(product.getProductId());
                productVO.setProName(product.getProductName());
                productVO.setFactPrice(product.getUnitPrice());
                productVO.setCount(product.getQuantity());
                productVOS.add(productVO);
            });
            orderVo.setProducts(productVOS);
            orderVos.add(orderVo);
        });
        mainOrderVo.setMallOrderVos(orderVos);
        this.prepayCardBatchInterface.cacPoint(mainOrderVo);
        this.logger.info("\u8ba2\u5355[{}]\u63a8\u8350\u5361\u70b9\u6570:{}", (Object)orderMainNo, (Object)mainOrderVo.getUseCardPointPrice());
        List<PrepayCardBatchEntity> cardList = this.prepayCardBatchInterface.getPrepayCardBatchEntityList(mainOrderVo.getUseCardPointPrice(), 2);
        if (cardList == null || cardList.size() == 0) {
            return BaseJsonVo.success((String)"\u4e0d\u7b26\u5408\u5976\u5361\u63a8\u8350", null);
        }
        PrepayCardBatchEntity batchEntity = cardList.get(0);
        PrepayCardRecommendEntity recommend = new PrepayCardRecommendEntity();
        recommend.setOrderMainNo(orderMainNo);
        recommend.setCardBatchId(batchEntity.getBatchId());
        recommend.setCardPromotionId(batchEntity.getCardPromotionId());
        recommend.setCustomerId(orderMainEntity.getCustomerId());
        recommend.setCreateTime(new Date());
        recommend.setSucc(0);
        this.prepayCardRecommendInterface.insert(recommend);
        this.logger.info("\u8ba2\u5355[{}]\u63a8\u8350\u6210\u529f:{}", (Object)orderMainNo, (Object)JsonUtils.toJson((Object)recommend, (boolean)false));
        return BaseJsonVo.success(null);
    }
}

