/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.GiftInterface;
import cc.lechun.active.service.sales.ActiveSaleContext;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingRuleInterface;
import cc.lechun.mall.iservice.trade.SetCacheCheckInterface;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SetCacheCheckService
extends BaseService
implements SetCacheCheckInterface {
    @Autowired
    private GiftInterface giftInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallShoppingRuleInterface shoppingRuleInterface;
    @Autowired
    private MallFullcutInterface fullcutInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private ActiveSaleContext activeContext;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BaseJsonVo setCacheCheck(int platFormId, String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        ActiveEntity activeEntity;
        int platformGorupId = this.platFormInterface.getPlatFormGroupId(platFormId);
        int quantity = 0;
        BigDecimal amount = BigDecimal.ZERO;
        if (mallOrderCacheInVo.getMallOrderCacheInItemVoList() != null && mallOrderCacheInVo.getMallOrderCacheInItemVoList().size() > 0) {
            for (MallOrderCacheInItemVo vo : mallOrderCacheInVo.getMallOrderCacheInItemVoList()) {
                if (vo.getItemType() == 1) {
                    BaseJsonVo baseJsonVo = this.promotionInterface.buildPromotionVO(vo.getItemId(), vo.getQuantity(), true);
                    if (!baseJsonVo.isSuccess()) {
                        return BaseJsonVo.error((String)baseJsonVo.getError_msg());
                    }
                    MallPromotionVO promotionVO = (MallPromotionVO)baseJsonVo.getValue();
                    if (promotionVO.getPlatformGroupId() != platformGorupId) {
                        return BaseJsonVo.error((String)"\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38Group\u4e0d\u4e00\u81f4");
                    }
                    if (promotionVO.getGroup() != null) {
                        if (promotionVO.getGroup().getPlatformGroupId() != platformGorupId) {
                            return BaseJsonVo.error((String)"\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38Group\u4e0d\u4e00\u81f4");
                        }
                        quantity += promotionVO.getGroup().getProductList().stream().mapToInt(c -> c.getCount()).sum();
                    }
                    if (promotionVO.getProduct() != null) {
                        if (promotionVO.getProduct().getPlatformGroupId() != platformGorupId) {
                            return BaseJsonVo.error((String)"\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38Group\u4e0d\u4e00\u81f4");
                        }
                        quantity += promotionVO.getProduct().getCount().intValue();
                    }
                    amount = amount.add(PriceUtils.multiply((BigDecimal)promotionVO.getFactPrice(), (Integer)promotionVO.getCount()));
                    if (!promotionVO.getValid().booleanValue()) {
                        return BaseJsonVo.error((String)promotionVO.getInvalidReason());
                    }
                } else if (vo.getItemType() == 4) {
                    BaseJsonVo<MallProductVO> baseJsonVo = this.productInterface.buildProductVO(vo.getItemId(), vo.getQuantity(), false, true);
                    if (!baseJsonVo.isSuccess()) {
                        this.logger.error("\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38(ProductVo)2:{}", (Object)JsonUtils.toJson(baseJsonVo, (boolean)false));
                        return BaseJsonVo.error((String)("\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38(ProductVo)" + baseJsonVo.getError_msg()));
                    }
                    MallProductVO productVO = (MallProductVO)baseJsonVo.getValue();
                    if (productVO.getPlatformGroupId() != platformGorupId) {
                        return BaseJsonVo.error((String)"\u83b7\u53d6\u5355\u54c1\u5f02\u5e38Group\u4e0d\u4e00\u81f4");
                    }
                    quantity += productVO.getCount().intValue();
                    amount = mallOrderCacheInVo.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue() ? amount.add(PriceUtils.multiply((BigDecimal)new BigDecimal(productVO.getProPrice()), (Integer)productVO.getCount())) : amount.add(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()));
                    if (!productVO.getValid().booleanValue()) {
                        this.logger.error("\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38(ProductVo)1:{}", (Object)JsonUtils.toJson((Object)productVO, (boolean)false));
                        return BaseJsonVo.error((String)("\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38(ProductVo)" + productVO.getInvalidReason()));
                    }
                } else if (vo.getItemType() == 2) {
                    BaseJsonVo<MallGroupVO> baseJsonVo = this.groupInterface.buildGroupVO(vo.getItemId(), vo.getQuantity(), true);
                    if (!baseJsonVo.isSuccess()) {
                        return BaseJsonVo.error((String)("\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38(GroupVo)" + baseJsonVo.getError_msg()));
                    }
                    MallGroupVO groupVO = (MallGroupVO)baseJsonVo.getValue();
                    if (groupVO.getPlatformGroupId() != platformGorupId) {
                        return BaseJsonVo.error((String)"\u83b7\u53d6\u5957\u88c5\u5f02\u5e38Group\u4e0d\u4e00\u81f4");
                    }
                    if (groupVO.getProductList().stream().filter(c -> c.getPlatformGroupId() != platformGorupId).count() != 0L) {
                        return BaseJsonVo.error((String)"\u83b7\u53d6\u5957\u88c5\u5f02\u5e38Group\u4e0d\u4e00\u81f4");
                    }
                    quantity += groupVO.getProductList().stream().mapToInt(c -> c.getCount()).sum();
                    amount = amount.add(PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)groupVO.getCount()));
                    if (!groupVO.getValid().booleanValue()) {
                        return BaseJsonVo.error((String)("\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38(GroupVo)" + groupVO.getInvalidReason()));
                    }
                }
                switch (mallOrderCacheInVo.getOrderSource()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return this.giftInterface.validatePleaseYoghourt(vo.getItemId(), vo.getItemType(), vo.getQuantity());
                    }
                    case 2: {
                        if (mallOrderCacheInVo.getDeliverType() != 2 && mallOrderCacheInVo.getDeliverType() != 3 && mallOrderCacheInVo.getDeliverType() != 4 && mallOrderCacheInVo.getDeliverType() != 5) {
                            return BaseJsonVo.error((String)"\u957f\u671f\u8ba2\u8d2d\u7c7b\u578b\u4e0d\u6b63\u786e");
                        }
                        if (mallOrderCacheInVo.getDeliverType() != 5) break;
                        if (mallOrderCacheInVo.getDeliverCount() < 1 || mallOrderCacheInVo.getDeliverCount() > 99) {
                            return BaseJsonVo.error((String)"\u957f\u671f\u8ba2\u8d2d\u6b21\u6570\u4e0d\u6b63\u786e");
                        }
                        if (mallOrderCacheInVo.getDeliverPeriod() >= 0 && mallOrderCacheInVo.getDeliverPeriod() <= 30) break;
                        return BaseJsonVo.error((String)"\u957f\u671f\u8ba2\u8d2d\u671f\u95f4\u4e0d\u6b63\u786e");
                    }
                    case 3: {
                        if (vo.getItemType() == SalesTypeEnum.SALES_PROMOTION.getValue()) break;
                        return BaseJsonVo.error((String)"\u9500\u552e\u7c7b\u578b\u4e0d\u6b63\u786e");
                    }
                    case 7: {
                        return this.fullcutInterface.getEnableFullcut(mallOrderCacheInVo.getBindCode());
                    }
                }
            }
        }
        if (StringUtils.isNotEmpty((String)mallOrderCacheInVo.getBindCode()) && (activeEntity = this.activeInterface.getActiveEntityByQrcode(mallOrderCacheInVo.getBindCode())) != null) {
            return this.activeContext.checkCanJoin(activeEntity.getActiveType(), customerId, mallOrderCacheInVo);
        }
        return BaseJsonVo.success((Object)"");
    }
}

