/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.cache;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallOrderPayMapper;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MallOrderPayCacheService
extends BaseService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private MallOrderPayMapper mallOrderPayMapper;

    public List<MallOrderPayEntity> getList(String orderMainNo) {
        MallOrderPayEntity orderPayEntity = new MallOrderPayEntity();
        orderPayEntity.setOrderMainNo(orderMainNo);
        return this.mallOrderPayMapper.getList(orderPayEntity);
    }

    public MallOrderPayEntity getSingleOrderPayByTradeNo(String tradeNo) {
        MallOrderPayEntity orderPayEntity = new MallOrderPayEntity();
        orderPayEntity.setTradeNo(tradeNo);
        List lst = this.mallOrderPayMapper.getList(orderPayEntity);
        if (lst != null && lst.size() > 0) {
            return (MallOrderPayEntity)lst.get(0);
        }
        return null;
    }

    public MallOrderPayEntity getSingleOrderPayByTradeNo(String tradeNo, String orderMainNo) {
        List lst;
        MallOrderPayEntity orderPayEntity = new MallOrderPayEntity();
        orderPayEntity.setTradeNo(tradeNo);
        if (StringUtils.isNotEmpty((String)orderMainNo)) {
            orderPayEntity.setOrderMainNo(orderMainNo);
        }
        if ((lst = this.mallOrderPayMapper.getList(orderPayEntity)) != null && lst.size() > 0) {
            return (MallOrderPayEntity)lst.get(0);
        }
        return null;
    }

    public MallOrderPayEntity getSingleOrderPayByThirdTradeNo(String thirdTradeNo, Date date) {
        List<MallOrderPayEntity> lst = this.mallOrderPayMapper.getOrderPayInfoByThirdTradeNo(thirdTradeNo, date);
        if (lst != null && lst.size() > 0) {
            return lst.get(0);
        }
        return null;
    }
}

