/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallRecommendCardVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="45_card")
public class CardHandle
implements OrderHandleInterface {
    private static final Logger logger = LoggerFactory.getLogger(CardHandle.class);
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private MallGroupInterface groupService;
    @Autowired
    private MallProductInterface productService;
    @Value(value="${lechun.environment}")
    private String environment;
    @Autowired
    @Lazy
    private PrepayCardItemInterface prepayCardItemInterface;
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mainOrderVo) {
        boolean sourcOrderFlag;
        this.sumCardCut(mainOrderVo);
        boolean bl = sourcOrderFlag = OrderSourceEnum.NEW_USER_CUT.getValue() != mainOrderVo.getOrderCacheVo().getOrderSource() && OrderSourceEnum.COMMUNITY_GROUP.getValue() != mainOrderVo.getOrderCacheVo().getOrderSource() && OrderSourceEnum.RECHANGE_CARD.getValue() != mainOrderVo.getOrderCacheVo().getOrderSource() && OrderSourceEnum.FULLCUT.getValue() != mainOrderVo.getOrderCacheVo().getOrderSource() && mainOrderVo.getMallOrderVos().size() <= 1 && OrderSourceEnum.LONGPERIOD_BUY.getValue() != mainOrderVo.getOrderCacheVo().getOrderSource();
        if (sourcOrderFlag) {
            this.priceCalcInterface.totalOrderPrice(mainOrderVo.getMallOrderVos(), mainOrderVo);
            for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
                int cardType = orderVo.getTransportType() == 1 ? 1 : 0;
                if (cardType <= 0) continue;
                BigDecimal couponAmount = orderVo.getCouponAmount();
                BigDecimal[] factPriceSum = new BigDecimal[]{orderVo.getOrderAmount()};
                logger.info("\u5546\u54c1\u91d1\u989d:{},\u4f18\u60e0\u5238\u91d1\u989d:{},\u4f59\u989d:{}", new Object[]{factPriceSum[0], couponAmount, orderVo.getBalanceAmount()});
                if (factPriceSum[0].compareTo(PriceUtils.add((BigDecimal)couponAmount, (BigDecimal)orderVo.getBalanceAmount())) <= 0) continue;
                this.prepayCardBatchInterface.cacPoint(mainOrderVo);
                logger.info("\u4f18\u60e0\u5238\u62b5\u6263\u91d1\u989d:{},\u4f7f\u7528\u5361\u652f\u4ed8\u7684\u91d1\u989d:{}", (Object)couponAmount, (Object)orderVo.getCanUseCardPrice());
                BigDecimal[] useCardPointPrice = new BigDecimal[]{orderVo.getUseCardPointPrice()};
                BigDecimal[] canUseCardPrice = new BigDecimal[]{orderVo.getCanUseCardPrice()};
                logger.info("\u5546\u54c1\u70b9\u6570:{},\u53ef\u7528\u70b9\u6570\u652f\u4ed8\u5546\u54c1\u91d1\u989d:{}", (Object)useCardPointPrice[0], (Object)canUseCardPrice[0]);
                if (useCardPointPrice[0].compareTo(BigDecimal.ZERO) <= 0) continue;
                List<PrepayCardBatchEntity> cardList = this.prepayCardBatchInterface.getPrepayCardBatchEntityList(useCardPointPrice[0], cardType + 1);
                if (CollectionUtils.isNotEmpty(cardList)) {
                    BaseJsonVo<MallPromotionVO> promotionVOBaseJsonVo = this.promotionService.buildPromotionVO(cardList);
                    if (promotionVOBaseJsonVo.isSuccess() && ((MallPromotionVO)promotionVOBaseJsonVo.getValue()).getValid().booleanValue()) {
                        PrepayCardBatchEntity prepayCardBatchEntity = cardList.stream().filter(card -> Objects.equals(((MallPromotionVO)promotionVOBaseJsonVo.getValue()).getBatchId(), card.getBatchId())).findFirst().get();
                        logger.info("\u5339\u914d\u5230\u7684\u63a8\u8350\u5976\u5361:{}", (Object)JsonUtils.toJson((Object)prepayCardBatchEntity, (boolean)false));
                        BigDecimal rate = prepayCardBatchEntity.getRate() == null ? PriceUtils.divide((BigDecimal)prepayCardBatchEntity.getSaleValue(), (BigDecimal)prepayCardBatchEntity.getCardPrice(), (int)2, (Integer)1) : prepayCardBatchEntity.getRate();
                        BigDecimal cardPointAmount = PriceUtils.divide((BigDecimal)useCardPointPrice[0], (BigDecimal)rate);
                        logger.info("\u4e0d\u7528\u5976\u5361\u5b9e\u4ed8\u91d1\u989d:{},\u5546\u54c1\u70b9\u6570:{},\u4f7f\u7528\u5976\u5361\u652f\u4ed8\u91d1\u989d:{}", new Object[]{canUseCardPrice[0], useCardPointPrice[0], cardPointAmount});
                        if (canUseCardPrice[0].compareTo(cardPointAmount) > 0) {
                            if (CollectionUtils.isNotEmpty(mainOrderVo.getOrderCacheVo().getCardList()) && !Objects.equals(mainOrderVo.getOrderCacheVo().getCardList().get(0).getBatchId(), prepayCardBatchEntity.getBatchId())) {
                                return BaseJsonVo.error((String)"\u9009\u62e9\u7684\u5361\u6709\u8bef");
                            }
                            logger.info("\u8ba2\u5355\u91d1\u989d:{},\u53ef\u4ee5\u4f7f\u7528\u70b9\u5361\u91d1\u989d:{}, \u4f7f\u7528\u5361\u4f18\u60e0\u91d1\u989d:{},\u4f18\u60e0\u5238\u91d1\u989d:{},\u53ef\u7528\u4f59\u989d:{}", new Object[]{factPriceSum[0], cardPointAmount, orderVo.getUseCardCutAmount(), couponAmount, orderVo.getBalanceAmount()});
                            orderVo.setUseCardCutAmount(PriceUtils.subtract((BigDecimal)canUseCardPrice[0], (BigDecimal)cardPointAmount));
                            if (cardPointAmount.compareTo(PriceUtils.subtract((BigDecimal)factPriceSum[0], (BigDecimal)couponAmount)) > 0) {
                                canUseCardPrice[0] = PriceUtils.subtract((BigDecimal)factPriceSum[0], (BigDecimal)couponAmount);
                                cardPointAmount = PriceUtils.subtract((BigDecimal)canUseCardPrice[0], (BigDecimal)orderVo.getUseCardCutAmount());
                                logger.info("\u91cd\u65b0\u8ba1\u7b97canUseCardPrice[0]:{},cardPointAmount={}", (Object)canUseCardPrice[0], (Object)cardPointAmount);
                                orderVo.setUseCardPointPrice(PriceUtils.multiply((BigDecimal)cardPointAmount, (BigDecimal)rate));
                                logger.info("\u91cd\u65b0\u8ba1\u7b97\u53ef\u7528\u91d1\u989d:{},\u8ba2\u5355\u62b5\u6263\u70b9\u6570:{},\u5361\u62b5\u6263\u91d1\u989d:{}", new Object[]{canUseCardPrice[0], orderVo.getUseCardPointPrice(), cardPointAmount});
                            } else if (couponAmount.compareTo(BigDecimal.ZERO) > 0 && canUseCardPrice[0].compareTo(factPriceSum[0]) >= 0) {
                                canUseCardPrice[0] = PriceUtils.subtract((BigDecimal)factPriceSum[0], (BigDecimal)couponAmount);
                                cardPointAmount = PriceUtils.subtract((BigDecimal)canUseCardPrice[0], (BigDecimal)orderVo.getUseCardCutAmount());
                                logger.info("\u91cd\u65b0\u8ba1\u7b97 canUseCardPrice[0]:{},cardPointAmount={}", (Object)canUseCardPrice[0], (Object)cardPointAmount);
                                orderVo.setUseCardPointPrice(PriceUtils.multiply((BigDecimal)cardPointAmount, (BigDecimal)rate));
                                logger.info("\u91cd\u65b0\u8ba1\u7b97\u53ef\u7528\u91d1\u989d2:{},\u8ba2\u5355\u62b5\u6263\u70b9\u6570:{},\u5361\u62b5\u6263\u91d1\u989d:{}", new Object[]{canUseCardPrice[0], orderVo.getUseCardPointPrice(), cardPointAmount});
                            }
                            logger.info("\u8ba2\u5355\u91d1\u989d:{},\u4f7f\u7528\u5361\u4f18\u60e0\u91d1\u989d:{},\u4f18\u60e0\u5238\u91d1\u989d:{},\u91cd\u65b0\u8ba1\u7b97\u540e\u7684\u53ef\u7528\u70b9\u91d1\u989d:{}", new Object[]{factPriceSum[0], orderVo.getUseCardCutAmount(), couponAmount, cardPointAmount});
                            if (cardPointAmount.compareTo(BigDecimal.ZERO) > 0) {
                                this.prepayCardBatchInterface.buildMallRecommendCardVO(orderVo, prepayCardBatchEntity, (MallPromotionVO)promotionVOBaseJsonVo.getValue(), canUseCardPrice[0], cardPointAmount);
                                logger.info(" \u63a8\u8350\u5361\u6279\u6b21:{},\u62b5\u6263\u91d1\u989d:{}", (Object)prepayCardBatchEntity.getBatchId(), (Object)cardPointAmount);
                                if (CollectionUtils.isNotEmpty(mainOrderVo.getOrderCacheVo().getCardList())) {
                                    logger.info(" \u9009\u62e9\u5361:{}", (Object)mainOrderVo.getOrderCacheVo().getCardList().get(0).getBatchId());
                                    if (Objects.equals(mainOrderVo.getOrderCacheVo().getCardList().get(0).getBatchId(), orderVo.getRecommendCardVOList().get(0).getBatchId())) {
                                        orderVo.getRecommendCardVOList().get(0).setSelect(1);
                                        logger.info("\u5e78\u798f\u5361:{}\u9009\u4e2d", (Object)JsonUtils.toJson((Object)orderVo.getRecommendCardVOList().get(0), (boolean)false));
                                    }
                                }
                                mainOrderVo.setRecommendCardVOList(new ArrayList<MallRecommendCardVO>());
                                mainOrderVo.getRecommendCardVOList().addAll(orderVo.getRecommendCardVOList());
                            }
                            logger.info("\u63a8\u8350\u5e78\u798f\u5361:{},", orderVo.getRecommendCardVOList());
                            continue;
                        }
                        logger.info(" \u4f7f\u7528\u5976\u5361\u652f\u4ed8\u65e0\u4f18\u60e0\u4e0d\u63a8\u8350\u5976\u5361,\u4e0d\u4f7f\u7528\u5361\u652f\u4ed8\u91d1\u989d:{},\u4f7f\u7528\u5361\u652f\u4ed8\u62b5\u6263\u91d1\u989d:{}", (Object)canUseCardPrice[0], (Object)cardPointAmount);
                        continue;
                    }
                    logger.info("\u53ef\u62b5\u6263\u70b9\u6570:{}\u672a\u5339\u914d\u5230\u53ef\u7528\u4fc3\u9500", (Object)useCardPointPrice[0]);
                    continue;
                }
                if (mainOrderVo.getOrderCacheVo().getCardBatchId() == null) continue;
                logger.info("\u62c6\u5206\u540e\u7684\u5b9e\u7269\u914d\u9001\u8ba2\u5355");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private void sumCardCut(MallMainOrderVo mainOrderVo) {
        boolean isNewCard;
        boolean bl = isNewCard = Objects.equals(mainOrderVo.getOrderCacheVo().getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue())) || Objects.equals(mainOrderVo.getOrderCacheVo().getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue()));
        if (isNewCard) {
            BigDecimal cardProductSum;
            BigDecimal cardCutSum;
            mainOrderVo.setCardProductCut(BigDecimal.ZERO);
            for (MallOrderVo mallOrderVo : mainOrderVo.getMallOrderVos()) {
                BigDecimal cardProductCut = BigDecimal.ZERO;
                for (MallProductVO productVO : mallOrderVo.getProducts()) {
                    if (productVO.getCardOriginPrice() == null || productVO.getCardOriginPrice().compareTo(productVO.getCardFactPrice()) <= 0) continue;
                    cardProductCut = PriceUtils.add((BigDecimal)cardProductCut, (BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)productVO.getCardOriginPrice(), (BigDecimal)productVO.getCardFactPrice()), (Integer)productVO.getQuantity()));
                }
                if (CollectionUtils.isNotEmpty(mallOrderVo.getPromotions())) {
                    for (MallPromotionVO promotionVO : mallOrderVo.getPromotions()) {
                        if (promotionVO.getCardOriginPrice() == null || promotionVO.getCardOriginPrice().compareTo(promotionVO.getCardFactPrice()) <= 0) continue;
                        cardProductCut = PriceUtils.add((BigDecimal)cardProductCut, (BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)promotionVO.getCardOriginPrice(), (BigDecimal)promotionVO.getCardFactPrice()), (Integer)promotionVO.getQuantity()));
                    }
                }
                if (cardProductCut.compareTo(BigDecimal.ZERO) > 0) {
                    logger.info("\u7528\u6237:{}\u5b50\u5355\u5361\u5546\u54c1\u4f18\u60e0:{}", (Object)mainOrderVo.getCustomerId(), (Object)cardProductCut);
                    mallOrderVo.setCardProductCut(cardProductCut);
                    mallOrderVo.setUseCardCutSum(PriceUtils.add((BigDecimal)mallOrderVo.getCardProductCut(), (BigDecimal)mallOrderVo.getFreeCut()));
                    logger.info("\u7528\u6237:{}\u5b50\u5355\u4f7f\u7528\u5976\u5361\u7701\u5408\u8ba1:{},\u8d60\u54c1\u7701:{},\u5361\u5546\u54c1\u7701:{}", new Object[]{mainOrderVo.getCustomerId(), mallOrderVo.getUseCardCutSum(), mallOrderVo.getFreeCut(), mallOrderVo.getCardProductCut(), mallOrderVo.getUseCardCutSum()});
                    continue;
                }
                mallOrderVo.setCardProductCut(BigDecimal.ZERO);
            }
            BigDecimal freeCutSum = BigDecimal.ZERO;
            if (mainOrderVo.getMallOrderVos().stream().anyMatch(item -> item.getFreeCut() != null)) {
                freeCutSum = mainOrderVo.getMallOrderVos().stream().filter(item -> item.getFreeCut() != null).map(MallOrderVo::getFreeCut).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if ((cardCutSum = PriceUtils.add((BigDecimal)freeCutSum, (BigDecimal)(cardProductSum = mainOrderVo.getMallOrderVos().stream().map(MallOrderVo::getCardProductCut).reduce(BigDecimal.ZERO, BigDecimal::add)))).compareTo(BigDecimal.ZERO) > 0) {
                mainOrderVo.setUseCardCutSum(cardCutSum);
                mainOrderVo.setFreeCut(freeCutSum);
                mainOrderVo.setCardProductCut(cardProductSum);
                logger.info("\u7528\u6237:{}\u5361\u8ba2\u5355\u4f18\u60e0 ,\u8d60\u54c1\u4f18\u60e0:{},\u5546\u54c1\u4f18\u60e0:{},\u4f18\u60e0\u5408\u8ba1:{}", new Object[]{mainOrderVo.getCustomerId(), freeCutSum, cardProductSum, mainOrderVo.getUseCardCutSum()});
            }
        }
    }
}

