/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="10_check")
public class CheckHandle
implements OrderHandleInterface {
    private static final Logger logger = LoggerFactory.getLogger(CheckHandle.class);
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private PlatFormInterface platFormInterface;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        PlatFormEntity platFormEntity;
        for (MallOrderVo c : mallMainOrderVo.getMallOrderVos()) {
            if (CollectionUtils.isNotEmpty(c.getProducts())) {
                for (MallProductVO mallProductVO : c.getProducts()) {
                    if (mallProductVO.getValid().booleanValue()) continue;
                    return BaseJsonVo.error((String)mallProductVO.getInvalidReason());
                }
            }
            if (CollectionUtils.isNotEmpty(c.getGroups())) {
                for (MallGroupVO mallGroupVO : c.getGroups()) {
                    if (mallGroupVO.getValid().booleanValue()) continue;
                    return BaseJsonVo.error((String)mallGroupVO.getInvalidReason());
                }
            }
            if (!CollectionUtils.isNotEmpty(c.getPromotions())) continue;
            for (MallPromotionVO mallPromotionVO : c.getPromotions()) {
                if (mallPromotionVO.getValid().booleanValue()) continue;
                return BaseJsonVo.error((String)mallPromotionVO.getInvalidReason());
            }
        }
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
            BigDecimal[] cardFactPrice = new BigDecimal[]{BigDecimal.ZERO};
            for (MallShoppingcartVO mallShoppingcartVO : mallMainOrderVo.getMallOrderVos()) {
                if (mallShoppingcartVO == null) continue;
                for (MallProductVO mallProductVO : mallShoppingcartVO.getProducts()) {
                    cardFactPrice[0] = PriceUtils.add((BigDecimal)cardFactPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)mallProductVO.getCardFactPrice(), (Integer)mallProductVO.getCount()));
                }
                for (MallPromotionVO mallPromotionVO : mallShoppingcartVO.getPromotions()) {
                    cardFactPrice[0] = PriceUtils.add((BigDecimal)cardFactPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)mallPromotionVO.getCardFactPrice(), (Integer)mallPromotionVO.getCount()));
                }
            }
            logger.info("\u7528\u6237:{}\u5361\u7ed3\u7b97\u5b9e\u9645\u70b9\u6570:{}", (Object)mallMainOrderVo.getCustomerId(), (Object)cardFactPrice[0]);
            if (StringUtils.isNotEmpty((String)mallMainOrderVo.getOrderCacheVo().getBindCode())) {
                if (mallMainOrderVo.getOrderCacheVo().getBindCode().length() > 3) {
                    if (cardFactPrice[0].compareTo(new BigDecimal("990")) < 0) {
                        return BaseJsonVo.error((String)"\u6ee1990\u70b9\u8d77\u9001");
                    }
                } else if (Objects.equals(mallMainOrderVo.getOrderCacheVo().getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue()))) {
                    if (cardFactPrice[0].compareTo(new BigDecimal("99")) < 0) {
                        return BaseJsonVo.error((String)"\u6ee199\u8d77\u9001");
                    }
                } else if (Objects.equals(mallMainOrderVo.getOrderCacheVo().getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue())) && cardFactPrice[0].compareTo(new BigDecimal("59")) < 0) {
                    return BaseJsonVo.error((String)"\u6ee159\u8d77\u9001");
                }
            }
        }
        if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 1 && (platFormEntity = this.platFormInterface.getPlatForm(mallMainOrderVo.getPlatFormId())) != null) {
            mallMainOrderVo.setTipMessage(this.dictionaryInterface.getValidDictionaryList(platFormEntity.getPlatformGroupId(), 20));
        }
        return BaseJsonVo.success((Object)"");
    }
}

