/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.cashticket.CashComposeUseEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CanUseCashticketVo;
import cc.lechun.mall.entity.cashticket.SelectCashVo;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.service.cashticket.CashticketCustomerService;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="30_coupon")
public class CouponHandle
implements OrderHandleInterface {
    @Autowired
    private CashticketCustomerService cashticketCustomerService;
    @Autowired
    private PlatFormService platFormService;
    @Autowired
    private DictionaryInterface dictionaryService;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        Integer useStatus;
        if (this.isInvalidOrderSource(mallMainOrderVo.getOrderCacheVo().getOrderSource())) {
            this.setNotUseCoupon(mallMainOrderVo);
            return BaseJsonVo.success((Object)"");
        }
        if (CollectionUtils.isNotEmpty(mallMainOrderVo.getOrderCacheVo().getCardList()) && Objects.equals(useStatus = this.dictionaryService.getDictionaryToInteger(1000, 223, "useCoupon"), 0)) {
            this.setNotUseCoupon(mallMainOrderVo);
            return BaseJsonVo.success((Object)"");
        }
        this.logger.info("MMMMMMMMMMM:{}", (Object)JsonUtils.toJson(mallMainOrderVo.getOrderCacheVo().getSelectCashList(), (boolean)false));
        if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2) {
            if (mallMainOrderVo.getOrderCacheVo().getSelectCashList().size() > 2) {
                return BaseJsonVo.error((String)"\u4f18\u60e0\u5238\u4f7f\u7528\u5f20\u6570\u6709\u8bef!");
            }
            if (mallMainOrderVo.getOrderCacheVo().getTicketCustomerId() > 0 && mallMainOrderVo.getOrderCacheVo().getSelectCashList().size() == 0) {
                mallMainOrderVo.getOrderCacheVo().getSelectCashList().add(mallMainOrderVo.getOrderCacheVo().getTicketCustomerId());
            }
            if (mallMainOrderVo.getOrderCacheVo().getSelectCashList().size() == 0) {
                mallMainOrderVo.setUseCoupon(false);
                mallMainOrderVo.setCouponAmount(BigDecimal.ZERO);
                return BaseJsonVo.success((Object)"");
            }
        }
        if (mallMainOrderVo.getOrderCacheVo().getChoseNoTicket().booleanValue()) {
            mallMainOrderVo.getOrderCacheVo().setSelectCashList(new ArrayList<Integer>());
        }
        PlatFormAndGroupVo platFormAndGroupVo = this.platFormService.getPlatFormAndGroup(mallMainOrderVo.getPlatFormId());
        CanUseCashticketVo canUseCashticketVo = this.cashticketCustomerService.getEnabledCashticketList(mallMainOrderVo.getOrderCacheVo().getCacheType(), platFormAndGroupVo.getPlatformGroupId(), mallMainOrderVo.getOrderCacheVo().getSelectCashList(), mallMainOrderVo.getCustomerId(), mallMainOrderVo.getMallOrderVos());
        if (mallMainOrderVo.getOrderCacheVo().getChoseNoTicket().booleanValue()) {
            canUseCashticketVo.setSelectCashVo(new SelectCashVo());
        }
        if (mallMainOrderVo.getOrderCacheVo().getCacheType() != 2) {
            mallMainOrderVo.setUnUseList(canUseCashticketVo.getUnUseList());
        }
        this.logger.info("mallMainOrderVo.getOrderCacheVo()={},canUseCashticketVo={}", (Object)JsonUtils.toJson(mallMainOrderVo.getOrderCacheVo().getSelectCashList(), (boolean)false), (Object)canUseCashticketVo.toString());
        if (CollectionUtils.isNotEmpty(canUseCashticketVo.getList())) {
            mallMainOrderVo.setCashticketVos(canUseCashticketVo.getList());
            if (mallMainOrderVo.getOrderCacheVo().getSelectCashList().size() > 1) {
                if (canUseCashticketVo.getList().stream().filter(cash -> cash.getComposeUse().intValue() == CashComposeUseEnum.available.getValue() && mallMainOrderVo.getOrderCacheVo().getSelectCashList().stream().filter(select -> select.intValue() == cash.getTicketCustomerId().intValue()).findAny().isPresent()).collect(Collectors.toList()).size() > 1) {
                    return BaseJsonVo.error((String)(CashComposeUseEnum.available.getName() + "\u5238\u4e00\u4e2a\u8ba2\u5355\u53ea\u80fd\u4f7f\u7528\u4e00\u5f20"));
                }
                if (canUseCashticketVo.getList().stream().filter(cash -> cash.getComposeUse().intValue() == CashComposeUseEnum.unavailable.getValue() && mallMainOrderVo.getOrderCacheVo().getSelectCashList().stream().filter(select -> select.intValue() == cash.getTicketCustomerId().intValue()).findAny().isPresent()).collect(Collectors.toList()).size() > 1) {
                    return BaseJsonVo.error((String)(CashComposeUseEnum.unavailable.getName() + "\u5238\u4e00\u4e2a\u8ba2\u5355\u53ea\u80fd\u4f7f\u7528\u4e00\u5f20"));
                }
                mallMainOrderVo.setUseCoupon(true);
                mallMainOrderVo.setCouponAmount(canUseCashticketVo.getSelectCashVo().getCashAmout());
            }
            BigDecimal orderCouponAmount = PriceUtils.format((BigDecimal)mallMainOrderVo.getMallOrderVos().stream().map(MallOrderVo::getCouponAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            SelectCashVo selectCashVo = canUseCashticketVo.getSelectCashVo();
            mallMainOrderVo.setSelectCashVo(selectCashVo);
            if (selectCashVo.getSelectCashList().size() > 0) {
                mallMainOrderVo.setCouponAmount(selectCashVo.getCashAmout());
                mallMainOrderVo.setUseCoupon(true);
                mallMainOrderVo.getOrderCacheVo().setSelectCashList(selectCashVo.getSelectCashList());
                mallMainOrderVo.setSelectCashVo(selectCashVo);
            } else {
                mallMainOrderVo.setCouponAmount(BigDecimal.ZERO);
                mallMainOrderVo.setUseCoupon(false);
            }
            if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2 && orderCouponAmount.compareTo(mallMainOrderVo.getCouponAmount()) != 0) {
                return BaseJsonVo.error((String)("\u4f18\u60e0\u5238\u91d1\u989d\u4e0d\u4e00\u81f4\uff1aMain(" + mallMainOrderVo.getCouponAmount() + "),order(" + orderCouponAmount + ")"));
            }
        } else {
            mallMainOrderVo.setUseCoupon(false);
            mallMainOrderVo.setCouponAmount(BigDecimal.ZERO);
            mallMainOrderVo.setCashticketVos(canUseCashticketVo.getList());
            if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2 && mallMainOrderVo.getOrderCacheVo().getSelectCashList().size() > 0) {
                return BaseJsonVo.error((String)"\u9009\u62e9\u7684\u4f18\u60e0\u5238\u4e0d\u53ef\u7528");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private boolean isInvalidOrderSource(int orderSource) {
        return orderSource == OrderSourceEnum.NEW_USER_CUT.getValue() || orderSource == OrderSourceEnum.RECHANGE_CARD.getValue() || orderSource == OrderSourceEnum.CARDPLAN.getValue() || orderSource == OrderSourceEnum.COMMUNITY_GROUP.getValue() || orderSource == OrderSourceEnum.COLLAGE.getValue();
    }

    private void setNotUseCoupon(MallMainOrderVo mallMainOrderVo) {
        mallMainOrderVo.setUseCoupon(false);
        mallMainOrderVo.setCouponAmount(BigDecimal.ZERO);
        mallMainOrderVo.getOrderCacheVo().setSelectCashList(new ArrayList<Integer>());
        mallMainOrderVo.setSelectCashVo(null);
    }
}

