/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallExchangeProductVO;
import cc.lechun.mall.entity.sales.MallExchangeVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInFreeVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.service.sales.MallPromotionService;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="32_exchange")
public class ExchangeHandle
implements OrderHandleInterface {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeHandle.class);
    @Autowired
    private MallFreeInterface freeService;
    @Autowired
    @Lazy
    private MallPromotionService mallPromotionService;
    @Autowired
    @Lazy
    MallProductInterface productService;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CART.getValue()) {
            BigDecimal factPriceSum = mallMainOrderVo.getMallOrderVos().stream().map(MallShoppingcartVO::getFactPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BaseJsonVo<List<MallExchangeVO>> exchangeResult = this.freeService.buildExchangeProductList(mallMainOrderVo.getMallOrderVos(), mallMainOrderVo.getMallOrderVos().get(0).getPlatFormGroupId(), factPriceSum);
            if (exchangeResult.isSuccess()) {
                MallOrderVo mallOrderVo = mallMainOrderVo.getMallOrderVos().get(0);
                List<MallOrderCacheInFreeVo> exchangeVoList = mallMainOrderVo.getOrderCacheVo().getExchangeVoList();
                if (CollectionUtils.isNotEmpty(exchangeVoList)) {
                    logger.info("\u9009\u62e9\u7684\u6362\u8d2d\u5546\u54c1:{}", (Object)JsonUtils.toJson(exchangeVoList, (boolean)false));
                    for (MallOrderCacheInFreeVo orderCacheInFreeVo : exchangeVoList) {
                        Optional<MallExchangeVO> exchangeVOOptional = ((List)exchangeResult.getValue()).stream().filter(mallExchangeVO -> Objects.equals(orderCacheInFreeVo.getFreeId(), mallExchangeVO.getFreeId())).findFirst();
                        if (!exchangeVOOptional.isPresent()) {
                            throw new RuntimeException("\u6362\u8d2d\u5546\u54c1\u6570\u91cf\u8d85\u51fa\u6700\u5927\u9650\u5236");
                        }
                        Optional<MallExchangeProductVO> exchangeProductVOOptional = exchangeVOOptional.get().getProductList().stream().filter(exchangeProductVO -> Objects.equals(exchangeProductVO.getProductType(), orderCacheInFreeVo.getItemType()) && Objects.equals(exchangeProductVO.getProId(), orderCacheInFreeVo.getItemId())).findFirst();
                        if (!exchangeProductVOOptional.isPresent()) {
                            throw new RuntimeException("\u6362\u8d2d\u5546\u54c1\u6570\u91cf\u8d85\u51fa\u6700\u5927\u9650\u5236");
                        }
                        if (orderCacheInFreeVo.getQuantity() <= exchangeProductVOOptional.get().getAddMaxCount()) {
                            exchangeProductVOOptional.get().setQuantity(orderCacheInFreeVo.getQuantity());
                            logger.info("\u8bbe\u7f6e\u6362\u8d2d\u5546\u54c1:{}\u9009\u4e2d\u6570\u91cf{}", (Object)exchangeProductVOOptional.get().getProName(), (Object)exchangeProductVOOptional.get().getQuantity());
                            continue;
                        }
                        throw new RuntimeException("\u6362\u8d2d\u5546\u54c1\u6570\u91cf\u8d85\u51fa\u6700\u5927\u9650\u5236");
                    }
                }
                mallOrderVo.setEnableExchanges((List)exchangeResult.getValue());
                this.collectionExchanges(mallMainOrderVo);
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private void collectionExchanges(MallMainOrderVo mallMainOrderVo) {
        for (MallOrderVo orderVo : mallMainOrderVo.getMallOrderVos()) {
            if (orderVo.getEnableExchanges() == null) continue;
            orderVo.getEnableExchanges().forEach(vo -> {
                if (vo != null) {
                    vo.getProductList().forEach(proVO -> {
                        if (proVO.getQuantity() > 0) {
                            if (Objects.equals(proVO.getProductType(), SalesTypeEnum.SALES_PRODUCT.getValue())) {
                                this.collectionProduct((MallExchangeProductVO)proVO, orderVo.getProductsPool());
                            } else if (Objects.equals(proVO.getProductType(), SalesTypeEnum.SALES_PROMOTION.getValue())) {
                                this.collectionPromotion((MallExchangeProductVO)proVO, orderVo.getProductsPool());
                            }
                            logger.info("\u6362\u8d2d:{}\u5546\u54c1\u6c47\u603b\u5b8c\u6210", (Object)vo.getFreeId());
                        }
                    });
                }
            });
        }
    }

    private void collectionPromotion(MallExchangeProductVO productVO, List<MallProductVO> productPool) {
        BaseJsonVo<MallPromotionVO> sr = this.mallPromotionService.buildPromotionVO(productVO.getProId(), productVO.getQuantity(), true);
        if (sr.isSuccess()) {
            MallPromotionVO vo = (MallPromotionVO)sr.getValue();
            if (((MallPromotionVO)sr.getValue()).getValid().booleanValue()) {
                if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(vo.getProductType()).intValue()) {
                    if (vo.getProduct() != null) {
                        vo.getProduct().setValid(vo.getValid());
                        vo.getProduct().setPromotionName(vo.getPromotionName());
                        vo.getProduct().setPromotionId(vo.getPromotionId());
                        productPool.add(vo.getProduct());
                    }
                } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(vo.getProductType()).intValue() && vo.getGroup() != null) {
                    for (MallProductVO proVO : vo.getGroup().getProductList()) {
                        proVO.setValid(vo.getValid());
                        proVO.setPromotionId(vo.getPromotionId());
                        proVO.setPromotionName(vo.getPromotionName());
                        productPool.add(proVO);
                    }
                }
                logger.info("\u6c47\u603b\u6362\u8d2d:{},\u4fc3\u9500:{},\u5b8c\u6210", (Object)productVO.getFreeId(), (Object)productVO.getProId());
            } else {
                logger.info("\u4fc3\u9500:{}\u4e0d\u53ef\u7528:{}", (Object)((MallPromotionVO)sr.getValue()).getPromotionName(), (Object)((MallPromotionVO)sr.getValue()).getInvalidReason());
            }
        }
    }

    private void collectionProduct(MallExchangeProductVO productVO, List<MallProductVO> productPool) {
        BaseJsonVo<MallProductVO> sr = this.productService.buildProductVO(productVO.getProId(), productVO.getQuantity(), true, true);
        if (sr.isSuccess()) {
            productPool.add((MallProductVO)sr.getValue());
            logger.info("\u6c47\u603b\u6362\u8d2d:{},\u5355\u54c1:{},\u5b8c\u6210", (Object)productVO.getFreeId(), (Object)productVO.getProId());
        } else {
            logger.info("\u6c47\u603b\u6362\u8d2d:{},\u5355\u54c1:{},\u5b8c\u6210", (Object)productVO.getFreeId(), (Object)productVO.getProId());
        }
    }
}

