/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="34_freeGift")
public class FreeGiftHandle
implements OrderHandleInterface {
    private static final Logger logger = LoggerFactory.getLogger(FreeGiftHandle.class);
    @Autowired
    private MallFreeInterface freeInterface;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        this.freeInterface.buildFreeVOFromCart(mallMainOrderVo);
        for (MallOrderVo mallOrderVo : mallMainOrderVo.getMallOrderVos()) {
            if (!CollectionUtils.isNotEmpty(mallOrderVo.getFrees())) continue;
            BigDecimal freeProductCut = BigDecimal.ZERO;
            for (MallFreeVO freeVO : mallOrderVo.getFrees()) {
                if (freeVO == null) continue;
                for (MallProductVO productVO : freeVO.getProductList()) {
                    mallOrderVo.getProductsPool().add(productVO);
                    boolean isNewCard = Objects.equals(mallMainOrderVo.getOrderCacheVo().getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue())) || Objects.equals(mallMainOrderVo.getOrderCacheVo().getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue()));
                    if (!isNewCard) continue;
                    productVO.setCardOriginPrice(productVO.getOriginPrice());
                    logger.info("\u7528\u6237:{}\u8d60\u54c1:{} \u539f\u4ef7\u683c:{}", new Object[]{mallOrderVo.getCustomerId(), productVO.getProName(), PriceUtils.multiply((BigDecimal)productVO.getCardOriginPrice(), (Integer)productVO.getQuantity())});
                    freeProductCut = PriceUtils.add((BigDecimal)freeProductCut, (BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getCardOriginPrice(), (Integer)productVO.getQuantity()));
                }
            }
            mallOrderVo.setFreeCut(freeProductCut);
        }
        return BaseJsonVo.success((Object)"");
    }
}

