/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.deliver.DeliverFreightVo;
import cc.lechun.mall.entity.deliver.MallFreightCalVo;
import cc.lechun.mall.entity.sales.MallExchangeProductVO;
import cc.lechun.mall.entity.sales.MallExchangeVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.deliver.DeliverFreightInterface;
import cc.lechun.mall.iservice.deliver.MallFreightInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="39_freight")
public class FreightHandle
implements OrderHandleInterface {
    private static final Logger logger = LoggerFactory.getLogger(FreightHandle.class);
    @Autowired
    private DeliverFreightInterface freightInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private MallFreightInterface mallFreightService;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        if (this.tradeCommonInterface.isNoDeliverOrder(mallMainOrderVo) || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.COMMUNITY_GROUP.getValue()) {
            return BaseJsonVo.success((Object)"");
        }
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
            mallMainOrderVo.setFreight(mallMainOrderVo.getOrderCacheVo().getFreight());
            return BaseJsonVo.success((Object)"");
        }
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARDPLAN.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_JD_POP.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_CHANNEL.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_JD_SELF_RUN.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_CHANNEL.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_STRATEGY.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_SHOP.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
            return BaseJsonVo.success((Object)"");
        }
        String[] err = new String[]{""};
        int cityId = mallMainOrderVo.getAddressVo() != null ? mallMainOrderVo.getAddressVo().getCityId() : 0;
        int platFormId = mallMainOrderVo.getPlatFormId();
        BigDecimal[] mainOrderAmount = new BigDecimal[]{mallMainOrderVo.getMallOrderVos().stream().map(MallOrderVo::getOrderAmount).reduce(BigDecimal::add).get()};
        mallMainOrderVo.getMallOrderVos().forEach(c -> {
            DeliverFreightVo deliverFreightVo = new DeliverFreightVo();
            deliverFreightVo.setCityId(cityId);
            if (c.getDeliverVo() != null) {
                deliverFreightVo.setDeliverId(c.getDeliverVo().getDeliverId());
            }
            deliverFreightVo.setPlatFormId(platFormId);
            deliverFreightVo.setAmount(c.getFreightItemPrice());
            if (CollectionUtils.isNotEmpty(mallMainOrderVo.getMallOrderVos().get(0).getEnableExchanges())) {
                for (MallExchangeVO mallExchangeVO : mallMainOrderVo.getMallOrderVos().get(0).getEnableExchanges()) {
                    for (MallExchangeProductVO exchangeProductVO : mallExchangeVO.getProductList()) {
                        logger.info("\u6362\u8d2d\u5546\u54c1:{},\u6570\u91cf:{},\u91d1\u989d:{}", new Object[]{exchangeProductVO.getProName(), exchangeProductVO.getCount(), exchangeProductVO.getFactPrice()});
                        if (exchangeProductVO.getQuantity() <= 0) continue;
                        logger.info("\u914d\u9001\u7c7b\u578b:{},\u6362\u8d2d\u7c7b\u578b:{}", (Object)c.getTransportType(), (Object)exchangeProductVO.getTransportType());
                        if (c.getTransportType() != exchangeProductVO.getTransportType().intValue()) continue;
                        logger.info("\u8fd0\u8d39\u91d1\u989d:{}, \u52a0\u8d2d\u5546\u54c1\u91d1\u989d:{}", (Object)deliverFreightVo.getAmount(), (Object)PriceUtils.multiply((BigDecimal)exchangeProductVO.getFactPrice(), (Integer)exchangeProductVO.getQuantity()));
                        deliverFreightVo.setAmount(PriceUtils.add((BigDecimal)deliverFreightVo.getAmount(), (BigDecimal)PriceUtils.multiply((BigDecimal)exchangeProductVO.getFactPrice(), (Integer)exchangeProductVO.getQuantity())));
                        logger.info("\u8fd0\u8d39\u91d1\u989d:{}", (Object)deliverFreightVo.getAmount());
                    }
                }
            }
            logger.info("\u6240\u6709\u53c2\u4e0e\u8fd0\u8d39\u8ba1\u7b97\u5546\u54c1\u91d1\u989d\u548c:{}", (Object)deliverFreightVo.getAmount());
            deliverFreightVo.setQuantity(c.getProductsPool().stream().mapToInt(d -> d.getCount()).sum());
            deliverFreightVo.setOrderSource(c.getOrderSource());
            BigDecimal freightAmount = BigDecimal.ZERO;
            BigDecimal levelFreightAmount = BigDecimal.ZERO;
            String levelFreightDesc = "";
            if (cityId != 0) {
                ArrayList<MallFreightCalVo> mallFreightCalVoList = new ArrayList<MallFreightCalVo>();
                MallFreightCalVo mallFreightCalVo = new MallFreightCalVo();
                mallFreightCalVo.setCityId(String.valueOf(cityId));
                mallFreightCalVo.setOrderSource(c.getOrderSource());
                if (mallMainOrderVo.getOrderCacheVo().getSpeedUp() == 0) {
                    mallFreightCalVo.setDeliverId(String.valueOf(c.getTransportType()));
                }
                if (mallMainOrderVo.getOrderCacheVo().getSpeedUp() == 1) {
                    mallFreightCalVo.setDeliverId("3");
                }
                if (mallMainOrderVo.getOrderCacheVo().getSpeedUp() == -1) {
                    if (c.getDeliverVo().getSpeedupInventory() == 1) {
                        mallFreightCalVo.setDeliverId("3");
                    } else {
                        mallFreightCalVo.setDeliverId(String.valueOf(c.getTransportType()));
                    }
                }
                mallFreightCalVo.setPlatFormGroupId(c.getPlatFormGroupId());
                BigDecimal couponAmount = BigDecimal.ZERO;
                if (!mallMainOrderVo.getOrderCacheVo().getChoseNoTicket().booleanValue() && mallMainOrderVo.getSelectCashVo() != null && mallMainOrderVo.getSelectCashVo().getCashAmout() != null) {
                    couponAmount = mallMainOrderVo.getSelectCashVo().getCashAmout();
                    if (mallMainOrderVo.getMallOrderVos().size() > 1) {
                        logger.info("\u62c6\u5355\u8ba2\u5355\u8ba1\u7b97\u8fd0\u8d39\uff0c\u603b\u5355orderAmount={}\uff0c\u5f53\u524d\u5355orderAmount={},\u62c6\u5206\u90ae\u8d39\u524dcouponAmount={}", new Object[]{mainOrderAmount[0], c.getOrderAmount(), couponAmount});
                        couponAmount = couponAmount.multiply(c.getOrderAmount()).divide(mainOrderAmount[0], RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                        logger.info("\u62c6\u5355\u8ba2\u5355\u8ba1\u7b97\u8fd0\u8d39\uff0c\u62c6\u5206\u90ae\u8d39\u540ecouponAmount={}", (Object)couponAmount);
                    }
                }
                mallFreightCalVo.setAmount(deliverFreightVo.getAmount().subtract(couponAmount));
                logger.info("NNNNNNNNNNNNNN:{},\u5546\u54c1\u91d1\u989d:{}, \u6709\u8fd0\u8d39\u5546\u54c1\u603b\u91d1\u989d:{}", new Object[]{couponAmount, c.getFactPrice(), mallFreightCalVo.getAmount()});
                if (c.getGroups() != null && c.getGroups().size() > 0) {
                    mallFreightCalVo.setGorupId(StringUtils.join((Object[])c.getGroups().stream().map(g -> g.getGroupId()).toArray(), (String)","));
                }
                if (c.getProducts() != null && c.getProducts().size() > 0) {
                    mallFreightCalVo.setProductId(StringUtils.join((Object[])c.getProducts().stream().map(g -> g.getProId()).toArray(), (String)","));
                }
                if (c.getPromotions() != null && c.getPromotions().size() > 0) {
                    mallFreightCalVo.setPromotionId(StringUtils.join((Object[])c.getPromotions().stream().map(g -> g.getPromotionId()).toArray(), (String)","));
                }
                mallFreightCalVo.setBindCode(c.getBindCode());
                mallFreightCalVoList.add(mallFreightCalVo);
                logger.info("----\u652f\u4ed8\u9875\u9762\u8fd4\u56de\u8fd0\u8d39freightArray={}------", (Object)JsonUtils.toJson(mallFreightCalVoList, (boolean)false));
                JSONArray freightArray = this.mallFreightService.getFreightByCityAmountDeliveryType(mallFreightCalVoList);
                if (freightArray != null && freightArray.size() > 0) {
                    for (JSONObject freightObject : freightArray) {
                        String freightAmountStr = freightObject.getString("freightAmount");
                        freightAmount = freightAmount.add(new BigDecimal(freightAmountStr));
                        levelFreightAmount = levelFreightAmount.add(new BigDecimal(freightObject.getString("levelFreightAmount")));
                        levelFreightDesc = freightObject.getString("levelFreightAmountDesc");
                        logger.info("\u8fd0\u8d39\u6587\u6848:{}", (Object)levelFreightDesc);
                    }
                }
            }
            c.setFreight(freightAmount);
            c.setLevelFreight(levelFreightAmount);
            logger.info("\u8fd0\u8d39\u6587\u6848:{}", (Object)levelFreightDesc);
            c.setLevelFreightDesc(levelFreightDesc);
            logger.info("\u8fd0\u8d39:{}", (Object)freightAmount);
            mallMainOrderVo.setFreight(PriceUtils.add((BigDecimal)mallMainOrderVo.getFreight(), (BigDecimal)freightAmount));
        });
        if (mallMainOrderVo.getFreight().compareTo(BigDecimal.ZERO) > 0) {
            if (mallMainOrderVo.getMallOrderVos().size() > 1) {
                String levelFreightAmountDesc = mallMainOrderVo.getMallOrderVos().stream().map(MallOrderVo::getLevelFreightDesc).reduce("", (a, b) -> a + b);
                mallMainOrderVo.setLevelFreight(levelFreightAmountDesc);
                logger.info("\u7ec4\u5408\u8fd0\u8d39\u6587\u6848:{}", (Object)levelFreightAmountDesc);
            } else {
                String levelFreightAmountDesc = mallMainOrderVo.getMallOrderVos().get(0).getLevelFreightDesc();
                mallMainOrderVo.setLevelFreight(levelFreightAmountDesc);
                logger.info("\u53ea\u6709\u4e00\u79cd\u914d\u9001\u65b9\u5f0f\u65f6\u8fd0\u8d39\u6587\u6848:{}", (Object)levelFreightAmountDesc);
            }
        }
        if (err[0].isEmpty()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)err[0]);
    }
}

