/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.prepay.PrepayCardRecommendDetailEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardRecommendInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="46_orderAmount")
public class OrderAmountPayHandle
implements OrderHandleInterface {
    @Autowired
    private PlatFormService platFormService;
    @Autowired
    private DictionaryInterface dictionaryService;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private PrepayCardRecommendInterface recommendInterface;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        String sourceOrderno = mallMainOrderVo.getOrderCacheVo().getSourceOrderNo();
        this.logger.info("OrderAmountPayHandle:{}", (Object)JsonUtils.toJson((Object)mallMainOrderVo.getOrderCacheVo(), (boolean)false));
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY.getValue() && mallMainOrderVo.getOrderCacheVo().getCardBatchId() != null && StringUtils.isNotEmpty((String)sourceOrderno)) {
            PrepayCardRecommendDetailEntity recommend = this.recommendInterface.getEnableRecommendDetail(sourceOrderno, mallMainOrderVo.getOrderCacheVo().getCardBatchId());
            if (recommend == null) {
                return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u4e0d\u652f\u6301\u62b5\u6263\u6216\u5df2\u7ecf\u62b5\u6263");
            }
            mallMainOrderVo.setSourceOrderAmount(recommend.getOrderAmount());
            mallMainOrderVo.getMallOrderVos().get(0).setSourceOrderAmount(recommend.getOrderAmount());
            if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2) {
                this.recommendInterface.updateRecommendBatchIdByOrderMainNo(sourceOrderno, mallMainOrderVo.getOrderCacheVo().getCardBatchId());
            }
        } else {
            mallMainOrderVo.setSourceOrderAmount(BigDecimal.ZERO);
            this.logger.info("OrderAmountPayHandle:\u4e0d\u652f\u6301\u62b5\u6263");
            return BaseJsonVo.success((Object)"");
        }
        this.priceCalcInterface.totalOrderPrice(mallMainOrderVo.getMallOrderVos(), mallMainOrderVo);
        this.priceCalcInterface.totalMainOrderPrice(mallMainOrderVo);
        this.logger.info("OrderAmountPayHandle:MainOrderVo:{}" + mallMainOrderVo.toString());
        return BaseJsonVo.success((Object)"");
    }
}

