/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="49_balance")
public class balanceHandle
implements OrderHandleInterface {
    @Autowired
    private AccountBalanceInterface balanceInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;
    private static final Logger logger = LoggerFactory.getLogger(balanceHandle.class);

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        BigDecimal[] remainder;
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() != OrderSourceEnum.RECHANGE_CARD.getValue()) {
            boolean noBalanceFlag;
            boolean bl = noBalanceFlag = mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.SPLITE_CARD_ORDER.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == 0 && mallMainOrderVo.getOrderCacheVo().getCardBatchId() != null && StringUtils.isNotEmpty((String)mallMainOrderVo.getOrderCacheVo().getSourceOrderNo());
            if (noBalanceFlag || mallMainOrderVo.getOrderCacheVo().getUseAccountBalance() == 0 || Objects.equals("0", mallMainOrderVo.getUseBalance())) {
                return BaseJsonVo.success((Object)"");
            }
        }
        this.priceCalcInterface.totalOrderPrice(mallMainOrderVo.getMallOrderVos(), mallMainOrderVo);
        this.priceCalcInterface.totalMainOrderPrice(mallMainOrderVo);
        CustomerEntity customerEntity = this.customerInterface.getCustomer(mallMainOrderVo.getCustomerId());
        if (customerEntity == null) {
            if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
                customerEntity = new CustomerEntity();
                customerEntity.setCustomerId(mallMainOrderVo.getCustomerId());
            } else {
                return BaseJsonVo.error((String)("\u7528\u6237\u4e0d\u5b58\u5728customer:" + mallMainOrderVo.getCustomerId()));
            }
        }
        BigDecimal balance = BigDecimal.ZERO;
        BigDecimal useBalanceAmount = BigDecimal.ZERO;
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
            Integer cardType = mallMainOrderVo.getOrderCacheVo().getBindCode().length() > 2 ? PrepayCardTypeEnum.yogurt_card.getValue() : Integer.valueOf(mallMainOrderVo.getOrderCacheVo().getBindCode()).intValue();
            useBalanceAmount = Objects.equals(cardType, PrepayCardTypeEnum.yogurt_card.getValue()) ? PriceUtils.subtract((BigDecimal)mallMainOrderVo.getCardTotalAmount(), (BigDecimal)PriceUtils.multiply((BigDecimal)mallMainOrderVo.getCouponAmount(), (Integer)10)) : mallMainOrderVo.getCardTotalAmount();
            balance = this.balanceInterface.getSpecialTotal(customerEntity.getCustomerId(), cardType);
            logger.info("\u7528\u6237{}\u9700\u8981\u652f\u4ed8\u7684\u70b9\u6570:{} \u7528\u6237\u5e10\u6237\u70b9\u6570:{}", new Object[]{mallMainOrderVo.getCustomerId(), useBalanceAmount, balance});
            mallMainOrderVo.setCardPayAmount(useBalanceAmount);
            mallMainOrderVo.setCardTotalBalanceAmount(balance);
            logger.info("\u7528\u6237{} \u5e10\u6237\u70b9\u6570:{},\u8ba2\u5355\u70b9\u6570:{}", new Object[]{mallMainOrderVo.getCustomerId(), balance, useBalanceAmount});
            if (balance.compareTo(BigDecimal.ZERO) <= 0) {
                return BaseJsonVo.error((String)"\u5e10\u6237\u5361\u70b9\u6570\u4e3a0!");
            }
        } else {
            logger.info("\u8ba2\u5355\u603b\u989d:{},\u4f18\u60e0\u5238\u91d1\u989d:{},\u8ba2\u5355\u62b5\u6263:{}", new Object[]{mallMainOrderVo.getTotalAmount(), mallMainOrderVo.getCouponAmount(), mallMainOrderVo.getSourceOrderAmount()});
            useBalanceAmount = PriceUtils.subtract((BigDecimal)mallMainOrderVo.getTotalAmount(), (BigDecimal)mallMainOrderVo.getCouponAmount());
            useBalanceAmount = PriceUtils.subtract((BigDecimal)useBalanceAmount, (BigDecimal)mallMainOrderVo.getSourceOrderAmount());
            balance = mallMainOrderVo.getOrderCacheVo().getMildCardPay() == 1 ? useBalanceAmount : this.balanceInterface.getGiftBalanceById(customerEntity.getCustomerId());
            logger.info("\u53ef\u7528\u4f59\u989d\u91d1\u989d:{},\u4f59\u989d\u603b\u989d:{}", (Object)useBalanceAmount, (Object)balance);
            mallMainOrderVo.setTotalBalanceAmount(balance);
        }
        if (useBalanceAmount.doubleValue() > balance.doubleValue()) {
            useBalanceAmount = balance;
        }
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
            if (useBalanceAmount.compareTo(BigDecimal.ZERO) > 0) {
                remainder = new BigDecimal[]{new BigDecimal(0)};
                BigDecimal[] finalUseBalanceAmount = new BigDecimal[]{useBalanceAmount};
                BigDecimal mainOrderMoneyAmount = PriceUtils.subtractToSix((BigDecimal)mallMainOrderVo.getCardTotalAmount(), (BigDecimal)PriceUtils.multiply((BigDecimal)mallMainOrderVo.getCouponAmount(), (Integer)10));
                mallMainOrderVo.getMallOrderVos().forEach(c -> {
                    BigDecimal orderMoneyAmount = PriceUtils.subtractToSix((BigDecimal)c.getCardTotalAmount(), (BigDecimal)PriceUtils.multiply((BigDecimal)c.getCouponAmount(), (Integer)10));
                    logger.info("\u4e3b\u8ba2\u5355\u70b9\u6570:{},\u5b50\u5355\u70b9\u6570:{}", (Object)mainOrderMoneyAmount, (Object)orderMoneyAmount);
                    BigDecimal orderDivideMainMoneyAmount = orderMoneyAmount.divide(mainOrderMoneyAmount, 6, 4);
                    BigDecimal subBalanceAmount = PriceUtils.multiply((BigDecimal)orderDivideMainMoneyAmount, (BigDecimal)finalUseBalanceAmount[0]);
                    logger.info("\u5b50\u5355\u70b9\u6570\u5360\u6bd4:{},\u5b50\u5355\u70b9\u6570:{}", (Object)orderDivideMainMoneyAmount, (Object)subBalanceAmount);
                    c.setCardBalanceAmount(subBalanceAmount);
                    remainder[0] = PriceUtils.addNoUp((BigDecimal)remainder[0], (BigDecimal)subBalanceAmount);
                    logger.info("\u5b50\u5355\u70b9\u6570\u5360\u6bd4:{}", (Object)remainder[0]);
                });
                remainder[0] = PriceUtils.subtractToSix((BigDecimal)useBalanceAmount, (BigDecimal)remainder[0]);
                if (remainder[0].doubleValue() != 0.0) {
                    mallMainOrderVo.getMallOrderVos().get(0).setCardBalanceAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getMallOrderVos().get(0).getCardBalanceAmount(), (BigDecimal)remainder[0]));
                }
            }
            mallMainOrderVo.setCardBalanceAmount(useBalanceAmount);
        } else {
            if (useBalanceAmount.doubleValue() > 0.0) {
                remainder = new BigDecimal[]{new BigDecimal(0)};
                BigDecimal[] finalUseBalanceAmount = new BigDecimal[]{useBalanceAmount};
                BigDecimal mianOrderMoneyAmount = PriceUtils.subtractToSix((BigDecimal)mallMainOrderVo.getTotalAmount(), (BigDecimal)mallMainOrderVo.getCouponAmount());
                mallMainOrderVo.getMallOrderVos().forEach(c -> {
                    BigDecimal orderMoneyAmount = PriceUtils.subtractToSix((BigDecimal)c.getTotalAmount(), (BigDecimal)c.getCouponAmount());
                    BigDecimal orderDivideMainMoneyAmount = orderMoneyAmount.divide(mianOrderMoneyAmount, 6, 4);
                    BigDecimal subBalanceAmount = PriceUtils.multiply((BigDecimal)orderDivideMainMoneyAmount, (BigDecimal)finalUseBalanceAmount[0]);
                    c.setBalanceAmount(subBalanceAmount);
                    remainder[0] = PriceUtils.addNoUp((BigDecimal)remainder[0], (BigDecimal)subBalanceAmount);
                });
                remainder[0] = PriceUtils.subtractToSix((BigDecimal)useBalanceAmount, (BigDecimal)remainder[0]);
                if (remainder[0].doubleValue() != 0.0) {
                    mallMainOrderVo.getMallOrderVos().get(0).setBalanceAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getMallOrderVos().get(0).getBalanceAmount(), (BigDecimal)remainder[0]));
                }
            }
            mallMainOrderVo.setBalanceAmount(useBalanceAmount);
        }
        return BaseJsonVo.success((Object)"");
    }
}

