/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.vip;

import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.common.enums.customer.VipRightTypeEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.vip.MallVipConditionMapper;
import cc.lechun.mall.dao.vip.MallVipLogMapper;
import cc.lechun.mall.dao.vip.MallVipMapper;
import cc.lechun.mall.dao.vip.MallVipNoticeTemplateMapper;
import cc.lechun.mall.dao.vip.MallVipQuestionnairePaperMapper;
import cc.lechun.mall.dao.vip.MallVipRewardsMapper;
import cc.lechun.mall.dao.vip.MallVipRewardsRelationMapper;
import cc.lechun.mall.dao.vip.MallVipRightsMapper;
import cc.lechun.mall.dao.vip.MallVipTasksMapper;
import cc.lechun.mall.dao.vip.MallVipTasksRelationMapper;
import cc.lechun.mall.dao.vip.MallVipTasksRewardsMapper;
import cc.lechun.mall.dao.vip.MallVipdaylogMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.vip.MallVipConditionEntity;
import cc.lechun.mall.entity.vip.MallVipEntity;
import cc.lechun.mall.entity.vip.MallVipLogEntity;
import cc.lechun.mall.entity.vip.MallVipNoticeTemplateEntity;
import cc.lechun.mall.entity.vip.MallVipQuestionnairePaperEntity;
import cc.lechun.mall.entity.vip.MallVipRewardsEntity;
import cc.lechun.mall.entity.vip.MallVipRewardsRelationEntity;
import cc.lechun.mall.entity.vip.MallVipRightsEntity;
import cc.lechun.mall.entity.vip.MallVipSetVo;
import cc.lechun.mall.entity.vip.MallVipTasksEntity;
import cc.lechun.mall.entity.vip.MallVipTasksRelationEntity;
import cc.lechun.mall.entity.vip.MallVipTasksRewardsEntity;
import cc.lechun.mall.entity.vip.MallVipVo;
import cc.lechun.mall.entity.vip.MallVipdaylogEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.service.thirdparty.OldApiUtil;
import cc.lechun.mall.service.thirdparty.OldWealthUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallVipService
extends BaseService
implements MallVipInterface {
    @Autowired
    private MallVipMapper vipMapper;
    @Autowired
    private MallVipConditionMapper vipConditionMapper;
    @Autowired
    MallVipTasksMapper tasksMapper;
    @Autowired
    MallVipTasksRelationMapper vipTaskRelationMapper;
    @Autowired
    MallVipTasksRewardsMapper vipTasksRewardsMapper;
    @Autowired
    MallVipRewardsMapper vipRewardsMapper;
    @Autowired
    MallVipRewardsRelationMapper vipRewardsRelationMapper;
    @Autowired
    MallVipRightsMapper vipRightsMapper;
    @Autowired
    MallVipLogMapper vipLogMapper;
    @Autowired
    MallVipQuestionnairePaperMapper vipQuestionnairePaperMapper;
    @Autowired
    MallVipNoticeTemplateMapper vipNoticeTemplateMapper;
    @Autowired
    MallVipdaylogMapper vipdaylogMapper;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MallOrderMainInterface orderMainService;
    @Autowired
    private MallOrderInterface orderService;
    @Autowired
    private OldApiUtil oldApiUtil;
    @Autowired
    private OldWealthUtil oldWealthUtil;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketService;
    @Autowired
    private DictionaryInterface dicService;
    @Autowired
    private ActiveQrcodeInterface qrcodeService;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;

    @Override
    @ReadThroughSingleCache(namespace="VIP")
    public List<MallVipConditionEntity> conditionList(@ParameterValueKeyProvider Integer platformGroupId) {
        MallVipConditionEntity searchParam = new MallVipConditionEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        return this.vipConditionMapper.getList(searchParam);
    }

    @Override
    public PageInfo conditionList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        PageInfo pg = page.toPageInfo();
        pg.setList(this.conditionList(platformGroupId));
        return pg;
    }

    @Override
    public MallVipConditionEntity getCondition(String id) {
        return (MallVipConditionEntity)this.vipConditionMapper.selectByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public BaseJsonVo saveVipCondition(MallVipConditionEntity vipCondition) {
        if (StringUtil.isEmpty((String)vipCondition.getId())) {
            MallVipConditionEntity param = new MallVipConditionEntity();
            param.setLevel(vipCondition.getLevel());
            List conditions = this.vipConditionMapper.getList(param);
            if (conditions != null && conditions.size() > 0) {
                BaseJsonVo sr = BaseJsonVo.success((Object)"");
                sr.setError("\u5b58\u5728\u7684\u7b49\u7ea7");
                return sr;
            }
            this.vipConditionMapper.insert(vipCondition);
        } else {
            this.vipConditionMapper.updateByPrimaryKeySelective(vipCondition);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void deleteVipCondition(String id) {
        this.vipConditionMapper.deleteByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public List<MallVipRewardsEntity> rewardsList(Integer platformGroupId) {
        MallVipRewardsEntity param = new MallVipRewardsEntity();
        param.setPlatformGroupId(platformGroupId);
        List list = this.vipRewardsMapper.getList(param);
        return list;
    }

    @Override
    public PageInfo rewardsList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        PageInfo pg = page.toPageInfo();
        List<MallVipRewardsEntity> list = this.rewardsList(platformGroupId);
        ArrayList listData = new ArrayList();
        list.forEach(reward -> {
            ActiveQrcodeEntity qrcode;
            Map map = ObjectConvert.beanToMap((Object)reward);
            map.put("rewardDataName", reward.getRewardData());
            if ("1".equals(reward.getRewardType()) && (qrcode = this.qrcodeService.getQrcode(reward.getRewardData())) != null) {
                map.put("rewardDataName", qrcode.getQrcodeName());
            }
            listData.add(map);
        });
        pg.setList(listData);
        return pg;
    }

    @Override
    public MallVipRewardsEntity getReward(String id) {
        return (MallVipRewardsEntity)this.vipRewardsMapper.selectByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public BaseJsonVo saveVipRewards(MallVipRewardsEntity vipRewards) {
        if (StringUtil.isEmpty((String)vipRewards.getId())) {
            vipRewards.setId(IDGenerate.getUniqueIdStr());
            this.vipRewardsMapper.insert(vipRewards);
        } else {
            this.vipRewardsMapper.updateByPrimaryKeySelective(vipRewards);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void deleteVipRewards(String id) {
        this.vipRewardsMapper.deleteByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public List<MallVipRightsEntity> rightsList(Integer platformGroupId) {
        List<MallVipRightsEntity> rights = this.vipRightsMapper.getVipRights(platformGroupId);
        return rights;
    }

    @Override
    public PageInfo rightsList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        this.rightsList(platformGroupId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public MallVipRightsEntity getRight(String rightId) {
        return this.vipRightsMapper.getRight(rightId);
    }

    @Override
    public MallVipRightsEntity getRightById(String id) {
        return (MallVipRightsEntity)this.vipRightsMapper.selectByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public BaseJsonVo saveVipRights(MallVipRightsEntity vipRights) {
        if (StringUtil.isEmpty((String)vipRights.getId())) {
            MallVipConditionEntity mallVipConditionEntity = new MallVipConditionEntity();
            List vipConditionEntities = this.vipConditionMapper.getList(mallVipConditionEntity);
            if (vipConditionEntities != null && vipConditionEntities.size() > 0) {
                ArrayList mallVipRightsEntityList = new ArrayList();
                vipRights.setRightId(RandomUtils.generateStrId());
                vipRights.setHasRight("0");
                for (MallVipConditionEntity vipConditionEntity : vipConditionEntities) {
                    vipRights.setId(IDGenerate.getUniqueIdStr());
                    vipRights.setLevel(vipConditionEntity.getLevel());
                    this.vipRightsMapper.insert(vipRights);
                }
            }
        } else {
            this.vipRightsMapper.updateByRightId(vipRights);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateVipRights(MallVipRightsEntity vipRights) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateByIdLevel(MallVipRightsEntity vipRights) {
        this.vipRightsMapper.updateByIdLevel(vipRights);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void deleteVipRights(String rightId) {
        this.vipRightsMapper.deleteByRightId(rightId);
    }

    @Override
    public BaseJsonVo rightsChangeStatus(String id, String hasRight) {
        hasRight = "0".equals(hasRight) ? "1" : "0";
        this.vipRightsMapper.rightsChangeStatus(id, hasRight);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<MallVipTasksEntity> tasksList(Integer platformGroupId) {
        MallVipTasksEntity param = new MallVipTasksEntity();
        param.setPlatformGroupId(platformGroupId);
        List list = this.tasksMapper.getList(param);
        return list;
    }

    @Override
    public PageInfo tasksList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        PageInfo pg = page.toPageInfo();
        pg.setList(this.tasksList(platformGroupId));
        return pg;
    }

    @Override
    public MallVipTasksEntity getTask(String id) {
        return (MallVipTasksEntity)this.tasksMapper.selectByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public BaseJsonVo saveVipTasks(MallVipTasksEntity vipTasks) {
        if (StringUtil.isEmpty((String)vipTasks.getId())) {
            vipTasks.setId(IDGenerate.getUniqueIdStr());
            this.tasksMapper.insert(vipTasks);
        } else {
            this.tasksMapper.updateByPrimaryKeySelective(vipTasks);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void deleteVipTasks(String id) {
        this.tasksMapper.deleteByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public List<MallVipTasksRewardsEntity> tasksRewardsList(Integer platformGroupId) {
        MallVipTasksRewardsEntity param = new MallVipTasksRewardsEntity();
        param.setPlatformGroupId(platformGroupId);
        List list = this.vipTasksRewardsMapper.getList(param);
        return list;
    }

    @Override
    public PageInfo tasksRewardsList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        PageInfo pg = page.toPageInfo();
        List<MallVipTasksRewardsEntity> list = this.tasksRewardsList(platformGroupId);
        ArrayList listData = new ArrayList();
        list.forEach(reward -> {
            ActiveQrcodeEntity qrcode;
            Map map = ObjectConvert.beanToMap((Object)reward);
            map.put("rewardDataName", reward.getRewardData());
            if ("1".equals(reward.getRewardType()) && (qrcode = this.qrcodeService.getQrcode(reward.getRewardData())) != null && qrcode.getActiveQrcodeId() != null && StringUtils.isNotEmpty((String)qrcode.getQrcodeName())) {
                map.put("rewardDataName", qrcode.getQrcodeName());
            }
            listData.add(map);
        });
        pg.setList(listData);
        return pg;
    }

    @Override
    public MallVipTasksRewardsEntity getTasksRewards(String id) {
        return (MallVipTasksRewardsEntity)this.vipTasksRewardsMapper.selectByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public BaseJsonVo saveVipTasksRewards(MallVipTasksRewardsEntity vipTasksRewards) {
        MallVipTasksEntity entity = (MallVipTasksEntity)this.tasksMapper.selectByPrimaryKey((Serializable)((Object)vipTasksRewards.getTaskId()));
        vipTasksRewards.setTaskName(entity.getTaskName());
        vipTasksRewards.setTaskType(entity.getTaskType());
        if (StringUtil.isEmpty((String)vipTasksRewards.getId())) {
            vipTasksRewards.setId(IDGenerate.getUniqueIdStr());
            this.vipTasksRewardsMapper.insert(vipTasksRewards);
        } else {
            this.vipTasksRewardsMapper.updateByPrimaryKeySelective(vipTasksRewards);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void deleteVipTasksRewards(String id) {
        this.vipTasksRewardsMapper.deleteByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public BaseJsonVo customerLevelUp(String customerId, String orderMainNo) {
        Integer targetLevel;
        Integer sourceLevel;
        Integer platformGroupId;
        MallVipSetVo checkResult;
        BaseJsonVo<MallVipSetVo> sr = this.checkCustomerCanLevelUp(customerId, orderMainNo);
        this.logger.info("\u89e6\u53d1\u7528\u6237\u5347\u7ea72\uff0c\u7528\u6237ID\uff1a{},\u4e3b\u8ba2\u5355\u53f7\uff1a{}\uff0c\u662f\u5426\u53ef\u5347\u7ea7\uff1a{}", new Object[]{customerId, orderMainNo, JsonUtils.toJson(sr, (boolean)false)});
        if (sr.isSuccess()) {
            checkResult = (MallVipSetVo)sr.getValue();
            orderMainNo = checkResult.getOrderMainNo();
            platformGroupId = 1000;
            MallVipEntity vipInfo = this.vipInterface.getUserVipInfo(customerId);
            sourceLevel = vipInfo.getLevel();
            MallVipConditionEntity condition = this.vipConditionMapper.getTargetLevel(checkResult.getOrderCount());
            if (condition == null) {
                this.logger.error("\u7528\u6237:{},\u8ba2\u5355:{} \u67e5\u8be2\u76ee\u6807\u7b49\u7ea7\u51fa\u9519", (Object)customerId, (Object)checkResult.getOrderCount());
                return BaseJsonVo.error((String)"");
            }
            targetLevel = condition.getLevel();
            this.logger.info("\u89e6\u53d1\u7528\u6237\u5347\u7ea74\uff0c\u7528\u6237ID\uff1a{},\u4e3b\u8ba2\u5355\u53f7\uff1a{}\uff0c\u5f53\u524d\u7b49\u7ea7\uff1a{}\uff0c\u5347\u7ea7\u7b49\u7ea7\uff1a{}", new Object[]{customerId, orderMainNo, sourceLevel, targetLevel});
            if (targetLevel > sourceLevel) {
                int i = 0;
                if (sourceLevel == 0) {
                    vipInfo.setId(String.valueOf(IDGenerate.getUniqueID()));
                    vipInfo.setLevel(targetLevel);
                    vipInfo.setIsReward(0);
                    vipInfo.setCreateTime(DateUtils.now());
                    i = this.vipMapper.insert(vipInfo);
                } else {
                    vipInfo.setLevel(targetLevel);
                    i = this.vipMapper.updateByPrimaryKeySelective(vipInfo);
                }
                this.logger.info("\u89e6\u53d1\u7528\u6237\u5347\u7ea75\uff0c\u7528\u6237ID\uff1a{},\u4e3b\u8ba2\u5355\u53f7\uff1a{}\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u7ed3\u679c\uff1a{}", new Object[]{customerId, orderMainNo, i});
                this.vipInterface.deleteUserVipInfoCache(customerId);
                this.customerVipTaskRelation(customerId);
                this.customerVipRewardRelation(customerId);
                this.vipInterface.deleteUserVipInfoCache(customerId);
                Calendar rightNow = Calendar.getInstance();
                int hour = rightNow.get(11);
                if (hour < 22 && hour > 7) {
                    this.logger.info("\u89e6\u53d1\u7528\u6237\u5347\u7ea76\uff0c\u7528\u6237ID\uff1a{},\u4e3b\u8ba2\u5355\u53f7\uff1a{}\uff0c\u53d1\u9001\u901a\u77e5", (Object)customerId, (Object)orderMainNo);
                    this.sendTemplateVipLevelUpNoticeMessage(customerId);
                }
                if (Objects.equals(targetLevel, 5) || Objects.equals(targetLevel, 6)) {
                    // empty if block
                }
            }
        } else {
            return sr;
        }
        MallVipLogEntity log = new MallVipLogEntity();
        log.setId(String.valueOf(IDGenerate.getUniqueID()));
        log.setCustomerId(customerId);
        log.setPlatformGroupId(platformGroupId);
        log.setFromLevel(sourceLevel);
        log.setToLevel(targetLevel);
        log.setOrderMainNo(orderMainNo);
        log.setOrderNo(checkResult.getOrderNo());
        log.setOrderNum(checkResult.getOrderCount());
        log.setRemark("");
        log.setLevelup(sourceLevel >= targetLevel ? (short)0 : 1);
        log.setCreateTime(DateUtils.now());
        int i = this.vipLogMapper.insert(log);
        this.logger.info("\u89e6\u53d1\u7528\u6237\u5347\u7ea77\uff0c\u7528\u6237ID\uff1a{},\u4e3b\u8ba2\u5355\u53f7\uff1a{}\uff0c\u4fdd\u5b58\u5347\u7ea7\u8bb0\u5f55\uff1a{},\u4fdd\u5b58\u7ed3\u679c\uff1a{}", new Object[]{customerId, orderMainNo, JsonUtils.toJson((Object)log, (boolean)false), i});
        return BaseJsonVo.success(null);
    }

    public BaseJsonVo<MallVipSetVo> checkCustomerCanLevelUp(String customerId, String orderMainNo) {
        List<MallOrderEntity> orderList;
        MallOrderMainEntity mainOrder;
        if (StringUtils.isEmpty((String)customerId)) {
            return BaseJsonVo.error((String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerEntity customerEntity = this.customerService.getCustomer(customerId);
        if (customerEntity == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5347\u7ea7\u4f1a\u5458");
        }
        if (StringUtils.isEmpty((String)orderMainNo)) {
            mainOrder = this.orderMainService.getLastOrder(customerId);
            if (mainOrder != null) {
                orderMainNo = mainOrder.getOrderMainNo();
            } else {
                this.logger.error("\u7ed1\u5b9a\u4f1a\u5458\u7b49\u7ea7\u5931\u8d25,\u67e5\u4e0d\u5230\u7528\u6237:{}\u8ba2\u5355", (Object)customerId);
            }
        } else {
            mainOrder = this.orderMainService.selectByPrimaryKey(orderMainNo);
            if (mainOrder == null && (mainOrder = this.orderMainService.getLastOrder(customerId)) != null) {
                orderMainNo = mainOrder.getOrderMainNo();
            }
        }
        Integer orderCount = this.orderService.getUserOrderCount(customerId);
        MallVipSetVo setVo = new MallVipSetVo();
        setVo.setCanLevelUp(0);
        setVo.setCustomerId(customerId);
        setVo.setOrderMainNo(orderMainNo);
        setVo.setOrderNo("");
        setVo.setOrderCount(orderCount == null ? 0 : orderCount);
        this.logger.info("setVo\uff08\u67e5\u5b50\u5355\u524d\uff09" + JsonUtils.toJson((Object)setVo, (boolean)false));
        if (StringUtils.isNotEmpty((String)orderMainNo) && CollectionUtils.isNotEmpty(orderList = this.orderService.findOrders(orderMainNo)) && (orderList = orderList.stream().filter(c -> Integer.valueOf(16).equals(c.getStatus())).sorted(Comparator.comparing(MallOrderEntity::getCompleteTime).reversed()).collect(Collectors.toList())) != null && orderList.size() > 0) {
            setVo.setCanLevelUp(1);
            setVo.setOrderNo(orderList.get(0).getOrderNo());
            setVo.setCreateTime(mainOrder.getCreateTime());
            setVo.setCompleteTime(orderList.get(0).getCompleteTime());
        }
        this.logger.info("setVo\uff08\u67e5\u5b50\u5355\u540e\uff09" + JsonUtils.toJson((Object)setVo, (boolean)false));
        BaseJsonVo jsonVo = this.biOrderDetailInvoke.getCustomerOrderCountForVipLevel(customerId);
        this.logger.info("jsonVo\uff08\u67e5BI\u540e\uff09" + JsonUtils.toJson((Object)jsonVo, (boolean)false));
        if (jsonVo.isSuccess()) {
            MallVipSetVo vipSetVo = (MallVipSetVo)ObjectConvert.mapConvertToBean((Map)((Map)jsonVo.getValue()), MallVipSetVo.class);
            this.logger.info("vipSetVo\uff08\u67e5BI\u540e\uff09" + JsonUtils.toJson((Object)vipSetVo, (boolean)false));
            if (Integer.valueOf(1).equals(vipSetVo.getCanLevelUp())) {
                setVo.setOrderCount(setVo.getOrderCount() + vipSetVo.getOrderCount());
                setVo.setCanLevelUp(vipSetVo.getCanLevelUp());
                if (vipSetVo.getCompleteTime() != null && vipSetVo.getCompleteTime().after(setVo.getCompleteTime() == null ? DateUtils.StrToDate((String)"1900-01-01") : setVo.getCompleteTime())) {
                    setVo.setOrderMainNo(vipSetVo.getOrderMainNo());
                    setVo.setOrderNo(vipSetVo.getOrderNo());
                    setVo.setCreateTime(vipSetVo.getCreateTime());
                    setVo.setCompleteTime(vipSetVo.getCompleteTime());
                }
            }
        }
        this.logger.info("setVo\uff08\u67e5BI\u540e\uff09" + JsonUtils.toJson((Object)setVo, (boolean)false));
        if (!Integer.valueOf(1).equals(setVo.getCanLevelUp())) {
            this.logger.error("\u7ed1\u5b9a\u4f1a\u5458\u7b49\u7ea7\u5931\u8d25,\u7528\u6237:{}\u67e5\u8be2\u4e0d\u5230\u5b50\u8ba2\u5355", (Object)customerId);
            return BaseJsonVo.error((String)"\u67e5\u8be2\u4e0d\u5230\u5b50\u8ba2\u5355");
        }
        return BaseJsonVo.success((Object)setVo);
    }

    @Override
    public MallVipEntity getUserVipInfo(String customerId) {
        MallVipEntity searchParam = new MallVipEntity();
        if (customerId.isEmpty()) {
            searchParam.setPlatformGroupId(0);
            searchParam.setLevel(0);
            return searchParam;
        }
        return this.vipInterface.getUserVipInfoBycustomerId(customerId);
    }

    @Override
    @ReadThroughSingleCache(namespace="VIP", expiration=600)
    public MallVipEntity getUserVipInfoBycustomerId(@ParameterValueKeyProvider String customerId) {
        MallVipEntity searchParam = new MallVipEntity();
        searchParam.setCustomerId(customerId);
        MallVipEntity entity = (MallVipEntity)this.vipMapper.getSingle(searchParam);
        if (entity == null || entity.getLevel() == null) {
            CustomerEntity customerEntity = this.customerService.getCustomer(customerId);
            searchParam.setPlatformGroupId(customerEntity == null ? 1000 : customerEntity.getPlatformGroupId());
            searchParam.setLevel(0);
            return searchParam;
        }
        return entity;
    }

    @Override
    public MallVipVo getUserVipVO(String customerId) {
        MallVipEntity vipEntity = this.vipInterface.getUserVipInfo(customerId);
        MallVipVo vipVo = new MallVipVo();
        try {
            ObjectConvert.fatherConvertToChild((Object)vipEntity, (Object)vipVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vipVo.setVip(vipVo.getLevel() != 0);
        return vipVo;
    }

    @Override
    @InvalidateSingleCache(namespace="VIP")
    public void deleteUserVipInfoCache(@ParameterValueKeyProvider String customerId) {
    }

    @Override
    @Transactional
    public void customerVipTaskRelation(String customerId) {
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        List<MallVipTasksEntity> tasks = this.tasksMapper.findUngetTasksByCustomerId(customerId, vip.getLevel());
        ArrayList list = new ArrayList();
        tasks.forEach(task -> {
            MallVipTasksRelationEntity entity = new MallVipTasksRelationEntity();
            entity.setId(IDGenerate.getUniqueIdStr());
            entity.setCustomerId(customerId);
            entity.setTaskId(task.getId());
            entity.setTaskType(task.getTaskType());
            entity.setTaskName(task.getTaskName());
            entity.setPlatformGroupId(this.customerService.getCustomer(customerId).getPlatformGroupId());
            entity.setIsFinished("0");
            entity.setRecommendTimes(0);
            entity.setCreateTime(DateUtils.now());
            list.add(entity);
        });
        if (list.size() > 0) {
            this.vipTaskRelationMapper.batchInsert(list);
        }
    }

    @Override
    @Transactional
    public void customerVipRewardRelation(String customerId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        Integer curLevel = vip.getLevel();
        List<MallVipConditionEntity> conditions = this.conditionList(customer.getPlatformGroupId());
        conditions.forEach(condition -> {
            List<MallVipRewardsRelationEntity> checkRewardsRelations;
            if (curLevel >= condition.getLevel() && ((checkRewardsRelations = this.vipRewardsRelationMapper.findThisLevelRewardsRelation(customerId, condition.getLevel())) == null || checkRewardsRelations.size() == 0)) {
                List<MallVipRewardsEntity> rewards = this.vipRewardsMapper.findRewardsByLevel(condition.getLevel());
                List<MallVipRewardsRelationEntity> rewardsRelations = this.vipRewardsRelationMapper.findCustomerRewardsRelation(customerId);
                ArrayList sqls = new ArrayList();
                rewards.forEach(reward -> {
                    if (!rewardsRelations.stream().anyMatch(rewardRelation -> rewardRelation.getRewardId().equals(reward.getId()))) {
                        MallVipRewardsRelationEntity entity = new MallVipRewardsRelationEntity();
                        entity.setId(IDGenerate.getUniqueIdStr());
                        entity.setCustomerId(customerId);
                        entity.setRewardId(reward.getId());
                        entity.setRewardName(reward.getRewardName());
                        entity.setRewardType(reward.getRewardType());
                        entity.setPlatformGroupId(this.customerService.getCustomer(customerId).getPlatformGroupId());
                        entity.setHasReceived("0");
                        this.vipRewardsRelationMapper.insert(entity);
                    }
                });
            }
        });
    }

    @Override
    public BaseJsonVo customerVipReward(String customerId, String relationId, Integer platformId) {
        BaseJsonVo vo;
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        if (StringUtils.isEmpty((String)customerId) || StringUtils.isEmpty((String)relationId)) {
            result.setError("\u7f3a\u5c11\u53c2\u6570");
            return result;
        }
        MallVipRewardsRelationEntity rewardsRelation = (MallVipRewardsRelationEntity)this.vipRewardsRelationMapper.selectByPrimaryKey((Serializable)((Object)relationId));
        if (rewardsRelation == null) {
            result.setError("\u7528\u6237\u6ca1\u6709\u8be5\u5956\u52b1");
            return result;
        }
        if ("1".equals(rewardsRelation.getHasReceived())) {
            result.setError("\u5df2\u9886\u53d6\u8be5\u5956\u52b1");
            return result;
        }
        MallVipRewardsEntity rewards = (MallVipRewardsEntity)this.vipRewardsMapper.selectByPrimaryKey((Serializable)((Object)rewardsRelation.getRewardId()));
        if (rewards == null) {
            result.setError("\u7cfb\u7edf\u65e0\u8be5\u5956\u52b1");
            return result;
        }
        Boolean hasReceived = false;
        if ("1".equals(rewards.getRewardType())) {
            this.activeCashticketService.sendTicket4BaseAsynchronous(customerId, rewards.getRewardData(), "", platformId, true);
            hasReceived = true;
        } else if ("2".equals(rewards.getRewardType()) && (vo = this.accountBalanceInterface.activeCharge(customerId, new BigDecimal(rewards.getRewardData()).divide(new BigDecimal(100)), "\u4f1a\u5458\u5347\u7ea7\u5956\u52b1", true, "\u4f1a\u5458\u5347\u7ea7\u5956\u52b1\u8d60\u9001", rewards.getId())).isSuccess()) {
            hasReceived = true;
        }
        if (!hasReceived.booleanValue()) {
            result.setError("\u53d1\u9001\u5956\u52b1\u5931\u8d25");
            return result;
        }
        rewardsRelation.setHasReceived("1");
        this.vipRewardsRelationMapper.updateByPrimaryKeySelective(rewardsRelation);
        this.vipInterface.deleteUserVipInfoCache(customerId);
        return result;
    }

    @Override
    @ReadThroughSingleCache(namespace="VIP_CENTER_INFO", expiration=300)
    public Map<String, Object> centerInfo(@ParameterValueKeyProvider String customerId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        List<MallVipConditionEntity> conditionList = this.conditionList(customer.getPlatformGroupId());
        ArrayList conditions = new ArrayList();
        for (MallVipConditionEntity condition : conditionList) {
            HashMap<String, Object> _condition = new HashMap<String, Object>();
            _condition.put("ID", condition.getId());
            _condition.put("LEVEL", condition.getLevel());
            _condition.put("ORDER_NUM", condition.getOrderNum());
            _condition.put("LEVEL_IMG_URL", this.picService.getProductPicUrl(condition.getId() == null ? "" : condition.getId(), ProductPicTypeEnum.VIP_CONDITION_POP.getValue()).get(0));
            conditions.add(_condition);
        }
        rtnMap.put("CONDITIONS", conditions);
        Integer orderCount = this.orderService.getUserOrderCount(customerId);
        Integer curLevel = (int)this.vipInterface.getUserVipInfo(customerId).getLevel();
        rtnMap.put("ORDER_COUNT", orderCount);
        rtnMap.put("CURRENT_LEVEL", curLevel);
        List<Map<String, Object>> userRewards = this.vipRewardsRelationMapper.findUserRewards(customerId);
        List<Map<String, Object>> vipRewards = this.vipRewardsMapper.findVipHasnotRewards(curLevel);
        userRewards.addAll(vipRewards);
        List<Map<String, Object>> vipRightsHas = this.vipRightsMapper.findVipHasRights(curLevel);
        List<Map<String, Object>> vipRightsHasNot = this.vipRightsMapper.findVipHasNotRights(curLevel);
        vipRightsHasNot.addAll(vipRightsHas);
        ArrayList levelSet = new ArrayList();
        for (MallVipConditionEntity condition : conditionList) {
            HashMap<String, Object> levelRtnRecord = new HashMap<String, Object>();
            levelRtnRecord.put("ORDER_COUNT_DIFF", condition.getOrderNum() - orderCount < 0 ? 0 : condition.getOrderNum() - orderCount);
            levelRtnRecord.put("LEVEL", condition.getLevel());
            if (condition.getLevel() <= curLevel) {
                Map<String, Object> thisLevelTime = this.vipLogMapper.findCustomerLevelUpTime(customerId, condition.getLevel());
                if (thisLevelTime != null && thisLevelTime.size() > 0) {
                    levelRtnRecord.put("THIS_LEVEL_TIME", thisLevelTime.get("CREATE_TIME"));
                } else {
                    levelRtnRecord.put("THIS_LEVEL_TIME", "");
                }
                levelRtnRecord.put("LIGHT", "ON");
            } else {
                levelRtnRecord.put("THIS_LEVEL_TIME", "");
                levelRtnRecord.put("LIGHT", "OFF");
            }
            ArrayList<Map<String, Object>> rewardsRecordSet = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> reward : userRewards) {
                if (((Integer)reward.get("LEVEL")).intValue() != condition.getLevel().intValue()) continue;
                if ("ON".equals(reward.get("LIGHT"))) {
                    reward.put("REWARD_ICON_URL", this.picService.getProductPicUrl(reward.get("REWARD_ID").toString(), ProductPicTypeEnum.VIP_REWARD_ICON.getValue()).get(0));
                } else {
                    reward.put("REWARD_ICON_URL", this.picService.getProductPicUrl(reward.get("REWARD_ID").toString(), ProductPicTypeEnum.VIP_REWARD_ICON_DARK.getValue()).get(0));
                }
                reward.put("REWARD_IMG_URL", this.picService.getProductPicUrl(reward.get("REWARD_ID").toString(), ProductPicTypeEnum.VIP_REWARD_POP.getValue()).get(0));
                rewardsRecordSet.add(reward);
            }
            levelRtnRecord.put("REWARDS", rewardsRecordSet);
            ArrayList<Map<String, Object>> rightsRecordSet = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> right : vipRightsHasNot) {
                if (((Integer)right.get("LEVEL")).intValue() != condition.getLevel().intValue()) continue;
                if ("ON".equals(right.get("LIGHT"))) {
                    right.put("RIGHT_ICON_URL", this.picService.getProductPicUrl(right.get("ID").toString(), ProductPicTypeEnum.VIP_RIGHT_ICON.getValue()).get(0));
                } else {
                    right.put("RIGHT_ICON_URL", this.picService.getProductPicUrl(right.get("ID").toString(), ProductPicTypeEnum.VIP_RIGHT_ICON_DARK.getValue()).get(0));
                }
                right.put("RIGHT_IMG_URL", this.picService.getProductPicUrl(right.get("ID").toString(), ProductPicTypeEnum.VIP_RIGHT_POP.getValue()).get(0));
                if (right.get("RIGHT_IMG_URL") != null && StringUtils.isNotEmpty((String)String.valueOf(right.get("RIGHT_IMG_URL")))) {
                    right.put("SHOW_POP", 1);
                } else {
                    right.put("SHOW_POP", 0);
                }
                if (Integer.valueOf(String.valueOf(right.get("STATUS"))) == 0) {
                    right.put("HAS_RECEIVED", 3);
                }
                rightsRecordSet.add(right);
            }
            levelRtnRecord.put("RIGHTS", rightsRecordSet);
            levelSet.add(levelRtnRecord);
        }
        rtnMap.put("LEVELS_DATA", levelSet);
        return rtnMap;
    }

    @Override
    public Map<String, Object> pushCustomerTask(String customerId) {
        Map<String, Object> record = this.vipTaskRelationMapper.findCustomerPushTask(customerId);
        if (record != null && StringUtils.isNotEmpty((String)String.valueOf(record.get("ID")))) {
            record.put("TASK_IMG_URL", this.picService.getProductPicUrl(String.valueOf(record.get("ID")), ProductPicTypeEnum.VIP_TASK_FONTPAGE.getValue()).get(0));
            this.vipTaskRelationMapper.updatePushTimes(String.valueOf(record.get("RID")));
        }
        return record;
    }

    @Override
    public Map<String, Object> customerTasks(String customerId) {
        this.customerVipTaskRelation(customerId);
        if (this.checkFinishTaskBindMobile(customerId).booleanValue()) {
            this.finishTaskBindMobile(customerId);
        }
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        HashMap<String, Object> rtnRecord = new HashMap<String, Object>();
        List<MallVipConditionEntity> conditionList = this.conditionList(customer.getPlatformGroupId());
        rtnRecord.put("CONDITIONS", conditionList);
        Integer orderCount = this.orderService.getUserOrderCount(customerId);
        Integer curLevel = this.vipInterface.getUserVipInfo(customerId).getLevel();
        rtnRecord.put("ORDER_COUNT", orderCount);
        rtnRecord.put("CURRENT_LEVEL", curLevel);
        List<Map<String, Object>> userTasks = this.vipTaskRelationMapper.findCustomerTasks(customerId);
        List<Map<String, Object>> vipTasks = this.tasksMapper.findHasnotTasksByLevel(curLevel);
        ArrayList levelSet = new ArrayList();
        for (MallVipConditionEntity condition : conditionList) {
            HashMap<String, Object> levelRtnRecord = new HashMap<String, Object>();
            levelRtnRecord.put("ORDER_COUNT_DIFF", condition.getOrderNum() - orderCount < 0 ? 0 : condition.getOrderNum() - orderCount);
            levelRtnRecord.put("LEVEL", condition.getLevel());
            if (condition.getLevel() <= curLevel) {
                levelRtnRecord.put("LIGHT", "ON");
            } else {
                levelRtnRecord.put("LIGHT", "OFF");
            }
            ArrayList<Map<String, Object>> tasksRecordSet = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> task : userTasks) {
                if (((Integer)task.get("LEVEL")).intValue() != condition.getLevel().intValue()) continue;
                if (condition.getLevel() > curLevel) {
                    task.put("LIGHT", "OFF");
                    task.put("IS_FINISHED", "2");
                }
                tasksRecordSet.add(task);
            }
            levelRtnRecord.put("TASKS", tasksRecordSet);
            levelSet.add(levelRtnRecord);
        }
        rtnRecord.put("LEVELS_DATA", levelSet);
        return rtnRecord;
    }

    @Override
    public MallVipRightsEntity checkCustomerRight(String customerId, String rightId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        MallVipEntity vip = this.getUserVipInfo(customerId);
        MallVipRightsEntity searchParam = new MallVipRightsEntity();
        searchParam.setPlatformGroupId(customer.getPlatformGroupId());
        searchParam.setStatus("1");
        searchParam.setRightId(rightId);
        searchParam.setHasRight("1");
        searchParam.setLevel(vip.getLevel());
        return (MallVipRightsEntity)this.vipRightsMapper.getSingle(searchParam);
    }

    @Override
    public BaseJsonVo getCustomerRight(String customerId, String rightId) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        MallVipRightsEntity entity = this.checkCustomerRight(customerId, rightId);
        if (entity != null) {
            result.setValue((Object)entity);
        } else {
            result.setError("\u65e0\u6743\u9650");
        }
        return result;
    }

    @Override
    public MallVipRightsEntity checkCustomerRightByType(String customerId, String typeId, Boolean isVipDay) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        if ("3".equals(typeId) && !isVipDay.booleanValue() && vip.getLevel() < 6) {
            return null;
        }
        MallVipRightsEntity searchParam = new MallVipRightsEntity();
        searchParam.setPlatformGroupId(customer.getPlatformGroupId());
        searchParam.setStatus("1");
        searchParam.setRightType(typeId);
        searchParam.setHasRight("1");
        searchParam.setLevel(vip.getLevel());
        return (MallVipRightsEntity)this.vipRightsMapper.getSingle(searchParam);
    }

    @Override
    public BaseJsonVo finishTask(String customerId, String taskId) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        MallVipTasksEntity task = (MallVipTasksEntity)this.tasksMapper.selectByPrimaryKey((Serializable)((Object)taskId));
        if (task == null) {
            result.setError("\u4efb\u52a1\u4e0d\u5b58\u5728");
            return result;
        }
        MallVipTasksRelationEntity searchParam = new MallVipTasksRelationEntity();
        searchParam.setCustomerId(customerId);
        searchParam.setTaskId(taskId);
        searchParam.setIsFinished("0");
        MallVipTasksRelationEntity taskRelation = (MallVipTasksRelationEntity)this.vipTaskRelationMapper.getSingle(searchParam);
        if (taskRelation == null) {
            result.setError("\u7528\u6237\u6ca1\u6709\u8be5\u4efb\u52a1\u6216\u8005\u5df2\u5b8c\u6210\u4e86\u8be5\u4efb\u52a1");
            return result;
        }
        Boolean hasReceived = true;
        String rewardSql = "SELECT ID,TASK_ID,TASK_TYPE,TASK_NAME,REWARD_TYPE,REWARD_NAME,REWARD_DATA,STATUS FROM t_mall_customer_vip_tasks_rewards WHERE TASK_ID = '" + taskId + "'";
        MallVipTasksRewardsEntity searchParam2 = new MallVipTasksRewardsEntity();
        searchParam2.setTaskId(taskId);
        List rewards = this.vipTasksRewardsMapper.getList(searchParam2);
        if (rewards != null && rewards.size() > 0) {
            for (MallVipTasksRewardsEntity reward : rewards) {
                BaseJsonVo vo;
                if ("1".equals(reward.getRewardType())) {
                    this.activeCashticketService.sendTicket4BaseAsynchronous(customerId, reward.getRewardData(), "", 1000, false);
                    continue;
                }
                if (!"2".equals(reward.getRewardType()) || (vo = this.accountBalanceInterface.activeCharge(customerId, new BigDecimal(reward.getRewardData()).divide(new BigDecimal(100)), taskRelation.getTaskName(), true, "\u5b8c\u6210" + taskRelation.getTaskName() + "\u8d60\u9001", taskRelation.getTaskId())).isSuccess()) continue;
                hasReceived = false;
            }
        }
        if (hasReceived.booleanValue()) {
            taskRelation.setIsFinished("1");
            taskRelation.setCreateTime(DateUtils.now());
            this.vipTaskRelationMapper.updateByPrimaryKeySelective(taskRelation);
        } else {
            result.setError(customerId + "|" + taskId + "|\u53d1\u9001\u4efb\u52a1\u5956\u54c1\u5931\u8d25");
        }
        this.vipInterface.deleteUserVipInfoCache(customerId);
        return result;
    }

    @Override
    public BaseJsonVo finishTaskAllTaste(String customerId) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskAllTaste(customerId);
        if (list == null || list.size() == 0) {
            this.finishTask(customerId, "3164433361515307029");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskVipOnly(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskVipOnly(customerId, orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3164445216329869515");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskNewTaste(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskNewTaste(customerId, orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3164445280522429618");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskMiaosha(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskMiaosha(customerId, orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3172187990057360659");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public Boolean isFinishedTask12ask(String customerId) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.isFinishedTask12ask(customerId);
        if (list == null || list.size() == 0) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean isFinishedTask5yuan(String customerId) {
        Map<String, Object> list = this.vipTaskRelationMapper.isFinishedTask5yuan(customerId);
        Map<String, Object> existWhite = this.vipTaskRelationMapper.existsWhiteList(customerId, 1);
        if (list != null && list.size() != 0 && ("2".equals(list.get("status")) || "3".equals(list.get("status"))) && (existWhite == null || existWhite.size() == 0 || existWhite.get("_exist") == null)) {
            return true;
        }
        return false;
    }

    @Override
    public BaseJsonVo finishTask5yuan(String customerId) {
        if (this.isFinishedTask5yuan(customerId).booleanValue()) {
            this.finishTask(customerId, "3164445118971216140");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskTuangou(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskTuangou(orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3164445184631168131");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskPleaseYoghourt(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskPleaseYoghourt(orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3164445404530475556");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskTupianchuanbo(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskTupianchuanbo(orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3170555507788115764");
            this.finishTask(customerId, "3170555406046817438");
            this.finishTask(customerId, "3164654221540859007");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskOrderedTwice(String customerId) {
        Map<String, Object> list = this.vipTaskRelationMapper.finishTaskOrderedTwice(customerId, DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-30), (String)"yyyy-MM-dd HH:mm:ss"));
        this.logger.info("\u6708\u6536\u4e24\u5355\u4efb\u52a1[" + customerId + "]" + (list == null ? 0 : list.size()));
        if (list != null && list.size() > 0 && list.get("_cou") != null && Integer.valueOf(list.get("_cou").toString()) > 0) {
            this.finishTask(customerId, "1245978092654039040");
        }
        if (list != null && list.size() > 0 && list.get("_cou") != null && Integer.valueOf(list.get("_cou").toString()) > 1) {
            this.finishTask(customerId, "3164445355091200679");
        }
        if (list != null && list.size() > 0 && list.get("_cou") != null && Integer.valueOf(list.get("_cou").toString()) > 2) {
            this.finishTask(customerId, "1245978630363811840");
        }
        if (list != null && list.size() > 0 && list.get("_cou") != null && Integer.valueOf(list.get("_cou").toString()) > 3) {
            this.finishTask(customerId, "1022869781126189056");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskRegularOrder(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskRegularOrder(orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3172187498156596686");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskCanteen(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskCanteen(orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3172187593008494233");
        }
        return BaseJsonVo.success((Object)"");
    }

    private Boolean checkFinishTaskBindMobile(String customerId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        if (StringUtils.isNotEmpty((String)customer.getMobile())) {
            return true;
        }
        return false;
    }

    @Override
    public BaseJsonVo finishTaskBindMobile(String customerId) {
        this.finishTask(customerId, "1022869204455526400");
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskImproveInfo(String customerId) {
        this.finishTask(customerId, "1022869402032410624");
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishEvaluate(String customerId) {
        this.finishTask(customerId, "3164445155423067970");
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public Integer getMaxLevelOrderShort(String customerId) {
        Integer vipOrderCount = this.orderService.getUserOrderCount(customerId);
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        List<MallVipConditionEntity> conditions = this.conditionList(customer.getPlatformGroupId());
        if (conditions == null || conditions.size() == 0) {
            return 0;
        }
        Integer maxLevelOrderShort = conditions.get(conditions.size() - 1).getOrderNum();
        if (vipOrderCount >= maxLevelOrderShort) {
            return 0;
        }
        return maxLevelOrderShort - vipOrderCount;
    }

    @Override
    public BaseJsonVo sendTemplateVipLevelUpNoticeMessage(String customerId) {
        return null;
    }

    @Override
    @Transactional
    public BaseJsonVo saveVipQuestionnaire(List<MallVipQuestionnairePaperEntity> papers) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        for (MallVipQuestionnairePaperEntity r : papers) {
            r.setId(IDGenerate.getUniqueIdStr());
            this.vipQuestionnairePaperMapper.insert(r);
        }
        if (papers.size() > 0) {
            this.finishTask(papers.get(0).getCustomerId(), "3172412336858010334");
        }
        return result;
    }

    @Override
    public List<HashMap<String, Object>> getUnsendVipsByLevel(String level) {
        List<HashMap<String, Object>> vips = this.vipMapper.findUnsendVipsByLevel(level);
        return vips;
    }

    @Override
    public MallVipNoticeTemplateEntity getVipReservationsRemindMessage(Integer level) {
        MallVipNoticeTemplateEntity searchParam = new MallVipNoticeTemplateEntity();
        searchParam.setLevel(level);
        return (MallVipNoticeTemplateEntity)this.vipNoticeTemplateMapper.getSingle(searchParam);
    }

    @Override
    public void saveVipReservationsRemindMessage(MallVipNoticeTemplateEntity entity) {
        MallVipNoticeTemplateEntity searchParam = new MallVipNoticeTemplateEntity();
        searchParam.setLevel(entity.getLevel());
        MallVipNoticeTemplateEntity notice = (MallVipNoticeTemplateEntity)this.vipNoticeTemplateMapper.getSingle(searchParam);
        if (notice != null) {
            entity.setId(notice.getId());
            this.vipNoticeTemplateMapper.updateByPrimaryKeySelective(entity);
        } else {
            entity.setId(IDGenerate.getUniqueIdStr());
            this.vipNoticeTemplateMapper.insert(entity);
        }
    }

    @Override
    public boolean sendReservationsRemindMessageByLevel(int level) {
        return false;
    }

    @Override
    public BaseJsonVo initVipData() {
        return null;
    }

    @Override
    public void updateVipLevel(String customerId, Integer level) {
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        int sourceLevel = vip.getLevel();
        int targetLevel = level;
        if (sourceLevel == 0) {
            vip.setId(IDGenerate.getUniqueIdStr());
            vip.setIsReward(0);
            vip.setLevel(targetLevel);
            this.vipMapper.insert(vip);
        } else {
            vip.setLevel(targetLevel);
            this.vipMapper.updateByPrimaryKeySelective(vip);
        }
        this.customerVipTaskRelation(customerId);
        this.customerVipRewardRelation(customerId);
        MallVipLogEntity log = new MallVipLogEntity();
        log.setId(String.valueOf(IDGenerate.getUniqueID()));
        log.setCustomerId(customerId);
        log.setPlatformGroupId(vip.getPlatformGroupId());
        log.setFromLevel(sourceLevel);
        log.setToLevel(targetLevel);
        log.setCreateTime(DateUtils.now());
        log.setOrderMainNo("");
        log.setOrderNo("");
        log.setOrderNum(0);
        log.setRemark("\u624b\u52a8\u540e\u53f0\u5347\u7ea7");
        log.setLevelup(sourceLevel == targetLevel ? (short)0 : 1);
        this.vipLogMapper.insert(log);
        this.vipInterface.deleteUserVipInfoCache(customerId);
    }

    @Override
    public void rebuildVipLevel(String customerId) {
        MallOrderMainEntity orderMain = this.orderMainService.getLastOrder(customerId);
        if (orderMain != null && StringUtils.isNotEmpty((String)orderMain.getOrderMainNo())) {
            this.customerLevelUp(customerId, orderMain.getOrderMainNo());
        }
    }

    @Override
    public void rebuildVipLevelBatch() {
        List<Map<String, String>> orderMainList = this.orderMainService.getRebuildVipLevelBatch();
        orderMainList.forEach(map -> this.customerLevelUp((String)map.get("CUSTOMER_ID"), (String)map.get("ORDER_MAIN_NO")));
    }

    @Override
    public BaseJsonVo rebuildVipLevelEveryday() {
        List<Map<String, String>> orderMainList = this.orderMainService.getRebuildVipLevelEverydayBatch(DateUtils.date());
        BaseJsonVo jsonVo = this.biOrderDetailInvoke.getNeedLevelUpCustomers();
        List cus = jsonVo.isSuccess() ? (List)jsonVo.getValue() : new ArrayList();
        orderMainList.forEach(map -> {
            this.customerLevelUp((String)map.get("CUSTOMER_ID"), (String)map.get("ORDER_MAIN_NO"));
            cus.remove(map.get("CUSTOMER_ID"));
        });
        cus.forEach(c -> this.customerLevelUp((String)c, null));
        return BaseJsonVo.success(null);
    }

    @Override
    public void sendVipReservationsRemindMessageByQueue(List<MallVipEntity> vipCustomers, Map<String, String> paramRecord) {
    }

    @Override
    public List<Integer> rightsLevels() {
        MallVipRightsEntity searchParam = new MallVipRightsEntity();
        searchParam.setStatus("1");
        List rights = this.vipRightsMapper.getList(searchParam);
        ArrayList<Integer> rightLevels = new ArrayList<Integer>();
        rights.forEach(right -> {
            if (!rightLevels.contains(right.getLevel())) {
                rightLevels.add(right.getLevel());
            }
        });
        return rightLevels;
    }

    @Override
    public boolean checkVipRightByType(String customerId, String rightType) {
        if (String.valueOf(VipRightTypeEnum.RIGHT_XINPINCHANGXIAN.getValue()).equals(rightType)) {
            return true;
        }
        MallVipEntity vipEntity = this.vipInterface.getUserVipInfo(customerId);
        int level = 0;
        if (vipEntity != null) {
            level = vipEntity.getLevel();
        }
        MallVipRightsEntity rightsEntity = new MallVipRightsEntity();
        rightsEntity.setLevel(level);
        rightsEntity.setStatus("1");
        rightsEntity.setRightType(rightType);
        rightsEntity.setHasRight("1");
        List vipRightsEntities = this.vipRightsMapper.getList(rightsEntity);
        return vipRightsEntities != null && vipRightsEntities.size() != 0;
    }

    @Override
    public Boolean isVipDayNow() {
        int weekIndex;
        Object isVipDayStr = this.memcachedService.get("VIP", "VIP_DAY");
        if (isVipDayStr == null || StringUtils.isEmpty((String)isVipDayStr.toString())) {
            return false;
        }
        Map r = (Map)JSON.parseObject((String)isVipDayStr.toString(), HashMap.class);
        if (r == null || r.get("weekIndex") == null || "0".equals(r.get("weekIndex").toString())) {
            return false;
        }
        int weekIndexOfDate = DateUtils.getWeekIndexOfDate((Date)DateUtils.now());
        if (weekIndexOfDate == (weekIndex = Integer.valueOf(r.get("weekIndex").toString()).intValue())) {
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getMallVipDay() {
        Object isVipDayStr = this.memcachedService.get("VIP", "VIP_DAY");
        if (isVipDayStr == null || StringUtils.isEmpty((String)isVipDayStr.toString())) {
            return null;
        }
        return (Map)JSON.parseObject((String)isVipDayStr.toString(), HashMap.class);
    }

    @Override
    public void setVipDay(Map<String, Object> map) {
        if (map != null) {
            this.memcachedService.set("VIP", "VIP_DAY", (Object)JSON.toJSONString(map));
        }
    }

    @Override
    public BaseJsonVo sendVipTextMessage(int platformId, final int level, Boolean isTest) {
        List<Object> customers = new ArrayList();
        if (isTest.booleanValue()) {
            String[] idsArray;
            String ids = this.dicService.getDictionaryToString(this.platFormService.getPlatFormGroupId(platformId), 54, "1");
            if (StringUtils.isNotEmpty((String)ids) && (idsArray = ids.split(",")) != null && idsArray.length > 0) {
                for (String id : idsArray) {
                    customers.add(this.customerService.getCustomer(id));
                }
            }
        } else {
            customers = this.vipMapper.getCustomerVip(level);
        }
        ExecutorService pool = Executors.newFixedThreadPool(6);
        final int[] succ = new int[]{0};
        for (final CustomerEntity customerEntity : customers) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("nickName", customerEntity.getNickName());
                    BaseJsonVo result = MallVipService.this.messageService.sendWechatMessage("vipday_v" + level, customerEntity.getCustomerId(), map);
                    if (result.isSuccess()) {
                        succ[0] = succ[0] + 1;
                    }
                }
            });
        }
        pool.shutdown();
        MallVipdaylogEntity entity = new MallVipdaylogEntity();
        entity.setLevel(level);
        entity.setMessage(this.dicService.getDictionaryToString(this.platFormService.getPlatFormGroupId(platformId), 52, "vipday_v" + level));
        entity.setTotalNum(customers.size());
        entity.setSuccNum(succ[0]);
        entity.setFailNum(customers.size() - succ[0]);
        entity.setCreateTime(DateUtils.now());
        this.vipdaylogMapper.insert(entity);
        return BaseJsonVo.success((Object)succ[0]);
    }

    @Override
    public List<MallSelectDataVo> getOptionConditionList(Integer platformGroupId) {
        return this.vipConditionMapper.getOptionConditionList(platformGroupId);
    }

    @Override
    public List<MallSelectDataVo> getOptionTaskList(Integer platformGroupId) {
        return this.tasksMapper.getOptionTaskList(platformGroupId);
    }

    @Override
    public List<MallSelectDataVo> getOptionVipQrcodesList(Integer platformGroupId) {
        DictionaryEntity entity = this.dicService.getDictionary(platformGroupId, 53, "0");
        if (entity != null && StringUtils.isNotEmpty((String)entity.getDictionaryName())) {
            return this.vipConditionMapper.getOptionVipQrcodesList(entity.getDictionaryName());
        }
        return null;
    }

    @Override
    public BaseJsonVo getVipCount(Integer platformGroupId) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public Boolean isVip(String customerId) {
        if (customerId == null || customerId.isEmpty()) {
            return false;
        }
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        if (vip.getLevel() > 0) {
            return true;
        }
        return false;
    }

    @Override
    public void finishAllTasksByFinishOrder(String orderMainNo, String customerId) {
        this.finishTaskAllTaste(customerId);
        this.finishTask5yuan(customerId);
        this.finishTaskCanteen(customerId, orderMainNo);
        this.finishTaskMiaosha(customerId, orderMainNo);
        this.finishTaskNewTaste(customerId, orderMainNo);
        this.finishTaskOrderedTwice(customerId);
        this.finishTaskRegularOrder(customerId, orderMainNo);
        this.finishTaskTuangou(customerId, orderMainNo);
        this.finishTaskVipOnly(customerId, orderMainNo);
        this.finishTaskTupianchuanbo(customerId, orderMainNo);
        this.finishTaskPleaseYoghourt(customerId, orderMainNo);
    }
}

