/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.enums.weixin.MessageBlackListTypeEnum;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.MessageBlackListMapper;
import cc.lechun.mall.entity.weixin.MessageBlackListEntity;
import cc.lechun.mall.iservice.weixin.MessageBlackListInterface;
import cc.lechun.mall.iservice.weixin.MessageErpBlackListInterface;
import com.github.pagehelper.util.StringUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageBlackListService
extends BaseService<MessageBlackListEntity, Integer>
implements MessageBlackListInterface {
    @Resource
    private MessageBlackListMapper messageBlackListMapper;
    @Autowired
    private MessageErpBlackListInterface erpBlackListInterface;

    @Override
    public BaseJsonVo<String> filter(MessageBlackListTypeEnum blackListTypeEnum, String phones, String customerIds, String openIds, String content) {
        String[] phoneArr;
        BaseJsonVo<String> jsonVo = BaseJsonVo.error((String)"\u9a8c\u8bc1\u5931\u8d25");
        if (StringUtil.isNotEmpty((String)phones)) {
            phoneArr = phones.split(",");
            jsonVo = this.filter(blackListTypeEnum, phoneArr, 1, content);
        }
        if (StringUtil.isNotEmpty((String)customerIds)) {
            phoneArr = customerIds.split(",");
            jsonVo = this.filter(blackListTypeEnum, phoneArr, 2, content);
        }
        if (StringUtil.isNotEmpty((String)openIds)) {
            phoneArr = openIds.split(",");
            jsonVo = this.filter(blackListTypeEnum, phoneArr, 3, content);
        }
        if (!jsonVo.isSuccess()) {
            this.logger.error(jsonVo.getMessage());
        }
        return jsonVo;
    }

    private BaseJsonVo<String> filter(MessageBlackListTypeEnum blackListTypeEnum, String[] sendObjects, Integer objectType, String content) {
        BaseJsonVo jsonVo = BaseJsonVo.error((String)"\u9a8c\u8bc1\u5931\u8d25");
        StringBuilder sb = new StringBuilder();
        String phone = "";
        String customerId = "";
        String openId = "";
        for (String s : sendObjects) {
            if (objectType == 1) {
                phone = s;
            }
            if (objectType == 2) {
                customerId = s;
            }
            if (objectType == 3) {
                openId = s;
            }
            if ((jsonVo = this.filterBase(blackListTypeEnum, phone, customerId, openId, content)).isSuccess()) {
                sb.append(s);
                sb.append(",");
            }
            this.logger.info("phone:{},\u7ed3\u679c:{}", (Object)phone, (Object)jsonVo.isSuccess());
        }
        if (sb.length() > 0) {
            return BaseJsonVo.success((Object)sb.substring(0, sb.length() - 2));
        }
        return BaseJsonVo.error((String)jsonVo.getMessage());
    }

    private BaseJsonVo filterBase(MessageBlackListTypeEnum blackListTypeEnum, String phone, String customerId, String openId, String content) {
        List<MessageBlackListEntity> blackList = this.getListByBlackType(blackListTypeEnum.getValue());
        if (blackList.size() > 0) {
            String sendObject = (StringUtil.isNotEmpty((String)phone) ? phone : "") + "-" + (StringUtil.isNotEmpty((String)customerId) ? customerId : "") + "-" + (StringUtil.isNotEmpty((String)openId) ? openId : "");
            String key = "MessageBlackListService-filter-" + blackListTypeEnum.getValue() + "-" + sendObject;
            String md5Content = StringUtil.isEmpty((String)content) ? "" : MD5.sign((String)content);
            String key1 = key + md5Content;
            Integer limitCount = 0;
            Integer limitSameCount = 0;
            Integer count = 0;
            Integer count1 = 0;
            Object o = this.redisCacheUtil.get(key);
            count = o != null ? Integer.parseInt(o.toString()) : 0;
            o = this.redisCacheUtil.get(key1);
            count1 = o != null ? Integer.parseInt(o.toString()) : 0;
            limitCount = blackList.get(0).getUnitTimeLimitCount();
            limitSameCount = blackList.get(0).getUnitTimeSameLimitCount();
            if (count.compareTo(limitCount) >= 0 && limitCount > 0) {
                return BaseJsonVo.error((String)(blackListTypeEnum.getName() + "\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u5df2\u53d1\u9001\u6b21\u6570:" + count + " \u9ed1\u540d\u5355\u53d1\u9001\u6b21\u6570\u9a8c\u8bc1\u4e0d\u901a\u8fc7\u603b\u53d1\u9001\u6b21\u6570\u9650\u5236\uff1a" + limitCount));
            }
            if (count1.compareTo(limitSameCount) >= 0 && limitSameCount > 0) {
                return BaseJsonVo.error((String)(blackListTypeEnum.getName() + "\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u76f8\u540c\u5185\u5bb9\u5df2\u53d1\u9001\u6b21\u6570:" + count1 + "\u9ed1\u540d\u5355\u53d1\u9001\u6b21\u6570\u9a8c\u8bc1\u4e0d\u901a\u8fc7(\u76f8\u540c\u5185\u5bb9)\u53d1\u9001\u6b21\u6570\u9650\u5236\uff1a" + limitSameCount));
            }
            for (MessageBlackListEntity black : blackList) {
                this.logger.info("phone:{},black.getPhone:{}", (Object)phone, (Object)black.getPhone());
                if (StringUtil.isNotEmpty((String)phone) && StringUtil.isNotEmpty((String)black.getPhone()) && black.getPhone().indexOf(phone) >= 0) {
                    return BaseJsonVo.error((String)(blackListTypeEnum.getName() + "\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u9ed1\u540d\u5355\u4e0d\u901a\u8fc7phone\u9650\u5236\uff1a" + phone));
                }
                if (StringUtil.isNotEmpty((String)phone)) {
                    String shops = "";
                    if (StringUtil.isNotEmpty((String)black.getErpCustomerId())) {
                        shops = black.getErpCustomerId();
                    }
                    if (StringUtil.isNotEmpty((String)black.getErpShopId())) {
                        shops = StringUtil.isEmpty((String)shops) ? black.getErpShopId() : shops + "," + black.getErpShopId();
                    }
                    if (!this.erpBlackListInterface.filter(null, phone).booleanValue()) {
                        return BaseJsonVo.error((String)(blackListTypeEnum.getName() + "\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u9ed1\u540d\u5355\u4e0d\u901a\u8fc7phone\uff1a" + phone + ",erpCustomer/shop\u9650\u5236:" + shops));
                    }
                }
                if (StringUtil.isNotEmpty((String)customerId) && StringUtil.isNotEmpty((String)black.getCustomerId()) && black.getCustomerId().indexOf(customerId) >= 0) {
                    return BaseJsonVo.error((String)(blackListTypeEnum.getName() + "\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u9ed1\u540d\u5355\u4e0d\u901a\u8fc7customerId\u9650\u5236\uff1a" + customerId));
                }
                if (!StringUtil.isNotEmpty((String)openId) || !StringUtil.isNotEmpty((String)black.getOpenId()) || black.getOpenId().indexOf(openId) < 0) continue;
                return BaseJsonVo.error((String)(blackListTypeEnum.getName() + "\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u9ed1\u540d\u5355\u4e0d\u901a\u8fc7openId\u9650\u5236\uff1a" + openId));
            }
            Integer unitTimeType = blackList.get(0).getUnitTimeType();
            if (unitTimeType != null & unitTimeType != 0) {
                long expireTime = 3600L;
                if (unitTimeType == 1) {
                    expireTime *= 1L;
                }
                if (unitTimeType == 2) {
                    expireTime *= 24L;
                }
                if (unitTimeType == 3) {
                    expireTime = expireTime * 24L * 7L;
                }
                if (limitCount != null && limitCount != 0) {
                    this.redisCacheUtil.set(key, (Object)(count + 1), Long.valueOf(expireTime));
                }
                if (limitSameCount != null && limitSameCount != 0) {
                    this.redisCacheUtil.set(key1, (Object)(count1 + 1), Long.valueOf(expireTime));
                }
            }
            return BaseJsonVo.success((Object)"blackListTypeEnum.getName()+\u9a8c\u8bc1\u901a\u8fc7\uff0c\u6240\u6709\u9a8c\u8bc1\u90fd\u901a\u8fc7");
        }
        return BaseJsonVo.success((Object)"blackListTypeEnum.getName()+\u9a8c\u8bc1\u901a\u8fc7\uff0c\u6ca1\u6709\u5339\u914d\u5230\u9a8c\u8bc1\u6761\u4ef6");
    }

    private List<MessageBlackListEntity> getListByBlackType(Integer blackType) {
        String key = "MessageErpBlackListService_getListByBlackType" + blackType;
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            return (List)o;
        }
        MessageBlackListEntity search = new MessageBlackListEntity();
        search.setBlackType(blackType);
        search.setStatus(1);
        List lst = this.getList(search);
        this.redisCacheUtil.set(key, (Object)lst, Long.valueOf(300L));
        return lst;
    }
}

