/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.apiinvoke.baseservice.SMSInvoke;
import cc.lechun.apiinvoke.baseservice.TaskInvoke;
import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.common.enums.weixin.MessageBlackListTypeEnum;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerOpenidEntity;
import cc.lechun.mall.entity.customer.SubscribeMessageEntity;
import cc.lechun.mall.entity.weixin.MallMessageConfigEntity;
import cc.lechun.mall.entity.weixin.MallTemplateMessageLogEntity;
import cc.lechun.mall.entity.weixin.MessageRemainEntity;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.SubscribeMessageInterface;
import cc.lechun.mall.iservice.weixin.MallMessageConfigInterface;
import cc.lechun.mall.iservice.weixin.MessageBlackListInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.MessageRemainInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageLogInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import weixin.popular.api.MessageAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.message.message.Message;
import weixin.popular.bean.message.message.TextMessage;
import weixin.popular.bean.message.templatemessage.MiniSubscribeMessage;
import weixin.popular.bean.message.templatemessage.MpSubscribeMessage;
import weixin.popular.bean.message.templatemessage.TemplateMessage;
import weixin.popular.bean.message.templatemessage.TemplateMessageItem;
import weixin.popular.bean.message.templatemessage.TemplateMessageResult;

@Service
public class MessageService
implements MessageInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private TemplateMessageLogInterface templateMessageLogInterface;
    @Autowired
    private MallMessageConfigInterface messageConfigInterface;
    @Autowired
    SMSInvoke smsInvoke;
    @Autowired
    private MessageBlackListInterface blackListInterface;
    @Autowired
    private TaskInvoke taskInvoke;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    MessageRemainInterface messageRemainInterface;
    @Autowired
    TemplateMessageInterface templateMessageInterface;
    @Autowired
    private SubscribeMessageInterface subscribeMessageInterface;

    @Override
    public BaseResult sendCustomerTextMessage4CustmoerId(String customerId, Integer platFormId, String content, int messageId) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platFormId);
        BaseResult baseResult = new BaseResult();
        if (customerDetailVo == null) {
            baseResult.setErrcode("\u7528\u6237\u4e0d\u5b58\u5728");
            baseResult.setErrcode("1001");
            this.logger.info("\u7528\u6237\u4e0d\u5b58\u5728,customerId={}", (Object)customerId);
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return this.sendCustomerTextMessage(customerDetailVo.getOpenId(), platFormId, content, messageId);
    }

    @Override
    public BaseResult sendCustomerTextMessage(String openId, Integer platFormId, String content, int messageId) {
        String accessToken = this.weiXinBaseService.getAccessTokenByPlatformId(platFormId).getAccessToken();
        return this.sendCustomerTextMessage4Base(openId, accessToken, content, messageId, platFormId);
    }

    @Override
    @Async
    public Future<BaseResult> sendCustomerTextMessage4CustmoerIdAsync(String customerId, Integer platFormId, String content, int messageId) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platFormId);
        BaseResult baseResult = new BaseResult();
        if (customerDetailVo == null) {
            baseResult.setErrcode("\u7528\u6237\u4e0d\u5b58\u5728");
            baseResult.setErrcode("1001");
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return new AsyncResult((Object)this.sendCustomerTextMessage(customerDetailVo.getOpenId(), platFormId, content, messageId));
    }

    private BaseResult sendCustomerTextMessage4Base(String openId, String accessToken, String content, int messageId, Integer platFormId) {
        BaseResult baseResult = new BaseResult();
        if (StringUtils.isEmpty((String)openId)) {
            baseResult.setErrmsg("\u7528\u6237\u4e0d\u5b58\u5728");
            baseResult.setErrcode("1001");
            return baseResult;
        }
        if (StringUtils.isEmpty((String)content)) {
            baseResult.setErrmsg("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            baseResult.setErrcode("1002");
            return baseResult;
        }
        if (StringUtils.isEmpty((String)accessToken)) {
            this.logger.info("\u83b7\u53d6accessToken\u5931\u8d25,accessToken\u4e3a\u7a7a");
            baseResult.setErrmsg("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            baseResult.setErrcode("1003");
            return baseResult;
        }
        TextMessage textMessage = new TextMessage(openId, content);
        try {
            String logId = IDGenerate.getUniqueIdStr();
            baseResult = MessageAPI.messageCustomSend((String)accessToken, (Message)textMessage);
            MallTemplateMessageLogEntity templateMessageLogEntity = new MallTemplateMessageLogEntity();
            templateMessageLogEntity.setLogId(logId);
            templateMessageLogEntity.setCreateTime(DateUtils.now());
            templateMessageLogEntity.setErrCode(baseResult.getErrcode());
            templateMessageLogEntity.setMessageId(messageId);
            templateMessageLogEntity.setMessageName("");
            templateMessageLogEntity.setMessageText(content);
            templateMessageLogEntity.setOpenId(openId);
            templateMessageLogEntity.setSource(1);
            templateMessageLogEntity.setTemplateId("");
            templateMessageLogEntity.setUrl("");
            templateMessageLogEntity.setErrMsg(baseResult.getErrmsg());
            this.templateMessageLogInterface.save(templateMessageLogEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResult.setErrcode("1004");
            this.logger.info("\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u5931\u8d25,\u9519\u8bef\u6d88\u606f:{}", new Object[]{openId, content, e.getMessage()});
            return baseResult;
        }
        if (baseResult.isSuccess()) {
            this.logger.info("\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u6210\u529f", (Object)openId, (Object)content);
        } else {
            this.logger.info("\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u5931\u8d25,\u9519\u8bef\u6d88\u606f:", new Object[]{openId, content, baseResult.getErrmsg()});
        }
        return baseResult;
    }

    @Override
    public TemplateMessageResult messageTemplateSend(Integer platFormId, String openId, String url, String templeteId, LinkedHashMap<String, TemplateMessageItem> data) {
        String accessToken = this.weiXinBaseService.getAccessTokenByPlatformId(platFormId).getAccessToken();
        return this.messageTemplateSend(accessToken, openId, url, templeteId, data);
    }

    @Override
    public TemplateMessageResult messageTemplateSend4CustmoerId(Integer platFormId, String customerId, String url, String templeteId, LinkedHashMap<String, TemplateMessageItem> data) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platFormId);
        String accessToken = this.weiXinBaseService.getAccessTokenByPlatformId(platFormId).getAccessToken();
        return this.messageTemplateSend(accessToken, customerDetailVo.getOpenId(), url, templeteId, data);
    }

    @Override
    public TemplateMessageResult messageTemplateSend4AppId(String appId, String openId, String url, String templeteId, LinkedHashMap<String, TemplateMessageItem> data) {
        String accessToken = null;
        try {
            accessToken = this.weiXinBaseService.getAccessToken(appId).getAccessToken();
            return this.messageTemplateSend(accessToken, openId, url, templeteId, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public TemplateMessageResult messageTemplateSend(String accessToken, String openId, String url, String templeteId, LinkedHashMap<String, TemplateMessageItem> data) {
        TemplateMessage templateMessage = new TemplateMessage();
        templateMessage.setTemplate_id(templeteId);
        templateMessage.setTouser(openId);
        if (StringUtils.isNotEmpty((String)url)) {
            templateMessage.setUrl(url);
        }
        templateMessage.setData(data);
        return this.messageTemplateSendBase(accessToken, templateMessage, 0, 0);
    }

    private TemplateMessageResult messageTemplateSendBase(String access_token, TemplateMessage templateMessage, Integer messageId, Integer platformId) {
        return this.messageTemplateSendBase(access_token, templateMessage, messageId, platformId, true);
    }

    private BaseResult miniMessageSubscribeSendBase(String access_token, MiniSubscribeMessage templateMessage, Integer messageId, Integer platformId, boolean writeLog) {
        TemplateMessageResult templateMessageResult = new TemplateMessageResult();
        BaseJsonVo<String> jsonVo = this.blackListInterface.filter(MessageBlackListTypeEnum.miniSubscribeMessage, "", "", templateMessage.getTouser(), JsonUtils.toJson((Object)templateMessage, (boolean)false));
        if (!jsonVo.isSuccess()) {
            templateMessageResult.setErrcode("500");
            templateMessageResult.setErrmsg(jsonVo.getMessage());
            return templateMessageResult;
        }
        templateMessageResult = MessageAPI.messageSubscribeSend((String)access_token, (MiniSubscribeMessage)templateMessage);
        String errcode = templateMessageResult.getErrcode();
        if (writeLog) {
            MallTemplateMessageLogEntity templateMessageLogEntity = new MallTemplateMessageLogEntity();
            templateMessageLogEntity.setLogId(UUID.randomUUID().toString().replace("-", ""));
            templateMessageLogEntity.setCreateTime(DateUtils.now());
            templateMessageLogEntity.setErrCode(errcode);
            templateMessageLogEntity.setMessageId(messageId);
            templateMessageLogEntity.setMessageName("");
            templateMessageLogEntity.setMessageText(templateMessage.toString());
            templateMessageLogEntity.setOpenId(templateMessage.getTouser());
            templateMessageLogEntity.setSource(platformId);
            templateMessageLogEntity.setTemplateId(templateMessage.getTemplate_id());
            templateMessageLogEntity.setUrl("");
            templateMessageLogEntity.setErrMsg(templateMessageResult.getErrmsg());
            this.templateMessageLogInterface.save(templateMessageLogEntity);
        }
        return templateMessageResult;
    }

    private TemplateMessageResult messageTemplateSendBase(String access_token, TemplateMessage templateMessage, Integer messageId, Integer platformId, boolean writeLog) {
        TemplateMessageResult templateMessageResult = new TemplateMessageResult();
        BaseJsonVo<String> jsonVo = this.blackListInterface.filter(MessageBlackListTypeEnum.mpTemplateMessage, "", "", templateMessage.getTouser(), JsonUtils.toJson((Object)templateMessage, (boolean)false));
        if (!jsonVo.isSuccess()) {
            templateMessageResult.setErrcode("500");
            templateMessageResult.setErrmsg(jsonVo.getMessage());
            return templateMessageResult;
        }
        Boolean isSucc = false;
        try {
            templateMessageResult = MessageAPI.messageTemplateSend((String)access_token, (TemplateMessage)templateMessage);
            String errcode = templateMessageResult.getErrcode();
            isSucc = templateMessageResult.isSuccess();
            if (writeLog) {
                MallTemplateMessageLogEntity templateMessageLogEntity = new MallTemplateMessageLogEntity();
                templateMessageLogEntity.setLogId(UUID.randomUUID().toString().replace("-", ""));
                templateMessageLogEntity.setCreateTime(DateUtils.now());
                templateMessageLogEntity.setErrCode(errcode);
                templateMessageLogEntity.setMessageId(messageId);
                templateMessageLogEntity.setMessageName("");
                templateMessageLogEntity.setMessageText(templateMessage.toString());
                templateMessageLogEntity.setOpenId(templateMessage.getTouser());
                templateMessageLogEntity.setSource(platformId);
                templateMessageLogEntity.setTemplateId(templateMessage.getTemplate_id());
                templateMessageLogEntity.setUrl("");
                templateMessageLogEntity.setErrMsg(templateMessageResult.getErrmsg());
                this.templateMessageLogInterface.save(templateMessageLogEntity);
            }
            if (isSucc.booleanValue()) {
                this.logger.info("\u7528\u6237:{},\u6a21\u677f\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u6210\u529f", (Object)templateMessage.getTouser(), (Object)templateMessage.toString());
            } else {
                this.logger.info("\u7528\u6237:{},\u6a21\u677f\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u5931\u8d25", (Object)templateMessage.getTouser(), (Object)templateMessage.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return templateMessageResult;
    }

    @Override
    public Boolean sendNotice(Map<String, Object> param) {
        List paramList = (List)param.get("list");
        String action = param.get("action").toString();
        this.logger.info("\u63a5\u6536\u53c2\u6570:action={},list={}", (Object)action, (Object)JsonUtils.toJson((Object)paramList, (boolean)false));
        if (StringUtils.isEmpty((String)action) || CollectionUtils.isEmpty((Collection)paramList)) {
            this.logger.info("\u63a8\u9001action\u4e3a\u7a7a");
            return true;
        }
        Boolean comeFromBaseService = ((Map)paramList.get(0)).containsKey("taskPushLogId") && ((Map)paramList.get(0)).get("taskPushLogId") != null;
        List<MallMessageConfigEntity> list = this.messageConfigInterface.getMessageConfigEntityList(1000, action);
        if (CollectionUtils.isEmpty(list)) {
            this.logger.error("action \u914d\u7f6e\u4e3a\u7a7a \u63a8\u9001\u5931\u8d25");
            return true;
        }
        if (list.stream().anyMatch(m -> Objects.equals(m.getMessageType(), MessageTypeEnum.SMS_MESSAGE.getValue())) && paramList.size() > 1 && !comeFromBaseService.booleanValue()) {
            BaseJsonVo<String> baseJsonVo = this.messageConfigInterface.getMessageConfig(list.get(0).getMessageConfigId(), null);
            if (!baseJsonVo.isSuccess()) {
                this.logger.info("\u67e5\u8be2\u8981\u53d1\u9001\u7684\u6d88\u606f\u5185\u5bb9\u5931\u8d25\uff0c\u53d1\u9001\u5931\u8d25:{}", (Object)baseJsonVo.getError_msg());
                return false;
            }
            Map objectMap = (Map)baseJsonVo.getValue();
            if (objectMap.containsKey(MessageTypeEnum.SMS_MESSAGE.getValue())) {
                TextMessage message = (TextMessage)objectMap.get(MessageTypeEnum.SMS_MESSAGE.getValue());
                try {
                    String mobileList = paramList.stream().map(item -> ((String)item.get("CUSTOMER_ID")).toString()).collect(Collectors.joining(","));
                    this.logger.info("\u6279\u91cf\u63a8\u9001\u77ed\u4fe1,\u8981\u63a8\u9001\u7684\u624b\u673a\u53f7:{},\u8981\u63a8\u9001\u7684\u5185\u5bb9:{}", (Object)mobileList, (Object)message.getText().getContent());
                    baseJsonVo = this.smsInvoke.batchSend(mobileList, message.getText().getContent(), param.get("custid").toString());
                    return baseJsonVo.isSuccess();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.info("\u77ed\u4fe1\u63a8\u9001\u5931\u8d25" + e);
                }
            }
            return true;
        }
        paramList.forEach(map -> {
            String taskPushLogId;
            this.logger.info("action={},CUSTOMER_ID={},map={}", new Object[]{action, map.get("CUSTOMER_ID"), JsonUtils.toJson((Object)map, (boolean)false)});
            String customerId = null;
            if (map.containsKey("CUSTOMER_ID") && StringUtils.isNotEmpty((String)((String)map.get("CUSTOMER_ID")))) {
                customerId = (String)map.get("CUSTOMER_ID");
            } else if (map.containsKey("customerId") && StringUtils.isNotEmpty((String)((String)map.get("customerId")))) {
                customerId = (String)map.get("customerId");
            } else if (map.containsKey("mobile") && StringUtils.isNotEmpty((String)((String)map.get("mobile")))) {
                customerId = (String)map.get("mobile");
            } else if (map.containsKey("openId") && StringUtils.isNotEmpty((String)((String)map.get("openId")))) {
                customerId = (String)map.get("openId");
            }
            if (list.stream().anyMatch(c -> Objects.equals(c.getMessageType(), MessageTypeEnum.TEMPLATE_MESSAGE.getValue()))) {
                MessageRemainEntity query = new MessageRemainEntity();
                query.setCustomerId(customerId);
                query.setAction(action);
                query.setStatus(2);
                MessageRemainEntity messageRemainEntity = (MessageRemainEntity)this.messageRemainInterface.getSingle(query, 0L);
                if (messageRemainEntity != null) {
                    messageRemainEntity.setStatus(3);
                    this.messageRemainInterface.updateByPrimaryKeySelective(messageRemainEntity);
                }
            }
            BaseJsonVo jsonVo = this.sendWechatMessage(list, customerId, (Map<String, String>)map);
            this.logger.info(JsonUtils.toJson((Object)jsonVo, (boolean)false));
            if (comeFromBaseService.booleanValue() && StringUtils.isNotEmpty((String)(taskPushLogId = String.valueOf(map.get("taskPushLogId"))))) {
                this.taskInvoke.saveTaskPushLogResult(Integer.valueOf(taskPushLogId), "", jsonVo.isSuccess() ? 1 : 0, "", jsonVo.isSuccess() ? "" : jsonVo.getMessage());
            }
        });
        return true;
    }

    @Override
    public BaseJsonVo sendWechatMessage(String actionId, String customerId, Map<String, String> variableMap) {
        return this.sendWechatMessage((Integer)1000, actionId, customerId, variableMap);
    }

    private BaseJsonVo sendWechatMessage(List<MallMessageConfigEntity> list, String customerId, Map<String, String> variableMap) {
        boolean flag = false;
        for (MallMessageConfigEntity configEntity : list) {
            BaseJsonVo messageValueBaseJson = this.messageConfigInterface.getMessageConfig(configEntity.getMessageConfigId(), variableMap);
            if (!messageValueBaseJson.isSuccess()) {
                this.logger.info("\u6d88\u606f\u63a8\u9001\u5931\u8d25:{}", (Object)messageValueBaseJson.getMessage());
                continue;
            }
            BaseJsonVo baseJsonVo = this.sendWechatMessageByCustomerId(configEntity, customerId, variableMap, (Map)messageValueBaseJson.getValue(), true);
            this.logger.info("\u7528\u6237:{},\u52a8\u4f5c:{}\u6d88\u606f\u63a8\u9001{},{}", new Object[]{customerId, configEntity.getActionId(), baseJsonVo.isSuccess(), baseJsonVo.getMessage()});
            if (baseJsonVo.isSuccess()) {
                flag = true;
            }
            if (!flag || !Objects.equals(configEntity.getMessageType(), MessageTypeEnum.TEMPLATE_MESSAGE.getValue()) && !Objects.equals(configEntity.getMessageType(), MessageTypeEnum.MP_SUBSCRIBE_MESSAGE.getValue())) continue;
            this.setSubscriptUsed(list, customerId);
        }
        return flag ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u6d88\u606f\u63a8\u9001\u5931\u8d25");
    }

    private void setSubscriptUsed(List<MallMessageConfigEntity> list, String customerId) {
        TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(list.get(0).getMessageId());
        if (templateMessageEntity != null) {
            SubscribeMessageEntity subscribeMessageEntity = new SubscribeMessageEntity();
            subscribeMessageEntity.setCustomerId(customerId);
            subscribeMessageEntity.setStatus(1);
            subscribeMessageEntity.setTmplId(templateMessageEntity.getTemplateId());
            SubscribeMessageEntity update = (SubscribeMessageEntity)this.subscribeMessageInterface.getSingle(subscribeMessageEntity, 0L);
            if (update != null) {
                update.setStatus(4);
                update.setCreateTime(DateUtils.now());
                this.subscribeMessageInterface.updateByPrimaryKeySelective(update);
            }
        }
    }

    @Override
    public BaseJsonVo sendWechatMessage(Integer platformGroupId, String actionId, String customerId, Map<String, String> variableMap) {
        boolean flag = true;
        List<MallMessageConfigEntity> list = this.messageConfigInterface.getMessageConfigEntityList(platformGroupId, actionId);
        if (CollectionUtils.isNotEmpty(list)) {
            BaseJsonVo baseJsonVo = this.sendWechatMessage(list, customerId, variableMap);
            flag = baseJsonVo.isSuccess();
        } else {
            this.logger.info("\u52a8\u4f5c{}\u5173\u8054\u6d88\u606f\u672a\u914d\u7f6e:", (Object)actionId);
        }
        return flag ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u6d88\u606f\u63a8\u9001\u5931\u8d25");
    }

    @Override
    public BaseJsonVo sendWechatMessage(int messageType, Integer messageId, String customerId, Map<String, String> variableMap) {
        List<CustomerOpenidEntity> list = this.customerService.getCustomerOpenidList(customerId);
        List platformIdList = list.stream().map(CustomerOpenidEntity::getPlatformId).collect(Collectors.toList());
        HashSet set = new HashSet(platformIdList);
        boolean flag = false;
        String errMessage = "";
        if (set != null) {
            for (Integer platformId : set) {
                BaseJsonVo baseJsonVo = this.sendWechatMessageByCustomerId(messageId, messageType, platformId, customerId, variableMap, true);
                if (baseJsonVo.isSuccess()) {
                    flag = true;
                    continue;
                }
                errMessage = baseJsonVo.getMessage();
            }
        }
        return flag ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)errMessage);
    }

    @Override
    public BaseJsonVo sendWechatMessage(MessageTypeEnum messageType, Integer messageId, String customerId, Map<String, String> variableMap) {
        return this.sendWechatMessage(messageType.getValue(), messageId, customerId, variableMap);
    }

    private BaseJsonVo sendWechatMessageByCustomerId(MallMessageConfigEntity configEntity, String customerId, Map<String, String> variableMap, boolean writeLog) {
        BaseJsonVo baseJsonVo = this.messageConfigInterface.getMessageConfig(configEntity.getMessageConfigId(), variableMap);
        if (!baseJsonVo.isSuccess()) {
            this.logger.info("\u6d88\u606f\u53d1\u9001\u5931\u8d25:{}", (Object)baseJsonVo.getError_msg());
            return baseJsonVo;
        }
        return this.sendWechatMessageByCustomerId(configEntity, customerId, variableMap, (Map)baseJsonVo.getValue(), writeLog);
    }

    private BaseJsonVo sendWechatMessageByCustomerId(MallMessageConfigEntity configEntity, String customerId, Map<String, String> variableMap, Map<Integer, Object> messageMap, boolean writeLog) {
        if (customerId.isEmpty()) {
            return BaseJsonVo.error((String)"customerId\u4e3a\u7a7a");
        }
        if (configEntity == null) {
            return BaseJsonVo.error((String)"\u6d88\u606f\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        if (MessageTypeEnum.TEMPLATE_MESSAGE.getValue() == configEntity.getMessageType().intValue() || MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue() == configEntity.getMessageType().intValue() || MessageTypeEnum.MP_SUBSCRIBE_MESSAGE.getValue() == configEntity.getMessageType().intValue()) {
            String openId;
            if (customerId.contains("o")) {
                openId = customerId;
            } else {
                CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, configEntity.getPlatformId());
                if (customerDetailVo == null) {
                    this.logger.error("\u7528\u6237:{},\u672a\u5728\u5e73\u53f0{}\u4e0a\u6ce8\u518c", (Object)customerId, (Object)configEntity.getPlatformId());
                    return BaseJsonVo.error((String)("\u6d88\u606f\u53d1\u9001\u5931\u8d25,\u7528\u6237\u672a\u5728\u5e73\u53f0" + configEntity.getPlatformId() + "\u6ce8\u518c"));
                }
                openId = customerDetailVo.getOpenId();
            }
            return this.sendWechatMessageBase(configEntity.getPlatformId(), configEntity.getMessageId(), openId, messageMap, writeLog);
        }
        if (MessageTypeEnum.SMS_MESSAGE.getValue() == configEntity.getMessageType().intValue()) {
            Map<Integer, Object> objectMap = messageMap;
            if (objectMap.containsKey(MessageTypeEnum.SMS_MESSAGE.getValue())) {
                TextMessage message = (TextMessage)objectMap.get(MessageTypeEnum.SMS_MESSAGE.getValue());
                this.logger.info("\u8981\u63a8\u9001\u7684\u624b\u673a\u53f7:{},\u63a8\u9001\u5185\u5bb9:{}", (Object)customerId, (Object)message.getText().getContent());
                if (customerId.length() != 11) {
                    if (variableMap.containsKey("mobile")) {
                        customerId = variableMap.get("mobile");
                    } else {
                        CustomerEntity customerEntity = this.customerService.getCustomer(customerId);
                        if (customerEntity != null && StringUtils.isNotEmpty((String)customerEntity.getMobile())) {
                            customerId = customerEntity.getMobile();
                        } else {
                            this.logger.info("\u7528\u6237:{}\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7\u63a8\u9001\u5185\u5bb9:{}", (Object)customerId, (Object)message.getText().getContent());
                            return BaseJsonVo.error((String)"\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7");
                        }
                    }
                }
                this.logger.info("\u8981\u63a8\u9001\u7684\u624b\u673a\u53f7:{},\u63a8\u9001\u5185\u5bb9:{}", (Object)customerId, (Object)message.getText().getContent());
                return this.smsInvoke.pushMessage(customerId, message.getText().getContent(), variableMap.get("custid"));
            }
            this.logger.error("\u77ed\u4fe1\u5185\u5bb9\u914d\u7f6e\u9519\u8bef\u8bf7\u68c0\u67e5");
        }
        return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u5e73\u53f0\u63a8\u9001\u5931\u8d25");
    }

    private BaseJsonVo sendWechatMessageByCustomerId(int messageId, int messageType, int platformId, String customerId, Map<String, String> variableMap, boolean writeLog) {
        if (customerId.isEmpty()) {
            return BaseJsonVo.error((String)"customerId\u4e3a\u7a7a");
        }
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platformId);
        if (customerDetailVo == null) {
            this.logger.error("\u7528\u6237:{},\u672a\u5728\u5e73\u53f0{}\u4e0a\u6ce8\u518c messageId={},messageType={}\u53d1\u9001\u5931\u8d25", new Object[]{customerId, platformId, messageId, messageType});
            return BaseJsonVo.error((String)("\u7528\u6237\u672a\u5728\u5e73\u53f0" + platformId + "\u6ce8\u518c"));
        }
        BaseJsonVo baseJsonVo = this.messageConfigInterface.getMessageConfigByMessageType(messageType, messageId, variableMap);
        if (!baseJsonVo.isSuccess()) {
            this.logger.info("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + baseJsonVo.getError_msg());
            return baseJsonVo;
        }
        return this.sendWechatMessageBase(platformId, messageId, customerDetailVo.getOpenId(), (Map)baseJsonVo.getValue(), writeLog);
    }

    @Override
    public BaseJsonVo sendWechatMessageBase(Integer platformId, Integer messageId, String openId, Map<Integer, Object> sendMap, boolean writeLog) {
        WeiXinBaseEntity baseEntity = this.weiXinBaseService.getAccessTokenByPlatformId(platformId);
        this.logger.info(JsonUtils.toJson(sendMap, (boolean)false));
        if (baseEntity == null) {
            return BaseJsonVo.error((String)("\u5e73\u53f0\u914d\u7f6e\u4e0d\u5b58\u5728,platformId:" + platformId));
        }
        String accessToken = baseEntity.getAccessToken();
        if (sendMap.containsKey(1)) {
            Message message = (Message)sendMap.get(1);
            BaseJsonVo<String> jsonVo = this.blackListInterface.filter(MessageBlackListTypeEnum.mpTemplateMessage, "", "", openId, JsonUtils.toJson(sendMap, (boolean)false));
            if (!jsonVo.isSuccess()) {
                return jsonVo;
            }
            message.setTouser(openId);
            try {
                BaseResult b = MessageAPI.messageCustomSend((String)accessToken, (Message)message);
                if (writeLog) {
                    this.writeLog(platformId, messageId, openId, message, b);
                }
                if (!b.isSuccess()) {
                    return BaseJsonVo.error((String)b.getErrmsg());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (sendMap.containsKey(2) || sendMap.containsKey(4)) {
            try {
                if (platformId == 1) {
                    if (sendMap.containsKey(2)) {
                        TemplateMessage templateMessage = (TemplateMessage)sendMap.get(2);
                        templateMessage.setTouser(openId);
                        TemplateMessageResult result = this.messageTemplateSendBase(accessToken, templateMessage, messageId, platformId, writeLog);
                        return result.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)result.getErrmsg());
                    }
                    if (sendMap.containsKey(4)) {
                        this.logger.info("MP\u8ba2\u9605\u6d88\u606fopenId:" + openId);
                        MpSubscribeMessage templateMessage = (MpSubscribeMessage)sendMap.get(4);
                        templateMessage.setTouser(openId);
                        BaseResult result = this.mpMessageSubscribeSendBase(accessToken, templateMessage, messageId, platformId, writeLog);
                        return result.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)result.getErrmsg());
                    }
                } else if (platformId == 4) {
                    MiniSubscribeMessage templateMessage = (MiniSubscribeMessage)sendMap.get(2);
                    templateMessage.setTouser(openId);
                    BaseResult baseResult = this.miniMessageSubscribeSendBase(accessToken, templateMessage, messageId, platformId, writeLog);
                    return baseResult.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)baseResult.getErrmsg());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void writeLog(Integer platformId, Integer messageId, String openId, Message message, BaseResult b) {
        MallTemplateMessageLogEntity templateMessageLogEntity = new MallTemplateMessageLogEntity();
        templateMessageLogEntity.setLogId(UUID.randomUUID().toString().replace("-", ""));
        templateMessageLogEntity.setCreateTime(DateUtils.now());
        templateMessageLogEntity.setErrCode(b.getErrcode());
        templateMessageLogEntity.setMessageId(messageId);
        templateMessageLogEntity.setMessageName("");
        templateMessageLogEntity.setMessageText("");
        if (message.getMsgtype().equals("text")) {
            templateMessageLogEntity.setMessageText(((TextMessage)message).getText().getContent());
        }
        templateMessageLogEntity.setOpenId(openId);
        templateMessageLogEntity.setSource(platformId);
        templateMessageLogEntity.setTemplateId("");
        templateMessageLogEntity.setUrl("");
        templateMessageLogEntity.setErrMsg(b.getErrmsg());
        this.templateMessageLogInterface.save(templateMessageLogEntity);
    }

    private BaseResult mpMessageSubscribeSendBase(String access_token, MpSubscribeMessage templateMessage, Integer messageId, Integer platformId, boolean writeLog) {
        TemplateMessageResult templateMessageResult = new TemplateMessageResult();
        BaseJsonVo<String> jsonVo = this.blackListInterface.filter(MessageBlackListTypeEnum.mpSubscribeMessage, "", "", templateMessage.getTouser(), JsonUtils.toJson((Object)templateMessage, (boolean)false));
        if (!jsonVo.isSuccess()) {
            templateMessageResult.setErrcode("500");
            templateMessageResult.setErrmsg(jsonVo.getMessage());
            return templateMessageResult;
        }
        if (StringUtils.isEmpty((String)templateMessage.getTouser())) {
            templateMessageResult.setErrcode("\u7528\u6237\u4e0d\u5b58\u5728");
            templateMessageResult.setErrcode("1001");
            return templateMessageResult;
        }
        if (templateMessage.getData() == null) {
            templateMessageResult.setErrcode("\u6a21\u677f\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            templateMessageResult.setErrcode("1002");
            return templateMessageResult;
        }
        if (StringUtils.isEmpty((String)templateMessage.getTemplate_id())) {
            this.logger.info("\u6a21\u677fid\u4e3a\u7a7a");
            templateMessageResult.setErrcode("\u6a21\u677fid\u4e3a\u7a7a");
            templateMessageResult.setErrcode("1003");
            return templateMessageResult;
        }
        if (StringUtils.isEmpty((String)access_token)) {
            this.logger.info("\u83b7\u53d6accessToken\u5931\u8d25,accessToken\u4e3a\u7a7a");
            templateMessageResult.setErrcode("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            templateMessageResult.setErrcode("1004");
            return templateMessageResult;
        }
        Boolean isSucc = false;
        try {
            templateMessageResult = MessageAPI.mpMessageSubscribeSend((String)access_token, (MpSubscribeMessage)templateMessage);
            String errcode = templateMessageResult.getErrcode();
            isSucc = templateMessageResult.isSuccess();
            if (writeLog) {
                MallTemplateMessageLogEntity templateMessageLogEntity = new MallTemplateMessageLogEntity();
                templateMessageLogEntity.setLogId(UUID.randomUUID().toString().replace("-", ""));
                templateMessageLogEntity.setCreateTime(DateUtils.now());
                templateMessageLogEntity.setErrCode(errcode);
                templateMessageLogEntity.setMessageId(messageId);
                templateMessageLogEntity.setMessageName("");
                templateMessageLogEntity.setMessageText(templateMessage.toString());
                templateMessageLogEntity.setOpenId(templateMessage.getTouser());
                templateMessageLogEntity.setSource(platformId);
                templateMessageLogEntity.setTemplateId(templateMessage.getTemplate_id());
                templateMessageLogEntity.setUrl("");
                templateMessageLogEntity.setErrMsg(templateMessageResult.getErrmsg());
                this.templateMessageLogInterface.save(templateMessageLogEntity);
            }
            if (isSucc.booleanValue()) {
                this.logger.info("\u7528\u6237:{},\u6a21\u677f\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u6210\u529f", (Object)templateMessage.getTouser(), (Object)templateMessage.toString());
            } else {
                this.logger.info("\u7528\u6237:{},\u6a21\u677f\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u5931\u8d25", (Object)templateMessage.getTouser(), (Object)templateMessage.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return templateMessageResult;
    }

    @Override
    public BaseJsonVo pushFixedTimeMessageByEvent(EventMessage eventMessage, int platformId) {
        String openId = eventMessage.getFromUserName();
        String msgType = eventMessage.getMsgType();
        String inputContent = eventMessage.getContent();
        Long timeStamp = (long)eventMessage.getCreateTime();
        String event = eventMessage.getEvent();
        event = StringUtils.isNotEmpty((String)event) ? event.toLowerCase() : "";
        this.logger.info("\u8fdb\u5165pushFixedTimeMessage\uff0copenId\uff1a" + openId + ",msgType:" + msgType + ",event:" + event + ",content:" + inputContent);
        CustomerDetailVo op = this.customerInterface.getCustomerDetailByOpenid(openId, platformId);
        if (op != null) {
            BaseJsonVo<Integer> jsonVo = this.biOrderDetailInvoke.getCustomerLastOrderDays(op.getCustomerId());
            this.logger.info("\u83b7\u53d6\u7528\u6237\u72b6\u6001\uff1a" + jsonVo.isSuccess() + "," + jsonVo.getValue());
            if (jsonVo.isSuccess()) {
                Integer c = (Integer)jsonVo.getValue();
                if (Integer.valueOf(-1).equals(c) || Integer.valueOf(180).compareTo(c) < 0) {
                    this.logger.info("\u5f00\u59cb\u53d1\u55661");
                    if ("text".equals(msgType)) {
                        this.taskInvoke.pushDirect(58, "", openId, "", this.getPushSecond(120), platformId);
                        this.taskInvoke.pushDirect(59, "", openId, "", this.getPushSecond(1800), platformId);
                        this.taskInvoke.pushDirect(60, "", openId, "", this.getPushSecond(86400), platformId);
                        this.taskInvoke.pushDirect(61, "", openId, "", this.getPushSecond(172740), platformId);
                    }
                    if ("event".equals(msgType) && "scan".equals(event)) {
                        this.taskInvoke.pushDirect(104, "", openId, "", this.getPushSecond(0), platformId);
                    }
                    if ("event".equals(msgType) && "subscribe".equals(event)) {
                        // empty if block
                    }
                } else {
                    this.logger.info("\u5f00\u59cb\u53d1\u55662");
                    if ("text".equals(msgType)) {
                        this.taskInvoke.pushDirect(60, "", openId, "", this.getPushSecond(86400), platformId);
                        this.taskInvoke.pushDirect(61, "", openId, "", this.getPushSecond(172740), platformId);
                    }
                    if ("event".equals(msgType) && "scan".equals(event)) {
                        this.taskInvoke.pushDirect(105, "", openId, "", this.getPushSecond(0), platformId);
                    }
                    if (!"event".equals(msgType) || "subscribe".equals(event)) {
                        // empty if block
                    }
                }
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private Integer getPushSecond(Integer second) {
        if (second <= 180) {
            return second;
        }
        Integer[] sendHour = new Integer[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(DateUtils.getAddDateBySecond((Date)new Date(), (int)second));
        int hour = calendar.get(11);
        if (hour < sendHour[0]) {
            if (second + (sendHour[0] - hour) > 172800) {
                // empty if block
            }
            return second + (sendHour[0] - hour) * 3600;
        }
        if (hour > sendHour[sendHour.length - 1]) {
            return second - (sendHour[sendHour.length - 1] - hour) * 3600;
        }
        return second;
    }
}

