/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.iservice.weixin.MiniApiInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.WxaAPI;
import weixin.popular.bean.BaseResult;

@Service
public class MiniApiService
extends BaseService
implements MiniApiInterface {
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;

    @Override
    public BaseJsonVo msgCheck(Integer platformId, String content) {
        String accessToken = this.weiXinBaseService.getAccessTokenByPlatformId(platformId).getAccessToken();
        this.logger.info("\u68c0\u6d4b\u7684\u8bcd\u8bed\uff1a" + content);
        BaseResult baseResult = WxaAPI.msgSecCheck((String)accessToken, (String)content);
        this.logger.info("\u68c0\u6d4b\u7ed3\u679c\uff1a" + JsonUtils.toJson((Object)baseResult, (boolean)false));
        if (baseResult.isSuccess()) {
            return BaseJsonVo.success(null);
        }
        return BaseJsonVo.error((String)(baseResult.getErrcode() + ":" + baseResult.getErrmsg()));
    }

    @Override
    public BaseJsonVo imgCheck(Integer platformId, File imgFile) {
        String accessToken = this.weiXinBaseService.getAccessTokenByPlatformId(platformId).getAccessToken();
        BaseResult baseResult = WxaAPI.imgSecCheck((String)accessToken, (File)imgFile);
        if (baseResult.isSuccess()) {
            return BaseJsonVo.success(null);
        }
        return BaseJsonVo.error((String)(baseResult.getErrcode() + ":" + baseResult.getErrmsg()));
    }

    @Override
    public BaseJsonVo mediaCheck(Integer platformId, File mediaFile) {
        String accessToken = this.weiXinBaseService.getAccessTokenByPlatformId(platformId).getAccessToken();
        BaseResult baseResult = WxaAPI.mediaCheckAsync((String)accessToken, (File)mediaFile);
        if (baseResult.isSuccess()) {
            return BaseJsonVo.success(null);
        }
        return BaseJsonVo.error((String)(baseResult.getErrcode() + ":" + baseResult.getErrmsg()));
    }
}

