/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.common.EnvironmentEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.WeiXinBaseMapper;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseVo;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import weixin.popular.api.TicketAPI;
import weixin.popular.api.TokenAPI;
import weixin.popular.bean.ticket.Ticket;
import weixin.popular.bean.token.Token;

@Service
public class WeiXinBaseService
extends BaseService
implements WeiXinBaseInterface {
    @Autowired
    private WeiXinBaseMapper weiXinBaseMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    private RedisService redisService;
    @Value(value="${lechun.environment}")
    private String environment;

    @Override
    @ReadThroughSingleCache(namespace="WeiXinBaseService.getWeiXinBase")
    public WeiXinBaseEntity getWeiXinBase(@ParameterValueKeyProvider Integer id) {
        return (WeiXinBaseEntity)this.weiXinBaseMapper.selectByPrimaryKey(id);
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinBaseService.getWeiXinBasefromAppId")
    public WeiXinBaseEntity getWeiXinBasefromAppId(@ParameterValueKeyProvider String appId) {
        return this.weiXinBaseMapper.getAccessToken(appId);
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinBaseService.getAccessToken")
    public WeiXinBaseEntity getAccessToken(@ParameterValueKeyProvider String appId) {
        WeiXinBaseEntity weiXinBase = this.getWeiXinBasefromAppId(appId);
        if (this.reflashAccessToken(weiXinBase)) {
            return weiXinBase;
        }
        this.logger.error("AppId:{},\u5237\u65b0accessToken\u51fa\u9519", (Object)appId);
        throw new RuntimeException("\u5237\u65b0accessToken\u51fa\u9519");
    }

    @Override
    public boolean reflashAccessToken(WeiXinBaseEntity weiXinBaseEntity) {
        boolean result = false;
        if (weiXinBaseEntity == null || weiXinBaseEntity.getAppid().isEmpty() || weiXinBaseEntity.getAppscret().isEmpty()) {
            return false;
        }
        if (!this.mallRedisLock.lock("wechat_accesstoken_lock" + weiXinBaseEntity.getPlatformId(), "1", 30L, TimeUnit.SECONDS)) {
            return true;
        }
        Token token = null;
        if (weiXinBaseEntity.getPlatformId() == 6 || weiXinBaseEntity.getPlatformId() == 7 || weiXinBaseEntity.getPlatformId() == 8) {
            token = TokenAPI.getQYtoken((String)weiXinBaseEntity.getAppid(), (String)weiXinBaseEntity.getAppscret());
            weiXinBaseEntity.setAccessToken(token.getAccess_token());
        } else {
            token = TokenAPI.token((String)weiXinBaseEntity.getAppid(), (String)weiXinBaseEntity.getAppscret());
            if (token != null) {
                weiXinBaseEntity.setAccessToken(token.getAccess_token());
                Ticket ticket = TicketAPI.ticketGetticket((String)token.getAccess_token());
                if (ticket != null) {
                    weiXinBaseEntity.setJsapiTicket(ticket.getTicket());
                    weiXinBaseEntity.setJsapiTicketExpired(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)token.getExpires_in()));
                }
            }
        }
        if (token != null) {
            if (StringUtils.isNotEmpty((String)token.getAccess_token())) {
                weiXinBaseEntity.setExpired(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)token.getExpires_in()));
                boolean temp = this.updateAccessToken(weiXinBaseEntity);
                if (!temp) {
                    this.logger.error("\u4fdd\u5b58accesstoken,\u8fc7\u671f\u65f6\u95f4\u51fa\u9519,{}", (Object)weiXinBaseEntity.toString());
                } else {
                    temp = this.redisService.save("WECHAT_ACCESSTOKEN" + String.valueOf(weiXinBaseEntity.getPlatformId()), weiXinBaseEntity, token.getExpires_in());
                    this.logger.info("\u4fdd\u5b58accesstoken:{}", (Object)temp);
                    result = true;
                }
            } else {
                this.logger.error("\u8c03\u7528\u5fae\u4fe1 \u83b7\u53d6AccessToken\u83b7\u53d6\u5931\u8d25,\u503c\u4e3a\u7a7a,{}", (Object)weiXinBaseEntity.toString());
                result = false;
            }
        } else {
            this.logger.error("\u5237\u65b0AccessToken\u83b7\u53d6\u5931\u8d25,{}", (Object)weiXinBaseEntity.toString());
            result = false;
        }
        return result;
    }

    @Override
    public WeiXinBaseEntity getAccessTokenByPlatformId(Integer platformId) {
        Object object = this.redisService.get("WECHAT_ACCESSTOKEN" + String.valueOf(platformId));
        if (object != null) {
            return (WeiXinBaseEntity)object;
        }
        if (platformId == 4 && (EnvironmentEnum.TEST.getValue().equals(this.environment) || EnvironmentEnum.LOCAL.getValue().equals(this.environment))) {
            try {
                URIBuilder uriBuilder = new URIBuilder("https://mallapi.lechun.cc/lechun-mall/weixinapi/getAccessToken?platformId=" + platformId);
                HttpGet httpGet = new HttpGet(uriBuilder.build());
                httpGet.addHeader("Accept", "application/json");
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                this.logger.info("\u83b7\u53d6accessToken \u7ed3\u679c={} result= ", (Object)result);
                JSONObject jsonObject = JSON.parseObject((String)result);
                WeiXinBaseEntity weiXinBaseEntity = (WeiXinBaseEntity)JSONObject.parseObject((String)jsonObject.get((Object)"value").toString(), WeiXinBaseEntity.class);
                this.redisService.save("WECHAT_ACCESSTOKEN" + String.valueOf(weiXinBaseEntity.getPlatformId()), weiXinBaseEntity, (weiXinBaseEntity.getExpired().getTime() - DateUtils.now().getTime()) / 1000L);
                response.close();
                return weiXinBaseEntity;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            WeiXinBaseEntity weiXinBase = this.weiXinBaseMapper.getAccessTokenByPlatformId(platformId);
            if (weiXinBase != null) {
                if (weiXinBase.getExpired().after(DateUtils.now())) {
                    return weiXinBase;
                }
                if (this.reflashAccessToken(weiXinBase)) {
                    this.logger.info("\u5237\u65b0accesstoken true,platformId={}", (Object)platformId);
                    return weiXinBase;
                }
                this.logger.error("\u5e73\u53f0id:{},\u5237\u65b0accessToken\u51fa\u9519", (Object)platformId);
                return null;
            }
        }
        return null;
    }

    @Override
    public String getAccessTokenValueByPlatformId(Integer platformId) {
        WeiXinBaseEntity weiXinBaseEntity = this.getAccessTokenByPlatformId(platformId);
        if (weiXinBaseEntity != null) {
            return weiXinBaseEntity.getAccessToken();
        }
        this.logger.error("\u672a\u77e5\u7684\u5e73\u53f0:{}", (Object)platformId);
        return "";
    }

    public boolean updateAccessToken(WeiXinBaseEntity weiXinBase) {
        this.removCache(weiXinBase.getWeixinBaseId(), weiXinBase.getAppid(), weiXinBase.getPlatformId());
        return this.weiXinBaseMapper.updateAccessToken(weiXinBase) >= 1;
    }

    @Override
    public WeiXinBaseEntity getWeixinBaseByFlatformId(Integer platformId) {
        return this.getAccessTokenByPlatformId(platformId);
    }

    @Override
    public boolean saveWeiXinBase(WeiXinBaseEntity weiXinBaseEntity) {
        this.removCache(weiXinBaseEntity.getWeixinBaseId(), weiXinBaseEntity.getAppid(), weiXinBaseEntity.getPlatformId());
        if (weiXinBaseEntity.getWeixinBaseId() != null && weiXinBaseEntity.getWeixinBaseId() != 0) {
            return this.weiXinBaseMapper.updateByPrimaryKeySelective(weiXinBaseEntity) >= 1;
        }
        return this.weiXinBaseMapper.insertSelective(weiXinBaseEntity) >= 1;
    }

    @Override
    public List<WeiXinBaseVo> getWeiXinBaseList(Pageable pageable) {
        return PageHelper.startPage((int)pageable.getPageNumber(), (int)pageable.getPageSize()).doSelectPage(() -> this.weiXinBaseMapper.getPageList(new WeiXinBaseEntity()));
    }

    private void removCache(Integer id, String appId, int platformId) {
        this.memcachedService.delete("WeiXinBaseService.getWeiXinBase", String.valueOf(id == null ? 0 : id));
        this.memcachedService.delete("WeiXinBaseService.getWeiXinBasefromAppId", appId);
        this.memcachedService.delete("WeiXinBaseService.getAccessToken", appId);
        this.memcachedService.delete("WeiXinBaseService.getAccessTokenByPlatformId", String.valueOf(platformId));
        this.memcachedService.delete("WeiXinBaseService.getWeixinBaseByFlatformId", String.valueOf(platformId));
    }
}

