/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.WeiXinOpenIdMapper;
import cc.lechun.mall.entity.weixin.WeiXinOpenIdEntity;
import cc.lechun.mall.iservice.weixin.WeiXinOpenIdInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import weixin.popular.bean.user.User;
import weixin.popular.bean.user.UserInfoList;

@Service
public class WeiXinOpenIdService
extends BaseService<WeiXinOpenIdEntity, String>
implements WeiXinOpenIdInterface {
    @Resource
    private WeiXinOpenIdMapper weiXinOpenIdMapper;

    @Override
    public BaseJsonVo saveWeixinOpenId(UserInfoList userInfoList, Integer platformId) {
        try {
            if (userInfoList == null) {
                return BaseJsonVo.error((String)"UserInfoList\u4e3a\u7a7a");
            }
            ArrayList<WeiXinOpenIdEntity> insertList = new ArrayList<WeiXinOpenIdEntity>();
            ArrayList<WeiXinOpenIdEntity> updateList = new ArrayList<WeiXinOpenIdEntity>();
            for (User user : userInfoList.getUser_info_list()) {
                if (user == null) continue;
                if (StringUtils.isEmpty((String)user.getOpenid())) {
                    return BaseJsonVo.error((String)"openId\u4e3a\u7a7a");
                }
                WeiXinOpenIdEntity entity = new WeiXinOpenIdEntity();
                entity.setCity(user.getCity());
                entity.setOpenId(user.getOpenid());
                entity.setCountry(user.getCountry());
                entity.setUpdateTime(new Date());
                entity.setNickName(user.getNickname());
                entity.setHeadImgurl(user.getHeadimgurl());
                entity.setNickNameEmoji(user.getNickname_emoji());
                entity.setPlatformId(platformId);
                entity.setProvince(user.getProvince());
                entity.setQrScene(user.getQr_scene());
                entity.setRemark(user.getRemark());
                entity.setQrSceneStr(user.getQr_scene_str());
                entity.setSex(user.getSex());
                entity.setStatus(0);
                entity.setSubscribe(user.getSubscribe());
                entity.setSubscribeScene(user.getSubscribe_scene());
                entity.setSubscribeTime(new Date(MathUtils.mulBigDecimal((Number)user.getSubscribe_time(), (Number)1000).longValue()));
                entity.setUnionId(user.getUnionid());
                if (this.exists((Serializable)((Object)entity.getOpenId())) > 0) {
                    updateList.add(entity);
                    continue;
                }
                entity.setCreateTime(new Date());
                insertList.add(entity);
            }
            if (updateList.size() > 0) {
                this.weiXinOpenIdMapper.batchUpdate(updateList);
            }
            if (insertList.size() > 0) {
                this.weiXinOpenIdMapper.batchInsert(insertList);
            }
            return BaseJsonVo.success((Object)"");
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5fae\u4fe1openId\u62a5\u9519\uff1a" + e.getMessage());
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }
}

